from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="libit",
    version="5.3.5",
    license="http://opensource.org/licenses/MIT",
    packages=find_packages(),
    install_requires=["pycryptodome>=3.15.0", "ecdsa>=0.18.0"],
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Security :: Cryptography",
    ],
    python_requires=">=3.7",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="Mmdrza",
    keywords=[
        "bitcoin",
        "ethereum",
        "tron",
        "litecoin",
        "dogecoin",
        "dash",
        "bitcoin-cash",
        "zcash",
        "vertcoin",
        "cryptography",
        "wallet",
        "cryptocurrency",
        "blockchain",
        "private-key",
        "address",
        "p2pkh",
        "p2sh",
        "p2wpkh",
        "p2wsh",
        "segwit",
        "bech32",
        "multi-coin",
        "dataclass",
        "validation",
        "bulk-generation",
        "short-names",
    ],
    include_package_data=True,
    author_email="Pymmdrza@gmail.com",
    description="Professional multi-cryptocurrency wallet library supporting Bitcoin, Ethereum, Tron, Litecoin, Dogecoin, Bitcoin Cash, Dash, Zcash, and Vertcoin with ultra-short function names and dataclass structure",
    url="https://libit.readthedocs.io/",
    project_urls={
        "Bug Tracker": "https://github.com/pylibit/libit/issues",
        "Source Code": "https://github.com/pylibit/libit",
        "Documentation": "https://pylibit.github.io/libit/",
        "Website Owner": "https://mmdrza.com",
        "documentation": "https://libit.readthedocs.io/",
    },
)
