# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GcpLinkAccountArgs', 'GcpLinkAccount']

@pulumi.input_type
class GcpLinkAccountArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GcpLinkAccount resource.
        :param pulumi.Input[_builtins.str] project_id: Project ID of the GCP account.
        :param pulumi.Input[_builtins.str] account_id: Account ID of the New Relic account.
        :param pulumi.Input[_builtins.str] name: name of the linked account
        """
        pulumi.set(__self__, "project_id", project_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project ID of the GCP account.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the New Relic account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the linked account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GcpLinkAccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GcpLinkAccount resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID of the New Relic account.
        :param pulumi.Input[_builtins.str] name: name of the linked account
        :param pulumi.Input[_builtins.str] project_id: Project ID of the GCP account.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the New Relic account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the linked account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID of the GCP account.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("newrelic:cloud/gcpLinkAccount:GcpLinkAccount")
class GcpLinkAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to link a GCP account to New Relic.

        ## Prerequisite

        To start receiving Google Cloud Platform (GCP) data with New Relic GCP integrations, connect your Google project to New Relic infrastructure monitoring. If you don't have one already, create a New Relic account. It's free, forever.

        Setup is required in GCP for this resource to work properly. The New Relic GCP integration can be done by creating a user account or a service account.

        A user with Project IAM Admin role is needed to add the service account ID as a member in your GCP project.

        In the GCP project IAM & admin, the service account must have the Project Viewer role and the Service Usage Consumer role or, alternatively, a custom role.

        Follow the [steps outlined here](https://docs.newrelic.com/docs/infrastructure/google-cloud-platform-integrations/get-started/connect-google-cloud-platform-services-new-relic) to set up the integration.

        ## Example Usage

        You can also use the full example, including the GCP set up, found in our guides.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.cloud.GcpLinkAccount("foo",
            account_id="account id of newrelic account",
            project_id="id of the Project",
            name="account name")
        ```

        ## Import

        Linked GCP accounts can be imported using `id`, you can find the `id` of an existing GCP linked accounts in GCP dashboard under Infrastructure in Newrelic Console.

        bash

        ```sh
        $ pulumi import newrelic:cloud/gcpLinkAccount:GcpLinkAccount  newrelic_cloud_gcp_link_account.foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID of the New Relic account.
        :param pulumi.Input[_builtins.str] name: name of the linked account
        :param pulumi.Input[_builtins.str] project_id: Project ID of the GCP account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpLinkAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to link a GCP account to New Relic.

        ## Prerequisite

        To start receiving Google Cloud Platform (GCP) data with New Relic GCP integrations, connect your Google project to New Relic infrastructure monitoring. If you don't have one already, create a New Relic account. It's free, forever.

        Setup is required in GCP for this resource to work properly. The New Relic GCP integration can be done by creating a user account or a service account.

        A user with Project IAM Admin role is needed to add the service account ID as a member in your GCP project.

        In the GCP project IAM & admin, the service account must have the Project Viewer role and the Service Usage Consumer role or, alternatively, a custom role.

        Follow the [steps outlined here](https://docs.newrelic.com/docs/infrastructure/google-cloud-platform-integrations/get-started/connect-google-cloud-platform-services-new-relic) to set up the integration.

        ## Example Usage

        You can also use the full example, including the GCP set up, found in our guides.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.cloud.GcpLinkAccount("foo",
            account_id="account id of newrelic account",
            project_id="id of the Project",
            name="account name")
        ```

        ## Import

        Linked GCP accounts can be imported using `id`, you can find the `id` of an existing GCP linked accounts in GCP dashboard under Infrastructure in Newrelic Console.

        bash

        ```sh
        $ pulumi import newrelic:cloud/gcpLinkAccount:GcpLinkAccount  newrelic_cloud_gcp_link_account.foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param GcpLinkAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpLinkAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpLinkAccountArgs.__new__(GcpLinkAccountArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(GcpLinkAccount, __self__).__init__(
            'newrelic:cloud/gcpLinkAccount:GcpLinkAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GcpLinkAccount':
        """
        Get an existing GcpLinkAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID of the New Relic account.
        :param pulumi.Input[_builtins.str] name: name of the linked account
        :param pulumi.Input[_builtins.str] project_id: Project ID of the GCP account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpLinkAccountState.__new__(_GcpLinkAccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        return GcpLinkAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID of the New Relic account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name of the linked account
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID of the GCP account.
        """
        return pulumi.get(self, "project_id")

