#!/usr/bin/env python3
"""
Pool Atom Definitions

All atom constants used throughout otpylib-pool for message dispatch,
state management, and internal communication.

Atoms provide fast identity-based comparison and are the preferred way
to handle message types in OTPylib GenServers.
"""

from otpylib import atom


# =============================================================================
# RPC Message Types (used in handle_call)
# =============================================================================

CHECKOUT = atom.ensure("checkout")
CHECKIN = atom.ensure("checkin")
STATUS = atom.ensure("status")
WHICH_WORKERS = atom.ensure("which_workers")
PING = atom.ensure("ping")


# =============================================================================
# Cast Message Types (used in handle_cast)
# =============================================================================

STOP = atom.ensure("stop")
REMOVE_WORKER = atom.ensure("remove_worker")


# =============================================================================
# Info Message Types (used in handle_info)
# =============================================================================

WORKER_EXITED = atom.ensure("worker_exited")
CHECKOUT_TIMEOUT = atom.ensure("checkout_timeout")
DOWN = atom.ensure("DOWN")


# =============================================================================
# Worker State Atoms
# =============================================================================

AVAILABLE = atom.ensure("available")
BUSY = atom.ensure("busy")
OVERFLOW = atom.ensure("overflow")


# =============================================================================
# Pool Strategy Atoms
# =============================================================================

FIFO = atom.ensure("fifo")
LIFO = atom.ensure("lifo")


# =============================================================================
# Response Atoms
# =============================================================================

OK = atom.ensure("ok")
ERROR = atom.ensure("error")
TIMEOUT = atom.ensure("timeout")
FULL = atom.ensure("full")
NOPROC = atom.ensure("noproc")


# =============================================================================
# Supervisor & Lifecycle Atoms
# =============================================================================

POOL_MANAGER = atom.ensure("pool_manager")
POOL_SUP = atom.ensure("pool_sup")
WORKER_SUP = atom.ensure("worker_sup")

