# mypy-boto3-mediapackage-vod

[![PyPI - mypy-boto3-mediapackage-vod](https://img.shields.io/pypi/v/mypy-boto3-mediapackage-vod.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediapackage-vod)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mediapackage-vod.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediapackage-vod)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MediaPackageVod 1.14.50](https://boto3.amazonaws.com/v1/documentation/api/1.14.50/reference/services/mediapackage-vod.html#MediaPackageVod) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MediaPackageVod` service.

```bash
python -m pip install boto3-stubs[mediapackage-vod]
```

## How to use

### Client annotations

`MediaPackageVodClient` provides annotations for `boto3.client("mediapackage-vod")`.

```python
import boto3

from mypy_boto3_mediapackage_vod import MediaPackageVodClient
from mypy_boto3_mediapackage_vod.paginator import (
    ListAssetsPaginator,
    ListPackagingConfigurationsPaginator,
    ListPackagingGroupsPaginator,
)
from mypy_boto3_mediapackage_vod.type_defs import AssetShallowTypeDef, ...

client: MediaPackageVodClient = boto3.client("mediapackage-vod")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaPackageVodClient = session.client("mediapackage-vod")
```

### Paginators annotations

`mypy_boto3_mediapackage_vod.paginator` module contains type annotations for all paginators.

```python

client: MediaPackageVodClient = boto3.client("mediapackage-vod")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_assets_paginator: ListAssetsPaginator = client.get_paginator("list_assets")
list_packaging_configurations_paginator: ListPackagingConfigurationsPaginator = client.get_paginator("list_packaging_configurations")
list_packaging_groups_paginator: ListPackagingGroupsPaginator = client.get_paginator("list_packaging_groups")
```







### Typed dictionations

`mypy_boto3_mediapackage_vod.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AssetShallowTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_mediapackage_vod` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("mediapackage-vod")

session_client = boto3.Session().client("mediapackage-vod")
```
