import numpy as np
from numpy.random import RandomState

from flatland.core.grid.grid4 import Grid4TransitionsEnum
from flatland.core.transition_map import GridTransitionMap
from flatland.envs.agent_utils import EnvAgent
from flatland.envs.grid.rail_env_grid import RailEnvTransitions
from flatland.envs.line_generators import LineGenerator, sparse_line_generator
from flatland.envs.rail_trainrun_data_structures import Waypoint
from flatland.envs.timetable_utils import Line


def test_sparse_line_generator():
    rail = GridTransitionMap(50, 50, RailEnvTransitions())
    rail.grid = np.array(
        [[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 16386, 1025, 1025, 1025, 1025, 17411, 1025, 5633, 1025, 1025, 1025, 1025,
          1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 1025, 1025, 5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 3089, 1025, 1025, 5633, 1025, 3089, 1025, 1097,
          1025, 17411, 1025, 1025, 1025, 38505, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386, 1025, 1097, 3089, 5633, 1025, 17411, 1097, 3089, 1025, 1025, 17411, 1025, 1097, 1025, 5633, 1025, 17411,
          1025, 3089, 1025, 5633, 4608, 72, 37408, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 0, 32800, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 72, 1097, 1025, 1097, 1025,
          5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 4608, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 3089, 5633, 1025,
          17411, 1097, 2064, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 5633, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 2064,
          0, 0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 4608, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 4608, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          16386, 17411, 2064, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          16386, 2064, 32800, 0, 0, 0, 0, 0],
         [16386, 1025, 5633, 17411, 1025, 1025, 1025, 5633, 17411, 1025, 3089, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32872, 37408, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386, 34864, 0, 0, 0, 0, 0],
         [32800, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 16386, 33825, 33825, 2064, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 32872, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 37408, 49186, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [72, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          49186, 2064, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872,
          37408, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 38505, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186,
          34864, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 34864,
          32872, 4608, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 37408,
          49186, 2064, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872,
          37408, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186,
          34864, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 2064,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386,
          2064, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          0, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0,
          0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 4608, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          0, 0, 0, 0, 0, 0, 0, 0],
         [0, 72, 1025, 1097, 1025, 5633, 17411, 1025, 1025, 1025, 5633, 17411, 1025, 5633, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 1025, 1025,
          1025, 1025, 1025, 1025, 1025, 1025, 4608, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 32800, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72,
          1025, 4608, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 4608, 72, 4608, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 33825, 1025, 1097, 1025, 5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 3089, 1025, 4608, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 1025, 1025, 1097, 3089, 5633, 1025, 17411, 1097, 3089, 1025, 5633, 1025, 37408, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 72, 1025, 1097, 1025, 5633, 17411, 1025, 1025, 1025, 5633,
          17411, 1025, 3089, 3089, 2064, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0]], dtype=np.uint16)
    np_random = RandomState()
    random_state = ('MT19937',
                    [2147483648, 1649661643, 2204385595, 1327114359, 539606687, 2099465216, 303851473, 1436347808, 852714359, 575232558, 1382821698, 1365943899,
                     1241224476, 3534551194, 2837091355, 3157051385, 1930656260, 1621991361, 3337394032, 1942435608, 2385092074, 3270116010, 1821450146,
                     3752120299,
                     2611729644, 3114635860, 2010847399, 3975999875, 22214436, 2278508436, 2969419436, 3688335948, 2458354792, 772357130, 2877981782,
                     2110185083,
                     1487903508, 64817640, 3427555153, 429433882, 3837758443, 2000933081, 328518905, 1879872237, 3200977831, 2088513913, 1989288599, 2909674809,
                     1796951916, 2457138500, 2604020763, 2211163582, 1030366011, 3735999881, 3068287681, 2148606875, 1502981550, 1075780261, 1211885357,
                     4264415436,
                     3670074722, 2167752278, 214926786, 615493834, 1461061972, 4011059408, 3887130633, 3423361761, 3414772315, 1682293769, 4188506610,
                     404250198,
                     3274456466, 325034300, 2269896778, 3570240424, 1128508847, 3237972663, 2475042993, 2478692482, 4051934861, 366099384, 1206987460,
                     1589814612,
                     4159293379, 4220048583, 2154987727, 4287360968, 1255019949, 4027966126, 1191843318, 103093943, 2714785611, 1860186568, 3562053579,
                     3110696691,
                     2138175472, 3182558240, 4096624133, 870621294, 3804117511, 3632611607, 1456998178, 2410699892, 403151641, 1899763855, 4251292935,
                     1950836321,
                     2946093777, 3173846308, 2438320027, 732059050, 2455178832, 669662596, 1943870001, 336602884, 3788818282, 1946366512, 1762907681,
                     4244977320,
                     2092821806, 4011939852, 2705058047, 2812388076, 1154612379, 4097791035, 1367135349, 2358711733, 663051093, 1400728441, 2516982976,
                     1351189120,
                     1338547217, 810006346, 4032851352, 1774566604, 3683786156, 94995540, 633538699, 1915359937, 523905194, 3785662339, 590989700, 480809397,
                     3562361735, 3028216725, 61174175, 3674566448, 3226325427, 2647195461, 4262079159, 955597286, 1515421022, 1670451293, 2630729714,
                     3826547451,
                     2074764500, 1128340413, 1162281050, 4225599749, 2362647596, 3521777889, 984186343, 92512844, 3251709351, 2694147366, 3491715737, 807002420,
                     1727960547, 1369709585, 3785141825, 3015832659, 2671927520, 1444767193, 2425927026, 933425004, 4230357117, 267087178, 2334705240,
                     1037872771,
                     748101849, 4264706677, 463641430, 3043173671, 796636659, 2529561541, 4007621762, 1588390719, 360345969, 2359892133, 4158969820, 3421197884,
                     869483324, 1319753001, 3946898252, 688409318, 2827192564, 1104037938, 4285345321, 2376512306, 2769871287, 2831150842, 3227231045,
                     1887214941,
                     2231951359, 4182818871, 1198021954, 386818504, 222324072, 3640400654, 159672786, 558466229, 2303933510, 1565455308, 3301036383, 547327476,
                     2903959405, 45045840, 3409001823, 2475480249, 3000441831, 437101296, 118733391, 3209888576, 371797845, 1495412523, 3410340417, 122933266,
                     421666431, 3716573900, 3571484149, 2971710455, 1922393602, 4119014813, 1570606844, 800284858, 280620014, 3902591247, 4267823416,
                     3575674764,
                     1621494958, 2398106963, 2166538658, 3516896801, 587363728, 1304426698, 1422123489, 4214649501, 2677387036, 3839923650, 2468374920,
                     1701057467,
                     3346512005, 2049709623, 171887159, 510720556, 814911597, 2316295873, 3679778699, 683519215, 1930224048, 4090725714, 3281136495, 3613750627,
                     3910396492, 1272919367, 2612600390, 2669015213, 990319672, 649713259, 2229298022, 3709930068, 1681999745, 570921791, 2058811081,
                     3558197435,
                     4209585099, 4238477666, 761112313, 1582247558, 3783959133, 3880137850, 3674847190, 3366975812, 2086458918, 2022131840, 1491741851,
                     1138027321,
                     4006544145, 663601164, 2577521234, 3420933060, 3664171069, 3447083350, 1560164785, 1327471555, 1829659600, 2353966497, 2818797807,
                     962649083,
                     2849172355, 4095736032, 2144618894, 2604555966, 2565951654, 1250218951, 2393073772, 4006669761, 766308919, 3391522753, 1166036720,
                     161108303,
                     3300436400, 3607155590, 3595000204, 3936868351, 3570618457, 2563840054, 2916398029, 1413336440, 3423499251, 2117061700, 2767227706,
                     1528043404,
                     4051655395, 2181460279, 2091503819, 2201739289, 2851065395, 1514701648, 2367065021, 462081582, 3448673786, 3407818356, 1666019318,
                     2932050398,
                     85803443, 3950600885, 3400630820, 1072170292, 3304128455, 2046306806, 2780655208, 1240192326, 1605676526, 1111538877, 1382273182,
                     1893705415,
                     507585398, 2607454137, 2749074293, 3946286383, 2586530371, 1513355174, 4010099035, 61007320, 1504482506, 3423367971, 2952086458,
                     1343538643,
                     725006089, 566827241, 1449300598, 3749887157, 1350162125, 1131055843, 1054052446, 3235657336, 4261654346, 3394391653, 2383797616,
                     3285134461,
                     1247881078, 2930311479, 3336688285, 1573714314, 2715984603, 928223088, 1971473022, 1253254317, 3419709554, 1166941943, 3173806230,
                     3960334565,
                     4119182134, 758018741, 75188810, 3533498878, 1138519668, 4089604333, 3127736739, 3368560027, 363059537, 4131654798, 3300566188, 3218228152,
                     3074998464, 2729531691, 1117778976, 3275235837, 3663368948, 322770367, 246296467, 531989057, 1951090884, 2757613851, 1632374923,
                     3885360142,
                     953142252, 395812526, 1734111462, 2191431071, 1231254447, 698759509, 371079609, 2417001428, 2163019402, 2179549232, 1641821563, 66579997,
                     2340096294, 577343611, 2320906326, 192241402, 4125916068, 2136553549, 4176085388, 2918755896, 2978907279, 3647265185, 4138749334,
                     1109792516,
                     2313436411, 472116172, 320849784, 1493330897, 3409986694, 830124966, 1109216428, 3014564778, 875250150, 2106150893, 1545511078, 3871773932,
                     4288260206, 140072917, 1710606833, 3599514394, 3836305580, 794610055, 3902758442, 3936674870, 3510211864, 188209235, 2922660945,
                     2042752757,
                     1834743549, 3265924355, 3916130414, 746323625, 4122430132, 3342351557, 2776449037, 3184970931, 1249782803, 151567899, 3139844062,
                     220751970,
                     2437389404, 3039474572, 3609134032, 3429837246, 3392064795, 212488643, 2331858110, 3340196923, 2117111123, 3977227091, 1073944544,
                     3197483355,
                     3948488979, 1443864233, 3711416750, 936822736, 144711704, 287287287, 645035017, 885434947, 101035744, 1325158782, 2493052978, 1289727404,
                     2868906505, 720407817, 4160171499, 1660376222, 1974588437, 3851307213, 3008830632, 3628895789, 1719047175, 4225823329, 2849825198,
                     1357658595,
                     2710497158, 1588103901, 1553182916, 3421095601, 1634129420, 3651529521, 1417801133, 2568231841, 2101353424, 3277581336, 1753019844,
                     783500912,
                     2758515254, 2954057812, 227782562, 3973373469, 1648077200, 2441255037, 1993138537, 1673575515, 157298829, 676150370, 4153330010,
                     3092354102,
                     954626249, 2362272204, 83987580, 3460474012, 2355241306, 4152027927, 674780370, 580714223, 2058541749, 1989410066, 3194781233, 3710279597,
                     2743945127, 1412595438, 999123907, 975906143, 2826678270, 1864781209, 3898716092, 4279550927, 4112193225, 2485544714, 2585204902,
                     1405670661,
                     459408928, 2142813828, 1895342041, 2354855906, 940201640, 3896150357, 2874813090, 3716510378, 3617349186, 2923857758, 2242749897,
                     3750657021,
                     1189757066, 2196387020, 3798552642, 3383499493, 831232405, 2422926475, 3320634516, 2223658532, 4360144, 1461795088, 3504136436, 2646502537,
                     2306390103, 998661848, 618427340, 1898541195, 1959782611, 3346555697, 1075531114, 362616681, 1825307418, 3069041695, 2867545971,
                     4272118626,
                     1347104250, 1134962299, 2329128459, 1530933548, 3673328829, 885168969, 257079043, 1509838517, 2022933874, 1005779941, 3716661034,
                     2914985666,
                     699624100, 1768376676, 401160693, 2356759728, 1638227403, 1971242660, 3937725790, 2582994844, 4158339204, 4174554769, 160914354,
                     3000664802,
                     1860669372, 382506485, 4236107793, 3009425926, 2591989040, 3449098397, 3523158264, 3956704965, 3125469379, 3074429269, 1211475055,
                     2325212431],
                    624, 0, 0.0)
    np_random.set_state(random_state)

    line_gen: LineGenerator = sparse_line_generator(line_length=2)
    agents_hints = {
        'city_positions': [(31, 26), (10, 40), (44, 34), (7, 27), (17, 5), (27, 41), (20, 24), (38, 8), (8, 16), (42, 22)],
        'train_stations': [[((31, 26), 0), ((31, 27), 1)], [((9, 40), 0), ((10, 40), 1), ((11, 40), 2), ((12, 40), 3)],
                           [((44, 34), 0), ((45, 34), 1)], [((7, 27), 0), ((8, 27), 1), ((9, 27), 2), ((10, 27), 3)], [((17, 5), 0), ((18, 5), 1)],
                           [((27, 40), 0), ((27, 41), 1), ((27, 42), 2), ((27, 43), 3)],
                           [((20, 24), 0), ((20, 25), 1), ((20, 26), 2), ((20, 27), 3)], [((38, 8), 0), ((39, 8), 1)],
                           [((7, 16), 0), ((8, 16), 1), ((9, 16), 2), ((10, 16), 3)], [((41, 22), 0), ((42, 22), 1), ((43, 22), 2), ((44, 22), 3)]],
        'city_orientations': [0, 3, 3, 3,
                              1, 0, 2, 1,
                              1, 1]
    }
    line = line_gen(rail, 10, agents_hints, 0, np_random)
    agent_positions = [[[(11, 40)]], [[(38, 8)]], [[(17, 5)]], [[(41, 22)]], [[(11, 40)]], [[(38, 8)]], [[(38, 8)]], [[(31, 26)]], [[(41, 22)]], [[(9, 27)]]]
    agent_directions = [[[Grid4TransitionsEnum.WEST]], [[Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.WEST]], [[Grid4TransitionsEnum.WEST]],
                        [[Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.WEST]], [[Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.NORTH]],
                        [[Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.WEST]]]
    agent_targets = [(39, 8), (10, 40), (42, 22), (18, 5), (39, 8), (12, 40), (31, 27), (39, 8), (8, 27), (44, 22)]
    agent_waypoints = {i: [[Waypoint(fpa, fda) for fpa, fda in zip(pa, da)] for pa, da in zip(pas, das)] + [[Waypoint(target, None)]] for i, (pas, das, target)
                       in enumerate(zip(agent_positions, agent_directions, agent_targets))}
    assert line == Line(agent_waypoints=agent_waypoints, agent_speeds=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0])


def test_sparse_line_generator_with_intermediate_stops():
    rail = GridTransitionMap(50, 50, RailEnvTransitions())
    rail.grid = np.array(
        [[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 16386, 1025, 1025, 1025, 1025, 17411, 1025, 5633, 1025, 1025, 1025, 1025,
          1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 1025, 1025, 5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 3089, 1025, 1025, 5633, 1025, 3089, 1025, 1097,
          1025, 17411, 1025, 1025, 1025, 38505, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386, 1025, 1097, 3089, 5633, 1025, 17411, 1097, 3089, 1025, 1025, 17411, 1025, 1097, 1025, 5633, 1025, 17411,
          1025, 3089, 1025, 5633, 4608, 72, 37408, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 0, 32800, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 72, 1097, 1025, 1097, 1025,
          5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 4608, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 3089, 5633, 1025,
          17411, 1097, 2064, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 5633, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 2064,
          0, 0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 4608, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 32800, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 4608, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          16386, 17411, 2064, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          16386, 2064, 32800, 0, 0, 0, 0, 0],
         [16386, 1025, 5633, 17411, 1025, 1025, 1025, 5633, 17411, 1025, 3089, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32872, 37408, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386, 34864, 0, 0, 0, 0, 0],
         [32800, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 16386, 33825, 33825, 2064, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 32872, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 37408, 49186, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [72, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          49186, 2064, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872,
          37408, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 38505, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186,
          34864, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 34864,
          32872, 4608, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 37408,
          49186, 2064, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 34864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872,
          37408, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186,
          34864, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16386, 2064,
          32800, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 37408, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 16386,
          2064, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49186, 2064, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          0, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0,
          0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32872, 1025, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 4608, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          0, 0, 0, 0, 0, 0, 0, 0],
         [0, 72, 1025, 1097, 1025, 5633, 17411, 1025, 1025, 1025, 5633, 17411, 1025, 5633, 5633, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 1025, 1025,
          1025, 1025, 1025, 1025, 1025, 1025, 4608, 0, 0, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 32800, 32800, 72, 4608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72,
          1025, 4608, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 32800,
          32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800, 72, 4608, 72, 4608, 0, 0, 0, 16386, 1025, 4608, 0, 0, 0, 32800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32800,
          32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 33825, 1025, 1097, 1025, 5633, 17411, 3089, 1025, 1097, 5633, 17411, 1025, 3089, 1025, 4608, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 1025, 1025, 1097, 3089, 5633, 1025, 17411, 1097, 3089, 1025, 5633, 1025, 37408, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 32800, 32800, 32800, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 1025, 2064, 0, 0, 0, 72, 1025, 1097, 1025, 5633, 17411, 1025, 1025, 1025, 5633,
          17411, 1025, 3089, 3089, 2064, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 3089, 1025, 1025, 1025, 1097, 2064, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
         [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          0]], dtype=np.uint16)
    np_random = RandomState()
    random_state = ('MT19937',
                    [2147483648, 1649661643, 2204385595, 1327114359, 539606687, 2099465216, 303851473, 1436347808, 852714359, 575232558, 1382821698, 1365943899,
                     1241224476, 3534551194, 2837091355, 3157051385, 1930656260, 1621991361, 3337394032, 1942435608, 2385092074, 3270116010, 1821450146,
                     3752120299,
                     2611729644, 3114635860, 2010847399, 3975999875, 22214436, 2278508436, 2969419436, 3688335948, 2458354792, 772357130, 2877981782,
                     2110185083,
                     1487903508, 64817640, 3427555153, 429433882, 3837758443, 2000933081, 328518905, 1879872237, 3200977831, 2088513913, 1989288599, 2909674809,
                     1796951916, 2457138500, 2604020763, 2211163582, 1030366011, 3735999881, 3068287681, 2148606875, 1502981550, 1075780261, 1211885357,
                     4264415436,
                     3670074722, 2167752278, 214926786, 615493834, 1461061972, 4011059408, 3887130633, 3423361761, 3414772315, 1682293769, 4188506610,
                     404250198,
                     3274456466, 325034300, 2269896778, 3570240424, 1128508847, 3237972663, 2475042993, 2478692482, 4051934861, 366099384, 1206987460,
                     1589814612,
                     4159293379, 4220048583, 2154987727, 4287360968, 1255019949, 4027966126, 1191843318, 103093943, 2714785611, 1860186568, 3562053579,
                     3110696691,
                     2138175472, 3182558240, 4096624133, 870621294, 3804117511, 3632611607, 1456998178, 2410699892, 403151641, 1899763855, 4251292935,
                     1950836321,
                     2946093777, 3173846308, 2438320027, 732059050, 2455178832, 669662596, 1943870001, 336602884, 3788818282, 1946366512, 1762907681,
                     4244977320,
                     2092821806, 4011939852, 2705058047, 2812388076, 1154612379, 4097791035, 1367135349, 2358711733, 663051093, 1400728441, 2516982976,
                     1351189120,
                     1338547217, 810006346, 4032851352, 1774566604, 3683786156, 94995540, 633538699, 1915359937, 523905194, 3785662339, 590989700, 480809397,
                     3562361735, 3028216725, 61174175, 3674566448, 3226325427, 2647195461, 4262079159, 955597286, 1515421022, 1670451293, 2630729714,
                     3826547451,
                     2074764500, 1128340413, 1162281050, 4225599749, 2362647596, 3521777889, 984186343, 92512844, 3251709351, 2694147366, 3491715737, 807002420,
                     1727960547, 1369709585, 3785141825, 3015832659, 2671927520, 1444767193, 2425927026, 933425004, 4230357117, 267087178, 2334705240,
                     1037872771,
                     748101849, 4264706677, 463641430, 3043173671, 796636659, 2529561541, 4007621762, 1588390719, 360345969, 2359892133, 4158969820, 3421197884,
                     869483324, 1319753001, 3946898252, 688409318, 2827192564, 1104037938, 4285345321, 2376512306, 2769871287, 2831150842, 3227231045,
                     1887214941,
                     2231951359, 4182818871, 1198021954, 386818504, 222324072, 3640400654, 159672786, 558466229, 2303933510, 1565455308, 3301036383, 547327476,
                     2903959405, 45045840, 3409001823, 2475480249, 3000441831, 437101296, 118733391, 3209888576, 371797845, 1495412523, 3410340417, 122933266,
                     421666431, 3716573900, 3571484149, 2971710455, 1922393602, 4119014813, 1570606844, 800284858, 280620014, 3902591247, 4267823416,
                     3575674764,
                     1621494958, 2398106963, 2166538658, 3516896801, 587363728, 1304426698, 1422123489, 4214649501, 2677387036, 3839923650, 2468374920,
                     1701057467,
                     3346512005, 2049709623, 171887159, 510720556, 814911597, 2316295873, 3679778699, 683519215, 1930224048, 4090725714, 3281136495, 3613750627,
                     3910396492, 1272919367, 2612600390, 2669015213, 990319672, 649713259, 2229298022, 3709930068, 1681999745, 570921791, 2058811081,
                     3558197435,
                     4209585099, 4238477666, 761112313, 1582247558, 3783959133, 3880137850, 3674847190, 3366975812, 2086458918, 2022131840, 1491741851,
                     1138027321,
                     4006544145, 663601164, 2577521234, 3420933060, 3664171069, 3447083350, 1560164785, 1327471555, 1829659600, 2353966497, 2818797807,
                     962649083,
                     2849172355, 4095736032, 2144618894, 2604555966, 2565951654, 1250218951, 2393073772, 4006669761, 766308919, 3391522753, 1166036720,
                     161108303,
                     3300436400, 3607155590, 3595000204, 3936868351, 3570618457, 2563840054, 2916398029, 1413336440, 3423499251, 2117061700, 2767227706,
                     1528043404,
                     4051655395, 2181460279, 2091503819, 2201739289, 2851065395, 1514701648, 2367065021, 462081582, 3448673786, 3407818356, 1666019318,
                     2932050398,
                     85803443, 3950600885, 3400630820, 1072170292, 3304128455, 2046306806, 2780655208, 1240192326, 1605676526, 1111538877, 1382273182,
                     1893705415,
                     507585398, 2607454137, 2749074293, 3946286383, 2586530371, 1513355174, 4010099035, 61007320, 1504482506, 3423367971, 2952086458,
                     1343538643,
                     725006089, 566827241, 1449300598, 3749887157, 1350162125, 1131055843, 1054052446, 3235657336, 4261654346, 3394391653, 2383797616,
                     3285134461,
                     1247881078, 2930311479, 3336688285, 1573714314, 2715984603, 928223088, 1971473022, 1253254317, 3419709554, 1166941943, 3173806230,
                     3960334565,
                     4119182134, 758018741, 75188810, 3533498878, 1138519668, 4089604333, 3127736739, 3368560027, 363059537, 4131654798, 3300566188, 3218228152,
                     3074998464, 2729531691, 1117778976, 3275235837, 3663368948, 322770367, 246296467, 531989057, 1951090884, 2757613851, 1632374923,
                     3885360142,
                     953142252, 395812526, 1734111462, 2191431071, 1231254447, 698759509, 371079609, 2417001428, 2163019402, 2179549232, 1641821563, 66579997,
                     2340096294, 577343611, 2320906326, 192241402, 4125916068, 2136553549, 4176085388, 2918755896, 2978907279, 3647265185, 4138749334,
                     1109792516,
                     2313436411, 472116172, 320849784, 1493330897, 3409986694, 830124966, 1109216428, 3014564778, 875250150, 2106150893, 1545511078, 3871773932,
                     4288260206, 140072917, 1710606833, 3599514394, 3836305580, 794610055, 3902758442, 3936674870, 3510211864, 188209235, 2922660945,
                     2042752757,
                     1834743549, 3265924355, 3916130414, 746323625, 4122430132, 3342351557, 2776449037, 3184970931, 1249782803, 151567899, 3139844062,
                     220751970,
                     2437389404, 3039474572, 3609134032, 3429837246, 3392064795, 212488643, 2331858110, 3340196923, 2117111123, 3977227091, 1073944544,
                     3197483355,
                     3948488979, 1443864233, 3711416750, 936822736, 144711704, 287287287, 645035017, 885434947, 101035744, 1325158782, 2493052978, 1289727404,
                     2868906505, 720407817, 4160171499, 1660376222, 1974588437, 3851307213, 3008830632, 3628895789, 1719047175, 4225823329, 2849825198,
                     1357658595,
                     2710497158, 1588103901, 1553182916, 3421095601, 1634129420, 3651529521, 1417801133, 2568231841, 2101353424, 3277581336, 1753019844,
                     783500912,
                     2758515254, 2954057812, 227782562, 3973373469, 1648077200, 2441255037, 1993138537, 1673575515, 157298829, 676150370, 4153330010,
                     3092354102,
                     954626249, 2362272204, 83987580, 3460474012, 2355241306, 4152027927, 674780370, 580714223, 2058541749, 1989410066, 3194781233, 3710279597,
                     2743945127, 1412595438, 999123907, 975906143, 2826678270, 1864781209, 3898716092, 4279550927, 4112193225, 2485544714, 2585204902,
                     1405670661,
                     459408928, 2142813828, 1895342041, 2354855906, 940201640, 3896150357, 2874813090, 3716510378, 3617349186, 2923857758, 2242749897,
                     3750657021,
                     1189757066, 2196387020, 3798552642, 3383499493, 831232405, 2422926475, 3320634516, 2223658532, 4360144, 1461795088, 3504136436, 2646502537,
                     2306390103, 998661848, 618427340, 1898541195, 1959782611, 3346555697, 1075531114, 362616681, 1825307418, 3069041695, 2867545971,
                     4272118626,
                     1347104250, 1134962299, 2329128459, 1530933548, 3673328829, 885168969, 257079043, 1509838517, 2022933874, 1005779941, 3716661034,
                     2914985666,
                     699624100, 1768376676, 401160693, 2356759728, 1638227403, 1971242660, 3937725790, 2582994844, 4158339204, 4174554769, 160914354,
                     3000664802,
                     1860669372, 382506485, 4236107793, 3009425926, 2591989040, 3449098397, 3523158264, 3956704965, 3125469379, 3074429269, 1211475055,
                     2325212431],
                    624, 0, 0.0)
    np_random.set_state(random_state)

    line_gen: LineGenerator = sparse_line_generator(line_length=3)
    agents_hints = {
        'city_positions': [(31, 26), (10, 40), (44, 34), (7, 27), (17, 5), (27, 41), (20, 24), (38, 8), (8, 16), (42, 22)],
        'train_stations': [[((31, 26), 0), ((31, 27), 1)], [((9, 40), 0), ((10, 40), 1), ((11, 40), 2), ((12, 40), 3)],
                           [((44, 34), 0), ((45, 34), 1)], [((7, 27), 0), ((8, 27), 1), ((9, 27), 2), ((10, 27), 3)], [((17, 5), 0), ((18, 5), 1)],
                           [((27, 40), 0), ((27, 41), 1), ((27, 42), 2), ((27, 43), 3)],
                           [((20, 24), 0), ((20, 25), 1), ((20, 26), 2), ((20, 27), 3)], [((38, 8), 0), ((39, 8), 1)],
                           [((7, 16), 0), ((8, 16), 1), ((9, 16), 2), ((10, 16), 3)], [((41, 22), 0), ((42, 22), 1), ((43, 22), 2), ((44, 22), 3)]],
        'city_orientations': [0, 3, 3, 3,
                              1, 0, 2, 1,
                              1, 1]
    }
    line = line_gen(rail, 10, agents_hints, 0, np_random)

    agent_positions = [[[(11, 40)], [(38, 8)]], [[(27, 40)], [(38, 8)]], [[(20, 26)], [(9, 27)]], [[(11, 40)], [(9, 27)]], [[(38, 8)], [(31, 26)]],
                       [[(44, 34)], [(31, 26)]],
                       [[(17, 5)], [(41, 22)]], [[(9, 40)], [(41, 22)]], [[(38, 8)], [(41, 22)]], [[(20, 24)], [(41, 22)]]]
    agent_directions = [[[Grid4TransitionsEnum.WEST], [Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.NORTH], [Grid4TransitionsEnum.WEST]],
                        [[Grid4TransitionsEnum.SOUTH], [Grid4TransitionsEnum.WEST]], [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.WEST]],
                        [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.NORTH]], [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.NORTH]],
                        [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.WEST]], [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.WEST]],
                        [[Grid4TransitionsEnum.EAST], [Grid4TransitionsEnum.EAST]], [[Grid4TransitionsEnum.NORTH], [Grid4TransitionsEnum.WEST]]]
    agent_targets = [(27, 41), (12, 40), (10, 40), (20, 27), (45, 34), (39, 8), (12, 40), (18, 5), (20, 25), (39, 8)]
    agent_waypoints = {i: [[Waypoint(fpa, fda) for fpa, fda in zip(pa, da)] for pa, da in zip(pas, das)] + [[Waypoint(target, None)]] for i, (pas, das, target)
                       in enumerate(zip(agent_positions, agent_directions, agent_targets))}

    assert line == Line(agent_waypoints=agent_waypoints, agent_speeds=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0])
    for a in EnvAgent.from_line(line):
        print(
            f"EnvAgent(handle={a.handle}, initial_position={a.initial_position}, initial_direction={a.initial_direction}, target={a.target}, direction={a.direction}, waypoints={a.waypoints}, waypoints_latest_arrival={a.waypoints_earliest_departure}, waypoints_earliest_departure={a.waypoints_latest_arrival}),")
