# The Air Web Framework: A Complete Guide

Welcome to **The Air Web Framework: A Complete Guide** - your comprehensive resource for building modern web applications with Air. This book is designed for developers of all levels, whether you're just starting with Python web development or looking to leverage Air's sophisticated features in your next project.

Air is a high-level layer over FastAPI that streamlines the creation of both interactive web interfaces and robust REST APIs within a single application. Built with developer experience in mind, Air provides an elegant Pythonic approach to modern web development.

This guide demonstrates how to build a complete blog application, showcasing both basic concepts for newcomers and advanced patterns that experienced developers can leverage in production systems.

## Table of Contents

1. [Introduction to Air](01-introduction.md)
2. [Getting Started](02-getting-started.md)
3. [AI-Enhanced Development Setup](03-ai-enhanced-development-setup.md)
4. [Air Tags and Layouts](04-air-tags-and-layouts.md)
5. [Building Our Blog Application](05-building-blog-application.md)
6. [Advanced Routing and URL Management](06-advanced-routing.md)
7. [Forms and Data Validation](07-forms-validation.md)
8. [Working with Databases](08-databases.md)
9. [API Development](09-api-development.md)
10. [HTMX and Interactive Interfaces](10-htmx-interfaces.md)
11. [Authentication and Security](11-authentication-security.md)
12. [Testing](12-testing.md)
13. [Deployment](13-deployment.md)
14. [Advanced Patterns and Best Practices](14-advanced-patterns.md)