# Learn 

Resources for learning the fundamentals of the Air web framework.

- **[Quickstart](quickstart.md)** - The TL;DR for getting started with Air, including many fundamental operations necessary for web development.

## Concepts

Why and how Air works.

- **[Air Tags](air_tags.md)** - An exploration of Air's Tag HTML generation system
- **[Escaping HTML](escaping_html.md)** - How Air handles escaping HTML to prevent XSS attacks
- **[Forms](forms.md)** - How to create and validate forms in Air
- **[Jinja](jinja.md)** - How to use Jinja templates in Air
- **[Layouts](layouts.md)** - Tools for building layouts in Air along with two simple layout systems
- **[SQLModel](sqlmodel.md)** - One way to use SQL databases in Air apps (to be moved to an external package soon)

# Cookbook

A handy Air-themed list of recipes for common web app tasks.

This section contains short recipes. See the topic pages for details:

- **[app.page decorator](cookbook/page-decorator.md)** - how to use the `@app.page` decorator to quickly create web pages
- **[Authentication](cookbook/authentication.md)** - how to handle login and authentication in your application
- **[Bigger applications](cookbook/bigger-applications.md)** - how to structure larger applications
- **[Charts](cookbook/charts.md)** - Examples of using charts in Air
- **[Minimal app](cookbook/minimal.md)** - The smallest possible Air app
- **[Forms & validation](cookbook/forms.md)** - how to create forms and validate user input
- **[Static files](cookbook/static.md)** - how to serve static files like CSS and JavaScript

If you'd like to contribute a recipe, open a PR with a new file under `docs/learn/cookbook`.

