"""A FastAPI-powered breath of fresh air in Python web development."""

from starlette.staticfiles import StaticFiles as StaticFiles

from . import (
    ext as ext,
    layouts as layouts,
    responses as responses,
)
from .applications import (
    Air as Air,
    AirRoute as AirRoute,
)
from .background import BackgroundTasks as BackgroundTasks
from .dependencies import is_htmx_request as is_htmx_request
from .exceptions import (
    HTTPException as HTTPException,
    RenderException as RenderException,
)
from .forms import (
    AirField as AirField,
    AirForm as AirForm,
)
from .middleware import SessionMiddleware as SessionMiddleware
from .requests import (
    AirRequest as AirRequest,
    Request as Request,
)
from .responses import (
    AirResponse as AirResponse,
    RedirectResponse as RedirectResponse,
    SSEResponse as SSEResponse,
    TagResponse as TagResponse,
)
from .routing import AirRouter as AirRouter
from .tags import (
    H1 as H1,
    H2 as H2,
    H3 as H3,
    H4 as H4,
    H5 as H5,
    H6 as H6,
    A as A,
    Abbr as Abbr,
    Address as Address,
    Area as Area,
    Article as Article,
    Aside as Aside,
    Audio as Audio,
    B as B,
    Base as Base,
    BaseTag as BaseTag,
    Bdi as Bdi,
    Bdo as Bdo,
    Blockquote as Blockquote,
    Body as Body,
    Br as Br,
    Button as Button,
    Canvas as Canvas,
    Caption as Caption,
    Children as Children,
    Cite as Cite,
    Code as Code,
    Col as Col,
    Colgroup as Colgroup,
    Data as Data,
    Datalist as Datalist,
    Dd as Dd,
    Del as Del,
    Details as Details,
    Dfn as Dfn,
    Dialog as Dialog,
    Div as Div,
    Dl as Dl,
    Dt as Dt,
    Em as Em,
    Embed as Embed,
    Fieldset as Fieldset,
    Figcaption as Figcaption,
    Figure as Figure,
    Footer as Footer,
    Form as Form,
    Fragment as Fragment,
    Head as Head,
    Header as Header,
    Hgroup as Hgroup,
    Hr as Hr,
    Html as Html,
    I as I,
    Iframe as Iframe,
    Img as Img,
    Input as Input,
    Ins as Ins,
    Kbd as Kbd,
    Label as Label,
    Legend as Legend,
    Li as Li,
    Link as Link,
    Main as Main,
    Map as Map,
    Mark as Mark,
    Menu as Menu,
    Meta as Meta,
    Meter as Meter,
    Nav as Nav,
    Noscript as Noscript,
    Object as Object,
    Ol as Ol,
    Optgroup as Optgroup,
    Option as Option,
    Output as Output,
    P as P,
    Param as Param,
    Picture as Picture,
    Pre as Pre,
    Progress as Progress,
    Q as Q,
    Raw as Raw,
    Rp as Rp,
    Rt as Rt,
    Ruby as Ruby,
    S as S,
    SafeStr as SafeStr,
    Samp as Samp,
    Script as Script,
    Search as Search,
    Section as Section,
    Select as Select,
    SelfClosingTag as SelfClosingTag,
    Small as Small,
    Source as Source,
    Span as Span,
    Strong as Strong,
    Style as Style,
    Sub as Sub,
    Summary as Summary,
    Sup as Sup,
    Table as Table,
    Tag as Tag,
    TagDictType as TagDictType,
    TagKeys as TagKeys,
    Tags as Tags,
    Tbody as Tbody,
    Td as Td,
    Template as Template,
    Textarea as Textarea,
    Tfoot as Tfoot,
    Th as Th,
    Thead as Thead,
    Time as Time,
    Title as Title,
    Tr as Tr,
    Track as Track,
    Transparent as Transparent,
    U as U,
    Ul as Ul,
    UnSafeTag as UnSafeTag,
    Var as Var,
    Video as Video,
    Wbr as Wbr,
    svg as svg,
)
from .templating import (
    JinjaRenderer as JinjaRenderer,
    Renderer as Renderer,
)
