import pytest
from moviebox_api.requests import Session
from moviebox_api.core import Search, SubjectType
from moviebox_api.download import (
    DownloadableMovieFilesDetail,
    DownloadableSeriesFilesDetail,
    CaptionFileDownloader,
    MediaFileDownloader,
)


@pytest.mark.asyncio
async def test_download_movie_caption_file():
    session = Session()
    search = Search(session, "avatar", subject_type=SubjectType.MOVIES)
    search_results = await search.get_modelled_content()
    target_movie = search_results.first_item

    downloadable_files = DownloadableMovieFilesDetail(session, target_movie)
    downloadable_files_detail = await downloadable_files.get_modelled_content()
    target_caption_file = downloadable_files_detail.english_subtitle_file

    caption_file_downloader = CaptionFileDownloader(target_caption_file)
    response = await caption_file_downloader.run(
        filename=target_movie.title + "- English.srt", test=True
    )
    assert response.is_success == True


@pytest.mark.asyncio
async def test_download_movie_file():
    session = Session()
    search = Search(session, "avatar", subject_type=SubjectType.MOVIES)
    search_results = await search.get_modelled_content()
    target_movie = search_results.first_item

    downloadable_files = DownloadableMovieFilesDetail(session, target_movie)
    downloadable_files_detail = await downloadable_files.get_modelled_content()
    target_media_file = downloadable_files_detail.best_media_file

    media_file_downloader = MediaFileDownloader(target_media_file)
    response = await media_file_downloader.run(
        filename=target_movie.title + ".mp4", test=True
    )
    assert response.is_success == True


@pytest.mark.asyncio
async def test_download_tv_series_caption_file():
    session = Session()
    search = Search(session, "Merlin", subject_type=SubjectType.TV_SERIES)
    search_results = await search.get_modelled_content()
    target_series = search_results.first_item
    downloadable_files = DownloadableSeriesFilesDetail(session, target_series)
    downloadable_files_detail = await downloadable_files.get_modelled_content(
        season=1, episode=1
    )
    target_caption_file = downloadable_files_detail.english_subtitle_file

    caption_file_downloader = CaptionFileDownloader(target_caption_file)
    response = await caption_file_downloader.run(filename=target_series, test=True)
    assert response.is_success == True


@pytest.mark.asyncio
async def test_download_tv_series_file():
    session = Session()
    search = Search(session, "Merlin", subject_type=SubjectType.TV_SERIES)
    search_results = await search.get_modelled_content()
    target_series = search_results.first_item
    downloadable_files = DownloadableSeriesFilesDetail(session, target_series)
    downloadable_files_detail = await downloadable_files.get_modelled_content(
        season=1, episode=1
    )
    target_media_file = downloadable_files_detail.best_media_file

    media_file_downloader = MediaFileDownloader(target_media_file)
    response = await media_file_downloader.run(filename=target_series, test=True)
    assert response.is_success == True
