# NOSP：轻量爬取工具

**NOSP** 是一个轻量级、模块化的 Python 框架，专为高效的网络爬取而设计。它为开发者提供了构建健壮且可扩展的网络爬虫所需的基本工具，同时处理常见的技术挑战，如并发、HTTP 请求、内容解析和数据存储。

作为一个专门的工具包，NOSP 通过提供预构建的组件，简化了复杂的爬取流程，帮助开发者专注于数据提取，而非底层实现细节。

------

## 主要特性

| 特性              | 描述                                                    |
| ----------------- | ------------------------------------------------------- |
| **多线程爬取**    | 内置线程池管理，支持高效并发操作                        |
| **HTTP 请求处理** | 强大的请求管理，支持重试机制、代理配置、请求/响应拦截器 |
| **内容解析**      | 基于 XPath 的强大内容提取工具，支持结构化数据抽取       |
| **数据库集成**    | 直接集成 MySQL 和 Redis，支持便捷的数据存储与缓存       |
| **错误处理**      | 全面的异常管理机制，确保爬虫在异常情况下的稳定性与韧性  |
| **资源提取**      | 提供专用工具，用于从网页中提取附件、图片等二进制资源    |

------

## 框架架构

NOSP 采用**模块化设计**，将关注点分离到独立组件中，同时保持清晰的接口定义。这种设计允许开发者按需使用特定模块，提升灵活性与可维护性。

### 核心组件

- **`BaseSpider` 类**：框架的核心，负责协调爬取工作流程，调度请求、解析与存储。
- **模块化结构**：各功能模块（如请求、解析、存储）松耦合，易于替换或扩展。

------

## 何时使用 NOSP？

NOSP 在以下场景中特别有价值：

- ✅ 需要构建**可维护、结构化**的网络爬虫
- ✅ 项目要求**高效率**，需支持并发操作
- ✅ 希望避免重复实现常见功能（如代理管理、解析逻辑、数据存储）
- ✅ 需要一个**灵活可扩展**的基础框架，适应不同爬取需求

> **适用范围**：既适用于简单的数据抓取任务，也足以支撑复杂的生产级爬虫系统。

------

## 核心概念

NOSP 围绕以下核心概念构建，理解这些概念是高效使用框架的关键：

| 概念                | 说明                                                         |
| ------------------- | ------------------------------------------------------------ |
| **爬虫 (Spider)**   | 协调整个爬取流程的核心类，定义起始 URL、解析逻辑和后续请求   |
| **请求 (Request)**  | 封装 HTTP 请求，支持自定义 headers、cookies、代理、重试等    |
| **解析器 (Parser)** | 负责从网页 HTML 内容中提取结构化数据，支持 XPath 和正则表达式 |
| **存储 (Storage)**  | 处理爬取数据的持久化，支持写入数据库（MySQL/Redis）或本地文件 |