"""anyio bridge to the sqlite3 standard module"""

import sys
import warnings
from sqlite3 import (
    PARSE_COLNAMES,
    PARSE_DECLTYPES,
    SQLITE_DENY,
    SQLITE_IGNORE,
    SQLITE_OK,
    DatabaseError,
    DataError,
    Error,
    IntegrityError,
    InterfaceError,
    InternalError,
    NotSupportedError,
    OperationalError,
    PrepareProtocol,
    ProgrammingError,
    Row,
    complete_statement,
    enable_callback_tracebacks,
    paramstyle,
    register_adapter,
    register_converter,
    sqlite_version,
    sqlite_version_info,
)

from .connection import Connection, connect
from .cursor import Cursor

if sys.version_info < (3, 10):
    from sqlite3 import OptimizedUnicode

if sys.version_info < (3, 12):
    from sqlite3 import enable_shared_cache, version

if sys.version_info < (3, 14):
    with warnings.catch_warnings():
        warnings.simplefilter("ignore", category=DeprecationWarning)
        from sqlite3 import version_info

if sys.version_info >= (3, 11):
    from sqlite3 import (
        SQLITE_ABORT,
        SQLITE_ABORT_ROLLBACK,
        SQLITE_AUTH,
        SQLITE_AUTH_USER,
        SQLITE_BUSY,
        SQLITE_BUSY_RECOVERY,
        SQLITE_BUSY_SNAPSHOT,
        SQLITE_BUSY_TIMEOUT,
        SQLITE_CANTOPEN,
        SQLITE_CANTOPEN_CONVPATH,
        SQLITE_CANTOPEN_DIRTYWAL,
        SQLITE_CANTOPEN_FULLPATH,
        SQLITE_CANTOPEN_ISDIR,
        SQLITE_CANTOPEN_NOTEMPDIR,
        SQLITE_CANTOPEN_SYMLINK,
        SQLITE_CONSTRAINT,
        SQLITE_CONSTRAINT_CHECK,
        SQLITE_CONSTRAINT_COMMITHOOK,
        SQLITE_CONSTRAINT_FOREIGNKEY,
        SQLITE_CONSTRAINT_FUNCTION,
        SQLITE_CONSTRAINT_NOTNULL,
        SQLITE_CONSTRAINT_PINNED,
        SQLITE_CONSTRAINT_PRIMARYKEY,
        SQLITE_CONSTRAINT_ROWID,
        SQLITE_CONSTRAINT_TRIGGER,
        SQLITE_CONSTRAINT_UNIQUE,
        SQLITE_CONSTRAINT_VTAB,
        SQLITE_CORRUPT,
        SQLITE_CORRUPT_INDEX,
        SQLITE_CORRUPT_SEQUENCE,
        SQLITE_CORRUPT_VTAB,
        SQLITE_EMPTY,
        SQLITE_ERROR,
        SQLITE_ERROR_MISSING_COLLSEQ,
        SQLITE_ERROR_RETRY,
        SQLITE_ERROR_SNAPSHOT,
        SQLITE_FORMAT,
        SQLITE_FULL,
        SQLITE_INTERNAL,
        SQLITE_INTERRUPT,
        SQLITE_IOERR,
        SQLITE_IOERR_ACCESS,
        SQLITE_IOERR_AUTH,
        SQLITE_IOERR_BEGIN_ATOMIC,
        SQLITE_IOERR_BLOCKED,
        SQLITE_IOERR_CHECKRESERVEDLOCK,
        SQLITE_IOERR_CLOSE,
        SQLITE_IOERR_COMMIT_ATOMIC,
        SQLITE_IOERR_CONVPATH,
        SQLITE_IOERR_CORRUPTFS,
        SQLITE_IOERR_DATA,
        SQLITE_IOERR_DELETE,
        SQLITE_IOERR_DELETE_NOENT,
        SQLITE_IOERR_DIR_CLOSE,
        SQLITE_IOERR_DIR_FSYNC,
        SQLITE_IOERR_FSTAT,
        SQLITE_IOERR_FSYNC,
        SQLITE_IOERR_GETTEMPPATH,
        SQLITE_IOERR_LOCK,
        SQLITE_IOERR_MMAP,
        SQLITE_IOERR_NOMEM,
        SQLITE_IOERR_RDLOCK,
        SQLITE_IOERR_READ,
        SQLITE_IOERR_ROLLBACK_ATOMIC,
        SQLITE_IOERR_SEEK,
        SQLITE_IOERR_SHMLOCK,
        SQLITE_IOERR_SHMMAP,
        SQLITE_IOERR_SHMOPEN,
        SQLITE_IOERR_SHMSIZE,
        SQLITE_IOERR_SHORT_READ,
        SQLITE_IOERR_TRUNCATE,
        SQLITE_IOERR_UNLOCK,
        SQLITE_IOERR_VNODE,
        SQLITE_IOERR_WRITE,
        SQLITE_LIMIT_ATTACHED,
        SQLITE_LIMIT_COLUMN,
        SQLITE_LIMIT_COMPOUND_SELECT,
        SQLITE_LIMIT_EXPR_DEPTH,
        SQLITE_LIMIT_FUNCTION_ARG,
        SQLITE_LIMIT_LENGTH,
        SQLITE_LIMIT_LIKE_PATTERN_LENGTH,
        SQLITE_LIMIT_SQL_LENGTH,
        SQLITE_LIMIT_TRIGGER_DEPTH,
        SQLITE_LIMIT_VARIABLE_NUMBER,
        SQLITE_LIMIT_VDBE_OP,
        SQLITE_LIMIT_WORKER_THREADS,
        SQLITE_LOCKED,
        SQLITE_LOCKED_SHAREDCACHE,
        SQLITE_LOCKED_VTAB,
        SQLITE_MISMATCH,
        SQLITE_MISUSE,
        SQLITE_NOLFS,
        SQLITE_NOMEM,
        SQLITE_NOTADB,
        SQLITE_NOTFOUND,
        SQLITE_NOTICE,
        SQLITE_NOTICE_RECOVER_ROLLBACK,
        SQLITE_NOTICE_RECOVER_WAL,
        SQLITE_OK_LOAD_PERMANENTLY,
        SQLITE_OK_SYMLINK,
        SQLITE_PERM,
        SQLITE_PROTOCOL,
        SQLITE_RANGE,
        SQLITE_READONLY,
        SQLITE_READONLY_CANTINIT,
        SQLITE_READONLY_CANTLOCK,
        SQLITE_READONLY_DBMOVED,
        SQLITE_READONLY_DIRECTORY,
        SQLITE_READONLY_RECOVERY,
        SQLITE_READONLY_ROLLBACK,
        SQLITE_ROW,
        SQLITE_SCHEMA,
        SQLITE_TOOBIG,
        SQLITE_WARNING,
        SQLITE_WARNING_AUTOINDEX,
    )

    from .blob import Blob

if sys.version_info >= (3, 12):
    from sqlite3 import (
        LEGACY_TRANSACTION_CONTROL,
        SQLITE_DBCONFIG_DEFENSIVE,
        SQLITE_DBCONFIG_DQS_DDL,
        SQLITE_DBCONFIG_DQS_DML,
        SQLITE_DBCONFIG_ENABLE_FKEY,
        SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER,
        SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION,
        SQLITE_DBCONFIG_ENABLE_QPSG,
        SQLITE_DBCONFIG_ENABLE_TRIGGER,
        SQLITE_DBCONFIG_ENABLE_VIEW,
        SQLITE_DBCONFIG_LEGACY_ALTER_TABLE,
        SQLITE_DBCONFIG_LEGACY_FILE_FORMAT,
        SQLITE_DBCONFIG_NO_CKPT_ON_CLOSE,
        SQLITE_DBCONFIG_RESET_DATABASE,
        SQLITE_DBCONFIG_TRIGGER_EQP,
        SQLITE_DBCONFIG_TRUSTED_SCHEMA,
        SQLITE_DBCONFIG_WRITABLE_SCHEMA,
    )


__all__ = [
    "PARSE_COLNAMES",
    "PARSE_DECLTYPES",
    "SQLITE_DENY",
    "SQLITE_IGNORE",
    "SQLITE_OK",
    "Connection",
    "Cursor",
    "DataError",
    "DatabaseError",
    "Error",
    "IntegrityError",
    "InterfaceError",
    "InternalError",
    "NotSupportedError",
    "OperationalError",
    "PrepareProtocol",
    "ProgrammingError",
    "Row",
    "complete_statement",
    "connect",
    "enable_callback_tracebacks",
    "paramstyle",
    "register_adapter",
    "register_converter",
    "sqlite_version",
    "sqlite_version_info",
]

if sys.version_info < (3, 10):
    __all__ += ["OptimizedUnicode"]

if sys.version_info < (3, 12):
    __all__ += ["enable_shared_cache", "version"]

if sys.version_info < (3, 14):
    __all__ += ["version_info"]

if sys.version_info >= (3, 11):
    __all__ += [
        "SQLITE_ABORT",
        "SQLITE_ABORT_ROLLBACK",
        "SQLITE_AUTH",
        "SQLITE_AUTH_USER",
        "SQLITE_BUSY",
        "SQLITE_BUSY_RECOVERY",
        "SQLITE_BUSY_SNAPSHOT",
        "SQLITE_BUSY_TIMEOUT",
        "SQLITE_CANTOPEN",
        "SQLITE_CANTOPEN_CONVPATH",
        "SQLITE_CANTOPEN_DIRTYWAL",
        "SQLITE_CANTOPEN_FULLPATH",
        "SQLITE_CANTOPEN_ISDIR",
        "SQLITE_CANTOPEN_NOTEMPDIR",
        "SQLITE_CANTOPEN_SYMLINK",
        "SQLITE_CONSTRAINT",
        "SQLITE_CONSTRAINT_CHECK",
        "SQLITE_CONSTRAINT_COMMITHOOK",
        "SQLITE_CONSTRAINT_FOREIGNKEY",
        "SQLITE_CONSTRAINT_FUNCTION",
        "SQLITE_CONSTRAINT_NOTNULL",
        "SQLITE_CONSTRAINT_PINNED",
        "SQLITE_CONSTRAINT_PRIMARYKEY",
        "SQLITE_CONSTRAINT_ROWID",
        "SQLITE_CONSTRAINT_TRIGGER",
        "SQLITE_CONSTRAINT_UNIQUE",
        "SQLITE_CONSTRAINT_VTAB",
        "SQLITE_CORRUPT",
        "SQLITE_CORRUPT_INDEX",
        "SQLITE_CORRUPT_SEQUENCE",
        "SQLITE_CORRUPT_VTAB",
        "SQLITE_EMPTY",
        "SQLITE_ERROR",
        "SQLITE_ERROR_MISSING_COLLSEQ",
        "SQLITE_ERROR_RETRY",
        "SQLITE_ERROR_SNAPSHOT",
        "SQLITE_FORMAT",
        "SQLITE_FULL",
        "SQLITE_INTERNAL",
        "SQLITE_INTERRUPT",
        "SQLITE_IOERR",
        "SQLITE_IOERR_ACCESS",
        "SQLITE_IOERR_AUTH",
        "SQLITE_IOERR_BEGIN_ATOMIC",
        "SQLITE_IOERR_BLOCKED",
        "SQLITE_IOERR_CHECKRESERVEDLOCK",
        "SQLITE_IOERR_CLOSE",
        "SQLITE_IOERR_COMMIT_ATOMIC",
        "SQLITE_IOERR_CONVPATH",
        "SQLITE_IOERR_CORRUPTFS",
        "SQLITE_IOERR_DATA",
        "SQLITE_IOERR_DELETE",
        "SQLITE_IOERR_DELETE_NOENT",
        "SQLITE_IOERR_DIR_CLOSE",
        "SQLITE_IOERR_DIR_FSYNC",
        "SQLITE_IOERR_FSTAT",
        "SQLITE_IOERR_FSYNC",
        "SQLITE_IOERR_GETTEMPPATH",
        "SQLITE_IOERR_LOCK",
        "SQLITE_IOERR_MMAP",
        "SQLITE_IOERR_NOMEM",
        "SQLITE_IOERR_RDLOCK",
        "SQLITE_IOERR_READ",
        "SQLITE_IOERR_ROLLBACK_ATOMIC",
        "SQLITE_IOERR_SEEK",
        "SQLITE_IOERR_SHMLOCK",
        "SQLITE_IOERR_SHMMAP",
        "SQLITE_IOERR_SHMOPEN",
        "SQLITE_IOERR_SHMSIZE",
        "SQLITE_IOERR_SHORT_READ",
        "SQLITE_IOERR_TRUNCATE",
        "SQLITE_IOERR_UNLOCK",
        "SQLITE_IOERR_VNODE",
        "SQLITE_IOERR_WRITE",
        "SQLITE_LIMIT_ATTACHED",
        "SQLITE_LIMIT_COLUMN",
        "SQLITE_LIMIT_COMPOUND_SELECT",
        "SQLITE_LIMIT_EXPR_DEPTH",
        "SQLITE_LIMIT_FUNCTION_ARG",
        "SQLITE_LIMIT_LENGTH",
        "SQLITE_LIMIT_LIKE_PATTERN_LENGTH",
        "SQLITE_LIMIT_SQL_LENGTH",
        "SQLITE_LIMIT_TRIGGER_DEPTH",
        "SQLITE_LIMIT_VARIABLE_NUMBER",
        "SQLITE_LIMIT_VDBE_OP",
        "SQLITE_LIMIT_WORKER_THREADS",
        "SQLITE_LOCKED",
        "SQLITE_LOCKED_SHAREDCACHE",
        "SQLITE_LOCKED_VTAB",
        "SQLITE_MISMATCH",
        "SQLITE_MISUSE",
        "SQLITE_NOLFS",
        "SQLITE_NOMEM",
        "SQLITE_NOTADB",
        "SQLITE_NOTFOUND",
        "SQLITE_NOTICE",
        "SQLITE_NOTICE_RECOVER_ROLLBACK",
        "SQLITE_NOTICE_RECOVER_WAL",
        "SQLITE_OK_LOAD_PERMANENTLY",
        "SQLITE_OK_SYMLINK",
        "SQLITE_PERM",
        "SQLITE_PROTOCOL",
        "SQLITE_RANGE",
        "SQLITE_READONLY",
        "SQLITE_READONLY_CANTINIT",
        "SQLITE_READONLY_CANTLOCK",
        "SQLITE_READONLY_DBMOVED",
        "SQLITE_READONLY_DIRECTORY",
        "SQLITE_READONLY_RECOVERY",
        "SQLITE_READONLY_ROLLBACK",
        "SQLITE_ROW",
        "SQLITE_SCHEMA",
        "SQLITE_TOOBIG",
        "SQLITE_WARNING",
        "SQLITE_WARNING_AUTOINDEX",
        "Blob",
    ]


if sys.version_info >= (3, 12):
    __all__ += [
        "LEGACY_TRANSACTION_CONTROL",
        "SQLITE_DBCONFIG_DEFENSIVE",
        "SQLITE_DBCONFIG_DQS_DDL",
        "SQLITE_DBCONFIG_DQS_DML",
        "SQLITE_DBCONFIG_ENABLE_FKEY",
        "SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER",
        "SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION",
        "SQLITE_DBCONFIG_ENABLE_QPSG",
        "SQLITE_DBCONFIG_ENABLE_TRIGGER",
        "SQLITE_DBCONFIG_ENABLE_VIEW",
        "SQLITE_DBCONFIG_LEGACY_ALTER_TABLE",
        "SQLITE_DBCONFIG_LEGACY_FILE_FORMAT",
        "SQLITE_DBCONFIG_NO_CKPT_ON_CLOSE",
        "SQLITE_DBCONFIG_RESET_DATABASE",
        "SQLITE_DBCONFIG_TRIGGER_EQP",
        "SQLITE_DBCONFIG_TRUSTED_SCHEMA",
        "SQLITE_DBCONFIG_WRITABLE_SCHEMA",
    ]
