# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApmRetentionFilterArgs', 'ApmRetentionFilter']

@pulumi.input_type
class ApmRetentionFilterArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 filter_type: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 rate: pulumi.Input[_builtins.str],
                 filter: Optional[pulumi.Input['ApmRetentionFilterFilterArgs']] = None,
                 trace_rate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApmRetentionFilter resource.
        :param pulumi.Input[_builtins.bool] enabled: the status of the retention filter.
        :param pulumi.Input[_builtins.str] filter_type: The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        :param pulumi.Input[_builtins.str] name: The name of the retention filter.
        :param pulumi.Input[_builtins.str] rate: Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        :param pulumi.Input['ApmRetentionFilterFilterArgs'] filter: The spans filter. Spans matching this filter will be indexed and stored.
        :param pulumi.Input[_builtins.str] trace_rate: Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rate", rate)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if trace_rate is not None:
            pulumi.set(__self__, "trace_rate", trace_rate)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        the status of the retention filter.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the retention filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rate(self) -> pulumi.Input[_builtins.str]:
        """
        Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rate", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ApmRetentionFilterFilterArgs']]:
        """
        The spans filter. Spans matching this filter will be indexed and stored.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ApmRetentionFilterFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="traceRate")
    def trace_rate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "trace_rate")

    @trace_rate.setter
    def trace_rate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_rate", value)


@pulumi.input_type
class _ApmRetentionFilterState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input['ApmRetentionFilterFilterArgs']] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_rate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApmRetentionFilter resources.
        :param pulumi.Input[_builtins.bool] enabled: the status of the retention filter.
        :param pulumi.Input['ApmRetentionFilterFilterArgs'] filter: The spans filter. Spans matching this filter will be indexed and stored.
        :param pulumi.Input[_builtins.str] filter_type: The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        :param pulumi.Input[_builtins.str] name: The name of the retention filter.
        :param pulumi.Input[_builtins.str] rate: Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        :param pulumi.Input[_builtins.str] trace_rate: Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)
        if trace_rate is not None:
            pulumi.set(__self__, "trace_rate", trace_rate)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        the status of the retention filter.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ApmRetentionFilterFilterArgs']]:
        """
        The spans filter. Spans matching this filter will be indexed and stored.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ApmRetentionFilterFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the retention filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rate", value)

    @_builtins.property
    @pulumi.getter(name="traceRate")
    def trace_rate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "trace_rate")

    @trace_rate.setter
    def trace_rate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_rate", value)


@pulumi.type_token("datadog:index/apmRetentionFilter:ApmRetentionFilter")
class ApmRetentionFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['ApmRetentionFilterFilterArgs', 'ApmRetentionFilterFilterArgsDict']]] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_rate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The object describing the configuration of the retention filter to create/update.

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing APM retention filter

        ```sh
        $ pulumi import datadog:index/apmRetentionFilter:ApmRetentionFilter foo <filter_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: the status of the retention filter.
        :param pulumi.Input[Union['ApmRetentionFilterFilterArgs', 'ApmRetentionFilterFilterArgsDict']] filter: The spans filter. Spans matching this filter will be indexed and stored.
        :param pulumi.Input[_builtins.str] filter_type: The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        :param pulumi.Input[_builtins.str] name: The name of the retention filter.
        :param pulumi.Input[_builtins.str] rate: Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        :param pulumi.Input[_builtins.str] trace_rate: Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApmRetentionFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The object describing the configuration of the retention filter to create/update.

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing APM retention filter

        ```sh
        $ pulumi import datadog:index/apmRetentionFilter:ApmRetentionFilter foo <filter_id>
        ```

        :param str resource_name: The name of the resource.
        :param ApmRetentionFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApmRetentionFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['ApmRetentionFilterFilterArgs', 'ApmRetentionFilterFilterArgsDict']]] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_rate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApmRetentionFilterArgs.__new__(ApmRetentionFilterArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            if filter_type is None and not opts.urn:
                raise TypeError("Missing required property 'filter_type'")
            __props__.__dict__["filter_type"] = filter_type
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if rate is None and not opts.urn:
                raise TypeError("Missing required property 'rate'")
            __props__.__dict__["rate"] = rate
            __props__.__dict__["trace_rate"] = trace_rate
        super(ApmRetentionFilter, __self__).__init__(
            'datadog:index/apmRetentionFilter:ApmRetentionFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filter: Optional[pulumi.Input[Union['ApmRetentionFilterFilterArgs', 'ApmRetentionFilterFilterArgsDict']]] = None,
            filter_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rate: Optional[pulumi.Input[_builtins.str]] = None,
            trace_rate: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApmRetentionFilter':
        """
        Get an existing ApmRetentionFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: the status of the retention filter.
        :param pulumi.Input[Union['ApmRetentionFilterFilterArgs', 'ApmRetentionFilterFilterArgsDict']] filter: The spans filter. Spans matching this filter will be indexed and stored.
        :param pulumi.Input[_builtins.str] filter_type: The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        :param pulumi.Input[_builtins.str] name: The name of the retention filter.
        :param pulumi.Input[_builtins.str] rate: Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        :param pulumi.Input[_builtins.str] trace_rate: Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApmRetentionFilterState.__new__(_ApmRetentionFilterState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["filter_type"] = filter_type
        __props__.__dict__["name"] = name
        __props__.__dict__["rate"] = rate
        __props__.__dict__["trace_rate"] = trace_rate
        return ApmRetentionFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        the status of the retention filter.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.ApmRetentionFilterFilter']]:
        """
        The spans filter. Spans matching this filter will be indexed and stored.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the retention filter, currently only spans-processing-sampling is available. Valid values are `spans-sampling-processor`.
        """
        return pulumi.get(self, "filter_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the retention filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> pulumi.Output[_builtins.str]:
        """
        Sample rate to apply to spans going through this retention filter as a string; a value of 1.0 keeps all spans matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "rate")

    @_builtins.property
    @pulumi.getter(name="traceRate")
    def trace_rate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sample rate to apply to traces with spans going through this retention filter as a string; a value of 1.0 keeps all traces matching the query. Value must be between 0.00 and 1.00.
        """
        return pulumi.get(self, "trace_rate")

