# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppBuilderAppArgs', 'AppBuilderApp']

@pulumi.input_type
class AppBuilderAppArgs:
    def __init__(__self__, *,
                 app_json: pulumi.Input[_builtins.str],
                 action_query_names_to_connection_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_instance_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppBuilderApp resource.
        :param pulumi.Input[_builtins.str] app_json: The JSON representation of the App. String length must be at least 1.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] action_query_names_to_connection_ids: If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        :param pulumi.Input[_builtins.str] description: If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.str] name: If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        :param pulumi.Input[_builtins.str] root_instance_name: The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        pulumi.set(__self__, "app_json", app_json)
        if action_query_names_to_connection_ids is not None:
            pulumi.set(__self__, "action_query_names_to_connection_ids", action_query_names_to_connection_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if root_instance_name is not None:
            pulumi.set(__self__, "root_instance_name", root_instance_name)

    @_builtins.property
    @pulumi.getter(name="appJson")
    def app_json(self) -> pulumi.Input[_builtins.str]:
        """
        The JSON representation of the App. String length must be at least 1.
        """
        return pulumi.get(self, "app_json")

    @app_json.setter
    def app_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_json", value)

    @_builtins.property
    @pulumi.getter(name="actionQueryNamesToConnectionIds")
    def action_query_names_to_connection_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        """
        return pulumi.get(self, "action_query_names_to_connection_ids")

    @action_query_names_to_connection_ids.setter
    def action_query_names_to_connection_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "action_query_names_to_connection_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def published(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "published", value)

    @_builtins.property
    @pulumi.getter(name="rootInstanceName")
    def root_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "root_instance_name")

    @root_instance_name.setter
    def root_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_instance_name", value)


@pulumi.input_type
class _AppBuilderAppState:
    def __init__(__self__, *,
                 action_query_names_to_connection_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_instance_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppBuilderApp resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] action_query_names_to_connection_ids: If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        :param pulumi.Input[_builtins.str] app_json: The JSON representation of the App. String length must be at least 1.
        :param pulumi.Input[_builtins.str] description: If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.str] name: If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        :param pulumi.Input[_builtins.str] root_instance_name: The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        if action_query_names_to_connection_ids is not None:
            pulumi.set(__self__, "action_query_names_to_connection_ids", action_query_names_to_connection_ids)
        if app_json is not None:
            pulumi.set(__self__, "app_json", app_json)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if root_instance_name is not None:
            pulumi.set(__self__, "root_instance_name", root_instance_name)

    @_builtins.property
    @pulumi.getter(name="actionQueryNamesToConnectionIds")
    def action_query_names_to_connection_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        """
        return pulumi.get(self, "action_query_names_to_connection_ids")

    @action_query_names_to_connection_ids.setter
    def action_query_names_to_connection_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "action_query_names_to_connection_ids", value)

    @_builtins.property
    @pulumi.getter(name="appJson")
    def app_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON representation of the App. String length must be at least 1.
        """
        return pulumi.get(self, "app_json")

    @app_json.setter
    def app_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_json", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def published(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "published", value)

    @_builtins.property
    @pulumi.getter(name="rootInstanceName")
    def root_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "root_instance_name")

    @root_instance_name.setter
    def root_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_instance_name", value)


@pulumi.type_token("datadog:index/appBuilderApp:AppBuilderApp")
class AppBuilderApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_query_names_to_connection_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appBuilderApp:AppBuilderApp my_app 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] action_query_names_to_connection_ids: If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        :param pulumi.Input[_builtins.str] app_json: The JSON representation of the App. String length must be at least 1.
        :param pulumi.Input[_builtins.str] description: If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.str] name: If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        :param pulumi.Input[_builtins.str] root_instance_name: The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppBuilderAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appBuilderApp:AppBuilderApp my_app 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param AppBuilderAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppBuilderAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_query_names_to_connection_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppBuilderAppArgs.__new__(AppBuilderAppArgs)

            __props__.__dict__["action_query_names_to_connection_ids"] = action_query_names_to_connection_ids
            if app_json is None and not opts.urn:
                raise TypeError("Missing required property 'app_json'")
            __props__.__dict__["app_json"] = app_json
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["published"] = published
            __props__.__dict__["root_instance_name"] = root_instance_name
        super(AppBuilderApp, __self__).__init__(
            'datadog:index/appBuilderApp:AppBuilderApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_query_names_to_connection_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            app_json: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            published: Optional[pulumi.Input[_builtins.bool]] = None,
            root_instance_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppBuilderApp':
        """
        Get an existing AppBuilderApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] action_query_names_to_connection_ids: If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        :param pulumi.Input[_builtins.str] app_json: The JSON representation of the App. String length must be at least 1.
        :param pulumi.Input[_builtins.str] description: If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.str] name: If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        :param pulumi.Input[_builtins.str] root_instance_name: The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppBuilderAppState.__new__(_AppBuilderAppState)

        __props__.__dict__["action_query_names_to_connection_ids"] = action_query_names_to_connection_ids
        __props__.__dict__["app_json"] = app_json
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["published"] = published
        __props__.__dict__["root_instance_name"] = root_instance_name
        return AppBuilderApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionQueryNamesToConnectionIds")
    def action_query_names_to_connection_ids(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        If specified, this will override the Action Connection IDs for the specified Action Query Names in the App JSON. Otherwise, a map of the App's Action Query Names to Action Connection IDs will be returned in output.
        """
        return pulumi.get(self, "action_query_names_to_connection_ids")

    @_builtins.property
    @pulumi.getter(name="appJson")
    def app_json(self) -> pulumi.Output[_builtins.str]:
        """
        The JSON representation of the App. String length must be at least 1.
        """
        return pulumi.get(self, "app_json")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        If specified, this will override the human-readable description of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        If specified, this will override the name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def published(self) -> pulumi.Output[_builtins.bool]:
        """
        Set the app to published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist. Defaults to `false`.
        """
        return pulumi.get(self, "published")

    @_builtins.property
    @pulumi.getter(name="rootInstanceName")
    def root_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the root component of the app. This must be a grid component that contains all other components. If specified, this will override the root instance name of the App in the App JSON. String length must be at least 1.
        """
        return pulumi.get(self, "root_instance_name")

