# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CostBudgetArgs', 'CostBudget']

@pulumi.input_type
class CostBudgetArgs:
    def __init__(__self__, *,
                 end_month: pulumi.Input[_builtins.int],
                 metrics_query: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 start_month: pulumi.Input[_builtins.int],
                 budget_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]] = None):
        """
        The set of arguments for constructing a CostBudget resource.
        :param pulumi.Input[_builtins.int] end_month: The month when the budget ends (YYYYMM).
        :param pulumi.Input[_builtins.str] metrics_query: The cost query used to track against the budget.
        :param pulumi.Input[_builtins.str] name: The name of the budget.
        :param pulumi.Input[_builtins.int] start_month: The month when the budget starts (YYYYMM).
        :param pulumi.Input[_builtins.str] budget_id: The ID of the budget.
        :param pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]] entries: The entries of the budget.
        """
        pulumi.set(__self__, "end_month", end_month)
        pulumi.set(__self__, "metrics_query", metrics_query)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "start_month", start_month)
        if budget_id is not None:
            pulumi.set(__self__, "budget_id", budget_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @_builtins.property
    @pulumi.getter(name="endMonth")
    def end_month(self) -> pulumi.Input[_builtins.int]:
        """
        The month when the budget ends (YYYYMM).
        """
        return pulumi.get(self, "end_month")

    @end_month.setter
    def end_month(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "end_month", value)

    @_builtins.property
    @pulumi.getter(name="metricsQuery")
    def metrics_query(self) -> pulumi.Input[_builtins.str]:
        """
        The cost query used to track against the budget.
        """
        return pulumi.get(self, "metrics_query")

    @metrics_query.setter
    def metrics_query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metrics_query", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the budget.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startMonth")
    def start_month(self) -> pulumi.Input[_builtins.int]:
        """
        The month when the budget starts (YYYYMM).
        """
        return pulumi.get(self, "start_month")

    @start_month.setter
    def start_month(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "start_month", value)

    @_builtins.property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the budget.
        """
        return pulumi.get(self, "budget_id")

    @budget_id.setter
    def budget_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "budget_id", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]]:
        """
        The entries of the budget.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]]):
        pulumi.set(self, "entries", value)


@pulumi.input_type
class _CostBudgetState:
    def __init__(__self__, *,
                 budget_id: Optional[pulumi.Input[_builtins.str]] = None,
                 end_month: Optional[pulumi.Input[_builtins.int]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]] = None,
                 metrics_query: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_month: Optional[pulumi.Input[_builtins.int]] = None,
                 total_amount: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering CostBudget resources.
        :param pulumi.Input[_builtins.str] budget_id: The ID of the budget.
        :param pulumi.Input[_builtins.int] end_month: The month when the budget ends (YYYYMM).
        :param pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]] entries: The entries of the budget.
        :param pulumi.Input[_builtins.str] metrics_query: The cost query used to track against the budget.
        :param pulumi.Input[_builtins.str] name: The name of the budget.
        :param pulumi.Input[_builtins.int] start_month: The month when the budget starts (YYYYMM).
        :param pulumi.Input[_builtins.float] total_amount: The sum of all budget entries' amounts.
        """
        if budget_id is not None:
            pulumi.set(__self__, "budget_id", budget_id)
        if end_month is not None:
            pulumi.set(__self__, "end_month", end_month)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if metrics_query is not None:
            pulumi.set(__self__, "metrics_query", metrics_query)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_month is not None:
            pulumi.set(__self__, "start_month", start_month)
        if total_amount is not None:
            pulumi.set(__self__, "total_amount", total_amount)

    @_builtins.property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the budget.
        """
        return pulumi.get(self, "budget_id")

    @budget_id.setter
    def budget_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "budget_id", value)

    @_builtins.property
    @pulumi.getter(name="endMonth")
    def end_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The month when the budget ends (YYYYMM).
        """
        return pulumi.get(self, "end_month")

    @end_month.setter
    def end_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_month", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]]:
        """
        The entries of the budget.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CostBudgetEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="metricsQuery")
    def metrics_query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cost query used to track against the budget.
        """
        return pulumi.get(self, "metrics_query")

    @metrics_query.setter
    def metrics_query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_query", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the budget.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startMonth")
    def start_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The month when the budget starts (YYYYMM).
        """
        return pulumi.get(self, "start_month")

    @start_month.setter
    def start_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_month", value)

    @_builtins.property
    @pulumi.getter(name="totalAmount")
    def total_amount(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The sum of all budget entries' amounts.
        """
        return pulumi.get(self, "total_amount")

    @total_amount.setter
    def total_amount(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "total_amount", value)


@pulumi.type_token("datadog:index/costBudget:CostBudget")
class CostBudget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 budget_id: Optional[pulumi.Input[_builtins.str]] = None,
                 end_month: Optional[pulumi.Input[_builtins.int]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CostBudgetEntryArgs', 'CostBudgetEntryArgsDict']]]]] = None,
                 metrics_query: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_month: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Datadog Cost Budget resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] budget_id: The ID of the budget.
        :param pulumi.Input[_builtins.int] end_month: The month when the budget ends (YYYYMM).
        :param pulumi.Input[Sequence[pulumi.Input[Union['CostBudgetEntryArgs', 'CostBudgetEntryArgsDict']]]] entries: The entries of the budget.
        :param pulumi.Input[_builtins.str] metrics_query: The cost query used to track against the budget.
        :param pulumi.Input[_builtins.str] name: The name of the budget.
        :param pulumi.Input[_builtins.int] start_month: The month when the budget starts (YYYYMM).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CostBudgetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Cost Budget resource.

        :param str resource_name: The name of the resource.
        :param CostBudgetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CostBudgetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 budget_id: Optional[pulumi.Input[_builtins.str]] = None,
                 end_month: Optional[pulumi.Input[_builtins.int]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CostBudgetEntryArgs', 'CostBudgetEntryArgsDict']]]]] = None,
                 metrics_query: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_month: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CostBudgetArgs.__new__(CostBudgetArgs)

            __props__.__dict__["budget_id"] = budget_id
            if end_month is None and not opts.urn:
                raise TypeError("Missing required property 'end_month'")
            __props__.__dict__["end_month"] = end_month
            __props__.__dict__["entries"] = entries
            if metrics_query is None and not opts.urn:
                raise TypeError("Missing required property 'metrics_query'")
            __props__.__dict__["metrics_query"] = metrics_query
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if start_month is None and not opts.urn:
                raise TypeError("Missing required property 'start_month'")
            __props__.__dict__["start_month"] = start_month
            __props__.__dict__["total_amount"] = None
        super(CostBudget, __self__).__init__(
            'datadog:index/costBudget:CostBudget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            budget_id: Optional[pulumi.Input[_builtins.str]] = None,
            end_month: Optional[pulumi.Input[_builtins.int]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CostBudgetEntryArgs', 'CostBudgetEntryArgsDict']]]]] = None,
            metrics_query: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            start_month: Optional[pulumi.Input[_builtins.int]] = None,
            total_amount: Optional[pulumi.Input[_builtins.float]] = None) -> 'CostBudget':
        """
        Get an existing CostBudget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] budget_id: The ID of the budget.
        :param pulumi.Input[_builtins.int] end_month: The month when the budget ends (YYYYMM).
        :param pulumi.Input[Sequence[pulumi.Input[Union['CostBudgetEntryArgs', 'CostBudgetEntryArgsDict']]]] entries: The entries of the budget.
        :param pulumi.Input[_builtins.str] metrics_query: The cost query used to track against the budget.
        :param pulumi.Input[_builtins.str] name: The name of the budget.
        :param pulumi.Input[_builtins.int] start_month: The month when the budget starts (YYYYMM).
        :param pulumi.Input[_builtins.float] total_amount: The sum of all budget entries' amounts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CostBudgetState.__new__(_CostBudgetState)

        __props__.__dict__["budget_id"] = budget_id
        __props__.__dict__["end_month"] = end_month
        __props__.__dict__["entries"] = entries
        __props__.__dict__["metrics_query"] = metrics_query
        __props__.__dict__["name"] = name
        __props__.__dict__["start_month"] = start_month
        __props__.__dict__["total_amount"] = total_amount
        return CostBudget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the budget.
        """
        return pulumi.get(self, "budget_id")

    @_builtins.property
    @pulumi.getter(name="endMonth")
    def end_month(self) -> pulumi.Output[_builtins.int]:
        """
        The month when the budget ends (YYYYMM).
        """
        return pulumi.get(self, "end_month")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.CostBudgetEntry']]]:
        """
        The entries of the budget.
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter(name="metricsQuery")
    def metrics_query(self) -> pulumi.Output[_builtins.str]:
        """
        The cost query used to track against the budget.
        """
        return pulumi.get(self, "metrics_query")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="startMonth")
    def start_month(self) -> pulumi.Output[_builtins.int]:
        """
        The month when the budget starts (YYYYMM).
        """
        return pulumi.get(self, "start_month")

    @_builtins.property
    @pulumi.getter(name="totalAmount")
    def total_amount(self) -> pulumi.Output[_builtins.float]:
        """
        The sum of all budget entries' amounts.
        """
        return pulumi.get(self, "total_amount")

