# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DashboardJsonArgs', 'DashboardJson']

@pulumi.input_type
class DashboardJsonArgs:
    def __init__(__self__, *,
                 dashboard: pulumi.Input[_builtins.str],
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DashboardJson resource.
        :param pulumi.Input[_builtins.str] dashboard: The JSON formatted definition of the Dashboard.
        :param pulumi.Input[_builtins.str] url: The URL of the dashboard.
        """
        pulumi.set(__self__, "dashboard", dashboard)
        if dashboard_lists is not None:
            pulumi.set(__self__, "dashboard_lists", dashboard_lists)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> pulumi.Input[_builtins.str]:
        """
        The JSON formatted definition of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dashboard", value)

    @_builtins.property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "dashboard_lists")

    @dashboard_lists.setter
    def dashboard_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "dashboard_lists", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _DashboardJsonState:
    def __init__(__self__, *,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 dashboard_lists_removeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DashboardJson resources.
        :param pulumi.Input[_builtins.str] dashboard: The JSON formatted definition of the Dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dashboard_lists_removeds: The list of dashboard lists this dashboard should be removed from. Internal only.
        :param pulumi.Input[_builtins.str] url: The URL of the dashboard.
        """
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if dashboard_lists is not None:
            pulumi.set(__self__, "dashboard_lists", dashboard_lists)
        if dashboard_lists_removeds is not None:
            pulumi.set(__self__, "dashboard_lists_removeds", dashboard_lists_removeds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON formatted definition of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard", value)

    @_builtins.property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "dashboard_lists")

    @dashboard_lists.setter
    def dashboard_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "dashboard_lists", value)

    @_builtins.property
    @pulumi.getter(name="dashboardListsRemoveds")
    def dashboard_lists_removeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The list of dashboard lists this dashboard should be removed from. Internal only.
        """
        return pulumi.get(self, "dashboard_lists_removeds")

    @dashboard_lists_removeds.setter
    def dashboard_lists_removeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "dashboard_lists_removeds", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("datadog:index/dashboardJson:DashboardJson")
class DashboardJson(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog dashboard JSON resource. This can be used to create and manage Datadog dashboards using the JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Example Dashboard JSON
        dashboard_json = datadog.DashboardJson("dashboard_json", dashboard=\"\"\"{
           "title":"Ordered Layout Dashboard",
           "description":"Created using the Datadog provider in Pulumi",
           "widgets":[
              {
                 "id":719369537777170,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_graph",
                    "alert_id":"895605",
                    "viz_type":"timeseries"
                 }
              },
              {
                 "id":2306240030393868,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_value",
                    "alert_id":"895605",
                    "unit":"b",
                    "text_align":"center",
                    "precision":3
                 }
              },
              {
                 "id":6990998850881326,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_value",
                    "alert_id":"895605",
                    "unit":"b",
                    "text_align":"center",
                    "precision":3
                 }
              },
              {
                 "id":3351284044659007,
                 "definition":{
                    "title":"Widget Title",
                    "type":"change",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "compare_to":"week_before",
                          "change_type":"absolute",
                          "order_dir":"desc",
                          "increase_good":true,
                          "order_by":"name",
                          "show_present":true
                       }
                    ]
                 }
              },
              {
                 "id":6450290622996182,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":false,
                    "type":"distribution",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "style":{
                             "palette":"warm"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":4902842646291536,
                 "definition":{
                    "title":"Widget Title",
                    "type":"check_status",
                    "check":"aws.ecs.agent_connected",
                    "grouping":"cluster",
                    "group_by":[
                       "account",
                       "cluster"
                    ],
                    "tags":[
                       "account:demo",
                       "cluster:awseb-ruthebdog-env-8-dn3m6u3gvk"
                    ]
                 }
              },
              {
                 "id":6392349954822644,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":false,
                    "type":"heatmap",
                    "yaxis":{
                       "scale":"sqrt",
                       "include_zero":true,
                       "min":"1",
                       "max":"2"
                    },
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "style":{
                             "palette":"warm"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":5222961478940988,
                 "definition":{
                    "title":"Widget Title",
                    "type":"hostmap",
                    "requests":{
                       "fill":{
                          "q":"avg:system.load.1{*} by {host}"
                       },
                       "size":{
                          "q":"avg:memcache.uptime{*} by {host}"
                       }
                    },
                    "node_type":"container",
                    "no_metric_hosts":true,
                    "no_group_hosts":true,
                    "group":[
                       "host",
                       "region"
                    ],
                    "scope":[
                       "region:us-east-1",
                       "aws_account:727006795293"
                    ],
                    "style":{
                       "palette":"yellow_to_green",
                       "palette_flip":true,
                       "fill_min":"10",
                       "fill_max":"20"
                    }
                 }
              },
              {
                 "id":8121199734227072,
                 "definition":{
                    "type":"note",
                    "content":"note text",
                    "background_color":"pink",
                    "font_size":"14",
                    "text_align":"center",
                    "show_tick":true,
                    "tick_pos":"50%",
                    "tick_edge":"left"
                 }
              },
              {
                 "id":1775856835833038,
                 "definition":{
                    "title":"Widget Title",
                    "type":"query_value",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "aggregator":"sum",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ]
                       }
                    ],
                    "autoscale":true,
                    "custom_unit":"xx",
                    "text_align":"right",
                    "precision":4
                 }
              },
              {
                 "id":8461455966625581,
                 "definition":{
                    "title":"Widget Title",
                    "type":"query_table",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "aggregator":"sum",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ],
                          "limit":10
                       }
                    ]
                 }
              },
              {
                 "id":8660006349418736,
                 "definition":{
                    "title":"Widget Title",
                    "type":"scatterplot",
                    "requests":{
                       "x":{
                          "q":"avg:system.cpu.user{*} by {service, account}",
                          "aggregator":"max"
                       },
                       "y":{
                          "q":"avg:system.mem.used{*} by {service, account}",
                          "aggregator":"min"
                       }
                    },
                    "xaxis":{
                       "scale":"pow",
                       "label":"x",
                       "include_zero":true,
                       "min":"1",
                       "max":"2000"
                    },
                    "yaxis":{
                       "scale":"log",
                       "label":"y",
                       "include_zero":false,
                       "min":"5",
                       "max":"2222"
                    },
                    "color_by_groups":[
                       "account",
                       "apm-role-group"
                    ]
                 }
              },
              {
                 "id":1669590772917638,
                 "definition":{
                    "title":"env: prod, datacenter:dc1, service: master-db",
                    "title_size":"16",
                    "title_align":"left",
                    "type":"servicemap",
                    "service":"master-db",
                    "filters":[
                       "env:prod",
                       "datacenter:dc1"
                    ]
                 }
              },
              {
                 "id":2138829058361817,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":true,
                    "legend_size":"2",
                    "type":"timeseries",
                    "requests":[
                       {
                          "q":"avg:system.cpu.user{app:general} by {env}",
                          "on_right_yaxis":false,
                          "metadata":[
                             {
                                "expression":"avg:system.cpu.user{app:general} by {env}",
                                "alias_name":"Alpha"
                             }
                          ],
                          "style":{
                             "palette":"warm",
                             "line_type":"dashed",
                             "line_width":"thin"
                          },
                          "display_type":"line"
                       },
                       {
                          "on_right_yaxis":false,
                          "log_query":{
                             "index":"mcnulty",
                             "search":{
                                "query":"status:info"
                             },
                             "group_by":[
                                {
                                   "facet":"host",
                                   "sort":{
                                      "facet":"@duration",
                                      "aggregation":"avg",
                                      "order":"desc"
                                   },
                                   "limit":10
                                }
                             ],
                             "compute":{
                                "facet":"@duration",
                                "interval":5000,
                                "aggregation":"avg"
                             }
                          },
                          "display_type":"area"
                       },
                       {
                          "on_right_yaxis":false,
                          "apm_query":{
                             "index":"apm-search",
                             "search":{
                                "query":"type:web"
                             },
                             "group_by":[
                                {
                                   "facet":"resource_name",
                                   "sort":{
                                      "facet":"@string_query.interval",
                                      "aggregation":"avg",
                                      "order":"desc"
                                   },
                                   "limit":50
                                }
                             ],
                             "compute":{
                                "facet":"@duration",
                                "interval":5000,
                                "aggregation":"avg"
                             }
                          },
                          "display_type":"bars"
                       },
                       {
                          "on_right_yaxis":false,
                          "process_query":{
                             "search_by":"error",
                             "metric":"process.stat.cpu.total_pct",
                             "limit":50,
                             "filter_by":[
                                "active"
                             ]
                          },
                          "display_type":"area"
                       }
                    ],
                    "yaxis":{
                       "scale":"log",
                       "include_zero":false,
                       "max":"100"
                    },
                    "events":[
                       {
                          "q":"sources:test tags:1"
                       },
                       {
                          "q":"sources:test tags:2"
                       }
                    ],
                    "markers":[
                       {
                          "label":" z=6 ",
                          "value":"y = 4",
                          "display_type":"error dashed"
                       },
                       {
                          "label":" x=8 ",
                          "value":"10 < y < 999",
                          "display_type":"ok solid"
                       }
                    ]
                 }
              },
              {
                 "id":7307171374656551,
                 "definition":{
                    "title":"Widget Title",
                    "type":"toplist",
                    "requests":[
                       {
                          "q":"avg:system.cpu.user{app:general} by {env}",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ]
                       }
                    ]
                 }
              },
              {
                 "id":7086674838553258,
                 "definition":{
                    "title":"Group Widget",
                    "type":"group",
                    "layout_type":"ordered",
                    "widgets":[
                       {
                          "id":3726092277657502,
                          "definition":{
                             "type":"note",
                             "content":"cluster note widget",
                             "background_color":"pink",
                             "font_size":"14",
                             "text_align":"center",
                             "show_tick":true,
                             "tick_pos":"50%",
                             "tick_edge":"left"
                          }
                       },
                       {
                          "id":6376384650558057,
                          "definition":{
                             "title":"Alert Graph",
                             "type":"alert_graph",
                             "alert_id":"123",
                             "viz_type":"toplist"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":4668903563678912,
                 "definition":{
                    "title":"Widget Title",
                    "type":"slo",
                    "view_type":"detail",
                    "time_windows":[
                       "7d",
                       "previous_week"
                    ],
                    "slo_id":"56789",
                    "show_error_budget":true,
                    "view_mode":"overall",
                    "global_time_target":"0"
                 }
              }
           ],
           "template_variables":[
              {
                 "name":"var_1",
                 "default":"aws",
                 "prefix":"host"
              },
              {
                 "name":"var_2",
                 "default":"autoscaling",
                 "prefix":"service_name"
              }
           ],
           "layout_type":"ordered",
           "notify_list":[

           ],
           "template_variable_presets":[
              {
                 "name":"preset_1",
                 "template_variables":[
                    {
                       "name":"var_1",
                       "value":"host.dc"
                    },
                    {
                       "name":"var_2",
                       "value":"my_service"
                    }
                 ]
              }
           ]
        }
        \"\"\")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/dashboardJson:DashboardJson my_service_dashboard sv7-gyh-kas
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dashboard: The JSON formatted definition of the Dashboard.
        :param pulumi.Input[_builtins.str] url: The URL of the dashboard.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardJsonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog dashboard JSON resource. This can be used to create and manage Datadog dashboards using the JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Example Dashboard JSON
        dashboard_json = datadog.DashboardJson("dashboard_json", dashboard=\"\"\"{
           "title":"Ordered Layout Dashboard",
           "description":"Created using the Datadog provider in Pulumi",
           "widgets":[
              {
                 "id":719369537777170,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_graph",
                    "alert_id":"895605",
                    "viz_type":"timeseries"
                 }
              },
              {
                 "id":2306240030393868,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_value",
                    "alert_id":"895605",
                    "unit":"b",
                    "text_align":"center",
                    "precision":3
                 }
              },
              {
                 "id":6990998850881326,
                 "definition":{
                    "title":"Widget Title",
                    "type":"alert_value",
                    "alert_id":"895605",
                    "unit":"b",
                    "text_align":"center",
                    "precision":3
                 }
              },
              {
                 "id":3351284044659007,
                 "definition":{
                    "title":"Widget Title",
                    "type":"change",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "compare_to":"week_before",
                          "change_type":"absolute",
                          "order_dir":"desc",
                          "increase_good":true,
                          "order_by":"name",
                          "show_present":true
                       }
                    ]
                 }
              },
              {
                 "id":6450290622996182,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":false,
                    "type":"distribution",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "style":{
                             "palette":"warm"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":4902842646291536,
                 "definition":{
                    "title":"Widget Title",
                    "type":"check_status",
                    "check":"aws.ecs.agent_connected",
                    "grouping":"cluster",
                    "group_by":[
                       "account",
                       "cluster"
                    ],
                    "tags":[
                       "account:demo",
                       "cluster:awseb-ruthebdog-env-8-dn3m6u3gvk"
                    ]
                 }
              },
              {
                 "id":6392349954822644,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":false,
                    "type":"heatmap",
                    "yaxis":{
                       "scale":"sqrt",
                       "include_zero":true,
                       "min":"1",
                       "max":"2"
                    },
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "style":{
                             "palette":"warm"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":5222961478940988,
                 "definition":{
                    "title":"Widget Title",
                    "type":"hostmap",
                    "requests":{
                       "fill":{
                          "q":"avg:system.load.1{*} by {host}"
                       },
                       "size":{
                          "q":"avg:memcache.uptime{*} by {host}"
                       }
                    },
                    "node_type":"container",
                    "no_metric_hosts":true,
                    "no_group_hosts":true,
                    "group":[
                       "host",
                       "region"
                    ],
                    "scope":[
                       "region:us-east-1",
                       "aws_account:727006795293"
                    ],
                    "style":{
                       "palette":"yellow_to_green",
                       "palette_flip":true,
                       "fill_min":"10",
                       "fill_max":"20"
                    }
                 }
              },
              {
                 "id":8121199734227072,
                 "definition":{
                    "type":"note",
                    "content":"note text",
                    "background_color":"pink",
                    "font_size":"14",
                    "text_align":"center",
                    "show_tick":true,
                    "tick_pos":"50%",
                    "tick_edge":"left"
                 }
              },
              {
                 "id":1775856835833038,
                 "definition":{
                    "title":"Widget Title",
                    "type":"query_value",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "aggregator":"sum",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ]
                       }
                    ],
                    "autoscale":true,
                    "custom_unit":"xx",
                    "text_align":"right",
                    "precision":4
                 }
              },
              {
                 "id":8461455966625581,
                 "definition":{
                    "title":"Widget Title",
                    "type":"query_table",
                    "requests":[
                       {
                          "q":"avg:system.load.1{env:staging} by {account}",
                          "aggregator":"sum",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ],
                          "limit":10
                       }
                    ]
                 }
              },
              {
                 "id":8660006349418736,
                 "definition":{
                    "title":"Widget Title",
                    "type":"scatterplot",
                    "requests":{
                       "x":{
                          "q":"avg:system.cpu.user{*} by {service, account}",
                          "aggregator":"max"
                       },
                       "y":{
                          "q":"avg:system.mem.used{*} by {service, account}",
                          "aggregator":"min"
                       }
                    },
                    "xaxis":{
                       "scale":"pow",
                       "label":"x",
                       "include_zero":true,
                       "min":"1",
                       "max":"2000"
                    },
                    "yaxis":{
                       "scale":"log",
                       "label":"y",
                       "include_zero":false,
                       "min":"5",
                       "max":"2222"
                    },
                    "color_by_groups":[
                       "account",
                       "apm-role-group"
                    ]
                 }
              },
              {
                 "id":1669590772917638,
                 "definition":{
                    "title":"env: prod, datacenter:dc1, service: master-db",
                    "title_size":"16",
                    "title_align":"left",
                    "type":"servicemap",
                    "service":"master-db",
                    "filters":[
                       "env:prod",
                       "datacenter:dc1"
                    ]
                 }
              },
              {
                 "id":2138829058361817,
                 "definition":{
                    "title":"Widget Title",
                    "show_legend":true,
                    "legend_size":"2",
                    "type":"timeseries",
                    "requests":[
                       {
                          "q":"avg:system.cpu.user{app:general} by {env}",
                          "on_right_yaxis":false,
                          "metadata":[
                             {
                                "expression":"avg:system.cpu.user{app:general} by {env}",
                                "alias_name":"Alpha"
                             }
                          ],
                          "style":{
                             "palette":"warm",
                             "line_type":"dashed",
                             "line_width":"thin"
                          },
                          "display_type":"line"
                       },
                       {
                          "on_right_yaxis":false,
                          "log_query":{
                             "index":"mcnulty",
                             "search":{
                                "query":"status:info"
                             },
                             "group_by":[
                                {
                                   "facet":"host",
                                   "sort":{
                                      "facet":"@duration",
                                      "aggregation":"avg",
                                      "order":"desc"
                                   },
                                   "limit":10
                                }
                             ],
                             "compute":{
                                "facet":"@duration",
                                "interval":5000,
                                "aggregation":"avg"
                             }
                          },
                          "display_type":"area"
                       },
                       {
                          "on_right_yaxis":false,
                          "apm_query":{
                             "index":"apm-search",
                             "search":{
                                "query":"type:web"
                             },
                             "group_by":[
                                {
                                   "facet":"resource_name",
                                   "sort":{
                                      "facet":"@string_query.interval",
                                      "aggregation":"avg",
                                      "order":"desc"
                                   },
                                   "limit":50
                                }
                             ],
                             "compute":{
                                "facet":"@duration",
                                "interval":5000,
                                "aggregation":"avg"
                             }
                          },
                          "display_type":"bars"
                       },
                       {
                          "on_right_yaxis":false,
                          "process_query":{
                             "search_by":"error",
                             "metric":"process.stat.cpu.total_pct",
                             "limit":50,
                             "filter_by":[
                                "active"
                             ]
                          },
                          "display_type":"area"
                       }
                    ],
                    "yaxis":{
                       "scale":"log",
                       "include_zero":false,
                       "max":"100"
                    },
                    "events":[
                       {
                          "q":"sources:test tags:1"
                       },
                       {
                          "q":"sources:test tags:2"
                       }
                    ],
                    "markers":[
                       {
                          "label":" z=6 ",
                          "value":"y = 4",
                          "display_type":"error dashed"
                       },
                       {
                          "label":" x=8 ",
                          "value":"10 < y < 999",
                          "display_type":"ok solid"
                       }
                    ]
                 }
              },
              {
                 "id":7307171374656551,
                 "definition":{
                    "title":"Widget Title",
                    "type":"toplist",
                    "requests":[
                       {
                          "q":"avg:system.cpu.user{app:general} by {env}",
                          "conditional_formats":[
                             {
                                "hide_value":false,
                                "comparator":"<",
                                "palette":"white_on_green",
                                "value":2
                             },
                             {
                                "hide_value":false,
                                "comparator":">",
                                "palette":"white_on_red",
                                "value":2.2
                             }
                          ]
                       }
                    ]
                 }
              },
              {
                 "id":7086674838553258,
                 "definition":{
                    "title":"Group Widget",
                    "type":"group",
                    "layout_type":"ordered",
                    "widgets":[
                       {
                          "id":3726092277657502,
                          "definition":{
                             "type":"note",
                             "content":"cluster note widget",
                             "background_color":"pink",
                             "font_size":"14",
                             "text_align":"center",
                             "show_tick":true,
                             "tick_pos":"50%",
                             "tick_edge":"left"
                          }
                       },
                       {
                          "id":6376384650558057,
                          "definition":{
                             "title":"Alert Graph",
                             "type":"alert_graph",
                             "alert_id":"123",
                             "viz_type":"toplist"
                          }
                       }
                    ]
                 }
              },
              {
                 "id":4668903563678912,
                 "definition":{
                    "title":"Widget Title",
                    "type":"slo",
                    "view_type":"detail",
                    "time_windows":[
                       "7d",
                       "previous_week"
                    ],
                    "slo_id":"56789",
                    "show_error_budget":true,
                    "view_mode":"overall",
                    "global_time_target":"0"
                 }
              }
           ],
           "template_variables":[
              {
                 "name":"var_1",
                 "default":"aws",
                 "prefix":"host"
              },
              {
                 "name":"var_2",
                 "default":"autoscaling",
                 "prefix":"service_name"
              }
           ],
           "layout_type":"ordered",
           "notify_list":[

           ],
           "template_variable_presets":[
              {
                 "name":"preset_1",
                 "template_variables":[
                    {
                       "name":"var_1",
                       "value":"host.dc"
                    },
                    {
                       "name":"var_2",
                       "value":"my_service"
                    }
                 ]
              }
           ]
        }
        \"\"\")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/dashboardJson:DashboardJson my_service_dashboard sv7-gyh-kas
        ```

        :param str resource_name: The name of the resource.
        :param DashboardJsonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardJsonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardJsonArgs.__new__(DashboardJsonArgs)

            if dashboard is None and not opts.urn:
                raise TypeError("Missing required property 'dashboard'")
            __props__.__dict__["dashboard"] = dashboard
            __props__.__dict__["dashboard_lists"] = dashboard_lists
            __props__.__dict__["url"] = url
            __props__.__dict__["dashboard_lists_removeds"] = None
        super(DashboardJson, __self__).__init__(
            'datadog:index/dashboardJson:DashboardJson',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard: Optional[pulumi.Input[_builtins.str]] = None,
            dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            dashboard_lists_removeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'DashboardJson':
        """
        Get an existing DashboardJson resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dashboard: The JSON formatted definition of the Dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dashboard_lists_removeds: The list of dashboard lists this dashboard should be removed from. Internal only.
        :param pulumi.Input[_builtins.str] url: The URL of the dashboard.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardJsonState.__new__(_DashboardJsonState)

        __props__.__dict__["dashboard"] = dashboard
        __props__.__dict__["dashboard_lists"] = dashboard_lists
        __props__.__dict__["dashboard_lists_removeds"] = dashboard_lists_removeds
        __props__.__dict__["url"] = url
        return DashboardJson(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> pulumi.Output[_builtins.str]:
        """
        The JSON formatted definition of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        return pulumi.get(self, "dashboard_lists")

    @_builtins.property
    @pulumi.getter(name="dashboardListsRemoveds")
    def dashboard_lists_removeds(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        The list of dashboard lists this dashboard should be removed from. Internal only.
        """
        return pulumi.get(self, "dashboard_lists_removeds")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

