# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIncidentNotificationTemplateResult',
    'AwaitableGetIncidentNotificationTemplateResult',
    'get_incident_notification_template',
    'get_incident_notification_template_output',
]

@pulumi.output_type
class GetIncidentNotificationTemplateResult:
    """
    A collection of values returned by getIncidentNotificationTemplate.
    """
    def __init__(__self__, category=None, content=None, created=None, id=None, incident_type=None, modified=None, name=None, subject=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if incident_type and not isinstance(incident_type, str):
            raise TypeError("Expected argument 'incident_type' to be a str")
        pulumi.set(__self__, "incident_type", incident_type)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The category of the notification template.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content body of the notification template.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        Timestamp when the notification template was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the incident notification template.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> _builtins.str:
        """
        The ID of the incident type this notification template is associated with.
        """
        return pulumi.get(self, "incident_type")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> _builtins.str:
        """
        Timestamp when the notification template was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the notification template.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject line of the notification template.
        """
        return pulumi.get(self, "subject")


class AwaitableGetIncidentNotificationTemplateResult(GetIncidentNotificationTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIncidentNotificationTemplateResult(
            category=self.category,
            content=self.content,
            created=self.created,
            id=self.id,
            incident_type=self.incident_type,
            modified=self.modified,
            name=self.name,
            subject=self.subject)


def get_incident_notification_template(id: Optional[_builtins.str] = None,
                                       name: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIncidentNotificationTemplateResult:
    """
    Use this data source to retrieve information about an existing incident notification template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_notification_template(id="52600bb1-e83a-48a1-aa77-6889ddb269b2")
    ```


    :param _builtins.str id: The ID of the incident notification template.
    :param _builtins.str name: The name of the notification template.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getIncidentNotificationTemplate:getIncidentNotificationTemplate', __args__, opts=opts, typ=GetIncidentNotificationTemplateResult).value

    return AwaitableGetIncidentNotificationTemplateResult(
        category=pulumi.get(__ret__, 'category'),
        content=pulumi.get(__ret__, 'content'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        incident_type=pulumi.get(__ret__, 'incident_type'),
        modified=pulumi.get(__ret__, 'modified'),
        name=pulumi.get(__ret__, 'name'),
        subject=pulumi.get(__ret__, 'subject'))
def get_incident_notification_template_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIncidentNotificationTemplateResult]:
    """
    Use this data source to retrieve information about an existing incident notification template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_notification_template(id="52600bb1-e83a-48a1-aa77-6889ddb269b2")
    ```


    :param _builtins.str id: The ID of the incident notification template.
    :param _builtins.str name: The name of the notification template.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getIncidentNotificationTemplate:getIncidentNotificationTemplate', __args__, opts=opts, typ=GetIncidentNotificationTemplateResult)
    return __ret__.apply(lambda __response__: GetIncidentNotificationTemplateResult(
        category=pulumi.get(__response__, 'category'),
        content=pulumi.get(__response__, 'content'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        incident_type=pulumi.get(__response__, 'incident_type'),
        modified=pulumi.get(__response__, 'modified'),
        name=pulumi.get(__response__, 'name'),
        subject=pulumi.get(__response__, 'subject')))
