# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLogsPipelinesResult',
    'AwaitableGetLogsPipelinesResult',
    'get_logs_pipelines',
    'get_logs_pipelines_output',
]

@pulumi.output_type
class GetLogsPipelinesResult:
    """
    A collection of values returned by getLogsPipelines.
    """
    def __init__(__self__, id=None, is_read_only=None, logs_pipelines=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_read_only and not isinstance(is_read_only, str):
            raise TypeError("Expected argument 'is_read_only' to be a str")
        pulumi.set(__self__, "is_read_only", is_read_only)
        if logs_pipelines and not isinstance(logs_pipelines, list):
            raise TypeError("Expected argument 'logs_pipelines' to be a list")
        pulumi.set(__self__, "logs_pipelines", logs_pipelines)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[_builtins.str]:
        """
        Filter parameter for retrieved pipelines
        """
        return pulumi.get(self, "is_read_only")

    @_builtins.property
    @pulumi.getter(name="logsPipelines")
    def logs_pipelines(self) -> Sequence['outputs.GetLogsPipelinesLogsPipelineResult']:
        """
        List of logs pipelines
        """
        return pulumi.get(self, "logs_pipelines")


class AwaitableGetLogsPipelinesResult(GetLogsPipelinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogsPipelinesResult(
            id=self.id,
            is_read_only=self.is_read_only,
            logs_pipelines=self.logs_pipelines)


def get_logs_pipelines(is_read_only: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogsPipelinesResult:
    """
    Use this data source to list all existing logs pipelines for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    # Gets all pipelines
    pipelines = datadog.get_logs_pipelines()
    # Using data source to set pipeline order
    lpo = datadog.LogsPipelineOrder("lpo",
        name="lpo",
        pipelines=[pipeline.id for pipeline in pipelines.logs_pipelines])
    ```


    :param _builtins.str is_read_only: Filter parameter for retrieved pipelines
    """
    __args__ = dict()
    __args__['isReadOnly'] = is_read_only
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getLogsPipelines:getLogsPipelines', __args__, opts=opts, typ=GetLogsPipelinesResult).value

    return AwaitableGetLogsPipelinesResult(
        id=pulumi.get(__ret__, 'id'),
        is_read_only=pulumi.get(__ret__, 'is_read_only'),
        logs_pipelines=pulumi.get(__ret__, 'logs_pipelines'))
def get_logs_pipelines_output(is_read_only: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogsPipelinesResult]:
    """
    Use this data source to list all existing logs pipelines for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    # Gets all pipelines
    pipelines = datadog.get_logs_pipelines()
    # Using data source to set pipeline order
    lpo = datadog.LogsPipelineOrder("lpo",
        name="lpo",
        pipelines=[pipeline.id for pipeline in pipelines.logs_pipelines])
    ```


    :param _builtins.str is_read_only: Filter parameter for retrieved pipelines
    """
    __args__ = dict()
    __args__['isReadOnly'] = is_read_only
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getLogsPipelines:getLogsPipelines', __args__, opts=opts, typ=GetLogsPipelinesResult)
    return __ret__.apply(lambda __response__: GetLogsPipelinesResult(
        id=pulumi.get(__response__, 'id'),
        is_read_only=pulumi.get(__response__, 'is_read_only'),
        logs_pipelines=pulumi.get(__response__, 'logs_pipelines')))
