# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RumRetentionFilterArgs', 'RumRetentionFilter']

@pulumi.input_type
class RumRetentionFilterArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 event_type: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 sample_rate: pulumi.Input[_builtins.int],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RumRetentionFilter resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[_builtins.str] event_type: The type of RUM events to filter on.
        :param pulumi.Input[_builtins.str] name: The name of a RUM retention filter.
        :param pulumi.Input[_builtins.int] sample_rate: The sample rate for a RUM retention filter, between 0 and 100.
        :param pulumi.Input[_builtins.bool] enabled: Whether the retention filter is to be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] query: The Query string for a RUM retention filter. Defaults to `""`.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sample_rate", sample_rate)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of RUM events to filter on.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of a RUM retention filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> pulumi.Input[_builtins.int]:
        """
        The sample rate for a RUM retention filter, between 0 and 100.
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "sample_rate", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the retention filter is to be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Query string for a RUM retention filter. Defaults to `""`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class _RumRetentionFilterState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_rate: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RumRetentionFilter resources.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the retention filter is to be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] event_type: The type of RUM events to filter on.
        :param pulumi.Input[_builtins.str] name: The name of a RUM retention filter.
        :param pulumi.Input[_builtins.str] query: The Query string for a RUM retention filter. Defaults to `""`.
        :param pulumi.Input[_builtins.int] sample_rate: The sample rate for a RUM retention filter, between 0 and 100.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the retention filter is to be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of RUM events to filter on.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a RUM retention filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Query string for a RUM retention filter. Defaults to `""`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sample rate for a RUM retention filter, between 0 and 100.
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sample_rate", value)


@pulumi.type_token("datadog:index/rumRetentionFilter:RumRetentionFilter")
class RumRetentionFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Datadog RumRetentionFilter resource. This can be used to create and manage Datadog rum_retention_filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new rum_retention_filter resource
        testing_rum_retention_filter = datadog.RumRetentionFilter("testing_rum_retention_filter",
            application_id="<APPLICATION_ID>",
            name="testing.rum.retention_filter",
            event_type="session",
            sample_rate=41,
            query="@session.has_replay:true",
            enabled=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumRetentionFilter:RumRetentionFilter testing_rum_retention_filter "<application_id>:<retention_filter_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the retention filter is to be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] event_type: The type of RUM events to filter on.
        :param pulumi.Input[_builtins.str] name: The name of a RUM retention filter.
        :param pulumi.Input[_builtins.str] query: The Query string for a RUM retention filter. Defaults to `""`.
        :param pulumi.Input[_builtins.int] sample_rate: The sample rate for a RUM retention filter, between 0 and 100.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RumRetentionFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog RumRetentionFilter resource. This can be used to create and manage Datadog rum_retention_filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new rum_retention_filter resource
        testing_rum_retention_filter = datadog.RumRetentionFilter("testing_rum_retention_filter",
            application_id="<APPLICATION_ID>",
            name="testing.rum.retention_filter",
            event_type="session",
            sample_rate=41,
            query="@session.has_replay:true",
            enabled=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumRetentionFilter:RumRetentionFilter testing_rum_retention_filter "<application_id>:<retention_filter_id>"
        ```

        :param str resource_name: The name of the resource.
        :param RumRetentionFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RumRetentionFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RumRetentionFilterArgs.__new__(RumRetentionFilterArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["enabled"] = enabled
            if event_type is None and not opts.urn:
                raise TypeError("Missing required property 'event_type'")
            __props__.__dict__["event_type"] = event_type
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["query"] = query
            if sample_rate is None and not opts.urn:
                raise TypeError("Missing required property 'sample_rate'")
            __props__.__dict__["sample_rate"] = sample_rate
        super(RumRetentionFilter, __self__).__init__(
            'datadog:index/rumRetentionFilter:RumRetentionFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            event_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            sample_rate: Optional[pulumi.Input[_builtins.int]] = None) -> 'RumRetentionFilter':
        """
        Get an existing RumRetentionFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the retention filter is to be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] event_type: The type of RUM events to filter on.
        :param pulumi.Input[_builtins.str] name: The name of a RUM retention filter.
        :param pulumi.Input[_builtins.str] query: The Query string for a RUM retention filter. Defaults to `""`.
        :param pulumi.Input[_builtins.int] sample_rate: The sample rate for a RUM retention filter, between 0 and 100.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RumRetentionFilterState.__new__(_RumRetentionFilterState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_type"] = event_type
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["sample_rate"] = sample_rate
        return RumRetentionFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the retention filter is to be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of RUM events to filter on.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of a RUM retention filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The Query string for a RUM retention filter. Defaults to `""`.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> pulumi.Output[_builtins.int]:
        """
        The sample rate for a RUM retention filter, between 0 and 100.
        """
        return pulumi.get(self, "sample_rate")

