# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticsGlobalVariableArgs', 'SyntheticsGlobalVariable']

@pulumi.input_type
class SyntheticsGlobalVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fido: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_totp: Optional[pulumi.Input[_builtins.bool]] = None,
                 options: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']] = None,
                 parse_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parse_test_options: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SyntheticsGlobalVariable resource.
        :param pulumi.Input[_builtins.str] name: Synthetics global variable name. Must be all uppercase with underscores.
        :param pulumi.Input[_builtins.str] description: Description of the global variable. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_fido: If set to true, the global variable is a FIDO variable. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] is_totp: If set to true, the global variable is a TOTP variable. Defaults to `false`.
        :param pulumi.Input['SyntheticsGlobalVariableOptionsArgs'] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[_builtins.str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs'] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        :param pulumi.Input[_builtins.bool] secure: If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[_builtins.str] value: The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_fido is not None:
            pulumi.set(__self__, "is_fido", is_fido)
        if is_totp is not None:
            pulumi.set(__self__, "is_totp", is_totp)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if parse_test_id is not None:
            pulumi.set(__self__, "parse_test_id", parse_test_id)
        if parse_test_options is not None:
            pulumi.set(__self__, "parse_test_options", parse_test_options)
        if restricted_roles is not None:
            warnings.warn("""This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""", DeprecationWarning)
            pulumi.log.warn("""restricted_roles is deprecated: This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""")
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Synthetics global variable name. Must be all uppercase with underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the global variable. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isFido")
    def is_fido(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the global variable is a FIDO variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_fido")

    @is_fido.setter
    def is_fido(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fido", value)

    @_builtins.property
    @pulumi.getter(name="isTotp")
    def is_totp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the global variable is a TOTP variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_totp")

    @is_totp.setter
    def is_totp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_totp", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @parse_test_id.setter
    def parse_test_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parse_test_id", value)

    @_builtins.property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @parse_test_options.setter
    def parse_test_options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]):
        pulumi.set(self, "parse_test_options", value)

    @_builtins.property
    @pulumi.getter(name="restrictedRoles")
    @_utilities.deprecated("""This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @_builtins.property
    @pulumi.getter
    def secure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @secure.setter
    def secure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _SyntheticsGlobalVariableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fido: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_totp: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']] = None,
                 parse_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parse_test_options: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SyntheticsGlobalVariable resources.
        :param pulumi.Input[_builtins.str] description: Description of the global variable. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_fido: If set to true, the global variable is a FIDO variable. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] is_totp: If set to true, the global variable is a TOTP variable. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Synthetics global variable name. Must be all uppercase with underscores.
        :param pulumi.Input['SyntheticsGlobalVariableOptionsArgs'] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[_builtins.str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs'] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        :param pulumi.Input[_builtins.bool] secure: If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[_builtins.str] value: The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_fido is not None:
            pulumi.set(__self__, "is_fido", is_fido)
        if is_totp is not None:
            pulumi.set(__self__, "is_totp", is_totp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if parse_test_id is not None:
            pulumi.set(__self__, "parse_test_id", parse_test_id)
        if parse_test_options is not None:
            pulumi.set(__self__, "parse_test_options", parse_test_options)
        if restricted_roles is not None:
            warnings.warn("""This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""", DeprecationWarning)
            pulumi.log.warn("""restricted_roles is deprecated: This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""")
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the global variable. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isFido")
    def is_fido(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the global variable is a FIDO variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_fido")

    @is_fido.setter
    def is_fido(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fido", value)

    @_builtins.property
    @pulumi.getter(name="isTotp")
    def is_totp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the global variable is a TOTP variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_totp")

    @is_totp.setter
    def is_totp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_totp", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synthetics global variable name. Must be all uppercase with underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @parse_test_id.setter
    def parse_test_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parse_test_id", value)

    @_builtins.property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @parse_test_options.setter
    def parse_test_options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]):
        pulumi.set(self, "parse_test_options", value)

    @_builtins.property
    @pulumi.getter(name="restrictedRoles")
    @_utilities.deprecated("""This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @_builtins.property
    @pulumi.getter
    def secure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @secure.setter
    def secure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable")
class SyntheticsGlobalVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fido: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_totp: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableOptionsArgs', 'SyntheticsGlobalVariableOptionsArgsDict']]] = None,
                 parse_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parse_test_options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableParseTestOptionsArgs', 'SyntheticsGlobalVariableParseTestOptionsArgsDict']]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog synthetics global variable resource. This can be used to create and manage Datadog synthetics global variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new synthetics_global_variable resource
        test_variable = datadog.SyntheticsGlobalVariable("test_variable",
            name="EXAMPLE_VARIABLE",
            description="Description of the variable",
            tags=[
                "foo:bar",
                "env:test",
            ],
            value="variable-value")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Synthetics global variables can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable fizz abcde123-fghi-456-jkl-mnopqrstuv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the global variable. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_fido: If set to true, the global variable is a FIDO variable. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] is_totp: If set to true, the global variable is a TOTP variable. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Synthetics global variable name. Must be all uppercase with underscores.
        :param pulumi.Input[Union['SyntheticsGlobalVariableOptionsArgs', 'SyntheticsGlobalVariableOptionsArgsDict']] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[_builtins.str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input[Union['SyntheticsGlobalVariableParseTestOptionsArgs', 'SyntheticsGlobalVariableParseTestOptionsArgsDict']] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        :param pulumi.Input[_builtins.bool] secure: If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[_builtins.str] value: The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticsGlobalVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog synthetics global variable resource. This can be used to create and manage Datadog synthetics global variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new synthetics_global_variable resource
        test_variable = datadog.SyntheticsGlobalVariable("test_variable",
            name="EXAMPLE_VARIABLE",
            description="Description of the variable",
            tags=[
                "foo:bar",
                "env:test",
            ],
            value="variable-value")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Synthetics global variables can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable fizz abcde123-fghi-456-jkl-mnopqrstuv
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticsGlobalVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticsGlobalVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fido: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_totp: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableOptionsArgs', 'SyntheticsGlobalVariableOptionsArgsDict']]] = None,
                 parse_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parse_test_options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableParseTestOptionsArgs', 'SyntheticsGlobalVariableParseTestOptionsArgsDict']]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticsGlobalVariableArgs.__new__(SyntheticsGlobalVariableArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["is_fido"] = is_fido
            __props__.__dict__["is_totp"] = is_totp
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["parse_test_id"] = parse_test_id
            __props__.__dict__["parse_test_options"] = parse_test_options
            __props__.__dict__["restricted_roles"] = restricted_roles
            __props__.__dict__["secure"] = secure
            __props__.__dict__["tags"] = tags
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyntheticsGlobalVariable, __self__).__init__(
            'datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_fido: Optional[pulumi.Input[_builtins.bool]] = None,
            is_totp: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableOptionsArgs', 'SyntheticsGlobalVariableOptionsArgsDict']]] = None,
            parse_test_id: Optional[pulumi.Input[_builtins.str]] = None,
            parse_test_options: Optional[pulumi.Input[Union['SyntheticsGlobalVariableParseTestOptionsArgs', 'SyntheticsGlobalVariableParseTestOptionsArgsDict']]] = None,
            restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secure: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'SyntheticsGlobalVariable':
        """
        Get an existing SyntheticsGlobalVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the global variable. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_fido: If set to true, the global variable is a FIDO variable. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] is_totp: If set to true, the global variable is a TOTP variable. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Synthetics global variable name. Must be all uppercase with underscores.
        :param pulumi.Input[Union['SyntheticsGlobalVariableOptionsArgs', 'SyntheticsGlobalVariableOptionsArgsDict']] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[_builtins.str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input[Union['SyntheticsGlobalVariableParseTestOptionsArgs', 'SyntheticsGlobalVariableParseTestOptionsArgsDict']] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        :param pulumi.Input[_builtins.bool] secure: If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[_builtins.str] value: The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticsGlobalVariableState.__new__(_SyntheticsGlobalVariableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["is_fido"] = is_fido
        __props__.__dict__["is_totp"] = is_totp
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["parse_test_id"] = parse_test_id
        __props__.__dict__["parse_test_options"] = parse_test_options
        __props__.__dict__["restricted_roles"] = restricted_roles
        __props__.__dict__["secure"] = secure
        __props__.__dict__["tags"] = tags
        __props__.__dict__["value"] = value
        return SyntheticsGlobalVariable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the global variable. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isFido")
    def is_fido(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, the global variable is a FIDO variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_fido")

    @_builtins.property
    @pulumi.getter(name="isTotp")
    def is_totp(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, the global variable is a TOTP variable. Defaults to `false`.
        """
        return pulumi.get(self, "is_totp")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Synthetics global variable name. Must be all uppercase with underscores.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.SyntheticsGlobalVariableOptions']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @_builtins.property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> pulumi.Output[Optional['outputs.SyntheticsGlobalVariableParseTestOptions']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @_builtins.property
    @pulumi.getter(name="restrictedRoles")
    @_utilities.deprecated("""This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.""")
    def restricted_roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable. **Deprecated.** This field is no longer supported by the Datadog API. Please use `RestrictionPolicy` instead.
        """
        return pulumi.get(self, "restricted_roles")

    @_builtins.property
    @pulumi.getter
    def secure(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, the value of the global variable is hidden. This setting is automatically set to `true` if `is_totp` or `is_fido` is set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value of the global variable. Required unless `is_fido` is set to `true`.
        """
        return pulumi.get(self, "value")

