# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkflowAutomationArgs', 'WorkflowAutomation']

@pulumi.input_type
class WorkflowAutomationArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 published: pulumi.Input[_builtins.bool],
                 spec_json: pulumi.Input[_builtins.str],
                 tags: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 webhook_secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkflowAutomation resource.
        :param pulumi.Input[_builtins.str] description: Description of the workflow.
        :param pulumi.Input[_builtins.str] name: Name of the workflow. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        :param pulumi.Input[_builtins.str] spec_json: The spec defines what the workflow does.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the workflow.
        :param pulumi.Input[_builtins.str] webhook_secret: If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "published", published)
        pulumi.set(__self__, "spec_json", spec_json)
        pulumi.set(__self__, "tags", tags)
        if webhook_secret is not None:
            pulumi.set(__self__, "webhook_secret", webhook_secret)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the workflow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the workflow. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def published(self) -> pulumi.Input[_builtins.bool]:
        """
        Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "published", value)

    @_builtins.property
    @pulumi.getter(name="specJson")
    def spec_json(self) -> pulumi.Input[_builtins.str]:
        """
        The spec defines what the workflow does.
        """
        return pulumi.get(self, "spec_json")

    @spec_json.setter
    def spec_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spec_json", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Tags of the workflow.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        return pulumi.get(self, "webhook_secret")

    @webhook_secret.setter
    def webhook_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook_secret", value)


@pulumi.input_type
class _WorkflowAutomationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 spec_json: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 webhook_secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkflowAutomation resources.
        :param pulumi.Input[_builtins.str] description: Description of the workflow.
        :param pulumi.Input[_builtins.str] name: Name of the workflow. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        :param pulumi.Input[_builtins.str] spec_json: The spec defines what the workflow does.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the workflow.
        :param pulumi.Input[_builtins.str] webhook_secret: If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if spec_json is not None:
            pulumi.set(__self__, "spec_json", spec_json)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if webhook_secret is not None:
            pulumi.set(__self__, "webhook_secret", webhook_secret)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the workflow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the workflow. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def published(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "published", value)

    @_builtins.property
    @pulumi.getter(name="specJson")
    def spec_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spec defines what the workflow does.
        """
        return pulumi.get(self, "spec_json")

    @spec_json.setter
    def spec_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_json", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags of the workflow.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        return pulumi.get(self, "webhook_secret")

    @webhook_secret.setter
    def webhook_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook_secret", value)


@pulumi.type_token("datadog:index/workflowAutomation:WorkflowAutomation")
class WorkflowAutomation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 spec_json: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 webhook_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        workflow = datadog.WorkflowAutomation("workflow",
            name="Send Email when Monitor Alerts",
            description="This workflow alerts me by email when my monitor goes off. ",
            tags=[
                "service:foo",
                "source:alert",
                "team:bar",
            ],
            published=True,
            spec_json=json.dumps({
                "triggers": [{
                    "startStepNames": ["Send_Email"],
                    "monitorTrigger": {},
                }],
                "steps": [{
                    "name": "Send_Email",
                    "actionId": "com.datadoghq.email.send",
                    "parameters": [
                        {
                            "name": "to",
                            "value": "REPLACE_ME",
                        },
                        {
                            "name": "subject",
                            "value": "Monitor \\"{{ Source.monitor.name }}\\" alerted",
                        },
                        {
                            "name": "message",
                            "value": \"\"\"This message is from {{ WorkflowName }}. 

        You can find a link to the monitor here: {{ Source.url }}.\"\"\",
                        },
                    ],
                    "display": {
                        "bounds": {
                            "x": 0,
                            "y": 216,
                        },
                    },
                }],
                "handle": "my-handle",
            }))
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/workflowAutomation:WorkflowAutomation my_workflow 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the workflow.
        :param pulumi.Input[_builtins.str] name: Name of the workflow. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        :param pulumi.Input[_builtins.str] spec_json: The spec defines what the workflow does.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the workflow.
        :param pulumi.Input[_builtins.str] webhook_secret: If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowAutomationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        workflow = datadog.WorkflowAutomation("workflow",
            name="Send Email when Monitor Alerts",
            description="This workflow alerts me by email when my monitor goes off. ",
            tags=[
                "service:foo",
                "source:alert",
                "team:bar",
            ],
            published=True,
            spec_json=json.dumps({
                "triggers": [{
                    "startStepNames": ["Send_Email"],
                    "monitorTrigger": {},
                }],
                "steps": [{
                    "name": "Send_Email",
                    "actionId": "com.datadoghq.email.send",
                    "parameters": [
                        {
                            "name": "to",
                            "value": "REPLACE_ME",
                        },
                        {
                            "name": "subject",
                            "value": "Monitor \\"{{ Source.monitor.name }}\\" alerted",
                        },
                        {
                            "name": "message",
                            "value": \"\"\"This message is from {{ WorkflowName }}. 

        You can find a link to the monitor here: {{ Source.url }}.\"\"\",
                        },
                    ],
                    "display": {
                        "bounds": {
                            "x": 0,
                            "y": 216,
                        },
                    },
                }],
                "handle": "my-handle",
            }))
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/workflowAutomation:WorkflowAutomation my_workflow 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param WorkflowAutomationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowAutomationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 published: Optional[pulumi.Input[_builtins.bool]] = None,
                 spec_json: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 webhook_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowAutomationArgs.__new__(WorkflowAutomationArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if published is None and not opts.urn:
                raise TypeError("Missing required property 'published'")
            __props__.__dict__["published"] = published
            if spec_json is None and not opts.urn:
                raise TypeError("Missing required property 'spec_json'")
            __props__.__dict__["spec_json"] = spec_json
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
            __props__.__dict__["webhook_secret"] = None if webhook_secret is None else pulumi.Output.secret(webhook_secret)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["webhookSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkflowAutomation, __self__).__init__(
            'datadog:index/workflowAutomation:WorkflowAutomation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            published: Optional[pulumi.Input[_builtins.bool]] = None,
            spec_json: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            webhook_secret: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkflowAutomation':
        """
        Get an existing WorkflowAutomation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the workflow.
        :param pulumi.Input[_builtins.str] name: Name of the workflow. String length must be at least 1.
        :param pulumi.Input[_builtins.bool] published: Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        :param pulumi.Input[_builtins.str] spec_json: The spec defines what the workflow does.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the workflow.
        :param pulumi.Input[_builtins.str] webhook_secret: If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkflowAutomationState.__new__(_WorkflowAutomationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["published"] = published
        __props__.__dict__["spec_json"] = spec_json
        __props__.__dict__["tags"] = tags
        __props__.__dict__["webhook_secret"] = webhook_secret
        return WorkflowAutomation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the workflow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the workflow. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def published(self) -> pulumi.Output[_builtins.bool]:
        """
        Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        """
        return pulumi.get(self, "published")

    @_builtins.property
    @pulumi.getter(name="specJson")
    def spec_json(self) -> pulumi.Output[_builtins.str]:
        """
        The spec defines what the workflow does.
        """
        return pulumi.get(self, "spec_json")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Tags of the workflow.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If a webhook trigger is defined on this workflow, a webhookSecret is required and should be provided here. String length must be at least 16.
        """
        return pulumi.get(self, "webhook_secret")

