"""Core TTT library functionality."""

from .api import ask, chat, stream
from .exceptions import (
    AIError,
    APIKeyError,
    BackendConnectionError,
    BackendError,
    BackendNotAvailableError,
    BackendTimeoutError,
    ConfigFileError,
    ConfigurationError,
    EmptyResponseError,
    FeatureNotAvailableError,
    InvalidParameterError,
    InvalidPromptError,
    ModelError,
    ModelNotFoundError,
    ModelNotSupportedError,
    MultiModalError,
    PluginError,
    PluginLoadError,
    PluginValidationError,
    QuotaExceededError,
    RateLimitError,
    ResponseError,
    ResponseParsingError,
    SessionError,
    SessionLoadError,
    SessionNotFoundError,
    SessionSaveError,
    ValidationError,
)
from .models import AIResponse, ImageInput, ModelInfo
from .routing import Router

__all__ = [
    # API functions
    "ask",
    "chat",
    "stream",
    # Data models
    "AIResponse",
    "ImageInput",
    "ModelInfo",
    "Router",
    # Exceptions
    "AIError",
    "APIKeyError",
    "BackendConnectionError",
    "BackendError",
    "BackendNotAvailableError",
    "BackendTimeoutError",
    "ConfigFileError",
    "ConfigurationError",
    "EmptyResponseError",
    "FeatureNotAvailableError",
    "InvalidParameterError",
    "InvalidPromptError",
    "ModelError",
    "ModelNotFoundError",
    "ModelNotSupportedError",
    "MultiModalError",
    "PluginError",
    "PluginLoadError",
    "PluginValidationError",
    "QuotaExceededError",
    "RateLimitError",
    "ResponseError",
    "ResponseParsingError",
    "SessionError",
    "SessionLoadError",
    "SessionNotFoundError",
    "SessionSaveError",
    "ValidationError",
]
