# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProcessorJobArgs', 'ProcessorJob']

@pulumi.input_type
class ProcessorJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 input_location: pulumi.Input['ProcessorJobInputLocationArgs'],
                 output_location: pulumi.Input['ProcessorJobOutputLocationArgs'],
                 processor_config: pulumi.Input['ProcessorJobProcessorConfigArgs'],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProcessorJob resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartment identifier.
        :param pulumi.Input['ProcessorJobInputLocationArgs'] input_location: The location of the inputs.
        :param pulumi.Input['ProcessorJobOutputLocationArgs'] output_location: The object storage location where to store analysis results.
        :param pulumi.Input['ProcessorJobProcessorConfigArgs'] processor_config: The configuration of a processor.
        :param pulumi.Input[_builtins.str] display_name: The display name of the processor job.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "input_location", input_location)
        pulumi.set(__self__, "output_location", output_location)
        pulumi.set(__self__, "processor_config", processor_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Input['ProcessorJobInputLocationArgs']:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: pulumi.Input['ProcessorJobInputLocationArgs']):
        pulumi.set(self, "input_location", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Input['ProcessorJobOutputLocationArgs']:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: pulumi.Input['ProcessorJobOutputLocationArgs']):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> pulumi.Input['ProcessorJobProcessorConfigArgs']:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @processor_config.setter
    def processor_config(self, value: pulumi.Input['ProcessorJobProcessorConfigArgs']):
        pulumi.set(self, "processor_config", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _ProcessorJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_location: Optional[pulumi.Input['ProcessorJobInputLocationArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 output_location: Optional[pulumi.Input['ProcessorJobOutputLocationArgs']] = None,
                 percent_complete: Optional[pulumi.Input[_builtins.float]] = None,
                 processor_config: Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
                 time_finished: Optional[pulumi.Input[_builtins.str]] = None,
                 time_started: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProcessorJob resources.
        :param pulumi.Input[_builtins.str] compartment_id: The compartment identifier.
        :param pulumi.Input[_builtins.str] display_name: The display name of the processor job.
        :param pulumi.Input['ProcessorJobInputLocationArgs'] input_location: The location of the inputs.
        :param pulumi.Input[_builtins.str] lifecycle_details: The detailed status of FAILED state.
        :param pulumi.Input['ProcessorJobOutputLocationArgs'] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[_builtins.float] percent_complete: How much progress the operation has made, compared to the total amount of work to be performed.
        :param pulumi.Input['ProcessorJobProcessorConfigArgs'] processor_config: The configuration of a processor.
        :param pulumi.Input[_builtins.str] state: The current state of the processor job.
        :param pulumi.Input[_builtins.str] time_accepted: The job acceptance time.
        :param pulumi.Input[_builtins.str] time_finished: The job finish time.
        :param pulumi.Input[_builtins.str] time_started: The job start time.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if input_location is not None:
            pulumi.set(__self__, "input_location", input_location)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if percent_complete is not None:
            pulumi.set(__self__, "percent_complete", percent_complete)
        if processor_config is not None:
            pulumi.set(__self__, "processor_config", processor_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> Optional[pulumi.Input['ProcessorJobInputLocationArgs']]:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: Optional[pulumi.Input['ProcessorJobInputLocationArgs']]):
        pulumi.set(self, "input_location", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed status of FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['ProcessorJobOutputLocationArgs']]:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['ProcessorJobOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        How much progress the operation has made, compared to the total amount of work to be performed.
        """
        return pulumi.get(self, "percent_complete")

    @percent_complete.setter
    def percent_complete(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_complete", value)

    @_builtins.property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']]:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @processor_config.setter
    def processor_config(self, value: Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']]):
        pulumi.set(self, "processor_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the processor job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job acceptance time.
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_accepted", value)

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job finish time.
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_finished", value)

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job start time.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_started", value)


@pulumi.type_token("oci:AiDocument/processorJob:ProcessorJob")
class ProcessorJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_location: Optional[pulumi.Input[Union['ProcessorJobInputLocationArgs', 'ProcessorJobInputLocationArgsDict']]] = None,
                 output_location: Optional[pulumi.Input[Union['ProcessorJobOutputLocationArgs', 'ProcessorJobOutputLocationArgsDict']]] = None,
                 processor_config: Optional[pulumi.Input[Union['ProcessorJobProcessorConfigArgs', 'ProcessorJobProcessorConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_processor_job = oci.aidocument.ProcessorJob("test_processor_job",
            compartment_id=compartment_id,
            input_location={
                "source_type": processor_job_input_location_source_type,
                "data": processor_job_input_location_data,
                "object_locations": [{
                    "bucket": processor_job_input_location_object_locations_bucket,
                    "namespace": processor_job_input_location_object_locations_namespace,
                    "object": processor_job_input_location_object_locations_object,
                    "page_ranges": processor_job_input_location_object_locations_page_range,
                }],
                "page_ranges": processor_job_input_location_page_range,
            },
            output_location={
                "bucket": processor_job_output_location_bucket,
                "namespace": processor_job_output_location_namespace,
                "prefix": processor_job_output_location_prefix,
            },
            processor_config={
                "processor_type": processor_job_processor_config_processor_type,
                "document_type": processor_job_processor_config_document_type,
                "features": [{
                    "feature_type": processor_job_processor_config_features_feature_type,
                    "generate_searchable_pdf": processor_job_processor_config_features_generate_searchable_pdf,
                    "max_results": processor_job_processor_config_features_max_results,
                    "model_id": test_model["id"],
                    "selection_mark_detection": processor_job_processor_config_features_selection_mark_detection,
                    "tenancy_id": test_tenancy["id"],
                }],
                "is_zip_output_enabled": processor_job_processor_config_is_zip_output_enabled,
                "language": processor_job_processor_config_language,
                "model_id": test_model["id"],
                "normalization_fields": [{
                    "maps": [{
                        "normalization_type": processor_job_processor_config_normalization_fields_map_normalization_type,
                    }],
                }],
            },
            display_name=processor_job_display_name)
        ```

        ## Import

        ProcessorJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/processorJob:ProcessorJob test_processor_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartment identifier.
        :param pulumi.Input[_builtins.str] display_name: The display name of the processor job.
        :param pulumi.Input[Union['ProcessorJobInputLocationArgs', 'ProcessorJobInputLocationArgsDict']] input_location: The location of the inputs.
        :param pulumi.Input[Union['ProcessorJobOutputLocationArgs', 'ProcessorJobOutputLocationArgsDict']] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[Union['ProcessorJobProcessorConfigArgs', 'ProcessorJobProcessorConfigArgsDict']] processor_config: The configuration of a processor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessorJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_processor_job = oci.aidocument.ProcessorJob("test_processor_job",
            compartment_id=compartment_id,
            input_location={
                "source_type": processor_job_input_location_source_type,
                "data": processor_job_input_location_data,
                "object_locations": [{
                    "bucket": processor_job_input_location_object_locations_bucket,
                    "namespace": processor_job_input_location_object_locations_namespace,
                    "object": processor_job_input_location_object_locations_object,
                    "page_ranges": processor_job_input_location_object_locations_page_range,
                }],
                "page_ranges": processor_job_input_location_page_range,
            },
            output_location={
                "bucket": processor_job_output_location_bucket,
                "namespace": processor_job_output_location_namespace,
                "prefix": processor_job_output_location_prefix,
            },
            processor_config={
                "processor_type": processor_job_processor_config_processor_type,
                "document_type": processor_job_processor_config_document_type,
                "features": [{
                    "feature_type": processor_job_processor_config_features_feature_type,
                    "generate_searchable_pdf": processor_job_processor_config_features_generate_searchable_pdf,
                    "max_results": processor_job_processor_config_features_max_results,
                    "model_id": test_model["id"],
                    "selection_mark_detection": processor_job_processor_config_features_selection_mark_detection,
                    "tenancy_id": test_tenancy["id"],
                }],
                "is_zip_output_enabled": processor_job_processor_config_is_zip_output_enabled,
                "language": processor_job_processor_config_language,
                "model_id": test_model["id"],
                "normalization_fields": [{
                    "maps": [{
                        "normalization_type": processor_job_processor_config_normalization_fields_map_normalization_type,
                    }],
                }],
            },
            display_name=processor_job_display_name)
        ```

        ## Import

        ProcessorJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/processorJob:ProcessorJob test_processor_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProcessorJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessorJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_location: Optional[pulumi.Input[Union['ProcessorJobInputLocationArgs', 'ProcessorJobInputLocationArgsDict']]] = None,
                 output_location: Optional[pulumi.Input[Union['ProcessorJobOutputLocationArgs', 'ProcessorJobOutputLocationArgsDict']]] = None,
                 processor_config: Optional[pulumi.Input[Union['ProcessorJobProcessorConfigArgs', 'ProcessorJobProcessorConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessorJobArgs.__new__(ProcessorJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["display_name"] = display_name
            if input_location is None and not opts.urn:
                raise TypeError("Missing required property 'input_location'")
            __props__.__dict__["input_location"] = input_location
            if output_location is None and not opts.urn:
                raise TypeError("Missing required property 'output_location'")
            __props__.__dict__["output_location"] = output_location
            if processor_config is None and not opts.urn:
                raise TypeError("Missing required property 'processor_config'")
            __props__.__dict__["processor_config"] = processor_config
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["percent_complete"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
        super(ProcessorJob, __self__).__init__(
            'oci:AiDocument/processorJob:ProcessorJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            input_location: Optional[pulumi.Input[Union['ProcessorJobInputLocationArgs', 'ProcessorJobInputLocationArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            output_location: Optional[pulumi.Input[Union['ProcessorJobOutputLocationArgs', 'ProcessorJobOutputLocationArgsDict']]] = None,
            percent_complete: Optional[pulumi.Input[_builtins.float]] = None,
            processor_config: Optional[pulumi.Input[Union['ProcessorJobProcessorConfigArgs', 'ProcessorJobProcessorConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
            time_finished: Optional[pulumi.Input[_builtins.str]] = None,
            time_started: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProcessorJob':
        """
        Get an existing ProcessorJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartment identifier.
        :param pulumi.Input[_builtins.str] display_name: The display name of the processor job.
        :param pulumi.Input[Union['ProcessorJobInputLocationArgs', 'ProcessorJobInputLocationArgsDict']] input_location: The location of the inputs.
        :param pulumi.Input[_builtins.str] lifecycle_details: The detailed status of FAILED state.
        :param pulumi.Input[Union['ProcessorJobOutputLocationArgs', 'ProcessorJobOutputLocationArgsDict']] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[_builtins.float] percent_complete: How much progress the operation has made, compared to the total amount of work to be performed.
        :param pulumi.Input[Union['ProcessorJobProcessorConfigArgs', 'ProcessorJobProcessorConfigArgsDict']] processor_config: The configuration of a processor.
        :param pulumi.Input[_builtins.str] state: The current state of the processor job.
        :param pulumi.Input[_builtins.str] time_accepted: The job acceptance time.
        :param pulumi.Input[_builtins.str] time_finished: The job finish time.
        :param pulumi.Input[_builtins.str] time_started: The job start time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessorJobState.__new__(_ProcessorJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["input_location"] = input_location
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["output_location"] = output_location
        __props__.__dict__["percent_complete"] = percent_complete
        __props__.__dict__["processor_config"] = processor_config
        __props__.__dict__["state"] = state
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        return ProcessorJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Output['outputs.ProcessorJobInputLocation']:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        The detailed status of FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output['outputs.ProcessorJobOutputLocation']:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @_builtins.property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> pulumi.Output[_builtins.float]:
        """
        How much progress the operation has made, compared to the total amount of work to be performed.
        """
        return pulumi.get(self, "percent_complete")

    @_builtins.property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> pulumi.Output['outputs.ProcessorJobProcessorConfig']:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the processor job.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[_builtins.str]:
        """
        The job acceptance time.
        """
        return pulumi.get(self, "time_accepted")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[_builtins.str]:
        """
        The job finish time.
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[_builtins.str]:
        """
        The job start time.
        """
        return pulumi.get(self, "time_started")

