# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    """
    A collection of values returned by getJob.
    """
    def __init__(__self__, compartment_id=None, completed_documents=None, created_by=None, description=None, display_name=None, failed_documents=None, id=None, input_configurations=None, input_locations=None, job_id=None, lifecycle_details=None, model_metadata_details=None, output_locations=None, pending_documents=None, percent_complete=None, state=None, time_accepted=None, time_completed=None, time_started=None, total_documents=None, ttl_in_days=None, warnings_count=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if completed_documents and not isinstance(completed_documents, int):
            raise TypeError("Expected argument 'completed_documents' to be a int")
        pulumi.set(__self__, "completed_documents", completed_documents)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if failed_documents and not isinstance(failed_documents, int):
            raise TypeError("Expected argument 'failed_documents' to be a int")
        pulumi.set(__self__, "failed_documents", failed_documents)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input_configurations and not isinstance(input_configurations, list):
            raise TypeError("Expected argument 'input_configurations' to be a list")
        pulumi.set(__self__, "input_configurations", input_configurations)
        if input_locations and not isinstance(input_locations, list):
            raise TypeError("Expected argument 'input_locations' to be a list")
        pulumi.set(__self__, "input_locations", input_locations)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_metadata_details and not isinstance(model_metadata_details, list):
            raise TypeError("Expected argument 'model_metadata_details' to be a list")
        pulumi.set(__self__, "model_metadata_details", model_metadata_details)
        if output_locations and not isinstance(output_locations, list):
            raise TypeError("Expected argument 'output_locations' to be a list")
        pulumi.set(__self__, "output_locations", output_locations)
        if pending_documents and not isinstance(pending_documents, int):
            raise TypeError("Expected argument 'pending_documents' to be a int")
        pulumi.set(__self__, "pending_documents", pending_documents)
        if percent_complete and not isinstance(percent_complete, int):
            raise TypeError("Expected argument 'percent_complete' to be a int")
        pulumi.set(__self__, "percent_complete", percent_complete)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)
        if time_completed and not isinstance(time_completed, str):
            raise TypeError("Expected argument 'time_completed' to be a str")
        pulumi.set(__self__, "time_completed", time_completed)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if total_documents and not isinstance(total_documents, int):
            raise TypeError("Expected argument 'total_documents' to be a int")
        pulumi.set(__self__, "total_documents", total_documents)
        if ttl_in_days and not isinstance(ttl_in_days, int):
            raise TypeError("Expected argument 'ttl_in_days' to be a int")
        pulumi.set(__self__, "ttl_in_days", ttl_in_days)
        if warnings_count and not isinstance(warnings_count, int):
            raise TypeError("Expected argument 'warnings_count' to be a int")
        pulumi.set(__self__, "warnings_count", warnings_count)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="completedDocuments")
    def completed_documents(self) -> _builtins.int:
        """
        Number of documents processed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "completed_documents")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A short description of the job.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly display name for the job.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="failedDocuments")
    def failed_documents(self) -> _builtins.int:
        """
        Number of documents failed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "failed_documents")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inputConfigurations")
    def input_configurations(self) -> Sequence['outputs.GetJobInputConfigurationResult']:
        """
        input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        """
        return pulumi.get(self, "input_configurations")

    @_builtins.property
    @pulumi.getter(name="inputLocations")
    def input_locations(self) -> Sequence['outputs.GetJobInputLocationResult']:
        """
        document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        """
        return pulumi.get(self, "input_locations")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="modelMetadataDetails")
    def model_metadata_details(self) -> Sequence['outputs.GetJobModelMetadataDetailResult']:
        """
        training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        """
        return pulumi.get(self, "model_metadata_details")

    @_builtins.property
    @pulumi.getter(name="outputLocations")
    def output_locations(self) -> Sequence['outputs.GetJobOutputLocationResult']:
        """
        Object storage output location to write inference results
        """
        return pulumi.get(self, "output_locations")

    @_builtins.property
    @pulumi.getter(name="pendingDocuments")
    def pending_documents(self) -> _builtins.int:
        """
        Number of documents still to process. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "pending_documents")

    @_builtins.property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> _builtins.int:
        """
        How much progress the operation has made, vs the total amount of work that must be performed.
        """
        return pulumi.get(self, "percent_complete")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Job.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> _builtins.str:
        """
        Job accepted time.
        """
        return pulumi.get(self, "time_accepted")

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> _builtins.str:
        """
        Job finished time.
        """
        return pulumi.get(self, "time_completed")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        Job started time.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="totalDocuments")
    def total_documents(self) -> _builtins.int:
        """
        Total number of documents given as input for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "total_documents")

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> _builtins.int:
        """
        Time to live duration in days for Job. Job will be available till max 90 days.
        """
        return pulumi.get(self, "ttl_in_days")

    @_builtins.property
    @pulumi.getter(name="warningsCount")
    def warnings_count(self) -> _builtins.int:
        """
        warnings count
        """
        return pulumi.get(self, "warnings_count")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            compartment_id=self.compartment_id,
            completed_documents=self.completed_documents,
            created_by=self.created_by,
            description=self.description,
            display_name=self.display_name,
            failed_documents=self.failed_documents,
            id=self.id,
            input_configurations=self.input_configurations,
            input_locations=self.input_locations,
            job_id=self.job_id,
            lifecycle_details=self.lifecycle_details,
            model_metadata_details=self.model_metadata_details,
            output_locations=self.output_locations,
            pending_documents=self.pending_documents,
            percent_complete=self.percent_complete,
            state=self.state,
            time_accepted=self.time_accepted,
            time_completed=self.time_completed,
            time_started=self.time_started,
            total_documents=self.total_documents,
            ttl_in_days=self.ttl_in_days,
            warnings_count=self.warnings_count)


def get_job(job_id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    This data source provides details about a specific Job resource in Oracle Cloud Infrastructure Ai Language service.

    Gets a language service async job

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job = oci.AiLanguage.get_job(job_id=test_job_oci_ai_language_job["id"])
    ```


    :param _builtins.str job_id: Unique Transcription Job identifier.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiLanguage/getJob:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        completed_documents=pulumi.get(__ret__, 'completed_documents'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        failed_documents=pulumi.get(__ret__, 'failed_documents'),
        id=pulumi.get(__ret__, 'id'),
        input_configurations=pulumi.get(__ret__, 'input_configurations'),
        input_locations=pulumi.get(__ret__, 'input_locations'),
        job_id=pulumi.get(__ret__, 'job_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        model_metadata_details=pulumi.get(__ret__, 'model_metadata_details'),
        output_locations=pulumi.get(__ret__, 'output_locations'),
        pending_documents=pulumi.get(__ret__, 'pending_documents'),
        percent_complete=pulumi.get(__ret__, 'percent_complete'),
        state=pulumi.get(__ret__, 'state'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'),
        time_completed=pulumi.get(__ret__, 'time_completed'),
        time_started=pulumi.get(__ret__, 'time_started'),
        total_documents=pulumi.get(__ret__, 'total_documents'),
        ttl_in_days=pulumi.get(__ret__, 'ttl_in_days'),
        warnings_count=pulumi.get(__ret__, 'warnings_count'))
def get_job_output(job_id: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobResult]:
    """
    This data source provides details about a specific Job resource in Oracle Cloud Infrastructure Ai Language service.

    Gets a language service async job

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job = oci.AiLanguage.get_job(job_id=test_job_oci_ai_language_job["id"])
    ```


    :param _builtins.str job_id: Unique Transcription Job identifier.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiLanguage/getJob:getJob', __args__, opts=opts, typ=GetJobResult)
    return __ret__.apply(lambda __response__: GetJobResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        completed_documents=pulumi.get(__response__, 'completed_documents'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        failed_documents=pulumi.get(__response__, 'failed_documents'),
        id=pulumi.get(__response__, 'id'),
        input_configurations=pulumi.get(__response__, 'input_configurations'),
        input_locations=pulumi.get(__response__, 'input_locations'),
        job_id=pulumi.get(__response__, 'job_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        model_metadata_details=pulumi.get(__response__, 'model_metadata_details'),
        output_locations=pulumi.get(__response__, 'output_locations'),
        pending_documents=pulumi.get(__response__, 'pending_documents'),
        percent_complete=pulumi.get(__response__, 'percent_complete'),
        state=pulumi.get(__response__, 'state'),
        time_accepted=pulumi.get(__response__, 'time_accepted'),
        time_completed=pulumi.get(__response__, 'time_completed'),
        time_started=pulumi.get(__response__, 'time_started'),
        total_documents=pulumi.get(__response__, 'total_documents'),
        ttl_in_days=pulumi.get(__response__, 'ttl_in_days'),
        warnings_count=pulumi.get(__response__, 'warnings_count')))
