# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 input_location: pulumi.Input['JobInputLocationArgs'],
                 model_metadata_details: pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]],
                 output_location: pulumi.Input['JobOutputLocationArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_configuration: Optional[pulumi.Input['JobInputConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input['JobInputLocationArgs'] input_location: document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        :param pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]] model_metadata_details: training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        :param pulumi.Input['JobOutputLocationArgs'] output_location: Object storage output location to write inference results
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the job.
        :param pulumi.Input['JobInputConfigurationArgs'] input_configuration: input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "input_location", input_location)
        pulumi.set(__self__, "model_metadata_details", model_metadata_details)
        pulumi.set(__self__, "output_location", output_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if input_configuration is not None:
            pulumi.set(__self__, "input_configuration", input_configuration)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Input['JobInputLocationArgs']:
        """
        document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: pulumi.Input['JobInputLocationArgs']):
        pulumi.set(self, "input_location", value)

    @_builtins.property
    @pulumi.getter(name="modelMetadataDetails")
    def model_metadata_details(self) -> pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]]:
        """
        training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        """
        return pulumi.get(self, "model_metadata_details")

    @model_metadata_details.setter
    def model_metadata_details(self, value: pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]]):
        pulumi.set(self, "model_metadata_details", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Input['JobOutputLocationArgs']:
        """
        Object storage output location to write inference results
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: pulumi.Input['JobOutputLocationArgs']):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="inputConfiguration")
    def input_configuration(self) -> Optional[pulumi.Input['JobInputConfigurationArgs']]:
        """
        input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        """
        return pulumi.get(self, "input_configuration")

    @input_configuration.setter
    def input_configuration(self, value: Optional[pulumi.Input['JobInputConfigurationArgs']]):
        pulumi.set(self, "input_configuration", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 completed_documents: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 failed_documents: Optional[pulumi.Input[_builtins.int]] = None,
                 input_configuration: Optional[pulumi.Input['JobInputConfigurationArgs']] = None,
                 input_location: Optional[pulumi.Input['JobInputLocationArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 model_metadata_details: Optional[pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]]] = None,
                 output_location: Optional[pulumi.Input['JobOutputLocationArgs']] = None,
                 pending_documents: Optional[pulumi.Input[_builtins.int]] = None,
                 percent_complete: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
                 time_completed: Optional[pulumi.Input[_builtins.str]] = None,
                 time_started: Optional[pulumi.Input[_builtins.str]] = None,
                 total_documents: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 warnings_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[_builtins.int] completed_documents: Number of documents processed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job.
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the job.
        :param pulumi.Input[_builtins.int] failed_documents: Number of documents failed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input['JobInputConfigurationArgs'] input_configuration: input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        :param pulumi.Input['JobInputLocationArgs'] input_location: document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]] model_metadata_details: training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        :param pulumi.Input['JobOutputLocationArgs'] output_location: Object storage output location to write inference results
        :param pulumi.Input[_builtins.int] pending_documents: Number of documents still to process. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.int] percent_complete: How much progress the operation has made, vs the total amount of work that must be performed.
        :param pulumi.Input[_builtins.str] state: The current state of the Job.
        :param pulumi.Input[_builtins.str] time_accepted: Job accepted time.
        :param pulumi.Input[_builtins.str] time_completed: Job finished time.
        :param pulumi.Input[_builtins.str] time_started: Job started time.
        :param pulumi.Input[_builtins.int] total_documents: Total number of documents given as input for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.int] ttl_in_days: Time to live duration in days for Job. Job will be available till max 90 days.
        :param pulumi.Input[_builtins.int] warnings_count: warnings count
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if completed_documents is not None:
            pulumi.set(__self__, "completed_documents", completed_documents)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if failed_documents is not None:
            pulumi.set(__self__, "failed_documents", failed_documents)
        if input_configuration is not None:
            pulumi.set(__self__, "input_configuration", input_configuration)
        if input_location is not None:
            pulumi.set(__self__, "input_location", input_location)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_metadata_details is not None:
            pulumi.set(__self__, "model_metadata_details", model_metadata_details)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if pending_documents is not None:
            pulumi.set(__self__, "pending_documents", pending_documents)
        if percent_complete is not None:
            pulumi.set(__self__, "percent_complete", percent_complete)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_completed is not None:
            pulumi.set(__self__, "time_completed", time_completed)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if total_documents is not None:
            pulumi.set(__self__, "total_documents", total_documents)
        if ttl_in_days is not None:
            pulumi.set(__self__, "ttl_in_days", ttl_in_days)
        if warnings_count is not None:
            pulumi.set(__self__, "warnings_count", warnings_count)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="completedDocuments")
    def completed_documents(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of documents processed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "completed_documents")

    @completed_documents.setter
    def completed_documents(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "completed_documents", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="failedDocuments")
    def failed_documents(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of documents failed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "failed_documents")

    @failed_documents.setter
    def failed_documents(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failed_documents", value)

    @_builtins.property
    @pulumi.getter(name="inputConfiguration")
    def input_configuration(self) -> Optional[pulumi.Input['JobInputConfigurationArgs']]:
        """
        input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        """
        return pulumi.get(self, "input_configuration")

    @input_configuration.setter
    def input_configuration(self, value: Optional[pulumi.Input['JobInputConfigurationArgs']]):
        pulumi.set(self, "input_configuration", value)

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> Optional[pulumi.Input['JobInputLocationArgs']]:
        """
        document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: Optional[pulumi.Input['JobInputLocationArgs']]):
        pulumi.set(self, "input_location", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="modelMetadataDetails")
    def model_metadata_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]]]:
        """
        training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        """
        return pulumi.get(self, "model_metadata_details")

    @model_metadata_details.setter
    def model_metadata_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobModelMetadataDetailArgs']]]]):
        pulumi.set(self, "model_metadata_details", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['JobOutputLocationArgs']]:
        """
        Object storage output location to write inference results
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['JobOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter(name="pendingDocuments")
    def pending_documents(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of documents still to process. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "pending_documents")

    @pending_documents.setter
    def pending_documents(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pending_documents", value)

    @_builtins.property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How much progress the operation has made, vs the total amount of work that must be performed.
        """
        return pulumi.get(self, "percent_complete")

    @percent_complete.setter
    def percent_complete(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "percent_complete", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job accepted time.
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_accepted", value)

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job finished time.
        """
        return pulumi.get(self, "time_completed")

    @time_completed.setter
    def time_completed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_completed", value)

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job started time.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_started", value)

    @_builtins.property
    @pulumi.getter(name="totalDocuments")
    def total_documents(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of documents given as input for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "total_documents")

    @total_documents.setter
    def total_documents(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_documents", value)

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time to live duration in days for Job. Job will be available till max 90 days.
        """
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_in_days", value)

    @_builtins.property
    @pulumi.getter(name="warningsCount")
    def warnings_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        warnings count
        """
        return pulumi.get(self, "warnings_count")

    @warnings_count.setter
    def warnings_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "warnings_count", value)


@pulumi.type_token("oci:AiLanguage/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_configuration: Optional[pulumi.Input[Union['JobInputConfigurationArgs', 'JobInputConfigurationArgsDict']]] = None,
                 input_location: Optional[pulumi.Input[Union['JobInputLocationArgs', 'JobInputLocationArgsDict']]] = None,
                 model_metadata_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobModelMetadataDetailArgs', 'JobModelMetadataDetailArgsDict']]]]] = None,
                 output_location: Optional[pulumi.Input[Union['JobOutputLocationArgs', 'JobOutputLocationArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Ai Language service.

        Creates a new language service async job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.ailanguage.Job("test_job",
            compartment_id=compartment_id,
            input_location={
                "bucket": job_input_location_bucket,
                "location_type": job_input_location_location_type,
                "namespace": job_input_location_namespace,
                "object_names": job_input_location_object_names,
                "prefix": job_input_location_prefix,
            },
            model_metadata_details=[{
                "configuration": [{
                    "configurationMap": job_model_metadata_details_configuration_configuration_map,
                }],
                "endpoint_id": test_endpoint["id"],
                "language_code": job_model_metadata_details_language_code,
                "model_id": test_model["id"],
                "model_type": job_model_metadata_details_model_type,
            }],
            output_location={
                "bucket": job_output_location_bucket,
                "namespace": job_output_location_namespace,
                "prefix": job_output_location_prefix,
            },
            description=job_description,
            display_name=job_display_name,
            input_configuration={
                "configuration": [{
                    "config": job_input_configuration_configuration_config,
                }],
                "document_types": job_input_configuration_document_types,
            })
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiLanguage/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the job.
        :param pulumi.Input[Union['JobInputConfigurationArgs', 'JobInputConfigurationArgsDict']] input_configuration: input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        :param pulumi.Input[Union['JobInputLocationArgs', 'JobInputLocationArgsDict']] input_location: document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobModelMetadataDetailArgs', 'JobModelMetadataDetailArgsDict']]]] model_metadata_details: training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        :param pulumi.Input[Union['JobOutputLocationArgs', 'JobOutputLocationArgsDict']] output_location: Object storage output location to write inference results
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Ai Language service.

        Creates a new language service async job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.ailanguage.Job("test_job",
            compartment_id=compartment_id,
            input_location={
                "bucket": job_input_location_bucket,
                "location_type": job_input_location_location_type,
                "namespace": job_input_location_namespace,
                "object_names": job_input_location_object_names,
                "prefix": job_input_location_prefix,
            },
            model_metadata_details=[{
                "configuration": [{
                    "configurationMap": job_model_metadata_details_configuration_configuration_map,
                }],
                "endpoint_id": test_endpoint["id"],
                "language_code": job_model_metadata_details_language_code,
                "model_id": test_model["id"],
                "model_type": job_model_metadata_details_model_type,
            }],
            output_location={
                "bucket": job_output_location_bucket,
                "namespace": job_output_location_namespace,
                "prefix": job_output_location_prefix,
            },
            description=job_description,
            display_name=job_display_name,
            input_configuration={
                "configuration": [{
                    "config": job_input_configuration_configuration_config,
                }],
                "document_types": job_input_configuration_document_types,
            })
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiLanguage/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_configuration: Optional[pulumi.Input[Union['JobInputConfigurationArgs', 'JobInputConfigurationArgsDict']]] = None,
                 input_location: Optional[pulumi.Input[Union['JobInputLocationArgs', 'JobInputLocationArgsDict']]] = None,
                 model_metadata_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobModelMetadataDetailArgs', 'JobModelMetadataDetailArgsDict']]]]] = None,
                 output_location: Optional[pulumi.Input[Union['JobOutputLocationArgs', 'JobOutputLocationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["input_configuration"] = input_configuration
            if input_location is None and not opts.urn:
                raise TypeError("Missing required property 'input_location'")
            __props__.__dict__["input_location"] = input_location
            if model_metadata_details is None and not opts.urn:
                raise TypeError("Missing required property 'model_metadata_details'")
            __props__.__dict__["model_metadata_details"] = model_metadata_details
            if output_location is None and not opts.urn:
                raise TypeError("Missing required property 'output_location'")
            __props__.__dict__["output_location"] = output_location
            __props__.__dict__["completed_documents"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["failed_documents"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["pending_documents"] = None
            __props__.__dict__["percent_complete"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_completed"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["total_documents"] = None
            __props__.__dict__["ttl_in_days"] = None
            __props__.__dict__["warnings_count"] = None
        super(Job, __self__).__init__(
            'oci:AiLanguage/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            completed_documents: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            failed_documents: Optional[pulumi.Input[_builtins.int]] = None,
            input_configuration: Optional[pulumi.Input[Union['JobInputConfigurationArgs', 'JobInputConfigurationArgsDict']]] = None,
            input_location: Optional[pulumi.Input[Union['JobInputLocationArgs', 'JobInputLocationArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            model_metadata_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobModelMetadataDetailArgs', 'JobModelMetadataDetailArgsDict']]]]] = None,
            output_location: Optional[pulumi.Input[Union['JobOutputLocationArgs', 'JobOutputLocationArgsDict']]] = None,
            pending_documents: Optional[pulumi.Input[_builtins.int]] = None,
            percent_complete: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
            time_completed: Optional[pulumi.Input[_builtins.str]] = None,
            time_started: Optional[pulumi.Input[_builtins.str]] = None,
            total_documents: Optional[pulumi.Input[_builtins.int]] = None,
            ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            warnings_count: Optional[pulumi.Input[_builtins.int]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[_builtins.int] completed_documents: Number of documents processed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job.
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the job.
        :param pulumi.Input[_builtins.int] failed_documents: Number of documents failed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[Union['JobInputConfigurationArgs', 'JobInputConfigurationArgsDict']] input_configuration: input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        :param pulumi.Input[Union['JobInputLocationArgs', 'JobInputLocationArgsDict']] input_location: document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobModelMetadataDetailArgs', 'JobModelMetadataDetailArgsDict']]]] model_metadata_details: training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        :param pulumi.Input[Union['JobOutputLocationArgs', 'JobOutputLocationArgsDict']] output_location: Object storage output location to write inference results
        :param pulumi.Input[_builtins.int] pending_documents: Number of documents still to process. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.int] percent_complete: How much progress the operation has made, vs the total amount of work that must be performed.
        :param pulumi.Input[_builtins.str] state: The current state of the Job.
        :param pulumi.Input[_builtins.str] time_accepted: Job accepted time.
        :param pulumi.Input[_builtins.str] time_completed: Job finished time.
        :param pulumi.Input[_builtins.str] time_started: Job started time.
        :param pulumi.Input[_builtins.int] total_documents: Total number of documents given as input for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        :param pulumi.Input[_builtins.int] ttl_in_days: Time to live duration in days for Job. Job will be available till max 90 days.
        :param pulumi.Input[_builtins.int] warnings_count: warnings count
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["completed_documents"] = completed_documents
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["failed_documents"] = failed_documents
        __props__.__dict__["input_configuration"] = input_configuration
        __props__.__dict__["input_location"] = input_location
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["model_metadata_details"] = model_metadata_details
        __props__.__dict__["output_location"] = output_location
        __props__.__dict__["pending_documents"] = pending_documents
        __props__.__dict__["percent_complete"] = percent_complete
        __props__.__dict__["state"] = state
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_completed"] = time_completed
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["total_documents"] = total_documents
        __props__.__dict__["ttl_in_days"] = ttl_in_days
        __props__.__dict__["warnings_count"] = warnings_count
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="completedDocuments")
    def completed_documents(self) -> pulumi.Output[_builtins.int]:
        """
        Number of documents processed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "completed_documents")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the job.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="failedDocuments")
    def failed_documents(self) -> pulumi.Output[_builtins.int]:
        """
        Number of documents failed for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "failed_documents")

    @_builtins.property
    @pulumi.getter(name="inputConfiguration")
    def input_configuration(self) -> pulumi.Output['outputs.JobInputConfiguration']:
        """
        input documents configuration by default TXT files will be processed and this behaviour will not change in future after adding new types
        """
        return pulumi.get(self, "input_configuration")

    @_builtins.property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Output['outputs.JobInputLocation']:
        """
        document location and other meta data about documents For TXT only ObjectStoragePrefixLocation supported For CSV only ObjectStorageFileNameLocation is supported For this release only one file is supported for ObjectStorageFileNameLocation i.e CSV file type
        """
        return pulumi.get(self, "input_location")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="modelMetadataDetails")
    def model_metadata_details(self) -> pulumi.Output[Sequence['outputs.JobModelMetadataDetail']]:
        """
        training model details For this release only one model is allowed to be input here. One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API
        """
        return pulumi.get(self, "model_metadata_details")

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output['outputs.JobOutputLocation']:
        """
        Object storage output location to write inference results
        """
        return pulumi.get(self, "output_location")

    @_builtins.property
    @pulumi.getter(name="pendingDocuments")
    def pending_documents(self) -> pulumi.Output[_builtins.int]:
        """
        Number of documents still to process. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "pending_documents")

    @_builtins.property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> pulumi.Output[_builtins.int]:
        """
        How much progress the operation has made, vs the total amount of work that must be performed.
        """
        return pulumi.get(self, "percent_complete")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Job.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[_builtins.str]:
        """
        Job accepted time.
        """
        return pulumi.get(self, "time_accepted")

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> pulumi.Output[_builtins.str]:
        """
        Job finished time.
        """
        return pulumi.get(self, "time_completed")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[_builtins.str]:
        """
        Job started time.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="totalDocuments")
    def total_documents(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of documents given as input for prediction. For CSV this signifies number of rows and for TXT this signifies number of files.
        """
        return pulumi.get(self, "total_documents")

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Time to live duration in days for Job. Job will be available till max 90 days.
        """
        return pulumi.get(self, "ttl_in_days")

    @_builtins.property
    @pulumi.getter(name="warningsCount")
    def warnings_count(self) -> pulumi.Output[_builtins.int]:
        """
        warnings count
        """
        return pulumi.get(self, "warnings_count")

