# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamJobArgs', 'StreamJob']

@pulumi.input_type
class StreamJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 features: pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]],
                 stream_output_location: pulumi.Input['StreamJobStreamOutputLocationArgs'],
                 stream_source_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamJob resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        :param pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]] features: (Updatable) a list of stream analysis features.
        :param pulumi.Input['StreamJobStreamOutputLocationArgs'] stream_output_location: (Updatable) Details about a where results will be Sent
        :param pulumi.Input[_builtins.str] stream_source_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Stream job display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "stream_output_location", stream_output_location)
        pulumi.set(__self__, "stream_source_id", stream_source_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]]:
        """
        (Updatable) a list of stream analysis features.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="streamOutputLocation")
    def stream_output_location(self) -> pulumi.Input['StreamJobStreamOutputLocationArgs']:
        """
        (Updatable) Details about a where results will be Sent
        """
        return pulumi.get(self, "stream_output_location")

    @stream_output_location.setter
    def stream_output_location(self, value: pulumi.Input['StreamJobStreamOutputLocationArgs']):
        pulumi.set(self, "stream_output_location", value)

    @_builtins.property
    @pulumi.getter(name="streamSourceId")
    def stream_source_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        """
        return pulumi.get(self, "stream_source_id")

    @stream_source_id.setter
    def stream_source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_source_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Stream job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _StreamJobState:
    def __init__(__self__, *,
                 agent_participant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_output_location: Optional[pulumi.Input['StreamJobStreamOutputLocationArgs']] = None,
                 stream_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamJob resources.
        :param pulumi.Input[_builtins.str] agent_participant_id: participant id of agent where results need to be sent
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Stream job display name.
        :param pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]] features: (Updatable) a list of stream analysis features.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional details about current state of streamJob
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['StreamJobStreamOutputLocationArgs'] stream_output_location: (Updatable) Details about a where results will be Sent
        :param pulumi.Input[_builtins.str] stream_source_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[_builtins.str] time_created: When the streamJob was created, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.str] time_updated: When the stream job was updated, as an RFC3339 datetime string.
        """
        if agent_participant_id is not None:
            pulumi.set(__self__, "agent_participant_id", agent_participant_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_output_location is not None:
            pulumi.set(__self__, "stream_output_location", stream_output_location)
        if stream_source_id is not None:
            pulumi.set(__self__, "stream_source_id", stream_source_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentParticipantId")
    def agent_participant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        participant id of agent where results need to be sent
        """
        return pulumi.get(self, "agent_participant_id")

    @agent_participant_id.setter
    def agent_participant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_participant_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Stream job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]]]:
        """
        (Updatable) a list of stream analysis features.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamJobFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional details about current state of streamJob
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="streamOutputLocation")
    def stream_output_location(self) -> Optional[pulumi.Input['StreamJobStreamOutputLocationArgs']]:
        """
        (Updatable) Details about a where results will be Sent
        """
        return pulumi.get(self, "stream_output_location")

    @stream_output_location.setter
    def stream_output_location(self, value: Optional[pulumi.Input['StreamJobStreamOutputLocationArgs']]):
        pulumi.set(self, "stream_output_location", value)

    @_builtins.property
    @pulumi.getter(name="streamSourceId")
    def stream_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        """
        return pulumi.get(self, "stream_source_id")

    @stream_source_id.setter
    def stream_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_source_id", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the streamJob was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the stream job was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:AiVision/streamJob:StreamJob")
class StreamJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamJobFeatureArgs', 'StreamJobFeatureArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_output_location: Optional[pulumi.Input[Union['StreamJobStreamOutputLocationArgs', 'StreamJobStreamOutputLocationArgsDict']]] = None,
                 stream_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_job = oci.aivision.StreamJob("test_stream_job",
            compartment_id=compartment_id,
            features=[{
                "feature_type": stream_job_features_feature_type,
                "max_results": stream_job_features_max_results,
                "should_return_landmarks": stream_job_features_should_return_landmarks,
                "tracking_types": [{
                    "biometric_store_compartment_id": test_compartment["id"],
                    "biometric_store_id": test_biometric_store["id"],
                    "detection_model_id": test_model["id"],
                    "max_results": stream_job_features_tracking_types_max_results,
                    "objects": stream_job_features_tracking_types_objects,
                    "should_return_landmarks": stream_job_features_tracking_types_should_return_landmarks,
                    "tracking_model_id": test_model["id"],
                }],
            }],
            stream_output_location={
                "bucket": stream_job_stream_output_location_bucket,
                "namespace": stream_job_stream_output_location_namespace,
                "output_location_type": stream_job_stream_output_location_output_location_type,
                "prefix": stream_job_stream_output_location_prefix,
                "obo_token": stream_job_stream_output_location_obo_token,
            },
            stream_source_id=test_stream_source["id"],
            defined_tags=stream_job_defined_tags,
            display_name=stream_job_display_name,
            freeform_tags=stream_job_freeform_tags)
        ```

        ## Import

        StreamJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiVision/streamJob:StreamJob test_stream_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Stream job display name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamJobFeatureArgs', 'StreamJobFeatureArgsDict']]]] features: (Updatable) a list of stream analysis features.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['StreamJobStreamOutputLocationArgs', 'StreamJobStreamOutputLocationArgsDict']] stream_output_location: (Updatable) Details about a where results will be Sent
        :param pulumi.Input[_builtins.str] stream_source_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_job = oci.aivision.StreamJob("test_stream_job",
            compartment_id=compartment_id,
            features=[{
                "feature_type": stream_job_features_feature_type,
                "max_results": stream_job_features_max_results,
                "should_return_landmarks": stream_job_features_should_return_landmarks,
                "tracking_types": [{
                    "biometric_store_compartment_id": test_compartment["id"],
                    "biometric_store_id": test_biometric_store["id"],
                    "detection_model_id": test_model["id"],
                    "max_results": stream_job_features_tracking_types_max_results,
                    "objects": stream_job_features_tracking_types_objects,
                    "should_return_landmarks": stream_job_features_tracking_types_should_return_landmarks,
                    "tracking_model_id": test_model["id"],
                }],
            }],
            stream_output_location={
                "bucket": stream_job_stream_output_location_bucket,
                "namespace": stream_job_stream_output_location_namespace,
                "output_location_type": stream_job_stream_output_location_output_location_type,
                "prefix": stream_job_stream_output_location_prefix,
                "obo_token": stream_job_stream_output_location_obo_token,
            },
            stream_source_id=test_stream_source["id"],
            defined_tags=stream_job_defined_tags,
            display_name=stream_job_display_name,
            freeform_tags=stream_job_freeform_tags)
        ```

        ## Import

        StreamJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiVision/streamJob:StreamJob test_stream_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param StreamJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamJobFeatureArgs', 'StreamJobFeatureArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_output_location: Optional[pulumi.Input[Union['StreamJobStreamOutputLocationArgs', 'StreamJobStreamOutputLocationArgsDict']]] = None,
                 stream_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamJobArgs.__new__(StreamJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if features is None and not opts.urn:
                raise TypeError("Missing required property 'features'")
            __props__.__dict__["features"] = features
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["state"] = state
            if stream_output_location is None and not opts.urn:
                raise TypeError("Missing required property 'stream_output_location'")
            __props__.__dict__["stream_output_location"] = stream_output_location
            if stream_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_source_id'")
            __props__.__dict__["stream_source_id"] = stream_source_id
            __props__.__dict__["agent_participant_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(StreamJob, __self__).__init__(
            'oci:AiVision/streamJob:StreamJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_participant_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamJobFeatureArgs', 'StreamJobFeatureArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            stream_output_location: Optional[pulumi.Input[Union['StreamJobStreamOutputLocationArgs', 'StreamJobStreamOutputLocationArgsDict']]] = None,
            stream_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamJob':
        """
        Get an existing StreamJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_participant_id: participant id of agent where results need to be sent
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Stream job display name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamJobFeatureArgs', 'StreamJobFeatureArgsDict']]]] features: (Updatable) a list of stream analysis features.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional details about current state of streamJob
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['StreamJobStreamOutputLocationArgs', 'StreamJobStreamOutputLocationArgsDict']] stream_output_location: (Updatable) Details about a where results will be Sent
        :param pulumi.Input[_builtins.str] stream_source_id: (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[_builtins.str] time_created: When the streamJob was created, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.str] time_updated: When the stream job was updated, as an RFC3339 datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamJobState.__new__(_StreamJobState)

        __props__.__dict__["agent_participant_id"] = agent_participant_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["features"] = features
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_output_location"] = stream_output_location
        __props__.__dict__["stream_source_id"] = stream_source_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return StreamJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentParticipantId")
    def agent_participant_id(self) -> pulumi.Output[_builtins.str]:
        """
        participant id of agent where results need to be sent
        """
        return pulumi.get(self, "agent_participant_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Stream job display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Output[Sequence['outputs.StreamJobFeature']]:
        """
        (Updatable) a list of stream analysis features.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional details about current state of streamJob
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The target state for the Stream Job. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamOutputLocation")
    def stream_output_location(self) -> pulumi.Output['outputs.StreamJobStreamOutputLocation']:
        """
        (Updatable) Details about a where results will be Sent
        """
        return pulumi.get(self, "stream_output_location")

    @_builtins.property
    @pulumi.getter(name="streamSourceId")
    def stream_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of streamSource.
        """
        return pulumi.get(self, "stream_source_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        When the streamJob was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        When the stream job was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

