# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledQueryArgs', 'ScheduledQuery']

@pulumi.input_type
class ScheduledQueryArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_description: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_maximum_runtime_in_seconds: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_configuration: Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']] = None,
                 scheduled_query_processing_sub_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_period_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_text: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScheduledQuery resource.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID for the intended request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] scheduled_query_description: (Updatable) Description for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_maximum_runtime_in_seconds: (Updatable) Maximum runtime for the scheduled query in seconds.
        :param pulumi.Input[_builtins.str] scheduled_query_name: (Updatable) Name of the scheduled query.
        :param pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs'] scheduled_query_processing_configuration: (Updatable) Definition of the scheduled query processing configuration.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_sub_type: (Updatable) Processing sub type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_type: (Updatable) Type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_criteria: (Updatable) Retention criteria for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_period_in_ms: (Updatable) Retention period for the scheduled query in milliseconds.
        :param pulumi.Input[_builtins.str] scheduled_query_schedule: (Updatable) Schedule for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_text: (Updatable) Scheduled query to be run. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if scheduled_query_description is not None:
            pulumi.set(__self__, "scheduled_query_description", scheduled_query_description)
        if scheduled_query_maximum_runtime_in_seconds is not None:
            pulumi.set(__self__, "scheduled_query_maximum_runtime_in_seconds", scheduled_query_maximum_runtime_in_seconds)
        if scheduled_query_name is not None:
            pulumi.set(__self__, "scheduled_query_name", scheduled_query_name)
        if scheduled_query_processing_configuration is not None:
            pulumi.set(__self__, "scheduled_query_processing_configuration", scheduled_query_processing_configuration)
        if scheduled_query_processing_sub_type is not None:
            pulumi.set(__self__, "scheduled_query_processing_sub_type", scheduled_query_processing_sub_type)
        if scheduled_query_processing_type is not None:
            pulumi.set(__self__, "scheduled_query_processing_type", scheduled_query_processing_type)
        if scheduled_query_retention_criteria is not None:
            pulumi.set(__self__, "scheduled_query_retention_criteria", scheduled_query_retention_criteria)
        if scheduled_query_retention_period_in_ms is not None:
            pulumi.set(__self__, "scheduled_query_retention_period_in_ms", scheduled_query_retention_period_in_ms)
        if scheduled_query_schedule is not None:
            pulumi.set(__self__, "scheduled_query_schedule", scheduled_query_schedule)
        if scheduled_query_text is not None:
            pulumi.set(__self__, "scheduled_query_text", scheduled_query_text)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The APM Domain ID for the intended request.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "apm_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opc_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryDescription")
    def scheduled_query_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_description")

    @scheduled_query_description.setter
    def scheduled_query_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_description", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryMaximumRuntimeInSeconds")
    def scheduled_query_maximum_runtime_in_seconds(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Maximum runtime for the scheduled query in seconds.
        """
        return pulumi.get(self, "scheduled_query_maximum_runtime_in_seconds")

    @scheduled_query_maximum_runtime_in_seconds.setter
    def scheduled_query_maximum_runtime_in_seconds(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_maximum_runtime_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_name")

    @scheduled_query_name.setter
    def scheduled_query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_name", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingConfiguration")
    def scheduled_query_processing_configuration(self) -> Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']]:
        """
        (Updatable) Definition of the scheduled query processing configuration.
        """
        return pulumi.get(self, "scheduled_query_processing_configuration")

    @scheduled_query_processing_configuration.setter
    def scheduled_query_processing_configuration(self, value: Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']]):
        pulumi.set(self, "scheduled_query_processing_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingSubType")
    def scheduled_query_processing_sub_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Processing sub type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_sub_type")

    @scheduled_query_processing_sub_type.setter
    def scheduled_query_processing_sub_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_processing_sub_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingType")
    def scheduled_query_processing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_type")

    @scheduled_query_processing_type.setter
    def scheduled_query_processing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_processing_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionCriteria")
    def scheduled_query_retention_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retention criteria for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_retention_criteria")

    @scheduled_query_retention_criteria.setter
    def scheduled_query_retention_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_retention_criteria", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionPeriodInMs")
    def scheduled_query_retention_period_in_ms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retention period for the scheduled query in milliseconds.
        """
        return pulumi.get(self, "scheduled_query_retention_period_in_ms")

    @scheduled_query_retention_period_in_ms.setter
    def scheduled_query_retention_period_in_ms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_retention_period_in_ms", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQuerySchedule")
    def scheduled_query_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Schedule for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_schedule")

    @scheduled_query_schedule.setter
    def scheduled_query_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_schedule", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryText")
    def scheduled_query_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Scheduled query to be run. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduled_query_text")

    @scheduled_query_text.setter
    def scheduled_query_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_text", value)


@pulumi.input_type
class _ScheduledQueryState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_description: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_instances: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_maximum_runtime_in_seconds: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_next_run_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_configuration: Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']] = None,
                 scheduled_query_processing_sub_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_period_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScheduledQuery resources.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID for the intended request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] scheduled_query_description: (Updatable) Description for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_instances: Scheduled query instances.
        :param pulumi.Input[_builtins.str] scheduled_query_maximum_runtime_in_seconds: (Updatable) Maximum runtime for the scheduled query in seconds.
        :param pulumi.Input[_builtins.str] scheduled_query_name: (Updatable) Name of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_next_run_in_ms: Next run for the scheduled query.
        :param pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs'] scheduled_query_processing_configuration: (Updatable) Definition of the scheduled query processing configuration.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_sub_type: (Updatable) Processing sub type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_type: (Updatable) Type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_criteria: (Updatable) Retention criteria for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_period_in_ms: (Updatable) Retention period for the scheduled query in milliseconds.
        :param pulumi.Input[_builtins.str] scheduled_query_schedule: (Updatable) Schedule for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_text: (Updatable) Scheduled query to be run. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the Scheduled Query.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if scheduled_query_description is not None:
            pulumi.set(__self__, "scheduled_query_description", scheduled_query_description)
        if scheduled_query_instances is not None:
            pulumi.set(__self__, "scheduled_query_instances", scheduled_query_instances)
        if scheduled_query_maximum_runtime_in_seconds is not None:
            pulumi.set(__self__, "scheduled_query_maximum_runtime_in_seconds", scheduled_query_maximum_runtime_in_seconds)
        if scheduled_query_name is not None:
            pulumi.set(__self__, "scheduled_query_name", scheduled_query_name)
        if scheduled_query_next_run_in_ms is not None:
            pulumi.set(__self__, "scheduled_query_next_run_in_ms", scheduled_query_next_run_in_ms)
        if scheduled_query_processing_configuration is not None:
            pulumi.set(__self__, "scheduled_query_processing_configuration", scheduled_query_processing_configuration)
        if scheduled_query_processing_sub_type is not None:
            pulumi.set(__self__, "scheduled_query_processing_sub_type", scheduled_query_processing_sub_type)
        if scheduled_query_processing_type is not None:
            pulumi.set(__self__, "scheduled_query_processing_type", scheduled_query_processing_type)
        if scheduled_query_retention_criteria is not None:
            pulumi.set(__self__, "scheduled_query_retention_criteria", scheduled_query_retention_criteria)
        if scheduled_query_retention_period_in_ms is not None:
            pulumi.set(__self__, "scheduled_query_retention_period_in_ms", scheduled_query_retention_period_in_ms)
        if scheduled_query_schedule is not None:
            pulumi.set(__self__, "scheduled_query_schedule", scheduled_query_schedule)
        if scheduled_query_text is not None:
            pulumi.set(__self__, "scheduled_query_text", scheduled_query_text)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The APM Domain ID for the intended request.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apm_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opc_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryDescription")
    def scheduled_query_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_description")

    @scheduled_query_description.setter
    def scheduled_query_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_description", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryInstances")
    def scheduled_query_instances(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduled query instances.
        """
        return pulumi.get(self, "scheduled_query_instances")

    @scheduled_query_instances.setter
    def scheduled_query_instances(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_instances", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryMaximumRuntimeInSeconds")
    def scheduled_query_maximum_runtime_in_seconds(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Maximum runtime for the scheduled query in seconds.
        """
        return pulumi.get(self, "scheduled_query_maximum_runtime_in_seconds")

    @scheduled_query_maximum_runtime_in_seconds.setter
    def scheduled_query_maximum_runtime_in_seconds(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_maximum_runtime_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_name")

    @scheduled_query_name.setter
    def scheduled_query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_name", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryNextRunInMs")
    def scheduled_query_next_run_in_ms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Next run for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_next_run_in_ms")

    @scheduled_query_next_run_in_ms.setter
    def scheduled_query_next_run_in_ms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_next_run_in_ms", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingConfiguration")
    def scheduled_query_processing_configuration(self) -> Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']]:
        """
        (Updatable) Definition of the scheduled query processing configuration.
        """
        return pulumi.get(self, "scheduled_query_processing_configuration")

    @scheduled_query_processing_configuration.setter
    def scheduled_query_processing_configuration(self, value: Optional[pulumi.Input['ScheduledQueryScheduledQueryProcessingConfigurationArgs']]):
        pulumi.set(self, "scheduled_query_processing_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingSubType")
    def scheduled_query_processing_sub_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Processing sub type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_sub_type")

    @scheduled_query_processing_sub_type.setter
    def scheduled_query_processing_sub_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_processing_sub_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingType")
    def scheduled_query_processing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_type")

    @scheduled_query_processing_type.setter
    def scheduled_query_processing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_processing_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionCriteria")
    def scheduled_query_retention_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retention criteria for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_retention_criteria")

    @scheduled_query_retention_criteria.setter
    def scheduled_query_retention_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_retention_criteria", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionPeriodInMs")
    def scheduled_query_retention_period_in_ms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retention period for the scheduled query in milliseconds.
        """
        return pulumi.get(self, "scheduled_query_retention_period_in_ms")

    @scheduled_query_retention_period_in_ms.setter
    def scheduled_query_retention_period_in_ms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_retention_period_in_ms", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQuerySchedule")
    def scheduled_query_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Schedule for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_schedule")

    @scheduled_query_schedule.setter
    def scheduled_query_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_schedule", value)

    @_builtins.property
    @pulumi.getter(name="scheduledQueryText")
    def scheduled_query_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Scheduled query to be run. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduled_query_text")

    @scheduled_query_text.setter
    def scheduled_query_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_query_text", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the Scheduled Query.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.type_token("oci:ApmTraces/scheduledQuery:ScheduledQuery")
class ScheduledQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_description: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_maximum_runtime_in_seconds: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduledQueryProcessingConfigurationArgs', 'ScheduledQueryScheduledQueryProcessingConfigurationArgsDict']]] = None,
                 scheduled_query_processing_sub_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_period_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ScheduledQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmTraces/scheduledQuery:ScheduledQuery test_scheduled_query "scheduledQueries/{scheduledQueryId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID for the intended request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] scheduled_query_description: (Updatable) Description for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_maximum_runtime_in_seconds: (Updatable) Maximum runtime for the scheduled query in seconds.
        :param pulumi.Input[_builtins.str] scheduled_query_name: (Updatable) Name of the scheduled query.
        :param pulumi.Input[Union['ScheduledQueryScheduledQueryProcessingConfigurationArgs', 'ScheduledQueryScheduledQueryProcessingConfigurationArgsDict']] scheduled_query_processing_configuration: (Updatable) Definition of the scheduled query processing configuration.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_sub_type: (Updatable) Processing sub type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_type: (Updatable) Type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_criteria: (Updatable) Retention criteria for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_period_in_ms: (Updatable) Retention period for the scheduled query in milliseconds.
        :param pulumi.Input[_builtins.str] scheduled_query_schedule: (Updatable) Schedule for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_text: (Updatable) Scheduled query to be run. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ScheduledQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmTraces/scheduledQuery:ScheduledQuery test_scheduled_query "scheduledQueries/{scheduledQueryId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_description: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_maximum_runtime_in_seconds: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduledQueryProcessingConfigurationArgs', 'ScheduledQueryScheduledQueryProcessingConfigurationArgsDict']]] = None,
                 scheduled_query_processing_sub_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_processing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_retention_period_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["opc_dry_run"] = opc_dry_run
            __props__.__dict__["scheduled_query_description"] = scheduled_query_description
            __props__.__dict__["scheduled_query_maximum_runtime_in_seconds"] = scheduled_query_maximum_runtime_in_seconds
            __props__.__dict__["scheduled_query_name"] = scheduled_query_name
            __props__.__dict__["scheduled_query_processing_configuration"] = scheduled_query_processing_configuration
            __props__.__dict__["scheduled_query_processing_sub_type"] = scheduled_query_processing_sub_type
            __props__.__dict__["scheduled_query_processing_type"] = scheduled_query_processing_type
            __props__.__dict__["scheduled_query_retention_criteria"] = scheduled_query_retention_criteria
            __props__.__dict__["scheduled_query_retention_period_in_ms"] = scheduled_query_retention_period_in_ms
            __props__.__dict__["scheduled_query_schedule"] = scheduled_query_schedule
            __props__.__dict__["scheduled_query_text"] = scheduled_query_text
            __props__.__dict__["scheduled_query_instances"] = None
            __props__.__dict__["scheduled_query_next_run_in_ms"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
        super(ScheduledQuery, __self__).__init__(
            'oci:ApmTraces/scheduledQuery:ScheduledQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_description: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_instances: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_maximum_runtime_in_seconds: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_name: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_next_run_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_processing_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduledQueryProcessingConfigurationArgs', 'ScheduledQueryScheduledQueryProcessingConfigurationArgsDict']]] = None,
            scheduled_query_processing_sub_type: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_processing_type: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_retention_criteria: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_retention_period_in_ms: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_query_text: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ScheduledQuery':
        """
        Get an existing ScheduledQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID for the intended request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] scheduled_query_description: (Updatable) Description for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_instances: Scheduled query instances.
        :param pulumi.Input[_builtins.str] scheduled_query_maximum_runtime_in_seconds: (Updatable) Maximum runtime for the scheduled query in seconds.
        :param pulumi.Input[_builtins.str] scheduled_query_name: (Updatable) Name of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_next_run_in_ms: Next run for the scheduled query.
        :param pulumi.Input[Union['ScheduledQueryScheduledQueryProcessingConfigurationArgs', 'ScheduledQueryScheduledQueryProcessingConfigurationArgsDict']] scheduled_query_processing_configuration: (Updatable) Definition of the scheduled query processing configuration.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_sub_type: (Updatable) Processing sub type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_processing_type: (Updatable) Type of the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_criteria: (Updatable) Retention criteria for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_retention_period_in_ms: (Updatable) Retention period for the scheduled query in milliseconds.
        :param pulumi.Input[_builtins.str] scheduled_query_schedule: (Updatable) Schedule for the scheduled query.
        :param pulumi.Input[_builtins.str] scheduled_query_text: (Updatable) Scheduled query to be run. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the Scheduled Query.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledQueryState.__new__(_ScheduledQueryState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["opc_dry_run"] = opc_dry_run
        __props__.__dict__["scheduled_query_description"] = scheduled_query_description
        __props__.__dict__["scheduled_query_instances"] = scheduled_query_instances
        __props__.__dict__["scheduled_query_maximum_runtime_in_seconds"] = scheduled_query_maximum_runtime_in_seconds
        __props__.__dict__["scheduled_query_name"] = scheduled_query_name
        __props__.__dict__["scheduled_query_next_run_in_ms"] = scheduled_query_next_run_in_ms
        __props__.__dict__["scheduled_query_processing_configuration"] = scheduled_query_processing_configuration
        __props__.__dict__["scheduled_query_processing_sub_type"] = scheduled_query_processing_sub_type
        __props__.__dict__["scheduled_query_processing_type"] = scheduled_query_processing_type
        __props__.__dict__["scheduled_query_retention_criteria"] = scheduled_query_retention_criteria
        __props__.__dict__["scheduled_query_retention_period_in_ms"] = scheduled_query_retention_period_in_ms
        __props__.__dict__["scheduled_query_schedule"] = scheduled_query_schedule
        __props__.__dict__["scheduled_query_text"] = scheduled_query_text
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        return ScheduledQuery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The APM Domain ID for the intended request.
        """
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not create or modify the resource  and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryDescription")
    def scheduled_query_description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_description")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryInstances")
    def scheduled_query_instances(self) -> pulumi.Output[_builtins.str]:
        """
        Scheduled query instances.
        """
        return pulumi.get(self, "scheduled_query_instances")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryMaximumRuntimeInSeconds")
    def scheduled_query_maximum_runtime_in_seconds(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Maximum runtime for the scheduled query in seconds.
        """
        return pulumi.get(self, "scheduled_query_maximum_runtime_in_seconds")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Name of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_name")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryNextRunInMs")
    def scheduled_query_next_run_in_ms(self) -> pulumi.Output[_builtins.str]:
        """
        Next run for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_next_run_in_ms")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingConfiguration")
    def scheduled_query_processing_configuration(self) -> pulumi.Output['outputs.ScheduledQueryScheduledQueryProcessingConfiguration']:
        """
        (Updatable) Definition of the scheduled query processing configuration.
        """
        return pulumi.get(self, "scheduled_query_processing_configuration")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingSubType")
    def scheduled_query_processing_sub_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Processing sub type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_sub_type")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingType")
    def scheduled_query_processing_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_type")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionCriteria")
    def scheduled_query_retention_criteria(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Retention criteria for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_retention_criteria")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionPeriodInMs")
    def scheduled_query_retention_period_in_ms(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Retention period for the scheduled query in milliseconds.
        """
        return pulumi.get(self, "scheduled_query_retention_period_in_ms")

    @_builtins.property
    @pulumi.getter(name="scheduledQuerySchedule")
    def scheduled_query_schedule(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Schedule for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_schedule")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryText")
    def scheduled_query_text(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Scheduled query to be run. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduled_query_text")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the Scheduled Query.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

