# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SessionArgs', 'Session']

@pulumi.input_type
class SessionArgs:
    def __init__(__self__, *,
                 bastion_id: pulumi.Input[_builtins.str],
                 key_details: pulumi.Input['SessionKeyDetailsArgs'],
                 target_resource_details: pulumi.Input['SessionTargetResourceDetailsArgs'],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Session resource.
        :param pulumi.Input[_builtins.str] bastion_id: The unique identifier (OCID) of the bastion on which to create this session.
        :param pulumi.Input['SessionKeyDetailsArgs'] key_details: Public key details for a bastion session.
        :param pulumi.Input['SessionTargetResourceDetailsArgs'] target_resource_details: Details about a bastion session's target resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the session.
        :param pulumi.Input[_builtins.str] key_type: The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        :param pulumi.Input[_builtins.int] session_ttl_in_seconds: The amount of time the session can remain active.
        """
        pulumi.set(__self__, "bastion_id", bastion_id)
        pulumi.set(__self__, "key_details", key_details)
        pulumi.set(__self__, "target_resource_details", target_resource_details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if session_ttl_in_seconds is not None:
            pulumi.set(__self__, "session_ttl_in_seconds", session_ttl_in_seconds)

    @_builtins.property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier (OCID) of the bastion on which to create this session.
        """
        return pulumi.get(self, "bastion_id")

    @bastion_id.setter
    def bastion_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bastion_id", value)

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> pulumi.Input['SessionKeyDetailsArgs']:
        """
        Public key details for a bastion session.
        """
        return pulumi.get(self, "key_details")

    @key_details.setter
    def key_details(self, value: pulumi.Input['SessionKeyDetailsArgs']):
        pulumi.set(self, "key_details", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceDetails")
    def target_resource_details(self) -> pulumi.Input['SessionTargetResourceDetailsArgs']:
        """
        Details about a bastion session's target resource.
        """
        return pulumi.get(self, "target_resource_details")

    @target_resource_details.setter
    def target_resource_details(self, value: pulumi.Input['SessionTargetResourceDetailsArgs']):
        pulumi.set(self, "target_resource_details", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the session.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="sessionTtlInSeconds")
    def session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the session can remain active.
        """
        return pulumi.get(self, "session_ttl_in_seconds")

    @session_ttl_in_seconds.setter
    def session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_ttl_in_seconds", value)


@pulumi.input_type
class _SessionState:
    def __init__(__self__, *,
                 bastion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bastion_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bastion_public_host_key_info: Optional[pulumi.Input[_builtins.str]] = None,
                 bastion_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_details: Optional[pulumi.Input['SessionKeyDetailsArgs']] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 ssh_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_details: Optional[pulumi.Input['SessionTargetResourceDetailsArgs']] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Session resources.
        :param pulumi.Input[_builtins.str] bastion_id: The unique identifier (OCID) of the bastion on which to create this session.
        :param pulumi.Input[_builtins.str] bastion_name: The name of the bastion that is hosting this session.
        :param pulumi.Input[_builtins.str] bastion_public_host_key_info: The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        :param pulumi.Input[_builtins.str] bastion_user_name: The username that the session uses to connect to the target resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the session.
        :param pulumi.Input['SessionKeyDetailsArgs'] key_details: Public key details for a bastion session.
        :param pulumi.Input[_builtins.str] key_type: The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current session state in more detail.
        :param pulumi.Input[_builtins.int] session_ttl_in_seconds: The amount of time the session can remain active.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ssh_metadata: The connection message for the session.
        :param pulumi.Input[_builtins.str] state: The current state of the session.
        :param pulumi.Input['SessionTargetResourceDetailsArgs'] target_resource_details: Details about a bastion session's target resource.
        :param pulumi.Input[_builtins.str] time_created: The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        if bastion_id is not None:
            pulumi.set(__self__, "bastion_id", bastion_id)
        if bastion_name is not None:
            pulumi.set(__self__, "bastion_name", bastion_name)
        if bastion_public_host_key_info is not None:
            pulumi.set(__self__, "bastion_public_host_key_info", bastion_public_host_key_info)
        if bastion_user_name is not None:
            pulumi.set(__self__, "bastion_user_name", bastion_user_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if key_details is not None:
            pulumi.set(__self__, "key_details", key_details)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if session_ttl_in_seconds is not None:
            pulumi.set(__self__, "session_ttl_in_seconds", session_ttl_in_seconds)
        if ssh_metadata is not None:
            pulumi.set(__self__, "ssh_metadata", ssh_metadata)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_resource_details is not None:
            pulumi.set(__self__, "target_resource_details", target_resource_details)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier (OCID) of the bastion on which to create this session.
        """
        return pulumi.get(self, "bastion_id")

    @bastion_id.setter
    def bastion_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bastion_id", value)

    @_builtins.property
    @pulumi.getter(name="bastionName")
    def bastion_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_name")

    @bastion_name.setter
    def bastion_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bastion_name", value)

    @_builtins.property
    @pulumi.getter(name="bastionPublicHostKeyInfo")
    def bastion_public_host_key_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        """
        return pulumi.get(self, "bastion_public_host_key_info")

    @bastion_public_host_key_info.setter
    def bastion_public_host_key_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bastion_public_host_key_info", value)

    @_builtins.property
    @pulumi.getter(name="bastionUserName")
    def bastion_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username that the session uses to connect to the target resource.
        """
        return pulumi.get(self, "bastion_user_name")

    @bastion_user_name.setter
    def bastion_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bastion_user_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the session.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[pulumi.Input['SessionKeyDetailsArgs']]:
        """
        Public key details for a bastion session.
        """
        return pulumi.get(self, "key_details")

    @key_details.setter
    def key_details(self, value: Optional[pulumi.Input['SessionKeyDetailsArgs']]):
        pulumi.set(self, "key_details", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current session state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="sessionTtlInSeconds")
    def session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the session can remain active.
        """
        return pulumi.get(self, "session_ttl_in_seconds")

    @session_ttl_in_seconds.setter
    def session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_ttl_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="sshMetadata")
    def ssh_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The connection message for the session.
        """
        return pulumi.get(self, "ssh_metadata")

    @ssh_metadata.setter
    def ssh_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_metadata", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the session.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceDetails")
    def target_resource_details(self) -> Optional[pulumi.Input['SessionTargetResourceDetailsArgs']]:
        """
        Details about a bastion session's target resource.
        """
        return pulumi.get(self, "target_resource_details")

    @target_resource_details.setter
    def target_resource_details(self, value: Optional[pulumi.Input['SessionTargetResourceDetailsArgs']]):
        pulumi.set(self, "target_resource_details", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Bastion/session:Session")
class Session(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bastion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_details: Optional[pulumi.Input[Union['SessionKeyDetailsArgs', 'SessionKeyDetailsArgsDict']]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_resource_details: Optional[pulumi.Input[Union['SessionTargetResourceDetailsArgs', 'SessionTargetResourceDetailsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_session = oci.bastion.Session("test_session",
            bastion_id=test_bastion["id"],
            key_details={
                "public_key_content": session_key_details_public_key_content,
            },
            target_resource_details={
                "session_type": session_target_resource_details_session_type,
                "target_resource_fqdn": session_target_resource_details_target_resource_fqdn,
                "target_resource_id": test_target_resource["id"],
                "target_resource_operating_system_user_name": test_user["name"],
                "target_resource_port": session_target_resource_details_target_resource_port,
                "target_resource_private_ip_address": session_target_resource_details_target_resource_private_ip_address,
            },
            display_name=session_display_name,
            key_type=session_key_type,
            session_ttl_in_seconds=session_session_ttl_in_seconds)
        ```

        ## Import

        Sessions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Bastion/session:Session test_session "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bastion_id: The unique identifier (OCID) of the bastion on which to create this session.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the session.
        :param pulumi.Input[Union['SessionKeyDetailsArgs', 'SessionKeyDetailsArgsDict']] key_details: Public key details for a bastion session.
        :param pulumi.Input[_builtins.str] key_type: The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        :param pulumi.Input[_builtins.int] session_ttl_in_seconds: The amount of time the session can remain active.
        :param pulumi.Input[Union['SessionTargetResourceDetailsArgs', 'SessionTargetResourceDetailsArgsDict']] target_resource_details: Details about a bastion session's target resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SessionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_session = oci.bastion.Session("test_session",
            bastion_id=test_bastion["id"],
            key_details={
                "public_key_content": session_key_details_public_key_content,
            },
            target_resource_details={
                "session_type": session_target_resource_details_session_type,
                "target_resource_fqdn": session_target_resource_details_target_resource_fqdn,
                "target_resource_id": test_target_resource["id"],
                "target_resource_operating_system_user_name": test_user["name"],
                "target_resource_port": session_target_resource_details_target_resource_port,
                "target_resource_private_ip_address": session_target_resource_details_target_resource_private_ip_address,
            },
            display_name=session_display_name,
            key_type=session_key_type,
            session_ttl_in_seconds=session_session_ttl_in_seconds)
        ```

        ## Import

        Sessions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Bastion/session:Session test_session "id"
        ```

        :param str resource_name: The name of the resource.
        :param SessionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SessionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bastion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_details: Optional[pulumi.Input[Union['SessionKeyDetailsArgs', 'SessionKeyDetailsArgsDict']]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_resource_details: Optional[pulumi.Input[Union['SessionTargetResourceDetailsArgs', 'SessionTargetResourceDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SessionArgs.__new__(SessionArgs)

            if bastion_id is None and not opts.urn:
                raise TypeError("Missing required property 'bastion_id'")
            __props__.__dict__["bastion_id"] = bastion_id
            __props__.__dict__["display_name"] = display_name
            if key_details is None and not opts.urn:
                raise TypeError("Missing required property 'key_details'")
            __props__.__dict__["key_details"] = key_details
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["session_ttl_in_seconds"] = session_ttl_in_seconds
            if target_resource_details is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_details'")
            __props__.__dict__["target_resource_details"] = target_resource_details
            __props__.__dict__["bastion_name"] = None
            __props__.__dict__["bastion_public_host_key_info"] = None
            __props__.__dict__["bastion_user_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ssh_metadata"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Session, __self__).__init__(
            'oci:Bastion/session:Session',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bastion_id: Optional[pulumi.Input[_builtins.str]] = None,
            bastion_name: Optional[pulumi.Input[_builtins.str]] = None,
            bastion_public_host_key_info: Optional[pulumi.Input[_builtins.str]] = None,
            bastion_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_details: Optional[pulumi.Input[Union['SessionKeyDetailsArgs', 'SessionKeyDetailsArgsDict']]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            ssh_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_details: Optional[pulumi.Input[Union['SessionTargetResourceDetailsArgs', 'SessionTargetResourceDetailsArgsDict']]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'Session':
        """
        Get an existing Session resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bastion_id: The unique identifier (OCID) of the bastion on which to create this session.
        :param pulumi.Input[_builtins.str] bastion_name: The name of the bastion that is hosting this session.
        :param pulumi.Input[_builtins.str] bastion_public_host_key_info: The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        :param pulumi.Input[_builtins.str] bastion_user_name: The username that the session uses to connect to the target resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the session.
        :param pulumi.Input[Union['SessionKeyDetailsArgs', 'SessionKeyDetailsArgsDict']] key_details: Public key details for a bastion session.
        :param pulumi.Input[_builtins.str] key_type: The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current session state in more detail.
        :param pulumi.Input[_builtins.int] session_ttl_in_seconds: The amount of time the session can remain active.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ssh_metadata: The connection message for the session.
        :param pulumi.Input[_builtins.str] state: The current state of the session.
        :param pulumi.Input[Union['SessionTargetResourceDetailsArgs', 'SessionTargetResourceDetailsArgsDict']] target_resource_details: Details about a bastion session's target resource.
        :param pulumi.Input[_builtins.str] time_created: The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SessionState.__new__(_SessionState)

        __props__.__dict__["bastion_id"] = bastion_id
        __props__.__dict__["bastion_name"] = bastion_name
        __props__.__dict__["bastion_public_host_key_info"] = bastion_public_host_key_info
        __props__.__dict__["bastion_user_name"] = bastion_user_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["key_details"] = key_details
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["session_ttl_in_seconds"] = session_ttl_in_seconds
        __props__.__dict__["ssh_metadata"] = ssh_metadata
        __props__.__dict__["state"] = state
        __props__.__dict__["target_resource_details"] = target_resource_details
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Session(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier (OCID) of the bastion on which to create this session.
        """
        return pulumi.get(self, "bastion_id")

    @_builtins.property
    @pulumi.getter(name="bastionName")
    def bastion_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_name")

    @_builtins.property
    @pulumi.getter(name="bastionPublicHostKeyInfo")
    def bastion_public_host_key_info(self) -> pulumi.Output[_builtins.str]:
        """
        The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        """
        return pulumi.get(self, "bastion_public_host_key_info")

    @_builtins.property
    @pulumi.getter(name="bastionUserName")
    def bastion_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The username that the session uses to connect to the target resource.
        """
        return pulumi.get(self, "bastion_user_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the session.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> pulumi.Output['outputs.SessionKeyDetails']:
        """
        Public key details for a bastion session.
        """
        return pulumi.get(self, "key_details")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current session state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="sessionTtlInSeconds")
    def session_ttl_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of time the session can remain active.
        """
        return pulumi.get(self, "session_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="sshMetadata")
    def ssh_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The connection message for the session.
        """
        return pulumi.get(self, "ssh_metadata")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the session.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetResourceDetails")
    def target_resource_details(self) -> pulumi.Output['outputs.SessionTargetResourceDetails']:
        """
        Details about a bastion session's target resource.
        """
        return pulumi.get(self, "target_resource_details")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

