# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsCapacityReportArgs', 'BdsCapacityReport']

@pulumi.input_type
class BdsCapacityReportArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 shape_availabilities: pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]):
        """
        The set of arguments for constructing a BdsCapacityReport resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]] shape_availabilities: Information about the shapes in the capacity report.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "shape_availabilities", shape_availabilities)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @shape_availabilities.setter
    def shape_availabilities(self, value: pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]):
        pulumi.set(self, "shape_availabilities", value)


@pulumi.input_type
class _BdsCapacityReportState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsCapacityReport resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]] shape_availabilities: Information about the shapes in the capacity report.
        :param pulumi.Input[_builtins.str] time_created: The time the report was created, shown as an RFC 3339 formatted datetime string.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if shape_availabilities is not None:
            pulumi.set(__self__, "shape_availabilities", shape_availabilities)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @shape_availabilities.setter
    def shape_availabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsCapacityReportShapeAvailabilityArgs']]]]):
        pulumi.set(self, "shape_availabilities", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the report was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:BigDataService/bdsCapacityReport:BdsCapacityReport")
class BdsCapacityReport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsCapacityReportShapeAvailabilityArgs', 'BdsCapacityReportShapeAvailabilityArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_capacity_report = oci.bigdataservice.BdsCapacityReport("test_bds_capacity_report",
            compartment_id=compartment_id,
            shape_availabilities=[{
                "shape": bds_capacity_report_shape_availabilities_shape,
                "shape_config": {
                    "memory_in_gbs": bds_capacity_report_shape_availabilities_shape_config_memory_in_gbs,
                    "nvmes": bds_capacity_report_shape_availabilities_shape_config_nvmes,
                    "ocpus": bds_capacity_report_shape_availabilities_shape_config_ocpus,
                },
            }])
        ```

        ## Import

        BdsCapacityReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsCapacityReport:BdsCapacityReport test_bds_capacity_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsCapacityReportShapeAvailabilityArgs', 'BdsCapacityReportShapeAvailabilityArgsDict']]]] shape_availabilities: Information about the shapes in the capacity report.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsCapacityReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_capacity_report = oci.bigdataservice.BdsCapacityReport("test_bds_capacity_report",
            compartment_id=compartment_id,
            shape_availabilities=[{
                "shape": bds_capacity_report_shape_availabilities_shape,
                "shape_config": {
                    "memory_in_gbs": bds_capacity_report_shape_availabilities_shape_config_memory_in_gbs,
                    "nvmes": bds_capacity_report_shape_availabilities_shape_config_nvmes,
                    "ocpus": bds_capacity_report_shape_availabilities_shape_config_ocpus,
                },
            }])
        ```

        ## Import

        BdsCapacityReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsCapacityReport:BdsCapacityReport test_bds_capacity_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param BdsCapacityReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsCapacityReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsCapacityReportShapeAvailabilityArgs', 'BdsCapacityReportShapeAvailabilityArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsCapacityReportArgs.__new__(BdsCapacityReportArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if shape_availabilities is None and not opts.urn:
                raise TypeError("Missing required property 'shape_availabilities'")
            __props__.__dict__["shape_availabilities"] = shape_availabilities
            __props__.__dict__["time_created"] = None
        super(BdsCapacityReport, __self__).__init__(
            'oci:BigDataService/bdsCapacityReport:BdsCapacityReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsCapacityReportShapeAvailabilityArgs', 'BdsCapacityReportShapeAvailabilityArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'BdsCapacityReport':
        """
        Get an existing BdsCapacityReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsCapacityReportShapeAvailabilityArgs', 'BdsCapacityReportShapeAvailabilityArgsDict']]]] shape_availabilities: Information about the shapes in the capacity report.
        :param pulumi.Input[_builtins.str] time_created: The time the report was created, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsCapacityReportState.__new__(_BdsCapacityReportState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["shape_availabilities"] = shape_availabilities
        __props__.__dict__["time_created"] = time_created
        return BdsCapacityReport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> pulumi.Output[Sequence['outputs.BdsCapacityReportShapeAvailability']]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the report was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

