# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceNodeBackupConfigurationArgs', 'BdsInstanceNodeBackupConfiguration']

@pulumi.input_type
class BdsInstanceNodeBackupConfigurationArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[_builtins.str],
                 level_type_details: pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs'],
                 schedule: pulumi.Input[_builtins.str],
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_backups_to_retain: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BdsInstanceNodeBackupConfiguration resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs'] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        :param pulumi.Input[_builtins.str] backup_type: (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[_builtins.int] number_of_backups_to_retain: (Updatable) Number of backup copies to retain.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The time zone of the execution schedule, in IANA time zone database name format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "level_type_details", level_type_details)
        pulumi.set(__self__, "schedule", schedule)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if number_of_backups_to_retain is not None:
            pulumi.set(__self__, "number_of_backups_to_retain", number_of_backups_to_retain)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs']:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs']):
        pulumi.set(self, "level_type_details", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfBackupsToRetain")
    def number_of_backups_to_retain(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of backup copies to retain.
        """
        return pulumi.get(self, "number_of_backups_to_retain")

    @number_of_backups_to_retain.setter
    def number_of_backups_to_retain(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_backups_to_retain", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The time zone of the execution schedule, in IANA time zone database name format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _BdsInstanceNodeBackupConfigurationState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs']] = None,
                 number_of_backups_to_retain: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceNodeBackupConfiguration resources.
        :param pulumi.Input[_builtins.str] backup_type: (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs'] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.int] number_of_backups_to_retain: (Updatable) Number of backup copies to retain.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        :param pulumi.Input[_builtins.str] state: The state of the NodeBackupConfiguration.
        :param pulumi.Input[_builtins.str] time_created: The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The time zone of the execution schedule, in IANA time zone database name format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if level_type_details is not None:
            pulumi.set(__self__, "level_type_details", level_type_details)
        if number_of_backups_to_retain is not None:
            pulumi.set(__self__, "number_of_backups_to_retain", number_of_backups_to_retain)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> Optional[pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs']]:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: Optional[pulumi.Input['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs']]):
        pulumi.set(self, "level_type_details", value)

    @_builtins.property
    @pulumi.getter(name="numberOfBackupsToRetain")
    def number_of_backups_to_retain(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of backup copies to retain.
        """
        return pulumi.get(self, "number_of_backups_to_retain")

    @number_of_backups_to_retain.setter
    def number_of_backups_to_retain(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_backups_to_retain", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the NodeBackupConfiguration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The time zone of the execution schedule, in IANA time zone database name format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceNodeBackupConfiguration:BdsInstanceNodeBackupConfiguration")
class BdsInstanceNodeBackupConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgsDict']]] = None,
                 number_of_backups_to_retain: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_backup_configuration = oci.bigdataservice.BdsInstanceNodeBackupConfiguration("test_bds_instance_node_backup_configuration",
            bds_instance_id=test_bds_instance["id"],
            level_type_details={
                "level_type": bds_instance_node_backup_configuration_level_type_details_level_type,
                "node_host_name": bds_instance_node_backup_configuration_level_type_details_node_host_name,
                "node_type": bds_instance_node_backup_configuration_level_type_details_node_type,
            },
            schedule=bds_instance_node_backup_configuration_schedule,
            backup_type=bds_instance_node_backup_configuration_backup_type,
            display_name=bds_instance_node_backup_configuration_display_name,
            number_of_backups_to_retain=bds_instance_node_backup_configuration_number_of_backups_to_retain,
            timezone=bds_instance_node_backup_configuration_timezone)
        ```

        ## Import

        BdsInstanceNodeBackupConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeBackupConfiguration:BdsInstanceNodeBackupConfiguration test_bds_instance_node_backup_configuration "bdsInstances/{bdsInstanceId}/nodeBackupConfigurations/{nodeBackupConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[Union['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgsDict']] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.int] number_of_backups_to_retain: (Updatable) Number of backup copies to retain.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The time zone of the execution schedule, in IANA time zone database name format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceNodeBackupConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_backup_configuration = oci.bigdataservice.BdsInstanceNodeBackupConfiguration("test_bds_instance_node_backup_configuration",
            bds_instance_id=test_bds_instance["id"],
            level_type_details={
                "level_type": bds_instance_node_backup_configuration_level_type_details_level_type,
                "node_host_name": bds_instance_node_backup_configuration_level_type_details_node_host_name,
                "node_type": bds_instance_node_backup_configuration_level_type_details_node_type,
            },
            schedule=bds_instance_node_backup_configuration_schedule,
            backup_type=bds_instance_node_backup_configuration_backup_type,
            display_name=bds_instance_node_backup_configuration_display_name,
            number_of_backups_to_retain=bds_instance_node_backup_configuration_number_of_backups_to_retain,
            timezone=bds_instance_node_backup_configuration_timezone)
        ```

        ## Import

        BdsInstanceNodeBackupConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeBackupConfiguration:BdsInstanceNodeBackupConfiguration test_bds_instance_node_backup_configuration "bdsInstances/{bdsInstanceId}/nodeBackupConfigurations/{nodeBackupConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceNodeBackupConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceNodeBackupConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgsDict']]] = None,
                 number_of_backups_to_retain: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceNodeBackupConfigurationArgs.__new__(BdsInstanceNodeBackupConfigurationArgs)

            __props__.__dict__["backup_type"] = backup_type
            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            __props__.__dict__["display_name"] = display_name
            if level_type_details is None and not opts.urn:
                raise TypeError("Missing required property 'level_type_details'")
            __props__.__dict__["level_type_details"] = level_type_details
            __props__.__dict__["number_of_backups_to_retain"] = number_of_backups_to_retain
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(BdsInstanceNodeBackupConfiguration, __self__).__init__(
            'oci:BigDataService/bdsInstanceNodeBackupConfiguration:BdsInstanceNodeBackupConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgsDict']]] = None,
            number_of_backups_to_retain: Optional[pulumi.Input[_builtins.int]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None) -> 'BdsInstanceNodeBackupConfiguration':
        """
        Get an existing BdsInstanceNodeBackupConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[Union['BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeBackupConfigurationLevelTypeDetailsArgsDict']] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.int] number_of_backups_to_retain: (Updatable) Number of backup copies to retain.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        :param pulumi.Input[_builtins.str] state: The state of the NodeBackupConfiguration.
        :param pulumi.Input[_builtins.str] time_created: The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The time zone of the execution schedule, in IANA time zone database name format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceNodeBackupConfigurationState.__new__(_BdsInstanceNodeBackupConfigurationState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["level_type_details"] = level_type_details
        __props__.__dict__["number_of_backups_to_retain"] = number_of_backups_to_retain
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timezone"] = timezone
        return BdsInstanceNodeBackupConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Output['outputs.BdsInstanceNodeBackupConfigurationLevelTypeDetails']:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @_builtins.property
    @pulumi.getter(name="numberOfBackupsToRetain")
    def number_of_backups_to_retain(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number of backup copies to retain.
        """
        return pulumi.get(self, "number_of_backups_to_retain")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the NodeBackupConfiguration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The time zone of the execution schedule, in IANA time zone database name format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

