# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceNodeReplaceConfigurationArgs', 'BdsInstanceNodeReplaceConfiguration']

@pulumi.input_type
class BdsInstanceNodeReplaceConfigurationArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[_builtins.str],
                 cluster_admin_password: pulumi.Input[_builtins.str],
                 duration_in_minutes: pulumi.Input[_builtins.int],
                 level_type_details: pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs'],
                 metric_type: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BdsInstanceNodeReplaceConfiguration resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[_builtins.int] duration_in_minutes: (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        :param pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs'] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.str] metric_type: (Updatable) Type of compute instance health metric to use for node replacement
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        pulumi.set(__self__, "level_type_details", level_type_details)
        pulumi.set(__self__, "metric_type", metric_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        """
        return pulumi.get(self, "duration_in_minutes")

    @duration_in_minutes.setter
    def duration_in_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "duration_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs']:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs']):
        pulumi.set(self, "level_type_details", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Type of compute instance health metric to use for node replacement
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _BdsInstanceNodeReplaceConfigurationState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 duration_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 level_type_details: Optional[pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs']] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceNodeReplaceConfiguration resources.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[_builtins.int] duration_in_minutes: (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        :param pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs'] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.str] metric_type: (Updatable) Type of compute instance health metric to use for node replacement
        :param pulumi.Input[_builtins.str] state: The state of the NodeReplaceConfiguration.
        :param pulumi.Input[_builtins.str] time_created: The time the NodeReplaceConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the NodeReplaceConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if duration_in_minutes is not None:
            pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if level_type_details is not None:
            pulumi.set(__self__, "level_type_details", level_type_details)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        """
        return pulumi.get(self, "duration_in_minutes")

    @duration_in_minutes.setter
    def duration_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> Optional[pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs']]:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: Optional[pulumi.Input['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs']]):
        pulumi.set(self, "level_type_details", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of compute instance health metric to use for node replacement
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the NodeReplaceConfiguration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the NodeReplaceConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the NodeReplaceConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceNodeReplaceConfiguration:BdsInstanceNodeReplaceConfiguration")
class BdsInstanceNodeReplaceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 duration_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgsDict']]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_replace_configuration = oci.bigdataservice.BdsInstanceNodeReplaceConfiguration("test_bds_instance_node_replace_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_node_replace_configuration_cluster_admin_password,
            duration_in_minutes=bds_instance_node_replace_configuration_duration_in_minutes,
            level_type_details={
                "level_type": bds_instance_node_replace_configuration_level_type_details_level_type,
                "node_host_name": bds_instance_node_replace_configuration_level_type_details_node_host_name,
                "node_type": bds_instance_node_replace_configuration_level_type_details_node_type,
            },
            metric_type=bds_instance_node_replace_configuration_metric_type,
            display_name=bds_instance_node_replace_configuration_display_name)
        ```

        ## Import

        BdsInstanceNodeReplaceConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeReplaceConfiguration:BdsInstanceNodeReplaceConfiguration test_bds_instance_node_replace_configuration "bdsInstances/{bdsInstanceId}/nodeReplaceConfigurations/{nodeReplaceConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[_builtins.int] duration_in_minutes: (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        :param pulumi.Input[Union['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgsDict']] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.str] metric_type: (Updatable) Type of compute instance health metric to use for node replacement
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceNodeReplaceConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_replace_configuration = oci.bigdataservice.BdsInstanceNodeReplaceConfiguration("test_bds_instance_node_replace_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_node_replace_configuration_cluster_admin_password,
            duration_in_minutes=bds_instance_node_replace_configuration_duration_in_minutes,
            level_type_details={
                "level_type": bds_instance_node_replace_configuration_level_type_details_level_type,
                "node_host_name": bds_instance_node_replace_configuration_level_type_details_node_host_name,
                "node_type": bds_instance_node_replace_configuration_level_type_details_node_type,
            },
            metric_type=bds_instance_node_replace_configuration_metric_type,
            display_name=bds_instance_node_replace_configuration_display_name)
        ```

        ## Import

        BdsInstanceNodeReplaceConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeReplaceConfiguration:BdsInstanceNodeReplaceConfiguration test_bds_instance_node_replace_configuration "bdsInstances/{bdsInstanceId}/nodeReplaceConfigurations/{nodeReplaceConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceNodeReplaceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceNodeReplaceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 duration_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgsDict']]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceNodeReplaceConfigurationArgs.__new__(BdsInstanceNodeReplaceConfigurationArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["display_name"] = display_name
            if duration_in_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'duration_in_minutes'")
            __props__.__dict__["duration_in_minutes"] = duration_in_minutes
            if level_type_details is None and not opts.urn:
                raise TypeError("Missing required property 'level_type_details'")
            __props__.__dict__["level_type_details"] = level_type_details
            if metric_type is None and not opts.urn:
                raise TypeError("Missing required property 'metric_type'")
            __props__.__dict__["metric_type"] = metric_type
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceNodeReplaceConfiguration, __self__).__init__(
            'oci:BigDataService/bdsInstanceNodeReplaceConfiguration:BdsInstanceNodeReplaceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            duration_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgsDict']]] = None,
            metric_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'BdsInstanceNodeReplaceConfiguration':
        """
        Get an existing BdsInstanceNodeReplaceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[_builtins.int] duration_in_minutes: (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        :param pulumi.Input[Union['BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgs', 'BdsInstanceNodeReplaceConfigurationLevelTypeDetailsArgsDict']] level_type_details: (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        :param pulumi.Input[_builtins.str] metric_type: (Updatable) Type of compute instance health metric to use for node replacement
        :param pulumi.Input[_builtins.str] state: The state of the NodeReplaceConfiguration.
        :param pulumi.Input[_builtins.str] time_created: The time the NodeReplaceConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the NodeReplaceConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceNodeReplaceConfigurationState.__new__(_BdsInstanceNodeReplaceConfigurationState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["duration_in_minutes"] = duration_in_minutes
        __props__.__dict__["level_type_details"] = level_type_details
        __props__.__dict__["metric_type"] = metric_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return BdsInstanceNodeReplaceConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) This value is the minimum period of time to wait before triggering node replacement. The value is in minutes.
        """
        return pulumi.get(self, "duration_in_minutes")

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Output['outputs.BdsInstanceNodeReplaceConfigurationLevelTypeDetails']:
        """
        (Updatable) Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Type of compute instance health metric to use for node replacement
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the NodeReplaceConfiguration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the NodeReplaceConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the NodeReplaceConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

