# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceOsPatchActionArgs', 'BdsInstanceOsPatchAction']

@pulumi.input_type
class BdsInstanceOsPatchActionArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[_builtins.str],
                 cluster_admin_password: pulumi.Input[_builtins.str],
                 os_patch_version: pulumi.Input[_builtins.str],
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 patching_configs: Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']] = None):
        """
        The set of arguments for constructing a BdsInstanceOsPatchAction resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
               * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        :param pulumi.Input[_builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs'] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "os_patch_version", os_patch_version)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if patching_configs is not None:
            pulumi.set(__self__, "patching_configs", patching_configs)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_patch_version", value)

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

    @patching_configs.setter
    def patching_configs(self, value: Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']]):
        pulumi.set(self, "patching_configs", value)


@pulumi.input_type
class _BdsInstanceOsPatchActionState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_patch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']] = None):
        """
        Input properties used for looking up and filtering BdsInstanceOsPatchAction resources.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
               * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        :param pulumi.Input[_builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs'] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if os_patch_version is not None:
            pulumi.set(__self__, "os_patch_version", os_patch_version)
        if patching_configs is not None:
            pulumi.set(__self__, "patching_configs", patching_configs)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_patch_version", value)

    @_builtins.property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

    @patching_configs.setter
    def patching_configs(self, value: Optional[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigsArgs']]):
        pulumi.set(self, "patching_configs", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceOsPatchAction:BdsInstanceOsPatchAction")
class BdsInstanceOsPatchAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_patch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigsArgs', 'BdsInstanceOsPatchActionPatchingConfigsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_os_patch_action = oci.bigdataservice.BdsInstanceOsPatchAction("test_bds_instance_os_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_os_patch_action_cluster_admin_password,
            os_patch_version=bds_instance_os_patch_action_os_patch_version,
            is_dry_run=is_dry_run,
            patching_configs={
                "patching_config_strategy": bds_instance_os_patch_action_patching_config_strategy,
                "batch_size": bds_instance_os_patch_action_batch_size,
                "wait_time_between_batch_in_seconds": bds_instance_os_patch_action_wait_time_between_batch_in_seconds,
                "tolerance_threshold_per_batch": bds_instance_os_patch_action_tolerance_threshold_per_batch,
                "wait_time_between_domain_in_seconds": bds_instance_os_patch_action_wait_time_between_domain_in_seconds,
                "tolerance_threshold_per_domain": bds_instance_os_patch_action_tolerance_threshold_per_domain,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
               * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        :param pulumi.Input[_builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigsArgs', 'BdsInstanceOsPatchActionPatchingConfigsArgsDict']] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceOsPatchActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_os_patch_action = oci.bigdataservice.BdsInstanceOsPatchAction("test_bds_instance_os_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_os_patch_action_cluster_admin_password,
            os_patch_version=bds_instance_os_patch_action_os_patch_version,
            is_dry_run=is_dry_run,
            patching_configs={
                "patching_config_strategy": bds_instance_os_patch_action_patching_config_strategy,
                "batch_size": bds_instance_os_patch_action_batch_size,
                "wait_time_between_batch_in_seconds": bds_instance_os_patch_action_wait_time_between_batch_in_seconds,
                "tolerance_threshold_per_batch": bds_instance_os_patch_action_tolerance_threshold_per_batch,
                "wait_time_between_domain_in_seconds": bds_instance_os_patch_action_wait_time_between_domain_in_seconds,
                "tolerance_threshold_per_domain": bds_instance_os_patch_action_tolerance_threshold_per_domain,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BdsInstanceOsPatchActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceOsPatchActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_patch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigsArgs', 'BdsInstanceOsPatchActionPatchingConfigsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceOsPatchActionArgs.__new__(BdsInstanceOsPatchActionArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["is_dry_run"] = is_dry_run
            if os_patch_version is None and not opts.urn:
                raise TypeError("Missing required property 'os_patch_version'")
            __props__.__dict__["os_patch_version"] = os_patch_version
            __props__.__dict__["patching_configs"] = patching_configs
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceOsPatchAction, __self__).__init__(
            'oci:BigDataService/bdsInstanceOsPatchAction:BdsInstanceOsPatchAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            os_patch_version: Optional[pulumi.Input[_builtins.str]] = None,
            patching_configs: Optional[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigsArgs', 'BdsInstanceOsPatchActionPatchingConfigsArgsDict']]] = None) -> 'BdsInstanceOsPatchAction':
        """
        Get an existing BdsInstanceOsPatchAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
               * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        :param pulumi.Input[_builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigsArgs', 'BdsInstanceOsPatchActionPatchingConfigsArgsDict']] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceOsPatchActionState.__new__(_BdsInstanceOsPatchActionState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["is_dry_run"] = is_dry_run
        __props__.__dict__["os_patch_version"] = os_patch_version
        __props__.__dict__["patching_configs"] = patching_configs
        return BdsInstanceOsPatchAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        * `isDryRun` - (Optional) Perform dry run for the patch and stop without actually patching the cluster.
        """
        return pulumi.get(self, "cluster_admin_password")

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "is_dry_run")

    @_builtins.property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @_builtins.property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> pulumi.Output['outputs.BdsInstanceOsPatchActionPatchingConfigs']:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

