# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstancePatchActionArgs', 'BdsInstancePatchAction']

@pulumi.input_type
class BdsInstancePatchActionArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[_builtins.str],
                 cluster_admin_password: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 patching_config: Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']] = None):
        """
        The set of arguments for constructing a BdsInstancePatchAction resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[_builtins.str] version: The version of the patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['BdsInstancePatchActionPatchingConfigArgs'] patching_config: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "version", version)
        if patching_config is not None:
            pulumi.set(__self__, "patching_config", patching_config)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="patchingConfig")
    def patching_config(self) -> Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_config")

    @patching_config.setter
    def patching_config(self, value: Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']]):
        pulumi.set(self, "patching_config", value)


@pulumi.input_type
class _BdsInstancePatchActionState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_config: Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsInstancePatchAction resources.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input['BdsInstancePatchActionPatchingConfigArgs'] patching_config: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        :param pulumi.Input[_builtins.str] version: The version of the patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if patching_config is not None:
            pulumi.set(__self__, "patching_config", patching_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="patchingConfig")
    def patching_config(self) -> Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_config")

    @patching_config.setter
    def patching_config(self, value: Optional[pulumi.Input['BdsInstancePatchActionPatchingConfigArgs']]):
        pulumi.set(self, "patching_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:BigDataService/bdsInstancePatchAction:BdsInstancePatchAction")
class BdsInstancePatchAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_config: Optional[pulumi.Input[Union['BdsInstancePatchActionPatchingConfigArgs', 'BdsInstancePatchActionPatchingConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_patch_action = oci.bigdataservice.BdsInstancePatchAction("test_bds_instance_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_patch_action_cluster_admin_password,
            version=bds_instance_patch_action_version,
            patching_config={
                "patching_config_strategy": bds_instance_patch_action_patching_config_patching_config_strategy,
                "batch_size": bds_instance_patch_action_patching_config_batch_size,
                "tolerance_threshold_per_batch": bds_instance_patch_action_patching_config_tolerance_threshold_per_batch,
                "tolerance_threshold_per_domain": bds_instance_patch_action_patching_config_tolerance_threshold_per_domain,
                "wait_time_between_batch_in_seconds": bds_instance_patch_action_patching_config_wait_time_between_batch_in_seconds,
                "wait_time_between_domain_in_seconds": bds_instance_patch_action_patching_config_wait_time_between_domain_in_seconds,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[Union['BdsInstancePatchActionPatchingConfigArgs', 'BdsInstancePatchActionPatchingConfigArgsDict']] patching_config: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        :param pulumi.Input[_builtins.str] version: The version of the patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstancePatchActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_patch_action = oci.bigdataservice.BdsInstancePatchAction("test_bds_instance_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_patch_action_cluster_admin_password,
            version=bds_instance_patch_action_version,
            patching_config={
                "patching_config_strategy": bds_instance_patch_action_patching_config_patching_config_strategy,
                "batch_size": bds_instance_patch_action_patching_config_batch_size,
                "tolerance_threshold_per_batch": bds_instance_patch_action_patching_config_tolerance_threshold_per_batch,
                "tolerance_threshold_per_domain": bds_instance_patch_action_patching_config_tolerance_threshold_per_domain,
                "wait_time_between_batch_in_seconds": bds_instance_patch_action_patching_config_wait_time_between_batch_in_seconds,
                "wait_time_between_domain_in_seconds": bds_instance_patch_action_patching_config_wait_time_between_domain_in_seconds,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BdsInstancePatchActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstancePatchActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 patching_config: Optional[pulumi.Input[Union['BdsInstancePatchActionPatchingConfigArgs', 'BdsInstancePatchActionPatchingConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstancePatchActionArgs.__new__(BdsInstancePatchActionArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["patching_config"] = patching_config
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstancePatchAction, __self__).__init__(
            'oci:BigDataService/bdsInstancePatchAction:BdsInstancePatchAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            patching_config: Optional[pulumi.Input[Union['BdsInstancePatchActionPatchingConfigArgs', 'BdsInstancePatchActionPatchingConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'BdsInstancePatchAction':
        """
        Get an existing BdsInstancePatchAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[Union['BdsInstancePatchActionPatchingConfigArgs', 'BdsInstancePatchActionPatchingConfigArgsDict']] patching_config: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        :param pulumi.Input[_builtins.str] version: The version of the patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstancePatchActionState.__new__(_BdsInstancePatchActionState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["patching_config"] = patching_config
        __props__.__dict__["version"] = version
        return BdsInstancePatchAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @_builtins.property
    @pulumi.getter(name="patchingConfig")
    def patching_config(self) -> pulumi.Output['outputs.BdsInstancePatchActionPatchingConfig']:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_config")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

