# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_config: pulumi.Input['CertificateCertificateConfigArgs'],
                 compartment_id: pulumi.Input[_builtins.str],
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input['CertificateCertificateConfigArgs'] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "certificate_config", certificate_config)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if certificate_rules is not None:
            pulumi.set(__self__, "certificate_rules", certificate_rules)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> pulumi.Input['CertificateCertificateConfigArgs']:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: pulumi.Input['CertificateCertificateConfigArgs']):
        pulumi.set(self, "certificate_config", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @certificate_rules.setter
    def certificate_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]):
        pulumi.set(self, "certificate_rules", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_config: Optional[pulumi.Input['CertificateCertificateConfigArgs']] = None,
                 certificate_profile_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 current_versions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 issuer_certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subjects: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input['CertificateCertificateConfigArgs'] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[_builtins.str] certificate_profile_type: The name of the profile used to create the certificate, which depends on the type of certificate you need.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]] certificate_revocation_list_details: The details of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[_builtins.str] config_type: The origin of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]] current_versions: The details of the certificate version. This object does not contain the certificate contents.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] issuer_certificate_authority_id: The OCID of the certificate authority (CA) that issued the certificate.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm used to create key pairs.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the certificate.
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] signature_algorithm: The algorithm used to sign the public key certificate.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[_builtins.str] time_created: A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        if certificate_config is not None:
            pulumi.set(__self__, "certificate_config", certificate_config)
        if certificate_profile_type is not None:
            pulumi.set(__self__, "certificate_profile_type", certificate_profile_type)
        if certificate_revocation_list_details is not None:
            pulumi.set(__self__, "certificate_revocation_list_details", certificate_revocation_list_details)
        if certificate_rules is not None:
            pulumi.set(__self__, "certificate_rules", certificate_rules)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if current_versions is not None:
            pulumi.set(__self__, "current_versions", current_versions)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if issuer_certificate_authority_id is not None:
            pulumi.set(__self__, "issuer_certificate_authority_id", issuer_certificate_authority_id)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> Optional[pulumi.Input['CertificateCertificateConfigArgs']]:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: Optional[pulumi.Input['CertificateCertificateConfigArgs']]):
        pulumi.set(self, "certificate_config", value)

    @_builtins.property
    @pulumi.getter(name="certificateProfileType")
    def certificate_profile_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the profile used to create the certificate, which depends on the type of certificate you need.
        """
        return pulumi.get(self, "certificate_profile_type")

    @certificate_profile_type.setter
    def certificate_profile_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_profile_type", value)

    @_builtins.property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]]:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @certificate_revocation_list_details.setter
    def certificate_revocation_list_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]]):
        pulumi.set(self, "certificate_revocation_list_details", value)

    @_builtins.property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @certificate_rules.setter
    def certificate_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]):
        pulumi.set(self, "certificate_rules", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The origin of the certificate.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_type", value)

    @_builtins.property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]]:
        """
        The details of the certificate version. This object does not contain the certificate contents.
        """
        return pulumi.get(self, "current_versions")

    @current_versions.setter
    def current_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]]):
        pulumi.set(self, "current_versions", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the certificate authority (CA) that issued the certificate.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @issuer_certificate_authority_id.setter
    def issuer_certificate_authority_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_certificate_authority_id", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm used to create key pairs.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state of the certificate.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm used to sign the public key certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the certificate.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]]):
        pulumi.set(self, "subjects", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)


@pulumi.type_token("oci:CertificatesManagement/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[Union['CertificateCertificateConfigArgs', 'CertificateCertificateConfigArgsDict']]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRuleArgs', 'CertificateCertificateRuleArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_certificate = oci.certificatesmanagement.Certificate("test_certificate",
            certificate_config={
                "config_type": certificate_certificate_config_config_type,
                "cert_chain_pem": certificate_certificate_config_cert_chain_pem,
                "certificate_pem": certificate_certificate_config_certificate_pem,
                "certificate_profile_type": certificate_certificate_config_certificate_profile_type,
                "csr_pem": certificate_certificate_config_csr_pem,
                "issuer_certificate_authority_id": test_certificate_authority["id"],
                "key_algorithm": certificate_certificate_config_key_algorithm,
                "private_key_pem": certificate_certificate_config_private_key_pem,
                "private_key_pem_passphrase": certificate_certificate_config_private_key_pem_passphrase,
                "signature_algorithm": certificate_certificate_config_signature_algorithm,
                "subject": {
                    "common_name": certificate_certificate_config_subject_common_name,
                    "country": certificate_certificate_config_subject_country,
                    "distinguished_name_qualifier": certificate_certificate_config_subject_distinguished_name_qualifier,
                    "domain_component": certificate_certificate_config_subject_domain_component,
                    "generation_qualifier": certificate_certificate_config_subject_generation_qualifier,
                    "given_name": certificate_certificate_config_subject_given_name,
                    "initials": certificate_certificate_config_subject_initials,
                    "locality_name": certificate_certificate_config_subject_locality_name,
                    "organization": certificate_certificate_config_subject_organization,
                    "organizational_unit": certificate_certificate_config_subject_organizational_unit,
                    "pseudonym": certificate_certificate_config_subject_pseudonym,
                    "serial_number": certificate_certificate_config_subject_serial_number,
                    "state_or_province_name": certificate_certificate_config_subject_state_or_province_name,
                    "street": certificate_certificate_config_subject_street,
                    "surname": certificate_certificate_config_subject_surname,
                    "title": certificate_certificate_config_subject_title,
                    "user_id": test_user["id"],
                },
                "subject_alternative_names": [{
                    "type": certificate_certificate_config_subject_alternative_names_type,
                    "value": certificate_certificate_config_subject_alternative_names_value,
                }],
                "validity": {
                    "time_of_validity_not_after": certificate_certificate_config_validity_time_of_validity_not_after,
                    "time_of_validity_not_before": certificate_certificate_config_validity_time_of_validity_not_before,
                },
                "version_name": certificate_certificate_config_version_name,
            },
            compartment_id=compartment_id,
            name=certificate_name,
            certificate_rules=[{
                "advance_renewal_period": certificate_certificate_rules_advance_renewal_period,
                "renewal_interval": certificate_certificate_rules_renewal_interval,
                "rule_type": certificate_certificate_rules_rule_type,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=certificate_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CertificatesManagement/certificate:Certificate test_certificate "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertificateCertificateConfigArgs', 'CertificateCertificateConfigArgsDict']] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRuleArgs', 'CertificateCertificateRuleArgsDict']]]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_certificate = oci.certificatesmanagement.Certificate("test_certificate",
            certificate_config={
                "config_type": certificate_certificate_config_config_type,
                "cert_chain_pem": certificate_certificate_config_cert_chain_pem,
                "certificate_pem": certificate_certificate_config_certificate_pem,
                "certificate_profile_type": certificate_certificate_config_certificate_profile_type,
                "csr_pem": certificate_certificate_config_csr_pem,
                "issuer_certificate_authority_id": test_certificate_authority["id"],
                "key_algorithm": certificate_certificate_config_key_algorithm,
                "private_key_pem": certificate_certificate_config_private_key_pem,
                "private_key_pem_passphrase": certificate_certificate_config_private_key_pem_passphrase,
                "signature_algorithm": certificate_certificate_config_signature_algorithm,
                "subject": {
                    "common_name": certificate_certificate_config_subject_common_name,
                    "country": certificate_certificate_config_subject_country,
                    "distinguished_name_qualifier": certificate_certificate_config_subject_distinguished_name_qualifier,
                    "domain_component": certificate_certificate_config_subject_domain_component,
                    "generation_qualifier": certificate_certificate_config_subject_generation_qualifier,
                    "given_name": certificate_certificate_config_subject_given_name,
                    "initials": certificate_certificate_config_subject_initials,
                    "locality_name": certificate_certificate_config_subject_locality_name,
                    "organization": certificate_certificate_config_subject_organization,
                    "organizational_unit": certificate_certificate_config_subject_organizational_unit,
                    "pseudonym": certificate_certificate_config_subject_pseudonym,
                    "serial_number": certificate_certificate_config_subject_serial_number,
                    "state_or_province_name": certificate_certificate_config_subject_state_or_province_name,
                    "street": certificate_certificate_config_subject_street,
                    "surname": certificate_certificate_config_subject_surname,
                    "title": certificate_certificate_config_subject_title,
                    "user_id": test_user["id"],
                },
                "subject_alternative_names": [{
                    "type": certificate_certificate_config_subject_alternative_names_type,
                    "value": certificate_certificate_config_subject_alternative_names_value,
                }],
                "validity": {
                    "time_of_validity_not_after": certificate_certificate_config_validity_time_of_validity_not_after,
                    "time_of_validity_not_before": certificate_certificate_config_validity_time_of_validity_not_before,
                },
                "version_name": certificate_certificate_config_version_name,
            },
            compartment_id=compartment_id,
            name=certificate_name,
            certificate_rules=[{
                "advance_renewal_period": certificate_certificate_rules_advance_renewal_period,
                "renewal_interval": certificate_certificate_rules_renewal_interval,
                "rule_type": certificate_certificate_rules_rule_type,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=certificate_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CertificatesManagement/certificate:Certificate test_certificate "id"
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[Union['CertificateCertificateConfigArgs', 'CertificateCertificateConfigArgsDict']]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRuleArgs', 'CertificateCertificateRuleArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate_config is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_config'")
            __props__.__dict__["certificate_config"] = certificate_config
            __props__.__dict__["certificate_rules"] = certificate_rules
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            __props__.__dict__["certificate_profile_type"] = None
            __props__.__dict__["certificate_revocation_list_details"] = None
            __props__.__dict__["config_type"] = None
            __props__.__dict__["current_versions"] = None
            __props__.__dict__["issuer_certificate_authority_id"] = None
            __props__.__dict__["key_algorithm"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["signature_algorithm"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subjects"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_deletion"] = None
        super(Certificate, __self__).__init__(
            'oci:CertificatesManagement/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_config: Optional[pulumi.Input[Union['CertificateCertificateConfigArgs', 'CertificateCertificateConfigArgsDict']]] = None,
            certificate_profile_type: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_revocation_list_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRevocationListDetailArgs', 'CertificateCertificateRevocationListDetailArgsDict']]]]] = None,
            certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRuleArgs', 'CertificateCertificateRuleArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_type: Optional[pulumi.Input[_builtins.str]] = None,
            current_versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCurrentVersionArgs', 'CertificateCurrentVersionArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            issuer_certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subjects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateSubjectArgs', 'CertificateSubjectArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertificateCertificateConfigArgs', 'CertificateCertificateConfigArgsDict']] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[_builtins.str] certificate_profile_type: The name of the profile used to create the certificate, which depends on the type of certificate you need.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRevocationListDetailArgs', 'CertificateCertificateRevocationListDetailArgsDict']]]] certificate_revocation_list_details: The details of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateRuleArgs', 'CertificateCertificateRuleArgsDict']]]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[_builtins.str] config_type: The origin of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateCurrentVersionArgs', 'CertificateCurrentVersionArgsDict']]]] current_versions: The details of the certificate version. This object does not contain the certificate contents.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] issuer_certificate_authority_id: The OCID of the certificate authority (CA) that issued the certificate.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm used to create key pairs.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the certificate.
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] signature_algorithm: The algorithm used to sign the public key certificate.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateSubjectArgs', 'CertificateSubjectArgsDict']]]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[_builtins.str] time_created: A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_config"] = certificate_config
        __props__.__dict__["certificate_profile_type"] = certificate_profile_type
        __props__.__dict__["certificate_revocation_list_details"] = certificate_revocation_list_details
        __props__.__dict__["certificate_rules"] = certificate_rules
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["current_versions"] = current_versions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["issuer_certificate_authority_id"] = issuer_certificate_authority_id
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["state"] = state
        __props__.__dict__["subjects"] = subjects
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> pulumi.Output['outputs.CertificateCertificateConfig']:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @_builtins.property
    @pulumi.getter(name="certificateProfileType")
    def certificate_profile_type(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the profile used to create the certificate, which depends on the type of certificate you need.
        """
        return pulumi.get(self, "certificate_profile_type")

    @_builtins.property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> pulumi.Output[Sequence['outputs.CertificateCertificateRevocationListDetail']]:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @_builtins.property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateCertificateRule']]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[_builtins.str]:
        """
        The origin of the certificate.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> pulumi.Output[Sequence['outputs.CertificateCurrentVersion']]:
        """
        The details of the certificate version. This object does not contain the certificate contents.
        """
        return pulumi.get(self, "current_versions")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the certificate authority (CA) that issued the certificate.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The algorithm used to create key pairs.
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state of the certificate.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The algorithm used to sign the public key certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the certificate.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> pulumi.Output[Sequence['outputs.CertificateSubject']]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

