# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssetArgs', 'Asset']

@pulumi.input_type
class AssetArgs:
    def __init__(__self__, *,
                 asset_type: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 external_asset_key: pulumi.Input[_builtins.str],
                 inventory_id: pulumi.Input[_builtins.str],
                 source_key: pulumi.Input[_builtins.str],
                 asset_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compute: Optional[pulumi.Input['AssetComputeArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vm: Optional[pulumi.Input['AssetVmArgs']] = None,
                 vmware_vcenter: Optional[pulumi.Input['AssetVmwareVcenterArgs']] = None,
                 vmware_vm: Optional[pulumi.Input['AssetVmwareVmArgs']] = None):
        """
        The set of arguments for constructing a Asset resource.
        :param pulumi.Input[_builtins.str] asset_type: (Updatable) The type of asset.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that the asset belongs to.
        :param pulumi.Input[_builtins.str] external_asset_key: The key of the asset from the external environment.
        :param pulumi.Input[_builtins.str] inventory_id: Inventory ID to which an asset belongs.
        :param pulumi.Input[_builtins.str] source_key: The source key to which the asset belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] asset_source_ids: (Updatable) List of asset source OCID.
        :param pulumi.Input['AssetComputeArgs'] compute: (Updatable) Compute related properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Asset display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['AssetVmArgs'] vm: (Updatable) Virtual machine related properties.
        :param pulumi.Input['AssetVmwareVcenterArgs'] vmware_vcenter: (Updatable) VMware vCenter related properties.
        :param pulumi.Input['AssetVmwareVmArgs'] vmware_vm: (Updatable) VMware virtual machine related properties.
        """
        pulumi.set(__self__, "asset_type", asset_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "external_asset_key", external_asset_key)
        pulumi.set(__self__, "inventory_id", inventory_id)
        pulumi.set(__self__, "source_key", source_key)
        if asset_source_ids is not None:
            pulumi.set(__self__, "asset_source_ids", asset_source_ids)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if vm is not None:
            pulumi.set(__self__, "vm", vm)
        if vmware_vcenter is not None:
            pulumi.set(__self__, "vmware_vcenter", vmware_vcenter)
        if vmware_vm is not None:
            pulumi.set(__self__, "vmware_vm", vmware_vm)

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of asset.
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "asset_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that the asset belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="externalAssetKey")
    def external_asset_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the asset from the external environment.
        """
        return pulumi.get(self, "external_asset_key")

    @external_asset_key.setter
    def external_asset_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_asset_key", value)

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> pulumi.Input[_builtins.str]:
        """
        Inventory ID to which an asset belongs.
        """
        return pulumi.get(self, "inventory_id")

    @inventory_id.setter
    def inventory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "inventory_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceKey")
    def source_key(self) -> pulumi.Input[_builtins.str]:
        """
        The source key to which the asset belongs.
        """
        return pulumi.get(self, "source_key")

    @source_key.setter
    def source_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_key", value)

    @_builtins.property
    @pulumi.getter(name="assetSourceIds")
    def asset_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of asset source OCID.
        """
        return pulumi.get(self, "asset_source_ids")

    @asset_source_ids.setter
    def asset_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "asset_source_ids", value)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['AssetComputeArgs']]:
        """
        (Updatable) Compute related properties.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['AssetComputeArgs']]):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Asset display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def vm(self) -> Optional[pulumi.Input['AssetVmArgs']]:
        """
        (Updatable) Virtual machine related properties.
        """
        return pulumi.get(self, "vm")

    @vm.setter
    def vm(self, value: Optional[pulumi.Input['AssetVmArgs']]):
        pulumi.set(self, "vm", value)

    @_builtins.property
    @pulumi.getter(name="vmwareVcenter")
    def vmware_vcenter(self) -> Optional[pulumi.Input['AssetVmwareVcenterArgs']]:
        """
        (Updatable) VMware vCenter related properties.
        """
        return pulumi.get(self, "vmware_vcenter")

    @vmware_vcenter.setter
    def vmware_vcenter(self, value: Optional[pulumi.Input['AssetVmwareVcenterArgs']]):
        pulumi.set(self, "vmware_vcenter", value)

    @_builtins.property
    @pulumi.getter(name="vmwareVm")
    def vmware_vm(self) -> Optional[pulumi.Input['AssetVmwareVmArgs']]:
        """
        (Updatable) VMware virtual machine related properties.
        """
        return pulumi.get(self, "vmware_vm")

    @vmware_vm.setter
    def vmware_vm(self, value: Optional[pulumi.Input['AssetVmwareVmArgs']]):
        pulumi.set(self, "vmware_vm", value)


@pulumi.input_type
class _AssetState:
    def __init__(__self__, *,
                 asset_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute: Optional[pulumi.Input['AssetComputeArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inventory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_key: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 vm: Optional[pulumi.Input['AssetVmArgs']] = None,
                 vmware_vcenter: Optional[pulumi.Input['AssetVmwareVcenterArgs']] = None,
                 vmware_vm: Optional[pulumi.Input['AssetVmwareVmArgs']] = None):
        """
        Input properties used for looking up and filtering Asset resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] asset_source_ids: (Updatable) List of asset source OCID.
        :param pulumi.Input[_builtins.str] asset_type: (Updatable) The type of asset.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that the asset belongs to.
        :param pulumi.Input['AssetComputeArgs'] compute: (Updatable) Compute related properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Asset display name.
        :param pulumi.Input[_builtins.str] external_asset_key: The key of the asset from the external environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] inventory_id: Inventory ID to which an asset belongs.
        :param pulumi.Input[_builtins.str] source_key: The source key to which the asset belongs.
        :param pulumi.Input[_builtins.str] state: The current state of the asset.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[_builtins.str] time_created: The time when the asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time when the asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input['AssetVmArgs'] vm: (Updatable) Virtual machine related properties.
        :param pulumi.Input['AssetVmwareVcenterArgs'] vmware_vcenter: (Updatable) VMware vCenter related properties.
        :param pulumi.Input['AssetVmwareVmArgs'] vmware_vm: (Updatable) VMware virtual machine related properties.
        """
        if asset_source_ids is not None:
            pulumi.set(__self__, "asset_source_ids", asset_source_ids)
        if asset_type is not None:
            pulumi.set(__self__, "asset_type", asset_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_asset_key is not None:
            pulumi.set(__self__, "external_asset_key", external_asset_key)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inventory_id is not None:
            pulumi.set(__self__, "inventory_id", inventory_id)
        if source_key is not None:
            pulumi.set(__self__, "source_key", source_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vm is not None:
            pulumi.set(__self__, "vm", vm)
        if vmware_vcenter is not None:
            pulumi.set(__self__, "vmware_vcenter", vmware_vcenter)
        if vmware_vm is not None:
            pulumi.set(__self__, "vmware_vm", vmware_vm)

    @_builtins.property
    @pulumi.getter(name="assetSourceIds")
    def asset_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of asset source OCID.
        """
        return pulumi.get(self, "asset_source_ids")

    @asset_source_ids.setter
    def asset_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "asset_source_ids", value)

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of asset.
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment that the asset belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['AssetComputeArgs']]:
        """
        (Updatable) Compute related properties.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['AssetComputeArgs']]):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Asset display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalAssetKey")
    def external_asset_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the asset from the external environment.
        """
        return pulumi.get(self, "external_asset_key")

    @external_asset_key.setter
    def external_asset_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_asset_key", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Inventory ID to which an asset belongs.
        """
        return pulumi.get(self, "inventory_id")

    @inventory_id.setter
    def inventory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inventory_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceKey")
    def source_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source key to which the asset belongs.
        """
        return pulumi.get(self, "source_key")

    @source_key.setter
    def source_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_key", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def vm(self) -> Optional[pulumi.Input['AssetVmArgs']]:
        """
        (Updatable) Virtual machine related properties.
        """
        return pulumi.get(self, "vm")

    @vm.setter
    def vm(self, value: Optional[pulumi.Input['AssetVmArgs']]):
        pulumi.set(self, "vm", value)

    @_builtins.property
    @pulumi.getter(name="vmwareVcenter")
    def vmware_vcenter(self) -> Optional[pulumi.Input['AssetVmwareVcenterArgs']]:
        """
        (Updatable) VMware vCenter related properties.
        """
        return pulumi.get(self, "vmware_vcenter")

    @vmware_vcenter.setter
    def vmware_vcenter(self, value: Optional[pulumi.Input['AssetVmwareVcenterArgs']]):
        pulumi.set(self, "vmware_vcenter", value)

    @_builtins.property
    @pulumi.getter(name="vmwareVm")
    def vmware_vm(self) -> Optional[pulumi.Input['AssetVmwareVmArgs']]:
        """
        (Updatable) VMware virtual machine related properties.
        """
        return pulumi.get(self, "vmware_vm")

    @vmware_vm.setter
    def vmware_vm(self, value: Optional[pulumi.Input['AssetVmwareVmArgs']]):
        pulumi.set(self, "vmware_vm", value)


@pulumi.type_token("oci:CloudBridge/asset:Asset")
class Asset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute: Optional[pulumi.Input[Union['AssetComputeArgs', 'AssetComputeArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inventory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_key: Optional[pulumi.Input[_builtins.str]] = None,
                 vm: Optional[pulumi.Input[Union['AssetVmArgs', 'AssetVmArgsDict']]] = None,
                 vmware_vcenter: Optional[pulumi.Input[Union['AssetVmwareVcenterArgs', 'AssetVmwareVcenterArgsDict']]] = None,
                 vmware_vm: Optional[pulumi.Input[Union['AssetVmwareVmArgs', 'AssetVmwareVmArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_asset = oci.cloudbridge.Asset("test_asset",
            asset_type=asset_asset_type,
            compartment_id=compartment_id,
            external_asset_key=asset_external_asset_key,
            inventory_id=test_inventory["id"],
            source_key=asset_source_key,
            asset_source_ids=asset_asset_source_ids,
            compute={
                "connected_networks": asset_compute_connected_networks,
                "cores_count": asset_compute_cores_count,
                "cpu_model": asset_compute_cpu_model,
                "description": asset_compute_description,
                "disks": [{
                    "boot_order": asset_compute_disks_boot_order,
                    "location": asset_compute_disks_location,
                    "name": asset_compute_disks_name,
                    "persistent_mode": asset_compute_disks_persistent_mode,
                    "size_in_mbs": asset_compute_disks_size_in_mbs,
                    "uuid": asset_compute_disks_uuid,
                    "uuid_lun": asset_compute_disks_uuid_lun,
                }],
                "disks_count": asset_compute_disks_count,
                "dns_name": asset_compute_dns_name,
                "firmware": asset_compute_firmware,
                "gpu_devices": [{
                    "cores_count": asset_compute_gpu_devices_cores_count,
                    "description": asset_compute_gpu_devices_description,
                    "manufacturer": asset_compute_gpu_devices_manufacturer,
                    "memory_in_mbs": asset_compute_gpu_devices_memory_in_mbs,
                    "name": asset_compute_gpu_devices_name,
                }],
                "gpu_devices_count": asset_compute_gpu_devices_count,
                "guest_state": asset_compute_guest_state,
                "hardware_version": asset_compute_hardware_version,
                "host_name": asset_compute_host_name,
                "is_pmem_enabled": asset_compute_is_pmem_enabled,
                "is_tpm_enabled": asset_compute_is_tpm_enabled,
                "latency_sensitivity": asset_compute_latency_sensitivity,
                "memory_in_mbs": asset_compute_memory_in_mbs,
                "nics": [{
                    "ip_addresses": asset_compute_nics_ip_addresses,
                    "label": asset_compute_nics_label,
                    "mac_address": asset_compute_nics_mac_address,
                    "mac_address_type": asset_compute_nics_mac_address_type,
                    "network_name": asset_compute_nics_network_name,
                    "switch_name": asset_compute_nics_switch_name,
                }],
                "nics_count": asset_compute_nics_count,
                "nvdimm_controller": {
                    "bus_number": asset_compute_nvdimm_controller_bus_number,
                    "label": asset_compute_nvdimm_controller_label,
                },
                "nvdimms": [{
                    "controller_key": asset_compute_nvdimms_controller_key,
                    "label": asset_compute_nvdimms_label,
                    "unit_number": asset_compute_nvdimms_unit_number,
                }],
                "operating_system": asset_compute_operating_system,
                "operating_system_version": asset_compute_operating_system_version,
                "pmem_in_mbs": asset_compute_pmem_in_mbs,
                "power_state": asset_compute_power_state,
                "primary_ip": asset_compute_primary_ip,
                "scsi_controller": {
                    "label": asset_compute_scsi_controller_label,
                    "shared_bus": asset_compute_scsi_controller_shared_bus,
                    "unit_number": asset_compute_scsi_controller_unit_number,
                },
                "storage_provisioned_in_mbs": asset_compute_storage_provisioned_in_mbs,
                "threads_per_core_count": asset_compute_threads_per_core_count,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=asset_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            vm={
                "hypervisor_host": asset_vm_hypervisor_host,
                "hypervisor_vendor": asset_vm_hypervisor_vendor,
                "hypervisor_version": asset_vm_hypervisor_version,
            },
            vmware_vcenter={
                "data_center": asset_vmware_vcenter_data_center,
                "vcenter_key": asset_vmware_vcenter_vcenter_key,
                "vcenter_version": asset_vmware_vcenter_vcenter_version,
            },
            vmware_vm={
                "cluster": asset_vmware_vm_cluster,
                "customer_fields": asset_vmware_vm_customer_fields,
                "customer_tags": [{
                    "description": asset_vmware_vm_customer_tags_description,
                    "name": asset_vmware_vm_customer_tags_name,
                }],
                "fault_tolerance_bandwidth": asset_vmware_vm_fault_tolerance_bandwidth,
                "fault_tolerance_secondary_latency": asset_vmware_vm_fault_tolerance_secondary_latency,
                "fault_tolerance_state": asset_vmware_vm_fault_tolerance_state,
                "instance_uuid": asset_vmware_vm_instance_uuid,
                "is_disks_cbt_enabled": asset_vmware_vm_is_disks_cbt_enabled,
                "is_disks_uuid_enabled": asset_vmware_vm_is_disks_uuid_enabled,
                "path": asset_vmware_vm_path,
                "vmware_tools_status": asset_vmware_vm_vmware_tools_status,
            })
        ```

        ## Import

        Assets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/asset:Asset test_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] asset_source_ids: (Updatable) List of asset source OCID.
        :param pulumi.Input[_builtins.str] asset_type: (Updatable) The type of asset.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that the asset belongs to.
        :param pulumi.Input[Union['AssetComputeArgs', 'AssetComputeArgsDict']] compute: (Updatable) Compute related properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Asset display name.
        :param pulumi.Input[_builtins.str] external_asset_key: The key of the asset from the external environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] inventory_id: Inventory ID to which an asset belongs.
        :param pulumi.Input[_builtins.str] source_key: The source key to which the asset belongs.
        :param pulumi.Input[Union['AssetVmArgs', 'AssetVmArgsDict']] vm: (Updatable) Virtual machine related properties.
        :param pulumi.Input[Union['AssetVmwareVcenterArgs', 'AssetVmwareVcenterArgsDict']] vmware_vcenter: (Updatable) VMware vCenter related properties.
        :param pulumi.Input[Union['AssetVmwareVmArgs', 'AssetVmwareVmArgsDict']] vmware_vm: (Updatable) VMware virtual machine related properties.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_asset = oci.cloudbridge.Asset("test_asset",
            asset_type=asset_asset_type,
            compartment_id=compartment_id,
            external_asset_key=asset_external_asset_key,
            inventory_id=test_inventory["id"],
            source_key=asset_source_key,
            asset_source_ids=asset_asset_source_ids,
            compute={
                "connected_networks": asset_compute_connected_networks,
                "cores_count": asset_compute_cores_count,
                "cpu_model": asset_compute_cpu_model,
                "description": asset_compute_description,
                "disks": [{
                    "boot_order": asset_compute_disks_boot_order,
                    "location": asset_compute_disks_location,
                    "name": asset_compute_disks_name,
                    "persistent_mode": asset_compute_disks_persistent_mode,
                    "size_in_mbs": asset_compute_disks_size_in_mbs,
                    "uuid": asset_compute_disks_uuid,
                    "uuid_lun": asset_compute_disks_uuid_lun,
                }],
                "disks_count": asset_compute_disks_count,
                "dns_name": asset_compute_dns_name,
                "firmware": asset_compute_firmware,
                "gpu_devices": [{
                    "cores_count": asset_compute_gpu_devices_cores_count,
                    "description": asset_compute_gpu_devices_description,
                    "manufacturer": asset_compute_gpu_devices_manufacturer,
                    "memory_in_mbs": asset_compute_gpu_devices_memory_in_mbs,
                    "name": asset_compute_gpu_devices_name,
                }],
                "gpu_devices_count": asset_compute_gpu_devices_count,
                "guest_state": asset_compute_guest_state,
                "hardware_version": asset_compute_hardware_version,
                "host_name": asset_compute_host_name,
                "is_pmem_enabled": asset_compute_is_pmem_enabled,
                "is_tpm_enabled": asset_compute_is_tpm_enabled,
                "latency_sensitivity": asset_compute_latency_sensitivity,
                "memory_in_mbs": asset_compute_memory_in_mbs,
                "nics": [{
                    "ip_addresses": asset_compute_nics_ip_addresses,
                    "label": asset_compute_nics_label,
                    "mac_address": asset_compute_nics_mac_address,
                    "mac_address_type": asset_compute_nics_mac_address_type,
                    "network_name": asset_compute_nics_network_name,
                    "switch_name": asset_compute_nics_switch_name,
                }],
                "nics_count": asset_compute_nics_count,
                "nvdimm_controller": {
                    "bus_number": asset_compute_nvdimm_controller_bus_number,
                    "label": asset_compute_nvdimm_controller_label,
                },
                "nvdimms": [{
                    "controller_key": asset_compute_nvdimms_controller_key,
                    "label": asset_compute_nvdimms_label,
                    "unit_number": asset_compute_nvdimms_unit_number,
                }],
                "operating_system": asset_compute_operating_system,
                "operating_system_version": asset_compute_operating_system_version,
                "pmem_in_mbs": asset_compute_pmem_in_mbs,
                "power_state": asset_compute_power_state,
                "primary_ip": asset_compute_primary_ip,
                "scsi_controller": {
                    "label": asset_compute_scsi_controller_label,
                    "shared_bus": asset_compute_scsi_controller_shared_bus,
                    "unit_number": asset_compute_scsi_controller_unit_number,
                },
                "storage_provisioned_in_mbs": asset_compute_storage_provisioned_in_mbs,
                "threads_per_core_count": asset_compute_threads_per_core_count,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=asset_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            vm={
                "hypervisor_host": asset_vm_hypervisor_host,
                "hypervisor_vendor": asset_vm_hypervisor_vendor,
                "hypervisor_version": asset_vm_hypervisor_version,
            },
            vmware_vcenter={
                "data_center": asset_vmware_vcenter_data_center,
                "vcenter_key": asset_vmware_vcenter_vcenter_key,
                "vcenter_version": asset_vmware_vcenter_vcenter_version,
            },
            vmware_vm={
                "cluster": asset_vmware_vm_cluster,
                "customer_fields": asset_vmware_vm_customer_fields,
                "customer_tags": [{
                    "description": asset_vmware_vm_customer_tags_description,
                    "name": asset_vmware_vm_customer_tags_name,
                }],
                "fault_tolerance_bandwidth": asset_vmware_vm_fault_tolerance_bandwidth,
                "fault_tolerance_secondary_latency": asset_vmware_vm_fault_tolerance_secondary_latency,
                "fault_tolerance_state": asset_vmware_vm_fault_tolerance_state,
                "instance_uuid": asset_vmware_vm_instance_uuid,
                "is_disks_cbt_enabled": asset_vmware_vm_is_disks_cbt_enabled,
                "is_disks_uuid_enabled": asset_vmware_vm_is_disks_uuid_enabled,
                "path": asset_vmware_vm_path,
                "vmware_tools_status": asset_vmware_vm_vmware_tools_status,
            })
        ```

        ## Import

        Assets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/asset:Asset test_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param AssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute: Optional[pulumi.Input[Union['AssetComputeArgs', 'AssetComputeArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inventory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_key: Optional[pulumi.Input[_builtins.str]] = None,
                 vm: Optional[pulumi.Input[Union['AssetVmArgs', 'AssetVmArgsDict']]] = None,
                 vmware_vcenter: Optional[pulumi.Input[Union['AssetVmwareVcenterArgs', 'AssetVmwareVcenterArgsDict']]] = None,
                 vmware_vm: Optional[pulumi.Input[Union['AssetVmwareVmArgs', 'AssetVmwareVmArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssetArgs.__new__(AssetArgs)

            __props__.__dict__["asset_source_ids"] = asset_source_ids
            if asset_type is None and not opts.urn:
                raise TypeError("Missing required property 'asset_type'")
            __props__.__dict__["asset_type"] = asset_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute"] = compute
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if external_asset_key is None and not opts.urn:
                raise TypeError("Missing required property 'external_asset_key'")
            __props__.__dict__["external_asset_key"] = external_asset_key
            __props__.__dict__["freeform_tags"] = freeform_tags
            if inventory_id is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_id'")
            __props__.__dict__["inventory_id"] = inventory_id
            if source_key is None and not opts.urn:
                raise TypeError("Missing required property 'source_key'")
            __props__.__dict__["source_key"] = source_key
            __props__.__dict__["vm"] = vm
            __props__.__dict__["vmware_vcenter"] = vmware_vcenter
            __props__.__dict__["vmware_vm"] = vmware_vm
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Asset, __self__).__init__(
            'oci:CloudBridge/asset:Asset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asset_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            asset_type: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute: Optional[pulumi.Input[Union['AssetComputeArgs', 'AssetComputeArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            inventory_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_key: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            vm: Optional[pulumi.Input[Union['AssetVmArgs', 'AssetVmArgsDict']]] = None,
            vmware_vcenter: Optional[pulumi.Input[Union['AssetVmwareVcenterArgs', 'AssetVmwareVcenterArgsDict']]] = None,
            vmware_vm: Optional[pulumi.Input[Union['AssetVmwareVmArgs', 'AssetVmwareVmArgsDict']]] = None) -> 'Asset':
        """
        Get an existing Asset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] asset_source_ids: (Updatable) List of asset source OCID.
        :param pulumi.Input[_builtins.str] asset_type: (Updatable) The type of asset.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that the asset belongs to.
        :param pulumi.Input[Union['AssetComputeArgs', 'AssetComputeArgsDict']] compute: (Updatable) Compute related properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Asset display name.
        :param pulumi.Input[_builtins.str] external_asset_key: The key of the asset from the external environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] inventory_id: Inventory ID to which an asset belongs.
        :param pulumi.Input[_builtins.str] source_key: The source key to which the asset belongs.
        :param pulumi.Input[_builtins.str] state: The current state of the asset.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[_builtins.str] time_created: The time when the asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time when the asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[Union['AssetVmArgs', 'AssetVmArgsDict']] vm: (Updatable) Virtual machine related properties.
        :param pulumi.Input[Union['AssetVmwareVcenterArgs', 'AssetVmwareVcenterArgsDict']] vmware_vcenter: (Updatable) VMware vCenter related properties.
        :param pulumi.Input[Union['AssetVmwareVmArgs', 'AssetVmwareVmArgsDict']] vmware_vm: (Updatable) VMware virtual machine related properties.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssetState.__new__(_AssetState)

        __props__.__dict__["asset_source_ids"] = asset_source_ids
        __props__.__dict__["asset_type"] = asset_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute"] = compute
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_asset_key"] = external_asset_key
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inventory_id"] = inventory_id
        __props__.__dict__["source_key"] = source_key
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vm"] = vm
        __props__.__dict__["vmware_vcenter"] = vmware_vcenter
        __props__.__dict__["vmware_vm"] = vmware_vm
        return Asset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetSourceIds")
    def asset_source_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of asset source OCID.
        """
        return pulumi.get(self, "asset_source_ids")

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The type of asset.
        """
        return pulumi.get(self, "asset_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that the asset belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def compute(self) -> pulumi.Output['outputs.AssetCompute']:
        """
        (Updatable) Compute related properties.
        """
        return pulumi.get(self, "compute")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Asset display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalAssetKey")
    def external_asset_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the asset from the external environment.
        """
        return pulumi.get(self, "external_asset_key")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> pulumi.Output[_builtins.str]:
        """
        Inventory ID to which an asset belongs.
        """
        return pulumi.get(self, "inventory_id")

    @_builtins.property
    @pulumi.getter(name="sourceKey")
    def source_key(self) -> pulumi.Output[_builtins.str]:
        """
        The source key to which the asset belongs.
        """
        return pulumi.get(self, "source_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the asset.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def vm(self) -> pulumi.Output['outputs.AssetVm']:
        """
        (Updatable) Virtual machine related properties.
        """
        return pulumi.get(self, "vm")

    @_builtins.property
    @pulumi.getter(name="vmwareVcenter")
    def vmware_vcenter(self) -> pulumi.Output['outputs.AssetVmwareVcenter']:
        """
        (Updatable) VMware vCenter related properties.
        """
        return pulumi.get(self, "vmware_vcenter")

    @_builtins.property
    @pulumi.getter(name="vmwareVm")
    def vmware_vm(self) -> pulumi.Output['outputs.AssetVmwareVm']:
        """
        (Updatable) VMware virtual machine related properties.
        """
        return pulumi.get(self, "vmware_vm")

