# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudGuardDataSourceArgs', 'CloudGuardDataSource']

@pulumi.input_type
class CloudGuardDataSourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 data_source_feed_provider: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 data_source_details: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudGuardDataSource resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[_builtins.str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Data source display name
        :param pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs'] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        pulumi.set(__self__, "display_name", display_name)
        if data_source_details is not None:
            pulumi.set(__self__, "data_source_details", data_source_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> pulumi.Input[_builtins.str]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @data_source_feed_provider.setter
    def data_source_feed_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_feed_provider", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]):
        pulumi.set(self, "data_source_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _CloudGuardDataSourceState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_details: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']] = None,
                 data_source_detector_mapping_infos: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region_status_details: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudGuardDataSource resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs'] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]] data_source_detector_mapping_infos: Information about the detector recipe and rule attached
        :param pulumi.Input[_builtins.str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]] region_status_details: Information about the region and status of query replication
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[_builtins.str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Data source was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the data source was updated. Format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_source_details is not None:
            pulumi.set(__self__, "data_source_details", data_source_details)
        if data_source_detector_mapping_infos is not None:
            pulumi.set(__self__, "data_source_detector_mapping_infos", data_source_detector_mapping_infos)
        if data_source_feed_provider is not None:
            pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if region_status_details is not None:
            pulumi.set(__self__, "region_status_details", region_status_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]):
        pulumi.set(self, "data_source_details", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDetectorMappingInfos")
    def data_source_detector_mapping_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]]:
        """
        Information about the detector recipe and rule attached
        """
        return pulumi.get(self, "data_source_detector_mapping_infos")

    @data_source_detector_mapping_infos.setter
    def data_source_detector_mapping_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]]):
        pulumi.set(self, "data_source_detector_mapping_infos", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @data_source_feed_provider.setter
    def data_source_feed_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_feed_provider", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="regionStatusDetails")
    def region_status_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]]:
        """
        Information about the region and status of query replication
        """
        return pulumi.get(self, "region_status_details")

    @region_status_details.setter
    def region_status_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]]):
        pulumi.set(self, "region_status_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Data source was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the data source was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource")
class CloudGuardDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_details: Optional[pulumi.Input[Union['CloudGuardDataSourceDataSourceDetailsArgs', 'CloudGuardDataSourceDataSourceDetailsArgsDict']]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_source = oci.cloudguard.CloudGuardDataSource("test_data_source",
            compartment_id=compartment_id,
            data_source_feed_provider=data_source_data_source_feed_provider,
            display_name=data_source_display_name,
            data_source_details={
                "data_source_feed_provider": data_source_data_source_details_data_source_feed_provider,
                "additional_entities_count": data_source_data_source_details_additional_entities_count,
                "description": data_source_data_source_details_description,
                "interval_in_minutes": data_source_data_source_details_interval_in_minutes,
                "interval_in_seconds": data_source_data_source_details_interval_in_seconds,
                "logging_query_details": {
                    "logging_query_type": data_source_data_source_details_logging_query_details_logging_query_type,
                    "key_entities_count": data_source_data_source_details_logging_query_details_key_entities_count,
                },
                "logging_query_type": data_source_data_source_details_logging_query_type,
                "operator": data_source_data_source_details_operator,
                "query": data_source_data_source_details_query,
                "query_start_time": {
                    "start_policy_type": data_source_data_source_details_query_start_time_start_policy_type,
                    "query_start_time": data_source_data_source_details_query_start_time_query_start_time,
                },
                "regions": data_source_data_source_details_regions,
                "scheduled_query_scope_details": [{
                    "region": data_source_data_source_details_scheduled_query_scope_details_region,
                    "resource_ids": data_source_data_source_details_scheduled_query_scope_details_resource_ids,
                    "resource_type": data_source_data_source_details_scheduled_query_scope_details_resource_type,
                }],
                "threshold": data_source_data_source_details_threshold,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=data_source_status)
        ```

        ## Import

        DataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource test_data_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[Union['CloudGuardDataSourceDataSourceDetailsArgs', 'CloudGuardDataSourceDataSourceDetailsArgsDict']] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[_builtins.str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudGuardDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_source = oci.cloudguard.CloudGuardDataSource("test_data_source",
            compartment_id=compartment_id,
            data_source_feed_provider=data_source_data_source_feed_provider,
            display_name=data_source_display_name,
            data_source_details={
                "data_source_feed_provider": data_source_data_source_details_data_source_feed_provider,
                "additional_entities_count": data_source_data_source_details_additional_entities_count,
                "description": data_source_data_source_details_description,
                "interval_in_minutes": data_source_data_source_details_interval_in_minutes,
                "interval_in_seconds": data_source_data_source_details_interval_in_seconds,
                "logging_query_details": {
                    "logging_query_type": data_source_data_source_details_logging_query_details_logging_query_type,
                    "key_entities_count": data_source_data_source_details_logging_query_details_key_entities_count,
                },
                "logging_query_type": data_source_data_source_details_logging_query_type,
                "operator": data_source_data_source_details_operator,
                "query": data_source_data_source_details_query,
                "query_start_time": {
                    "start_policy_type": data_source_data_source_details_query_start_time_start_policy_type,
                    "query_start_time": data_source_data_source_details_query_start_time_query_start_time,
                },
                "regions": data_source_data_source_details_regions,
                "scheduled_query_scope_details": [{
                    "region": data_source_data_source_details_scheduled_query_scope_details_region,
                    "resource_ids": data_source_data_source_details_scheduled_query_scope_details_resource_ids,
                    "resource_type": data_source_data_source_details_scheduled_query_scope_details_resource_type,
                }],
                "threshold": data_source_data_source_details_threshold,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=data_source_status)
        ```

        ## Import

        DataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource test_data_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudGuardDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudGuardDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_details: Optional[pulumi.Input[Union['CloudGuardDataSourceDataSourceDetailsArgs', 'CloudGuardDataSourceDataSourceDetailsArgsDict']]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudGuardDataSourceArgs.__new__(CloudGuardDataSourceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["data_source_details"] = data_source_details
            if data_source_feed_provider is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_feed_provider'")
            __props__.__dict__["data_source_feed_provider"] = data_source_feed_provider
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["status"] = status
            __props__.__dict__["data_source_detector_mapping_infos"] = None
            __props__.__dict__["region_status_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(CloudGuardDataSource, __self__).__init__(
            'oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_details: Optional[pulumi.Input[Union['CloudGuardDataSourceDataSourceDetailsArgs', 'CloudGuardDataSourceDataSourceDetailsArgsDict']]] = None,
            data_source_detector_mapping_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs', 'CloudGuardDataSourceDataSourceDetectorMappingInfoArgsDict']]]]] = None,
            data_source_feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region_status_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudGuardDataSourceRegionStatusDetailArgs', 'CloudGuardDataSourceRegionStatusDetailArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudGuardDataSource':
        """
        Get an existing CloudGuardDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[Union['CloudGuardDataSourceDataSourceDetailsArgs', 'CloudGuardDataSourceDataSourceDetailsArgsDict']] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs', 'CloudGuardDataSourceDataSourceDetectorMappingInfoArgsDict']]]] data_source_detector_mapping_infos: Information about the detector recipe and rule attached
        :param pulumi.Input[_builtins.str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudGuardDataSourceRegionStatusDetailArgs', 'CloudGuardDataSourceRegionStatusDetailArgsDict']]]] region_status_details: Information about the region and status of query replication
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[_builtins.str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Data source was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the data source was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudGuardDataSourceState.__new__(_CloudGuardDataSourceState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_source_details"] = data_source_details
        __props__.__dict__["data_source_detector_mapping_infos"] = data_source_detector_mapping_infos
        __props__.__dict__["data_source_feed_provider"] = data_source_feed_provider
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["region_status_details"] = region_status_details
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return CloudGuardDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> pulumi.Output['outputs.CloudGuardDataSourceDataSourceDetails']:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @_builtins.property
    @pulumi.getter(name="dataSourceDetectorMappingInfos")
    def data_source_detector_mapping_infos(self) -> pulumi.Output[Sequence['outputs.CloudGuardDataSourceDataSourceDetectorMappingInfo']]:
        """
        Information about the detector recipe and rule attached
        """
        return pulumi.get(self, "data_source_detector_mapping_infos")

    @_builtins.property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> pulumi.Output[_builtins.str]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="regionStatusDetails")
    def region_status_details(self) -> pulumi.Output[Sequence['outputs.CloudGuardDataSourceRegionStatusDetail']]:
        """
        Information about the region and status of query replication
        """
        return pulumi.get(self, "region_status_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Data source was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the data source was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

