# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DetectorRecipeArgs', 'DetectorRecipe']

@pulumi.input_type
class DetectorRecipeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_detector_recipe_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DetectorRecipe resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Detector recipe display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Detector recipe description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] detector: Detector for the rule
        :param pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]] detector_rules: (Updatable) Detector rules to override from source detector recipe
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] source_detector_recipe_id: The ID of the source detector recipe
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detector is not None:
            pulumi.set(__self__, "detector", detector)
        if detector_rules is not None:
            pulumi.set(__self__, "detector_rules", detector_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if source_detector_recipe_id is not None:
            pulumi.set(__self__, "source_detector_recipe_id", source_detector_recipe_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Detector recipe display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detector recipe description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def detector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Detector for the rule
        """
        return pulumi.get(self, "detector")

    @detector.setter
    def detector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector", value)

    @_builtins.property
    @pulumi.getter(name="detectorRules")
    def detector_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]]:
        """
        (Updatable) Detector rules to override from source detector recipe
        """
        return pulumi.get(self, "detector_rules")

    @detector_rules.setter
    def detector_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]]):
        pulumi.set(self, "detector_rules", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetectorRecipeId")
    def source_detector_recipe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source detector recipe


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_detector_recipe_id")

    @source_detector_recipe_id.setter
    def source_detector_recipe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_detector_recipe_id", value)


@pulumi.input_type
class _DetectorRecipeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_recipe_type: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeEffectiveDetectorRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 source_detector_recipe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DetectorRecipe resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Detector recipe description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] detector: Detector for the rule
        :param pulumi.Input[_builtins.str] detector_recipe_type: Recipe type ( STANDARD, ENTERPRISE )
        :param pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]] detector_rules: (Updatable) Detector rules to override from source detector recipe
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Detector recipe display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorRecipeEffectiveDetectorRuleArgs']]] effective_detector_rules: List of effective detector rules for the detector type for recipe after applying defaults
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] owner: Owner of detector recipe
        :param pulumi.Input[_builtins.str] source_detector_recipe_id: The ID of the source detector recipe
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_ids: List of target IDs to which the recipe is attached
        :param pulumi.Input[_builtins.str] time_created: The date and time the detector recipe was created Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the detector recipe was last updated Format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detector is not None:
            pulumi.set(__self__, "detector", detector)
        if detector_recipe_type is not None:
            pulumi.set(__self__, "detector_recipe_type", detector_recipe_type)
        if detector_rules is not None:
            pulumi.set(__self__, "detector_rules", detector_rules)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_detector_rules is not None:
            pulumi.set(__self__, "effective_detector_rules", effective_detector_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if source_detector_recipe_id is not None:
            pulumi.set(__self__, "source_detector_recipe_id", source_detector_recipe_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_ids is not None:
            pulumi.set(__self__, "target_ids", target_ids)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detector recipe description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def detector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Detector for the rule
        """
        return pulumi.get(self, "detector")

    @detector.setter
    def detector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector", value)

    @_builtins.property
    @pulumi.getter(name="detectorRecipeType")
    def detector_recipe_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Recipe type ( STANDARD, ENTERPRISE )
        """
        return pulumi.get(self, "detector_recipe_type")

    @detector_recipe_type.setter
    def detector_recipe_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector_recipe_type", value)

    @_builtins.property
    @pulumi.getter(name="detectorRules")
    def detector_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]]:
        """
        (Updatable) Detector rules to override from source detector recipe
        """
        return pulumi.get(self, "detector_rules")

    @detector_rules.setter
    def detector_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeDetectorRuleArgs']]]]):
        pulumi.set(self, "detector_rules", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detector recipe display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveDetectorRules")
    def effective_detector_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeEffectiveDetectorRuleArgs']]]]:
        """
        List of effective detector rules for the detector type for recipe after applying defaults
        """
        return pulumi.get(self, "effective_detector_rules")

    @effective_detector_rules.setter
    def effective_detector_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRecipeEffectiveDetectorRuleArgs']]]]):
        pulumi.set(self, "effective_detector_rules", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Owner of detector recipe
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetectorRecipeId")
    def source_detector_recipe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source detector recipe


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_detector_recipe_id")

    @source_detector_recipe_id.setter
    def source_detector_recipe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_detector_recipe_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target IDs to which the recipe is attached
        """
        return pulumi.get(self, "target_ids")

    @target_ids.setter
    def target_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_ids", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the detector recipe was created Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the detector recipe was last updated Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CloudGuard/detectorRecipe:DetectorRecipe")
class DetectorRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeDetectorRuleArgs', 'DetectorRecipeDetectorRuleArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_detector_recipe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        DetectorRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/detectorRecipe:DetectorRecipe test_detector_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Detector recipe description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] detector: Detector for the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeDetectorRuleArgs', 'DetectorRecipeDetectorRuleArgsDict']]]] detector_rules: (Updatable) Detector rules to override from source detector recipe
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Detector recipe display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] source_detector_recipe_id: The ID of the source detector recipe
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DetectorRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        DetectorRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/detectorRecipe:DetectorRecipe test_detector_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param DetectorRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DetectorRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeDetectorRuleArgs', 'DetectorRecipeDetectorRuleArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_detector_recipe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DetectorRecipeArgs.__new__(DetectorRecipeArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["detector"] = detector
            __props__.__dict__["detector_rules"] = detector_rules
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["source_detector_recipe_id"] = source_detector_recipe_id
            __props__.__dict__["detector_recipe_type"] = None
            __props__.__dict__["effective_detector_rules"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_ids"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DetectorRecipe, __self__).__init__(
            'oci:CloudGuard/detectorRecipe:DetectorRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detector: Optional[pulumi.Input[_builtins.str]] = None,
            detector_recipe_type: Optional[pulumi.Input[_builtins.str]] = None,
            detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeDetectorRuleArgs', 'DetectorRecipeDetectorRuleArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_detector_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeEffectiveDetectorRuleArgs', 'DetectorRecipeEffectiveDetectorRuleArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            source_detector_recipe_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DetectorRecipe':
        """
        Get an existing DetectorRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Detector recipe description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] detector: Detector for the rule
        :param pulumi.Input[_builtins.str] detector_recipe_type: Recipe type ( STANDARD, ENTERPRISE )
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeDetectorRuleArgs', 'DetectorRecipeDetectorRuleArgsDict']]]] detector_rules: (Updatable) Detector rules to override from source detector recipe
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Detector recipe display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorRecipeEffectiveDetectorRuleArgs', 'DetectorRecipeEffectiveDetectorRuleArgsDict']]]] effective_detector_rules: List of effective detector rules for the detector type for recipe after applying defaults
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] owner: Owner of detector recipe
        :param pulumi.Input[_builtins.str] source_detector_recipe_id: The ID of the source detector recipe
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_ids: List of target IDs to which the recipe is attached
        :param pulumi.Input[_builtins.str] time_created: The date and time the detector recipe was created Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the detector recipe was last updated Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DetectorRecipeState.__new__(_DetectorRecipeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["detector"] = detector
        __props__.__dict__["detector_recipe_type"] = detector_recipe_type
        __props__.__dict__["detector_rules"] = detector_rules
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_detector_rules"] = effective_detector_rules
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["owner"] = owner
        __props__.__dict__["source_detector_recipe_id"] = source_detector_recipe_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_ids"] = target_ids
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DetectorRecipe(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Detector recipe description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def detector(self) -> pulumi.Output[_builtins.str]:
        """
        Detector for the rule
        """
        return pulumi.get(self, "detector")

    @_builtins.property
    @pulumi.getter(name="detectorRecipeType")
    def detector_recipe_type(self) -> pulumi.Output[_builtins.str]:
        """
        Recipe type ( STANDARD, ENTERPRISE )
        """
        return pulumi.get(self, "detector_recipe_type")

    @_builtins.property
    @pulumi.getter(name="detectorRules")
    def detector_rules(self) -> pulumi.Output[Sequence['outputs.DetectorRecipeDetectorRule']]:
        """
        (Updatable) Detector rules to override from source detector recipe
        """
        return pulumi.get(self, "detector_rules")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Detector recipe display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveDetectorRules")
    def effective_detector_rules(self) -> pulumi.Output[Sequence['outputs.DetectorRecipeEffectiveDetectorRule']]:
        """
        List of effective detector rules for the detector type for recipe after applying defaults
        """
        return pulumi.get(self, "effective_detector_rules")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Owner of detector recipe
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="sourceDetectorRecipeId")
    def source_detector_recipe_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source detector recipe


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_detector_recipe_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of target IDs to which the recipe is attached
        """
        return pulumi.get(self, "target_ids")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the detector recipe was created Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the detector recipe was last updated Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

