# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCloudGuardConfigurationResult',
    'AwaitableGetCloudGuardConfigurationResult',
    'get_cloud_guard_configuration',
    'get_cloud_guard_configuration_output',
]

@pulumi.output_type
class GetCloudGuardConfigurationResult:
    """
    A collection of values returned by getCloudGuardConfiguration.
    """
    def __init__(__self__, compartment_id=None, id=None, reporting_region=None, self_manage_resources=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if reporting_region and not isinstance(reporting_region, str):
            raise TypeError("Expected argument 'reporting_region' to be a str")
        pulumi.set(__self__, "reporting_region", reporting_region)
        if self_manage_resources and not isinstance(self_manage_resources, bool):
            raise TypeError("Expected argument 'self_manage_resources' to be a bool")
        pulumi.set(__self__, "self_manage_resources", self_manage_resources)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="reportingRegion")
    def reporting_region(self) -> _builtins.str:
        """
        The reporting region
        """
        return pulumi.get(self, "reporting_region")

    @_builtins.property
    @pulumi.getter(name="selfManageResources")
    def self_manage_resources(self) -> _builtins.bool:
        """
        Were Oracle-managed resources created by customer?
        """
        return pulumi.get(self, "self_manage_resources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Cloud Guard tenant
        """
        return pulumi.get(self, "status")


class AwaitableGetCloudGuardConfigurationResult(GetCloudGuardConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudGuardConfigurationResult(
            compartment_id=self.compartment_id,
            id=self.id,
            reporting_region=self.reporting_region,
            self_manage_resources=self.self_manage_resources,
            status=self.status)


def get_cloud_guard_configuration(compartment_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudGuardConfigurationResult:
    """
    This data source provides details about a specific Cloud Guard Configuration resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns the configuration details for a Cloud Guard tenancy,
    identified by root compartment OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_guard_configuration = oci.CloudGuard.get_cloud_guard_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getCloudGuardConfiguration:getCloudGuardConfiguration', __args__, opts=opts, typ=GetCloudGuardConfigurationResult).value

    return AwaitableGetCloudGuardConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        reporting_region=pulumi.get(__ret__, 'reporting_region'),
        self_manage_resources=pulumi.get(__ret__, 'self_manage_resources'),
        status=pulumi.get(__ret__, 'status'))
def get_cloud_guard_configuration_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudGuardConfigurationResult]:
    """
    This data source provides details about a specific Cloud Guard Configuration resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns the configuration details for a Cloud Guard tenancy,
    identified by root compartment OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_guard_configuration = oci.CloudGuard.get_cloud_guard_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getCloudGuardConfiguration:getCloudGuardConfiguration', __args__, opts=opts, typ=GetCloudGuardConfigurationResult)
    return __ret__.apply(lambda __response__: GetCloudGuardConfigurationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        reporting_region=pulumi.get(__response__, 'reporting_region'),
        self_manage_resources=pulumi.get(__response__, 'self_manage_resources'),
        status=pulumi.get(__response__, 'status')))
