# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedListArgs', 'ManagedList']

@pulumi.input_type
class ManagedListArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 list_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_managed_list_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedList resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Managed list display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Managed list description
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] group: (Updatable) Managed list type group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_items: (Updatable) List of items in the managed list
        :param pulumi.Input[_builtins.str] list_type: Type of information stored in the list
        :param pulumi.Input[_builtins.str] source_managed_list_id: OCID of the source managed list
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if list_items is not None:
            pulumi.set(__self__, "list_items", list_items)
        if list_type is not None:
            pulumi.set(__self__, "list_type", list_type)
        if source_managed_list_id is not None:
            pulumi.set(__self__, "source_managed_list_id", source_managed_list_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Managed list display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Managed list description

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Managed list type group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="listItems")
    def list_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of items in the managed list
        """
        return pulumi.get(self, "list_items")

    @list_items.setter
    def list_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "list_items", value)

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of information stored in the list
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceManagedListId")
    def source_managed_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the source managed list


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_managed_list_id")

    @source_managed_list_id.setter
    def source_managed_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_managed_list_id", value)


@pulumi.input_type
class _ManagedListState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 is_editable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 list_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_managed_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedList resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Managed list description
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Managed list display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] feed_provider: Provider of the managed list feed
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] group: (Updatable) Managed list type group
        :param pulumi.Input[_builtins.bool] is_editable: Is this list editable?
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_items: (Updatable) List of items in the managed list
        :param pulumi.Input[_builtins.str] list_type: Type of information stored in the list
        :param pulumi.Input[_builtins.str] source_managed_list_id: OCID of the source managed list
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the managed list was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the managed list was last updated. Format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if feed_provider is not None:
            pulumi.set(__self__, "feed_provider", feed_provider)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if is_editable is not None:
            pulumi.set(__self__, "is_editable", is_editable)
        if lifecyle_details is not None:
            pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if list_items is not None:
            pulumi.set(__self__, "list_items", list_items)
        if list_type is not None:
            pulumi.set(__self__, "list_type", list_type)
        if source_managed_list_id is not None:
            pulumi.set(__self__, "source_managed_list_id", source_managed_list_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Managed list description

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Managed list display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="feedProvider")
    def feed_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider of the managed list feed
        """
        return pulumi.get(self, "feed_provider")

    @feed_provider.setter
    def feed_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feed_provider", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Managed list type group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this list editable?
        """
        return pulumi.get(self, "is_editable")

    @is_editable.setter
    def is_editable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_editable", value)

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecyle_details", value)

    @_builtins.property
    @pulumi.getter(name="listItems")
    def list_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of items in the managed list
        """
        return pulumi.get(self, "list_items")

    @list_items.setter
    def list_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "list_items", value)

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of information stored in the list
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceManagedListId")
    def source_managed_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the source managed list


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_managed_list_id")

    @source_managed_list_id.setter
    def source_managed_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_managed_list_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the managed list was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the managed list was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CloudGuard/managedList:ManagedList")
class ManagedList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 list_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_managed_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ManagedLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/managedList:ManagedList test_managed_list "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Managed list description
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Managed list display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] group: (Updatable) Managed list type group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_items: (Updatable) List of items in the managed list
        :param pulumi.Input[_builtins.str] list_type: Type of information stored in the list
        :param pulumi.Input[_builtins.str] source_managed_list_id: OCID of the source managed list
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ManagedLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/managedList:ManagedList test_managed_list "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 list_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_managed_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedListArgs.__new__(ManagedListArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["group"] = group
            __props__.__dict__["list_items"] = list_items
            __props__.__dict__["list_type"] = list_type
            __props__.__dict__["source_managed_list_id"] = source_managed_list_id
            __props__.__dict__["feed_provider"] = None
            __props__.__dict__["is_editable"] = None
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ManagedList, __self__).__init__(
            'oci:CloudGuard/managedList:ManagedList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            feed_provider: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            is_editable: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
            list_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            list_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_managed_list_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedList':
        """
        Get an existing ManagedList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Managed list description
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Managed list display name.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] feed_provider: Provider of the managed list feed
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] group: (Updatable) Managed list type group
        :param pulumi.Input[_builtins.bool] is_editable: Is this list editable?
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_items: (Updatable) List of items in the managed list
        :param pulumi.Input[_builtins.str] list_type: Type of information stored in the list
        :param pulumi.Input[_builtins.str] source_managed_list_id: OCID of the source managed list
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the managed list was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the managed list was last updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedListState.__new__(_ManagedListState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["feed_provider"] = feed_provider
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group"] = group
        __props__.__dict__["is_editable"] = is_editable
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["list_items"] = list_items
        __props__.__dict__["list_type"] = list_type
        __props__.__dict__["source_managed_list_id"] = source_managed_list_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ManagedList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Managed list description

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Managed list display name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="feedProvider")
    def feed_provider(self) -> pulumi.Output[_builtins.str]:
        """
        Provider of the managed list feed
        """
        return pulumi.get(self, "feed_provider")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Managed list type group
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> pulumi.Output[_builtins.bool]:
        """
        Is this list editable?
        """
        return pulumi.get(self, "is_editable")

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        """
        return pulumi.get(self, "lifecyle_details")

    @_builtins.property
    @pulumi.getter(name="listItems")
    def list_items(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of items in the managed list
        """
        return pulumi.get(self, "list_items")

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of information stored in the list
        """
        return pulumi.get(self, "list_type")

    @_builtins.property
    @pulumi.getter(name="sourceManagedListId")
    def source_managed_list_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the source managed list


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_managed_list_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the managed list was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the managed list was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

