# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetArgs', 'Target']

@pulumi.input_type
class TargetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 target_resource_type: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_detector_recipes: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]] = None,
                 target_responder_recipes: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]] = None):
        """
        The set of arguments for constructing a Target resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID where the resource is created
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Display name for the target.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] target_resource_id: Resource ID which the target uses to monitor
        :param pulumi.Input[_builtins.str] target_resource_type: Type of resource that target support (COMPARTMENT/FACLOUD)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: The target description.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] state: (Updatable) The enablement state of the detector rule
        :param pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]] target_detector_recipes: (Updatable) List of detector recipes to attach to target
        :param pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]] target_responder_recipes: (Updatable) List of responder recipes to attach to target
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_detector_recipes is not None:
            pulumi.set(__self__, "target_detector_recipes", target_detector_recipes)
        if target_responder_recipes is not None:
            pulumi.set(__self__, "target_responder_recipes", target_responder_recipes)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment OCID where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Display name for the target.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID which the target uses to monitor
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of resource that target support (COMPARTMENT/FACLOUD)
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The enablement state of the detector rule
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="targetDetectorRecipes")
    def target_detector_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]]:
        """
        (Updatable) List of detector recipes to attach to target
        """
        return pulumi.get(self, "target_detector_recipes")

    @target_detector_recipes.setter
    def target_detector_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]]):
        pulumi.set(self, "target_detector_recipes", value)

    @_builtins.property
    @pulumi.getter(name="targetResponderRecipes")
    def target_responder_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]]:
        """
        (Updatable) List of responder recipes to attach to target
        """
        return pulumi.get(self, "target_responder_recipes")

    @target_responder_recipes.setter
    def target_responder_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]]):
        pulumi.set(self, "target_responder_recipes", value)


@pulumi.input_type
class _TargetState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inherited_by_compartments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 recipe_count: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_details: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetailArgs']]]] = None,
                 target_detector_recipes: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_responder_recipes: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Target resources.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID where the resource is created
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: The target description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Display name for the target.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_by_compartments: List of inherited compartments
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current lifecycle state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        :param pulumi.Input[_builtins.int] recipe_count: Total number of recipes attached to target
        :param pulumi.Input[_builtins.str] state: (Updatable) The enablement state of the detector rule
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['TargetTargetDetailArgs']]] target_details: Details specific to the target type.
        :param pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]] target_detector_recipes: (Updatable) List of detector recipes to attach to target
        :param pulumi.Input[_builtins.str] target_resource_id: Resource ID which the target uses to monitor
        :param pulumi.Input[_builtins.str] target_resource_type: Type of resource that target support (COMPARTMENT/FACLOUD)
        :param pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]] target_responder_recipes: (Updatable) List of responder recipes to attach to target
        :param pulumi.Input[_builtins.str] time_created: The date and time the target was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the target was last updated. Format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inherited_by_compartments is not None:
            pulumi.set(__self__, "inherited_by_compartments", inherited_by_compartments)
        if lifecyle_details is not None:
            pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if recipe_count is not None:
            pulumi.set(__self__, "recipe_count", recipe_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_details is not None:
            pulumi.set(__self__, "target_details", target_details)
        if target_detector_recipes is not None:
            pulumi.set(__self__, "target_detector_recipes", target_detector_recipes)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if target_responder_recipes is not None:
            pulumi.set(__self__, "target_responder_recipes", target_responder_recipes)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment OCID where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Display name for the target.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inheritedByCompartments")
    def inherited_by_compartments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of inherited compartments
        """
        return pulumi.get(self, "inherited_by_compartments")

    @inherited_by_compartments.setter
    def inherited_by_compartments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inherited_by_compartments", value)

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current lifecycle state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecyle_details", value)

    @_builtins.property
    @pulumi.getter(name="recipeCount")
    def recipe_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of recipes attached to target
        """
        return pulumi.get(self, "recipe_count")

    @recipe_count.setter
    def recipe_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recipe_count", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The enablement state of the detector rule
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetDetails")
    def target_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetailArgs']]]]:
        """
        Details specific to the target type.
        """
        return pulumi.get(self, "target_details")

    @target_details.setter
    def target_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetailArgs']]]]):
        pulumi.set(self, "target_details", value)

    @_builtins.property
    @pulumi.getter(name="targetDetectorRecipes")
    def target_detector_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]]:
        """
        (Updatable) List of detector recipes to attach to target
        """
        return pulumi.get(self, "target_detector_recipes")

    @target_detector_recipes.setter
    def target_detector_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetDetectorRecipeArgs']]]]):
        pulumi.set(self, "target_detector_recipes", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID which the target uses to monitor
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of resource that target support (COMPARTMENT/FACLOUD)
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="targetResponderRecipes")
    def target_responder_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]]:
        """
        (Updatable) List of responder recipes to attach to target
        """
        return pulumi.get(self, "target_responder_recipes")

    @target_responder_recipes.setter
    def target_responder_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetTargetResponderRecipeArgs']]]]):
        pulumi.set(self, "target_responder_recipes", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the target was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the target was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CloudGuard/target:Target")
class Target(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_detector_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetectorRecipeArgs', 'TargetTargetDetectorRecipeArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_responder_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetResponderRecipeArgs', 'TargetTargetResponderRecipeArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target = oci.cloudguard.Target("test_target",
            compartment_id=compartment_id,
            display_name=target_display_name,
            target_resource_id=test_resource["id"],
            target_resource_type=target_target_resource_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=target_description,
            freeform_tags={
                "bar-key": "value",
            },
            state=target_state,
            target_detector_recipes=[{
                "detector_recipe_id": test_detector_recipe["id"],
                "detector_rules": [{
                    "details": {
                        "condition_groups": [{
                            "compartment_id": compartment_id,
                            "condition": target_target_detector_recipes_detector_rules_details_condition_groups_condition,
                        }],
                    },
                    "detector_rule_id": test_rule["id"],
                }],
            }],
            target_responder_recipes=[{
                "responder_recipe_id": test_responder_recipe["id"],
                "responder_rules": [{
                    "details": {
                        "condition": target_target_responder_recipes_responder_rules_details_condition,
                        "configurations": [{
                            "config_key": target_target_responder_recipes_responder_rules_details_configurations_config_key,
                            "name": target_target_responder_recipes_responder_rules_details_configurations_name,
                            "value": target_target_responder_recipes_responder_rules_details_configurations_value,
                        }],
                        "mode": target_target_responder_recipes_responder_rules_details_mode,
                    },
                    "responder_rule_id": test_rule["id"],
                }],
            }])
        ```

        ## Import

        Targets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/target:Target test_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID where the resource is created
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: The target description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Display name for the target.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] state: (Updatable) The enablement state of the detector rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetectorRecipeArgs', 'TargetTargetDetectorRecipeArgsDict']]]] target_detector_recipes: (Updatable) List of detector recipes to attach to target
        :param pulumi.Input[_builtins.str] target_resource_id: Resource ID which the target uses to monitor
        :param pulumi.Input[_builtins.str] target_resource_type: Type of resource that target support (COMPARTMENT/FACLOUD)
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetResponderRecipeArgs', 'TargetTargetResponderRecipeArgsDict']]]] target_responder_recipes: (Updatable) List of responder recipes to attach to target
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target = oci.cloudguard.Target("test_target",
            compartment_id=compartment_id,
            display_name=target_display_name,
            target_resource_id=test_resource["id"],
            target_resource_type=target_target_resource_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=target_description,
            freeform_tags={
                "bar-key": "value",
            },
            state=target_state,
            target_detector_recipes=[{
                "detector_recipe_id": test_detector_recipe["id"],
                "detector_rules": [{
                    "details": {
                        "condition_groups": [{
                            "compartment_id": compartment_id,
                            "condition": target_target_detector_recipes_detector_rules_details_condition_groups_condition,
                        }],
                    },
                    "detector_rule_id": test_rule["id"],
                }],
            }],
            target_responder_recipes=[{
                "responder_recipe_id": test_responder_recipe["id"],
                "responder_rules": [{
                    "details": {
                        "condition": target_target_responder_recipes_responder_rules_details_condition,
                        "configurations": [{
                            "config_key": target_target_responder_recipes_responder_rules_details_configurations_config_key,
                            "name": target_target_responder_recipes_responder_rules_details_configurations_name,
                            "value": target_target_responder_recipes_responder_rules_details_configurations_value,
                        }],
                        "mode": target_target_responder_recipes_responder_rules_details_mode,
                    },
                    "responder_rule_id": test_rule["id"],
                }],
            }])
        ```

        ## Import

        Targets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/target:Target test_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param TargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_detector_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetectorRecipeArgs', 'TargetTargetDetectorRecipeArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_responder_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetResponderRecipeArgs', 'TargetTargetResponderRecipeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetArgs.__new__(TargetArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["state"] = state
            __props__.__dict__["target_detector_recipes"] = target_detector_recipes
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            if target_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_type'")
            __props__.__dict__["target_resource_type"] = target_resource_type
            __props__.__dict__["target_responder_recipes"] = target_responder_recipes
            __props__.__dict__["inherited_by_compartments"] = None
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["recipe_count"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_details"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Target, __self__).__init__(
            'oci:CloudGuard/target:Target',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            inherited_by_compartments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
            recipe_count: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetailArgs', 'TargetTargetDetailArgsDict']]]]] = None,
            target_detector_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetectorRecipeArgs', 'TargetTargetDetectorRecipeArgsDict']]]]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            target_responder_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetResponderRecipeArgs', 'TargetTargetResponderRecipeArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'Target':
        """
        Get an existing Target resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID where the resource is created
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: The target description.
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Display name for the target.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_by_compartments: List of inherited compartments
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current lifecycle state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        :param pulumi.Input[_builtins.int] recipe_count: Total number of recipes attached to target
        :param pulumi.Input[_builtins.str] state: (Updatable) The enablement state of the detector rule
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetailArgs', 'TargetTargetDetailArgsDict']]]] target_details: Details specific to the target type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetDetectorRecipeArgs', 'TargetTargetDetectorRecipeArgsDict']]]] target_detector_recipes: (Updatable) List of detector recipes to attach to target
        :param pulumi.Input[_builtins.str] target_resource_id: Resource ID which the target uses to monitor
        :param pulumi.Input[_builtins.str] target_resource_type: Type of resource that target support (COMPARTMENT/FACLOUD)
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetTargetResponderRecipeArgs', 'TargetTargetResponderRecipeArgsDict']]]] target_responder_recipes: (Updatable) List of responder recipes to attach to target
        :param pulumi.Input[_builtins.str] time_created: The date and time the target was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the target was last updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetState.__new__(_TargetState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inherited_by_compartments"] = inherited_by_compartments
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["recipe_count"] = recipe_count
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_details"] = target_details
        __props__.__dict__["target_detector_recipes"] = target_detector_recipes
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["target_resource_type"] = target_resource_type
        __props__.__dict__["target_responder_recipes"] = target_responder_recipes
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Target(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment OCID where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The target description.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Display name for the target.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inheritedByCompartments")
    def inherited_by_compartments(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of inherited compartments
        """
        return pulumi.get(self, "inherited_by_compartments")

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current lifecycle state in more detail. For example, can be used to provide actionable information for a resource in Failed state. [DEPRECATE]
        """
        return pulumi.get(self, "lifecyle_details")

    @_builtins.property
    @pulumi.getter(name="recipeCount")
    def recipe_count(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of recipes attached to target
        """
        return pulumi.get(self, "recipe_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The enablement state of the detector rule
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetDetails")
    def target_details(self) -> pulumi.Output[Sequence['outputs.TargetTargetDetail']]:
        """
        Details specific to the target type.
        """
        return pulumi.get(self, "target_details")

    @_builtins.property
    @pulumi.getter(name="targetDetectorRecipes")
    def target_detector_recipes(self) -> pulumi.Output[Sequence['outputs.TargetTargetDetectorRecipe']]:
        """
        (Updatable) List of detector recipes to attach to target
        """
        return pulumi.get(self, "target_detector_recipes")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID which the target uses to monitor
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of resource that target support (COMPARTMENT/FACLOUD)
        """
        return pulumi.get(self, "target_resource_type")

    @_builtins.property
    @pulumi.getter(name="targetResponderRecipes")
    def target_responder_recipes(self) -> pulumi.Output[Sequence['outputs.TargetTargetResponderRecipe']]:
        """
        (Updatable) List of responder recipes to attach to target
        """
        return pulumi.get(self, "target_responder_recipes")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the target was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the target was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

