# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddonArgs', 'Addon']

@pulumi.input_type
class AddonArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[_builtins.str],
                 cluster_id: pulumi.Input[_builtins.str],
                 remove_addon_resources_on_delete: pulumi.Input[_builtins.bool],
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]] = None,
                 override_existing: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Addon resource.
        :param pulumi.Input[_builtins.str] addon_name: The name of the addon.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
        :param pulumi.Input[_builtins.bool] remove_addon_resources_on_delete: Whether to remove addon resource in deletion.
        :param pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]] configurations: (Updatable) Addon configuration details
        :param pulumi.Input[_builtins.bool] override_existing: Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        :param pulumi.Input[_builtins.str] version: (Updatable) The version of addon to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "remove_addon_resources_on_delete", remove_addon_resources_on_delete)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if override_existing is not None:
            pulumi.set(__self__, "override_existing", override_existing)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the addon.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="removeAddonResourcesOnDelete")
    def remove_addon_resources_on_delete(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to remove addon resource in deletion.
        """
        return pulumi.get(self, "remove_addon_resources_on_delete")

    @remove_addon_resources_on_delete.setter
    def remove_addon_resources_on_delete(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "remove_addon_resources_on_delete", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]]:
        """
        (Updatable) Addon configuration details
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="overrideExisting")
    def override_existing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        """
        return pulumi.get(self, "override_existing")

    @override_existing.setter
    def override_existing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override_existing", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The version of addon to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _AddonState:
    def __init__(__self__, *,
                 addon_errors: Optional[pulumi.Input[Sequence[pulumi.Input['AddonAddonErrorArgs']]]] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]] = None,
                 current_installed_version: Optional[pulumi.Input[_builtins.str]] = None,
                 override_existing: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_addon_resources_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Addon resources.
        :param pulumi.Input[Sequence[pulumi.Input['AddonAddonErrorArgs']]] addon_errors: The error info of the addon.
        :param pulumi.Input[_builtins.str] addon_name: The name of the addon.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]] configurations: (Updatable) Addon configuration details
        :param pulumi.Input[_builtins.str] current_installed_version: current installed version of the addon
        :param pulumi.Input[_builtins.bool] override_existing: Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        :param pulumi.Input[_builtins.bool] remove_addon_resources_on_delete: Whether to remove addon resource in deletion.
        :param pulumi.Input[_builtins.str] state: The state of the addon.
        :param pulumi.Input[_builtins.str] time_created: The time the cluster was created.
        :param pulumi.Input[_builtins.str] version: (Updatable) The version of addon to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if addon_errors is not None:
            pulumi.set(__self__, "addon_errors", addon_errors)
        if addon_name is not None:
            pulumi.set(__self__, "addon_name", addon_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if current_installed_version is not None:
            pulumi.set(__self__, "current_installed_version", current_installed_version)
        if override_existing is not None:
            pulumi.set(__self__, "override_existing", override_existing)
        if remove_addon_resources_on_delete is not None:
            pulumi.set(__self__, "remove_addon_resources_on_delete", remove_addon_resources_on_delete)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="addonErrors")
    def addon_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddonAddonErrorArgs']]]]:
        """
        The error info of the addon.
        """
        return pulumi.get(self, "addon_errors")

    @addon_errors.setter
    def addon_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddonAddonErrorArgs']]]]):
        pulumi.set(self, "addon_errors", value)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the addon.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]]:
        """
        (Updatable) Addon configuration details
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddonConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="currentInstalledVersion")
    def current_installed_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        current installed version of the addon
        """
        return pulumi.get(self, "current_installed_version")

    @current_installed_version.setter
    def current_installed_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_installed_version", value)

    @_builtins.property
    @pulumi.getter(name="overrideExisting")
    def override_existing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        """
        return pulumi.get(self, "override_existing")

    @override_existing.setter
    def override_existing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override_existing", value)

    @_builtins.property
    @pulumi.getter(name="removeAddonResourcesOnDelete")
    def remove_addon_resources_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to remove addon resource in deletion.
        """
        return pulumi.get(self, "remove_addon_resources_on_delete")

    @remove_addon_resources_on_delete.setter
    def remove_addon_resources_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove_addon_resources_on_delete", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the addon.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The version of addon to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:ContainerEngine/addon:Addon")
class Addon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonConfigurationArgs', 'AddonConfigurationArgsDict']]]]] = None,
                 override_existing: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_addon_resources_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Addons can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/addon:Addon test_addon "clusters/{clusterId}/addons/{addonName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_name: The name of the addon.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddonConfigurationArgs', 'AddonConfigurationArgsDict']]]] configurations: (Updatable) Addon configuration details
        :param pulumi.Input[_builtins.bool] override_existing: Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        :param pulumi.Input[_builtins.bool] remove_addon_resources_on_delete: Whether to remove addon resource in deletion.
        :param pulumi.Input[_builtins.str] version: (Updatable) The version of addon to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Addons can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/addon:Addon test_addon "clusters/{clusterId}/addons/{addonName}"
        ```

        :param str resource_name: The name of the resource.
        :param AddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonConfigurationArgs', 'AddonConfigurationArgsDict']]]]] = None,
                 override_existing: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_addon_resources_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonArgs.__new__(AddonArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["override_existing"] = override_existing
            if remove_addon_resources_on_delete is None and not opts.urn:
                raise TypeError("Missing required property 'remove_addon_resources_on_delete'")
            __props__.__dict__["remove_addon_resources_on_delete"] = remove_addon_resources_on_delete
            __props__.__dict__["version"] = version
            __props__.__dict__["addon_errors"] = None
            __props__.__dict__["current_installed_version"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Addon, __self__).__init__(
            'oci:ContainerEngine/addon:Addon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonAddonErrorArgs', 'AddonAddonErrorArgsDict']]]]] = None,
            addon_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonConfigurationArgs', 'AddonConfigurationArgsDict']]]]] = None,
            current_installed_version: Optional[pulumi.Input[_builtins.str]] = None,
            override_existing: Optional[pulumi.Input[_builtins.bool]] = None,
            remove_addon_resources_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Addon':
        """
        Get an existing Addon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddonAddonErrorArgs', 'AddonAddonErrorArgsDict']]]] addon_errors: The error info of the addon.
        :param pulumi.Input[_builtins.str] addon_name: The name of the addon.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddonConfigurationArgs', 'AddonConfigurationArgsDict']]]] configurations: (Updatable) Addon configuration details
        :param pulumi.Input[_builtins.str] current_installed_version: current installed version of the addon
        :param pulumi.Input[_builtins.bool] override_existing: Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        :param pulumi.Input[_builtins.bool] remove_addon_resources_on_delete: Whether to remove addon resource in deletion.
        :param pulumi.Input[_builtins.str] state: The state of the addon.
        :param pulumi.Input[_builtins.str] time_created: The time the cluster was created.
        :param pulumi.Input[_builtins.str] version: (Updatable) The version of addon to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonState.__new__(_AddonState)

        __props__.__dict__["addon_errors"] = addon_errors
        __props__.__dict__["addon_name"] = addon_name
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["current_installed_version"] = current_installed_version
        __props__.__dict__["override_existing"] = override_existing
        __props__.__dict__["remove_addon_resources_on_delete"] = remove_addon_resources_on_delete
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["version"] = version
        return Addon(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addonErrors")
    def addon_errors(self) -> pulumi.Output[Sequence['outputs.AddonAddonError']]:
        """
        The error info of the addon.
        """
        return pulumi.get(self, "addon_errors")

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the addon.
        """
        return pulumi.get(self, "addon_name")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Sequence['outputs.AddonConfiguration']]:
        """
        (Updatable) Addon configuration details
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="currentInstalledVersion")
    def current_installed_version(self) -> pulumi.Output[_builtins.str]:
        """
        current installed version of the addon
        """
        return pulumi.get(self, "current_installed_version")

    @_builtins.property
    @pulumi.getter(name="overrideExisting")
    def override_existing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to override an existing addon installation. Defaults to false. If set to true, any existing addon installation would be overridden as per new installation details.
        """
        return pulumi.get(self, "override_existing")

    @_builtins.property
    @pulumi.getter(name="removeAddonResourcesOnDelete")
    def remove_addon_resources_on_delete(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to remove addon resource in deletion.
        """
        return pulumi.get(self, "remove_addon_resources_on_delete")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the addon.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) The version of addon to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

