# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAddonOptionsResult',
    'AwaitableGetAddonOptionsResult',
    'get_addon_options',
    'get_addon_options_output',
]

@pulumi.output_type
class GetAddonOptionsResult:
    """
    A collection of values returned by getAddonOptions.
    """
    def __init__(__self__, addon_name=None, addon_options=None, filters=None, id=None, kubernetes_version=None, should_show_all_versions=None):
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if addon_options and not isinstance(addon_options, list):
            raise TypeError("Expected argument 'addon_options' to be a list")
        pulumi.set(__self__, "addon_options", addon_options)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if should_show_all_versions and not isinstance(should_show_all_versions, bool):
            raise TypeError("Expected argument 'should_show_all_versions' to be a bool")
        pulumi.set(__self__, "should_show_all_versions", should_show_all_versions)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "addon_name")

    @_builtins.property
    @pulumi.getter(name="addonOptions")
    def addon_options(self) -> Sequence['outputs.GetAddonOptionsAddonOptionResult']:
        """
        The list of addon_options.
        """
        return pulumi.get(self, "addon_options")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAddonOptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> _builtins.str:
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter(name="shouldShowAllVersions")
    def should_show_all_versions(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "should_show_all_versions")


class AwaitableGetAddonOptionsResult(GetAddonOptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonOptionsResult(
            addon_name=self.addon_name,
            addon_options=self.addon_options,
            filters=self.filters,
            id=self.id,
            kubernetes_version=self.kubernetes_version,
            should_show_all_versions=self.should_show_all_versions)


def get_addon_options(addon_name: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetAddonOptionsFilterArgs', 'GetAddonOptionsFilterArgsDict']]] = None,
                      kubernetes_version: Optional[_builtins.str] = None,
                      should_show_all_versions: Optional[_builtins.bool] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonOptionsResult:
    """
    This data source provides the list of Addon Options in Oracle Cloud Infrastructure Container Engine service.

    Get list of supported addons for a specific kubernetes version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_addon_options = oci.ContainerEngine.get_addon_options(kubernetes_version=addon_option_kubernetes_version,
        addon_name=test_addon["name"],
        should_show_all_versions=addon_option_should_show_all_versions)
    ```


    :param _builtins.str addon_name: The name of the addon.
    :param _builtins.str kubernetes_version: The kubernetes version to fetch the addons.
    :param _builtins.bool should_show_all_versions: Whether to show all add-on versions
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['filters'] = filters
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['shouldShowAllVersions'] = should_show_all_versions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getAddonOptions:getAddonOptions', __args__, opts=opts, typ=GetAddonOptionsResult).value

    return AwaitableGetAddonOptionsResult(
        addon_name=pulumi.get(__ret__, 'addon_name'),
        addon_options=pulumi.get(__ret__, 'addon_options'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        should_show_all_versions=pulumi.get(__ret__, 'should_show_all_versions'))
def get_addon_options_output(addon_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAddonOptionsFilterArgs', 'GetAddonOptionsFilterArgsDict']]]]] = None,
                             kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                             should_show_all_versions: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddonOptionsResult]:
    """
    This data source provides the list of Addon Options in Oracle Cloud Infrastructure Container Engine service.

    Get list of supported addons for a specific kubernetes version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_addon_options = oci.ContainerEngine.get_addon_options(kubernetes_version=addon_option_kubernetes_version,
        addon_name=test_addon["name"],
        should_show_all_versions=addon_option_should_show_all_versions)
    ```


    :param _builtins.str addon_name: The name of the addon.
    :param _builtins.str kubernetes_version: The kubernetes version to fetch the addons.
    :param _builtins.bool should_show_all_versions: Whether to show all add-on versions
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['filters'] = filters
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['shouldShowAllVersions'] = should_show_all_versions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getAddonOptions:getAddonOptions', __args__, opts=opts, typ=GetAddonOptionsResult)
    return __ret__.apply(lambda __response__: GetAddonOptionsResult(
        addon_name=pulumi.get(__response__, 'addon_name'),
        addon_options=pulumi.get(__response__, 'addon_options'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        should_show_all_versions=pulumi.get(__response__, 'should_show_all_versions')))
