# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CaptureFilterArgs', 'CaptureFilter']

@pulumi.input_type
class CaptureFilterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 filter_type: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]] = None):
        """
        The set of arguments for constructing a CaptureFilter resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[_builtins.str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]] flow_log_capture_filter_rules: (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "filter_type", filter_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if flow_log_capture_filter_rules is not None:
            pulumi.set(__self__, "flow_log_capture_filter_rules", flow_log_capture_filter_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if vtap_capture_filter_rules is not None:
            pulumi.set(__self__, "vtap_capture_filter_rules", vtap_capture_filter_rules)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="flowLogCaptureFilterRules")
    def flow_log_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        """
        return pulumi.get(self, "flow_log_capture_filter_rules")

    @flow_log_capture_filter_rules.setter
    def flow_log_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "flow_log_capture_filter_rules", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

    @vtap_capture_filter_rules.setter
    def vtap_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "vtap_capture_filter_rules", value)


@pulumi.input_type
class _CaptureFilterState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering CaptureFilter resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]] flow_log_capture_filter_rules: (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] state: The capture filter's current administrative state.
        :param pulumi.Input[_builtins.str] time_created: The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if flow_log_capture_filter_rules is not None:
            pulumi.set(__self__, "flow_log_capture_filter_rules", flow_log_capture_filter_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vtap_capture_filter_rules is not None:
            pulumi.set(__self__, "vtap_capture_filter_rules", vtap_capture_filter_rules)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter(name="flowLogCaptureFilterRules")
    def flow_log_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        """
        return pulumi.get(self, "flow_log_capture_filter_rules")

    @flow_log_capture_filter_rules.setter
    def flow_log_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterFlowLogCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "flow_log_capture_filter_rules", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The capture filter's current administrative state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

    @vtap_capture_filter_rules.setter
    def vtap_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "vtap_capture_filter_rules", value)


@pulumi.type_token("oci:Core/captureFilter:CaptureFilter")
class CaptureFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterFlowLogCaptureFilterRuleArgs', 'CaptureFilterFlowLogCaptureFilterRuleArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterVtapCaptureFilterRuleArgs', 'CaptureFilterVtapCaptureFilterRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_capture_filter = oci.core.CaptureFilter("test_capture_filter",
            compartment_id=compartment_id,
            filter_type=capture_filter_filter_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=capture_filter_display_name,
            flow_log_capture_filter_rules=[{
                "destination_cidr": capture_filter_flow_log_capture_filter_rules_destination_cidr,
                "flow_log_type": capture_filter_flow_log_capture_filter_rules_flow_log_type,
                "icmp_options": {
                    "type": capture_filter_flow_log_capture_filter_rules_icmp_options_type,
                    "code": capture_filter_flow_log_capture_filter_rules_icmp_options_code,
                },
                "is_enabled": capture_filter_flow_log_capture_filter_rules_is_enabled,
                "priority": capture_filter_flow_log_capture_filter_rules_priority,
                "protocol": capture_filter_flow_log_capture_filter_rules_protocol,
                "rule_action": capture_filter_flow_log_capture_filter_rules_rule_action,
                "sampling_rate": capture_filter_flow_log_capture_filter_rules_sampling_rate,
                "source_cidr": capture_filter_flow_log_capture_filter_rules_source_cidr,
                "tcp_options": {
                    "destination_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_tcp_options_destination_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_tcp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_tcp_options_source_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "destination_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_udp_options_destination_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_udp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_udp_options_source_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_udp_options_source_port_range_min,
                    },
                },
            }],
            freeform_tags={
                "Department": "Finance",
            },
            vtap_capture_filter_rules=[{
                "traffic_direction": capture_filter_vtap_capture_filter_rules_traffic_direction,
                "destination_cidr": capture_filter_vtap_capture_filter_rules_destination_cidr,
                "icmp_options": {
                    "type": capture_filter_vtap_capture_filter_rules_icmp_options_type,
                    "code": capture_filter_vtap_capture_filter_rules_icmp_options_code,
                },
                "protocol": capture_filter_vtap_capture_filter_rules_protocol,
                "rule_action": capture_filter_vtap_capture_filter_rules_rule_action,
                "source_cidr": capture_filter_vtap_capture_filter_rules_source_cidr,
                "tcp_options": {
                    "destination_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "destination_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_min,
                    },
                },
            }])
        ```

        ## Import

        CaptureFilters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/captureFilter:CaptureFilter test_capture_filter "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterFlowLogCaptureFilterRuleArgs', 'CaptureFilterFlowLogCaptureFilterRuleArgsDict']]]] flow_log_capture_filter_rules: (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterVtapCaptureFilterRuleArgs', 'CaptureFilterVtapCaptureFilterRuleArgsDict']]]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaptureFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_capture_filter = oci.core.CaptureFilter("test_capture_filter",
            compartment_id=compartment_id,
            filter_type=capture_filter_filter_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=capture_filter_display_name,
            flow_log_capture_filter_rules=[{
                "destination_cidr": capture_filter_flow_log_capture_filter_rules_destination_cidr,
                "flow_log_type": capture_filter_flow_log_capture_filter_rules_flow_log_type,
                "icmp_options": {
                    "type": capture_filter_flow_log_capture_filter_rules_icmp_options_type,
                    "code": capture_filter_flow_log_capture_filter_rules_icmp_options_code,
                },
                "is_enabled": capture_filter_flow_log_capture_filter_rules_is_enabled,
                "priority": capture_filter_flow_log_capture_filter_rules_priority,
                "protocol": capture_filter_flow_log_capture_filter_rules_protocol,
                "rule_action": capture_filter_flow_log_capture_filter_rules_rule_action,
                "sampling_rate": capture_filter_flow_log_capture_filter_rules_sampling_rate,
                "source_cidr": capture_filter_flow_log_capture_filter_rules_source_cidr,
                "tcp_options": {
                    "destination_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_tcp_options_destination_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_tcp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_tcp_options_source_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "destination_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_udp_options_destination_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_udp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_flow_log_capture_filter_rules_udp_options_source_port_range_max,
                        "min": capture_filter_flow_log_capture_filter_rules_udp_options_source_port_range_min,
                    },
                },
            }],
            freeform_tags={
                "Department": "Finance",
            },
            vtap_capture_filter_rules=[{
                "traffic_direction": capture_filter_vtap_capture_filter_rules_traffic_direction,
                "destination_cidr": capture_filter_vtap_capture_filter_rules_destination_cidr,
                "icmp_options": {
                    "type": capture_filter_vtap_capture_filter_rules_icmp_options_type,
                    "code": capture_filter_vtap_capture_filter_rules_icmp_options_code,
                },
                "protocol": capture_filter_vtap_capture_filter_rules_protocol,
                "rule_action": capture_filter_vtap_capture_filter_rules_rule_action,
                "source_cidr": capture_filter_vtap_capture_filter_rules_source_cidr,
                "tcp_options": {
                    "destination_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "destination_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_min,
                    },
                    "source_port_range": {
                        "max": capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_max,
                        "min": capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_min,
                    },
                },
            }])
        ```

        ## Import

        CaptureFilters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/captureFilter:CaptureFilter test_capture_filter "id"
        ```

        :param str resource_name: The name of the resource.
        :param CaptureFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaptureFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterFlowLogCaptureFilterRuleArgs', 'CaptureFilterFlowLogCaptureFilterRuleArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterVtapCaptureFilterRuleArgs', 'CaptureFilterVtapCaptureFilterRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaptureFilterArgs.__new__(CaptureFilterArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if filter_type is None and not opts.urn:
                raise TypeError("Missing required property 'filter_type'")
            __props__.__dict__["filter_type"] = filter_type
            __props__.__dict__["flow_log_capture_filter_rules"] = flow_log_capture_filter_rules
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["vtap_capture_filter_rules"] = vtap_capture_filter_rules
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(CaptureFilter, __self__).__init__(
            'oci:Core/captureFilter:CaptureFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            filter_type: Optional[pulumi.Input[_builtins.str]] = None,
            flow_log_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterFlowLogCaptureFilterRuleArgs', 'CaptureFilterFlowLogCaptureFilterRuleArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterVtapCaptureFilterRuleArgs', 'CaptureFilterVtapCaptureFilterRuleArgsDict']]]]] = None) -> 'CaptureFilter':
        """
        Get an existing CaptureFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterFlowLogCaptureFilterRuleArgs', 'CaptureFilterFlowLogCaptureFilterRuleArgsDict']]]] flow_log_capture_filter_rules: (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] state: The capture filter's current administrative state.
        :param pulumi.Input[_builtins.str] time_created: The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CaptureFilterVtapCaptureFilterRuleArgs', 'CaptureFilterVtapCaptureFilterRuleArgsDict']]]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaptureFilterState.__new__(_CaptureFilterState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filter_type"] = filter_type
        __props__.__dict__["flow_log_capture_filter_rules"] = flow_log_capture_filter_rules
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vtap_capture_filter_rules"] = vtap_capture_filter_rules
        return CaptureFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @_builtins.property
    @pulumi.getter(name="flowLogCaptureFilterRules")
    def flow_log_capture_filter_rules(self) -> pulumi.Output[Sequence['outputs.CaptureFilterFlowLogCaptureFilterRule']]:
        """
        (Updatable) The set of rules governing what traffic the Flow Log collects when creating a flow log capture filter.
        """
        return pulumi.get(self, "flow_log_capture_filter_rules")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The capture filter's current administrative state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> pulumi.Output[Sequence['outputs.CaptureFilterVtapCaptureFilterRule']]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

