# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeHostArgs', 'ComputeHost']

@pulumi.input_type
class ComputeHostArgs:
    def __init__(__self__, *,
                 compute_host_id: pulumi.Input[_builtins.str],
                 compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeHost resource.
        :param pulumi.Input[_builtins.str] compute_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        :param pulumi.Input[_builtins.str] compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        """
        pulumi.set(__self__, "compute_host_id", compute_host_id)
        if compute_host_group_id is not None:
            pulumi.set(__self__, "compute_host_group_id", compute_host_group_id)

    @_builtins.property
    @pulumi.getter(name="computeHostId")
    def compute_host_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        """
        return pulumi.get(self, "compute_host_id")

    @compute_host_id.setter
    def compute_host_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_host_id", value)

    @_builtins.property
    @pulumi.getter(name="computeHostGroupId")
    def compute_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        """
        return pulumi.get(self, "compute_host_group_id")

    @compute_host_group_id.setter
    def compute_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_host_group_id", value)


@pulumi.input_type
class _ComputeHostState:
    def __init__(__self__, *,
                 additional_data: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostConfigurationDataArgs']]]] = None,
                 configuration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 hpc_island_id: Optional[pulumi.Input[_builtins.str]] = None,
                 impacted_component_details: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_block_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_block_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recycle_details: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostRecycleDetailArgs']]]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_configuration_check: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeHost resources.
        :param pulumi.Input[_builtins.str] additional_data: Additional data that can be exposed to the customer.  Will include raw fault codes for strategic customers
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the compute host.  Example: `Uocm:US-CHICAGO-1-AD-2`
        :param pulumi.Input[_builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Capacity Reserver that is currently on host
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[_builtins.str] compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        :param pulumi.Input[_builtins.str] compute_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeHostConfigurationDataArgs']]] configuration_datas: Compute Host Configuration Data
        :param pulumi.Input[_builtins.str] configuration_state: Configuration state of the Compute Bare Metal Host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique GPU Memory Fabric
        :param pulumi.Input[_builtins.str] health: The heathy state of the host
        :param pulumi.Input[_builtins.str] hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        :param pulumi.Input[_builtins.str] impacted_component_details: A list that contains impacted components related to an unhealthy host. An impacted component will be a  free-form structure of key values pairs that will provide more or less details based on data tiering
        :param pulumi.Input[_builtins.str] instance_id: The public [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Virtual Machine or Bare Metal instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lifecycle_details: A free-form description detailing why the host is in its current state.
        :param pulumi.Input[_builtins.str] local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        :param pulumi.Input[_builtins.str] network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        :param pulumi.Input[Sequence[pulumi.Input['ComputeHostRecycleDetailArgs']]] recycle_details: Shows details about the last recycle performed on this host.
        :param pulumi.Input[_builtins.str] shape: The shape of host
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the host
        :param pulumi.Input[_builtins.str] time_configuration_check: The date and time that the compute bare metal host configuration check was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time that the compute host record was created, in the format defined by [RFC3339](https://tools .ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the compute host record was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if additional_data is not None:
            pulumi.set(__self__, "additional_data", additional_data)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_host_group_id is not None:
            pulumi.set(__self__, "compute_host_group_id", compute_host_group_id)
        if compute_host_id is not None:
            pulumi.set(__self__, "compute_host_id", compute_host_id)
        if configuration_datas is not None:
            pulumi.set(__self__, "configuration_datas", configuration_datas)
        if configuration_state is not None:
            pulumi.set(__self__, "configuration_state", configuration_state)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpu_memory_fabric_id is not None:
            pulumi.set(__self__, "gpu_memory_fabric_id", gpu_memory_fabric_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if hpc_island_id is not None:
            pulumi.set(__self__, "hpc_island_id", hpc_island_id)
        if impacted_component_details is not None:
            pulumi.set(__self__, "impacted_component_details", impacted_component_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if local_block_id is not None:
            pulumi.set(__self__, "local_block_id", local_block_id)
        if network_block_id is not None:
            pulumi.set(__self__, "network_block_id", network_block_id)
        if recycle_details is not None:
            pulumi.set(__self__, "recycle_details", recycle_details)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_configuration_check is not None:
            pulumi.set(__self__, "time_configuration_check", time_configuration_check)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional data that can be exposed to the customer.  Will include raw fault codes for strategic customers
        """
        return pulumi.get(self, "additional_data")

    @additional_data.setter
    def additional_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_data", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain of the compute host.  Example: `Uocm:US-CHICAGO-1-AD-2`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Capacity Reserver that is currently on host
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeHostGroupId")
    def compute_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        """
        return pulumi.get(self, "compute_host_group_id")

    @compute_host_group_id.setter
    def compute_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="computeHostId")
    def compute_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        """
        return pulumi.get(self, "compute_host_id")

    @compute_host_id.setter
    def compute_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_host_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationDatas")
    def configuration_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostConfigurationDataArgs']]]]:
        """
        Compute Host Configuration Data
        """
        return pulumi.get(self, "configuration_datas")

    @configuration_datas.setter
    def configuration_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostConfigurationDataArgs']]]]):
        pulumi.set(self, "configuration_datas", value)

    @_builtins.property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration state of the Compute Bare Metal Host.
        """
        return pulumi.get(self, "configuration_state")

    @configuration_state.setter
    def configuration_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_state", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique GPU Memory Fabric
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @gpu_memory_fabric_id.setter
    def gpu_memory_fabric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_memory_fabric_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The heathy state of the host
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="hpcIslandId")
    def hpc_island_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "hpc_island_id")

    @hpc_island_id.setter
    def hpc_island_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hpc_island_id", value)

    @_builtins.property
    @pulumi.getter(name="impactedComponentDetails")
    def impacted_component_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list that contains impacted components related to an unhealthy host. An impacted component will be a  free-form structure of key values pairs that will provide more or less details based on data tiering
        """
        return pulumi.get(self, "impacted_component_details")

    @impacted_component_details.setter
    def impacted_component_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "impacted_component_details", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Virtual Machine or Bare Metal instance
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A free-form description detailing why the host is in its current state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="localBlockId")
    def local_block_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        """
        return pulumi.get(self, "local_block_id")

    @local_block_id.setter
    def local_block_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_block_id", value)

    @_builtins.property
    @pulumi.getter(name="networkBlockId")
    def network_block_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "network_block_id")

    @network_block_id.setter
    def network_block_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_block_id", value)

    @_builtins.property
    @pulumi.getter(name="recycleDetails")
    def recycle_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostRecycleDetailArgs']]]]:
        """
        Shows details about the last recycle performed on this host.
        """
        return pulumi.get(self, "recycle_details")

    @recycle_details.setter
    def recycle_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeHostRecycleDetailArgs']]]]):
        pulumi.set(self, "recycle_details", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape of host
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle state of the host
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeConfigurationCheck")
    def time_configuration_check(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the compute bare metal host configuration check was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_configuration_check")

    @time_configuration_check.setter
    def time_configuration_check(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_configuration_check", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the compute host record was created, in the format defined by [RFC3339](https://tools .ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the compute host record was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Core/computeHost:ComputeHost")
class ComputeHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ComputeHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeHost:ComputeHost test_compute_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        :param pulumi.Input[_builtins.str] compute_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ComputeHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeHost:ComputeHost test_compute_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param ComputeHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeHostArgs.__new__(ComputeHostArgs)

            __props__.__dict__["compute_host_group_id"] = compute_host_group_id
            if compute_host_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_host_id'")
            __props__.__dict__["compute_host_id"] = compute_host_id
            __props__.__dict__["additional_data"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["capacity_reservation_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["configuration_datas"] = None
            __props__.__dict__["configuration_state"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["fault_domain"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["gpu_memory_fabric_id"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["hpc_island_id"] = None
            __props__.__dict__["impacted_component_details"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["local_block_id"] = None
            __props__.__dict__["network_block_id"] = None
            __props__.__dict__["recycle_details"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_configuration_check"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ComputeHost, __self__).__init__(
            'oci:Core/computeHost:ComputeHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_data: Optional[pulumi.Input[_builtins.str]] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_reservation_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeHostConfigurationDataArgs', 'ComputeHostConfigurationDataArgsDict']]]]] = None,
            configuration_state: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            hpc_island_id: Optional[pulumi.Input[_builtins.str]] = None,
            impacted_component_details: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            local_block_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_block_id: Optional[pulumi.Input[_builtins.str]] = None,
            recycle_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeHostRecycleDetailArgs', 'ComputeHostRecycleDetailArgsDict']]]]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_configuration_check: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeHost':
        """
        Get an existing ComputeHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_data: Additional data that can be exposed to the customer.  Will include raw fault codes for strategic customers
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the compute host.  Example: `Uocm:US-CHICAGO-1-AD-2`
        :param pulumi.Input[_builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Capacity Reserver that is currently on host
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[_builtins.str] compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        :param pulumi.Input[_builtins.str] compute_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeHostConfigurationDataArgs', 'ComputeHostConfigurationDataArgsDict']]]] configuration_datas: Compute Host Configuration Data
        :param pulumi.Input[_builtins.str] configuration_state: Configuration state of the Compute Bare Metal Host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique GPU Memory Fabric
        :param pulumi.Input[_builtins.str] health: The heathy state of the host
        :param pulumi.Input[_builtins.str] hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        :param pulumi.Input[_builtins.str] impacted_component_details: A list that contains impacted components related to an unhealthy host. An impacted component will be a  free-form structure of key values pairs that will provide more or less details based on data tiering
        :param pulumi.Input[_builtins.str] instance_id: The public [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Virtual Machine or Bare Metal instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lifecycle_details: A free-form description detailing why the host is in its current state.
        :param pulumi.Input[_builtins.str] local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        :param pulumi.Input[_builtins.str] network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeHostRecycleDetailArgs', 'ComputeHostRecycleDetailArgsDict']]]] recycle_details: Shows details about the last recycle performed on this host.
        :param pulumi.Input[_builtins.str] shape: The shape of host
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the host
        :param pulumi.Input[_builtins.str] time_configuration_check: The date and time that the compute bare metal host configuration check was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time that the compute host record was created, in the format defined by [RFC3339](https://tools .ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the compute host record was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeHostState.__new__(_ComputeHostState)

        __props__.__dict__["additional_data"] = additional_data
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_host_group_id"] = compute_host_group_id
        __props__.__dict__["compute_host_id"] = compute_host_id
        __props__.__dict__["configuration_datas"] = configuration_datas
        __props__.__dict__["configuration_state"] = configuration_state
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gpu_memory_fabric_id"] = gpu_memory_fabric_id
        __props__.__dict__["health"] = health
        __props__.__dict__["hpc_island_id"] = hpc_island_id
        __props__.__dict__["impacted_component_details"] = impacted_component_details
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["local_block_id"] = local_block_id
        __props__.__dict__["network_block_id"] = network_block_id
        __props__.__dict__["recycle_details"] = recycle_details
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["time_configuration_check"] = time_configuration_check
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ComputeHost(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> pulumi.Output[_builtins.str]:
        """
        Additional data that can be exposed to the customer.  Will include raw fault codes for strategic customers
        """
        return pulumi.get(self, "additional_data")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain of the compute host.  Example: `Uocm:US-CHICAGO-1-AD-2`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Capacity Reserver that is currently on host
        """
        return pulumi.get(self, "capacity_reservation_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeHostGroupId")
    def compute_host_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group this host was attached to at the time of recycle.
        """
        return pulumi.get(self, "compute_host_group_id")

    @_builtins.property
    @pulumi.getter(name="computeHostId")
    def compute_host_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host.
        """
        return pulumi.get(self, "compute_host_id")

    @_builtins.property
    @pulumi.getter(name="configurationDatas")
    def configuration_datas(self) -> pulumi.Output[Sequence['outputs.ComputeHostConfigurationData']]:
        """
        Compute Host Configuration Data
        """
        return pulumi.get(self, "configuration_datas")

    @_builtins.property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> pulumi.Output[_builtins.str]:
        """
        Configuration state of the Compute Bare Metal Host.
        """
        return pulumi.get(self, "configuration_state")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[_builtins.str]:
        """
        A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique GPU Memory Fabric
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        The heathy state of the host
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hpcIslandId")
    def hpc_island_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "hpc_island_id")

    @_builtins.property
    @pulumi.getter(name="impactedComponentDetails")
    def impacted_component_details(self) -> pulumi.Output[_builtins.str]:
        """
        A list that contains impacted components related to an unhealthy host. An impacted component will be a  free-form structure of key values pairs that will provide more or less details based on data tiering
        """
        return pulumi.get(self, "impacted_component_details")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The public [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Virtual Machine or Bare Metal instance
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A free-form description detailing why the host is in its current state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="localBlockId")
    def local_block_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        """
        return pulumi.get(self, "local_block_id")

    @_builtins.property
    @pulumi.getter(name="networkBlockId")
    def network_block_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "network_block_id")

    @_builtins.property
    @pulumi.getter(name="recycleDetails")
    def recycle_details(self) -> pulumi.Output[Sequence['outputs.ComputeHostRecycleDetail']]:
        """
        Shows details about the last recycle performed on this host.
        """
        return pulumi.get(self, "recycle_details")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The shape of host
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The lifecycle state of the host
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeConfigurationCheck")
    def time_configuration_check(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the compute bare metal host configuration check was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_configuration_check")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the compute host record was created, in the format defined by [RFC3339](https://tools .ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the compute host record was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

