# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetByoasnsResult',
    'AwaitableGetByoasnsResult',
    'get_byoasns',
    'get_byoasns_output',
]

@pulumi.output_type
class GetByoasnsResult:
    """
    A collection of values returned by getByoasns.
    """
    def __init__(__self__, byoasn_collections=None, compartment_id=None, filters=None, id=None):
        if byoasn_collections and not isinstance(byoasn_collections, list):
            raise TypeError("Expected argument 'byoasn_collections' to be a list")
        pulumi.set(__self__, "byoasn_collections", byoasn_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="byoasnCollections")
    def byoasn_collections(self) -> Sequence['outputs.GetByoasnsByoasnCollectionResult']:
        """
        The list of byoasn_collection.
        """
        return pulumi.get(self, "byoasn_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Byoasn` resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetByoasnsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetByoasnsResult(GetByoasnsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoasnsResult(
            byoasn_collections=self.byoasn_collections,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_byoasns(compartment_id: Optional[_builtins.str] = None,
                filters: Optional[Sequence[Union['GetByoasnsFilterArgs', 'GetByoasnsFilterArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoasnsResult:
    """
    This data source provides the list of Byoasns in Oracle Cloud Infrastructure Core service.

    Lists the `Byoasn` resources in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getByoasns:getByoasns', __args__, opts=opts, typ=GetByoasnsResult).value

    return AwaitableGetByoasnsResult(
        byoasn_collections=pulumi.get(__ret__, 'byoasn_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_byoasns_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetByoasnsFilterArgs', 'GetByoasnsFilterArgsDict']]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetByoasnsResult]:
    """
    This data source provides the list of Byoasns in Oracle Cloud Infrastructure Core service.

    Lists the `Byoasn` resources in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getByoasns:getByoasns', __args__, opts=opts, typ=GetByoasnsResult)
    return __ret__.apply(lambda __response__: GetByoasnsResult(
        byoasn_collections=pulumi.get(__response__, 'byoasn_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
