# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceConsoleConnectionArgs', 'InstanceConsoleConnection']

@pulumi.input_type
class InstanceConsoleConnectionArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 public_key: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InstanceConsoleConnection resource.
        :param pulumi.Input[_builtins.str] instance_id: The OCID of the instance to create the console connection to.
        :param pulumi.Input[_builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "public_key", public_key)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the instance to create the console connection to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[_builtins.str]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _InstanceConsoleConnectionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vnc_connection_string: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceConsoleConnection resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to contain the console connection.
        :param pulumi.Input[_builtins.str] connection_string: The SSH connection string for the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] fingerprint: The SSH public key's fingerprint for client authentication to the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] instance_id: The OCID of the instance to create the console connection to.
        :param pulumi.Input[_builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] service_host_key_fingerprint: The SSH public key's fingerprint for the console connection service host.
        :param pulumi.Input[_builtins.str] state: The current state of the console connection.
        :param pulumi.Input[_builtins.str] vnc_connection_string: The SSH connection string for the SSH tunnel used to connect to the console connection over VNC.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if service_host_key_fingerprint is not None:
            pulumi.set(__self__, "service_host_key_fingerprint", service_host_key_fingerprint)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vnc_connection_string is not None:
            pulumi.set(__self__, "vnc_connection_string", vnc_connection_string)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH connection string for the console connection.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH public key's fingerprint for client authentication to the console connection.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the instance to create the console connection to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="serviceHostKeyFingerprint")
    def service_host_key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH public key's fingerprint for the console connection service host.
        """
        return pulumi.get(self, "service_host_key_fingerprint")

    @service_host_key_fingerprint.setter
    def service_host_key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_host_key_fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the console connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vncConnectionString")
    def vnc_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH connection string for the SSH tunnel used to connect to the console connection over VNC.
        """
        return pulumi.get(self, "vnc_connection_string")

    @vnc_connection_string.setter
    def vnc_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnc_connection_string", value)


@pulumi.type_token("oci:Core/instanceConsoleConnection:InstanceConsoleConnection")
class InstanceConsoleConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_console_connection = oci.core.InstanceConsoleConnection("test_instance_console_connection",
            instance_id=test_instance["id"],
            public_key=instance_console_connection_public_key,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        InstanceConsoleConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceConsoleConnection:InstanceConsoleConnection test_instance_console_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] instance_id: The OCID of the instance to create the console connection to.
        :param pulumi.Input[_builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceConsoleConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_console_connection = oci.core.InstanceConsoleConnection("test_instance_console_connection",
            instance_id=test_instance["id"],
            public_key=instance_console_connection_public_key,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        InstanceConsoleConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceConsoleConnection:InstanceConsoleConnection test_instance_console_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceConsoleConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceConsoleConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceConsoleConnectionArgs.__new__(InstanceConsoleConnectionArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["service_host_key_fingerprint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["vnc_connection_string"] = None
        super(InstanceConsoleConnection, __self__).__init__(
            'oci:Core/instanceConsoleConnection:InstanceConsoleConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            service_host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vnc_connection_string: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceConsoleConnection':
        """
        Get an existing InstanceConsoleConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to contain the console connection.
        :param pulumi.Input[_builtins.str] connection_string: The SSH connection string for the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] fingerprint: The SSH public key's fingerprint for client authentication to the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] instance_id: The OCID of the instance to create the console connection to.
        :param pulumi.Input[_builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] service_host_key_fingerprint: The SSH public key's fingerprint for the console connection service host.
        :param pulumi.Input[_builtins.str] state: The current state of the console connection.
        :param pulumi.Input[_builtins.str] vnc_connection_string: The SSH connection string for the SSH tunnel used to connect to the console connection over VNC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceConsoleConnectionState.__new__(_InstanceConsoleConnectionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["service_host_key_fingerprint"] = service_host_key_fingerprint
        __props__.__dict__["state"] = state
        __props__.__dict__["vnc_connection_string"] = vnc_connection_string
        return InstanceConsoleConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH connection string for the console connection.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH public key's fingerprint for client authentication to the console connection.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the instance to create the console connection to.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="serviceHostKeyFingerprint")
    def service_host_key_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH public key's fingerprint for the console connection service host.
        """
        return pulumi.get(self, "service_host_key_fingerprint")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the console connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vncConnectionString")
    def vnc_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH connection string for the SSH tunnel used to connect to the console connection over VNC.
        """
        return pulumi.get(self, "vnc_connection_string")

