# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpsecConnectionTunnelManagementArgs', 'IpsecConnectionTunnelManagement']

@pulumi.input_type
class IpsecConnectionTunnelManagementArgs:
    def __init__(__self__, *,
                 ipsec_id: pulumi.Input[_builtins.str],
                 tunnel_id: pulumi.Input[_builtins.str],
                 bgp_session_info: Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]] = None,
                 encryption_domain_config: Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_translation_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_can_initiate: Optional[pulumi.Input[_builtins.str]] = None,
                 phase_one_details: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']] = None,
                 phase_two_details: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']] = None,
                 routing: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpsecConnectionTunnelManagement resource.
        :param pulumi.Input[_builtins.str] ipsec_id: The OCID of the IPSec connection.
        :param pulumi.Input[_builtins.str] tunnel_id: The OCID of the IPSec connection's tunnel.
        :param pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs'] bgp_session_info: Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.
               
               If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs'] encryption_domain_config: Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        :param pulumi.Input[_builtins.str] ike_version: Internet Key Exchange protocol version.
        :param pulumi.Input[_builtins.str] nat_translation_enabled: By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.
               
               The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.
               
               The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        :param pulumi.Input[_builtins.str] oracle_can_initiate: Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        :param pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs'] phase_one_details: Configuration details for IKE phase one (ISAKMP) configuration parameters. 
               
               See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        :param pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs'] phase_two_details: Configuration details for IPSec phase two configuration parameters.
               
               See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        :param pulumi.Input[_builtins.str] routing: The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        :param pulumi.Input[_builtins.str] shared_secret: The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        """
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if bgp_session_info is not None:
            pulumi.set(__self__, "bgp_session_info", bgp_session_info)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dpd_configs is not None:
            pulumi.set(__self__, "dpd_configs", dpd_configs)
        if encryption_domain_config is not None:
            pulumi.set(__self__, "encryption_domain_config", encryption_domain_config)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if nat_translation_enabled is not None:
            pulumi.set(__self__, "nat_translation_enabled", nat_translation_enabled)
        if oracle_can_initiate is not None:
            pulumi.set(__self__, "oracle_can_initiate", oracle_can_initiate)
        if phase_one_details is not None:
            pulumi.set(__self__, "phase_one_details", phase_one_details)
        if phase_two_details is not None:
            pulumi.set(__self__, "phase_two_details", phase_two_details)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if shared_secret is not None:
            pulumi.set(__self__, "shared_secret", shared_secret)

    @_builtins.property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the IPSec connection.
        """
        return pulumi.get(self, "ipsec_id")

    @ipsec_id.setter
    def ipsec_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipsec_id", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the IPSec connection's tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter(name="bgpSessionInfo")
    def bgp_session_info(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']]:
        """
        Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.

        If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        """
        return pulumi.get(self, "bgp_session_info")

    @bgp_session_info.setter
    def bgp_session_info(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']]):
        pulumi.set(self, "bgp_session_info", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dpdConfigs")
    def dpd_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]]:
        return pulumi.get(self, "dpd_configs")

    @dpd_configs.setter
    def dpd_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]]):
        pulumi.set(self, "dpd_configs", value)

    @_builtins.property
    @pulumi.getter(name="encryptionDomainConfig")
    def encryption_domain_config(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']]:
        """
        Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        """
        return pulumi.get(self, "encryption_domain_config")

    @encryption_domain_config.setter
    def encryption_domain_config(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']]):
        pulumi.set(self, "encryption_domain_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet Key Exchange protocol version.
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="natTranslationEnabled")
    def nat_translation_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.

        The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.

        The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        """
        return pulumi.get(self, "nat_translation_enabled")

    @nat_translation_enabled.setter
    def nat_translation_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_translation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="oracleCanInitiate")
    def oracle_can_initiate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        """
        return pulumi.get(self, "oracle_can_initiate")

    @oracle_can_initiate.setter
    def oracle_can_initiate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oracle_can_initiate", value)

    @_builtins.property
    @pulumi.getter(name="phaseOneDetails")
    def phase_one_details(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']]:
        """
        Configuration details for IKE phase one (ISAKMP) configuration parameters. 

        See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        """
        return pulumi.get(self, "phase_one_details")

    @phase_one_details.setter
    def phase_one_details(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']]):
        pulumi.set(self, "phase_one_details", value)

    @_builtins.property
    @pulumi.getter(name="phaseTwoDetails")
    def phase_two_details(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']]:
        """
        Configuration details for IPSec phase two configuration parameters.

        See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        """
        return pulumi.get(self, "phase_two_details")

    @phase_two_details.setter
    def phase_two_details(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']]):
        pulumi.set(self, "phase_two_details", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="sharedSecret")
    def shared_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        """
        return pulumi.get(self, "shared_secret")

    @shared_secret.setter
    def shared_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_secret", value)


@pulumi.input_type
class _IpsecConnectionTunnelManagementState:
    def __init__(__self__, *,
                 associated_virtual_circuits: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bgp_session_info: Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpe_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]] = None,
                 dpd_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_timeout_in_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 encryption_domain_config: Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_translation_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_can_initiate: Optional[pulumi.Input[_builtins.str]] = None,
                 phase_one_details: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']] = None,
                 phase_two_details: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']] = None,
                 routing: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_status_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpsecConnectionTunnelManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_virtual_circuits: The list of virtual circuit [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s over which your network can reach this tunnel.
        :param pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs'] bgp_session_info: Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.
               
               If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the tunnel.
        :param pulumi.Input[_builtins.str] cpe_ip: The IP address of the CPE device's VPN headend.  Example: `203.0.113.22`
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dpd_mode: Dead peer detection (DPD) mode set on the Oracle side of the connection.
        :param pulumi.Input[_builtins.int] dpd_timeout_in_sec: DPD timeout in seconds.
        :param pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs'] encryption_domain_config: Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        :param pulumi.Input[_builtins.str] ike_version: Internet Key Exchange protocol version.
        :param pulumi.Input[_builtins.str] ipsec_id: The OCID of the IPSec connection.
        :param pulumi.Input[_builtins.str] nat_translation_enabled: By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.
               
               The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.
               
               The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        :param pulumi.Input[_builtins.str] oracle_can_initiate: Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        :param pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs'] phase_one_details: Configuration details for IKE phase one (ISAKMP) configuration parameters. 
               
               See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        :param pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs'] phase_two_details: Configuration details for IPSec phase two configuration parameters.
               
               See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        :param pulumi.Input[_builtins.str] routing: The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        :param pulumi.Input[_builtins.str] shared_secret: The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        :param pulumi.Input[_builtins.str] state: The IPSec connection's tunnel's lifecycle state.
        :param pulumi.Input[_builtins.str] status: The tunnel's current state.
        :param pulumi.Input[_builtins.str] time_created: The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_status_updated: When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] tunnel_id: The OCID of the IPSec connection's tunnel.
        :param pulumi.Input[_builtins.str] vpn_ip: The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        if associated_virtual_circuits is not None:
            pulumi.set(__self__, "associated_virtual_circuits", associated_virtual_circuits)
        if bgp_session_info is not None:
            pulumi.set(__self__, "bgp_session_info", bgp_session_info)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpe_ip is not None:
            pulumi.set(__self__, "cpe_ip", cpe_ip)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dpd_configs is not None:
            pulumi.set(__self__, "dpd_configs", dpd_configs)
        if dpd_mode is not None:
            pulumi.set(__self__, "dpd_mode", dpd_mode)
        if dpd_timeout_in_sec is not None:
            pulumi.set(__self__, "dpd_timeout_in_sec", dpd_timeout_in_sec)
        if encryption_domain_config is not None:
            pulumi.set(__self__, "encryption_domain_config", encryption_domain_config)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if ipsec_id is not None:
            pulumi.set(__self__, "ipsec_id", ipsec_id)
        if nat_translation_enabled is not None:
            pulumi.set(__self__, "nat_translation_enabled", nat_translation_enabled)
        if oracle_can_initiate is not None:
            pulumi.set(__self__, "oracle_can_initiate", oracle_can_initiate)
        if phase_one_details is not None:
            pulumi.set(__self__, "phase_one_details", phase_one_details)
        if phase_two_details is not None:
            pulumi.set(__self__, "phase_two_details", phase_two_details)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if shared_secret is not None:
            pulumi.set(__self__, "shared_secret", shared_secret)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_status_updated is not None:
            pulumi.set(__self__, "time_status_updated", time_status_updated)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if vpn_ip is not None:
            pulumi.set(__self__, "vpn_ip", vpn_ip)

    @_builtins.property
    @pulumi.getter(name="associatedVirtualCircuits")
    def associated_virtual_circuits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of virtual circuit [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s over which your network can reach this tunnel.
        """
        return pulumi.get(self, "associated_virtual_circuits")

    @associated_virtual_circuits.setter
    def associated_virtual_circuits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_virtual_circuits", value)

    @_builtins.property
    @pulumi.getter(name="bgpSessionInfo")
    def bgp_session_info(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']]:
        """
        Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.

        If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        """
        return pulumi.get(self, "bgp_session_info")

    @bgp_session_info.setter
    def bgp_session_info(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementBgpSessionInfoArgs']]):
        pulumi.set(self, "bgp_session_info", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the tunnel.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="cpeIp")
    def cpe_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the CPE device's VPN headend.  Example: `203.0.113.22`
        """
        return pulumi.get(self, "cpe_ip")

    @cpe_ip.setter
    def cpe_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpe_ip", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dpdConfigs")
    def dpd_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]]:
        return pulumi.get(self, "dpd_configs")

    @dpd_configs.setter
    def dpd_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecConnectionTunnelManagementDpdConfigArgs']]]]):
        pulumi.set(self, "dpd_configs", value)

    @_builtins.property
    @pulumi.getter(name="dpdMode")
    def dpd_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dead peer detection (DPD) mode set on the Oracle side of the connection.
        """
        return pulumi.get(self, "dpd_mode")

    @dpd_mode.setter
    def dpd_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dpd_mode", value)

    @_builtins.property
    @pulumi.getter(name="dpdTimeoutInSec")
    def dpd_timeout_in_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        DPD timeout in seconds.
        """
        return pulumi.get(self, "dpd_timeout_in_sec")

    @dpd_timeout_in_sec.setter
    def dpd_timeout_in_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dpd_timeout_in_sec", value)

    @_builtins.property
    @pulumi.getter(name="encryptionDomainConfig")
    def encryption_domain_config(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']]:
        """
        Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        """
        return pulumi.get(self, "encryption_domain_config")

    @encryption_domain_config.setter
    def encryption_domain_config(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs']]):
        pulumi.set(self, "encryption_domain_config", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet Key Exchange protocol version.
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the IPSec connection.
        """
        return pulumi.get(self, "ipsec_id")

    @ipsec_id.setter
    def ipsec_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_id", value)

    @_builtins.property
    @pulumi.getter(name="natTranslationEnabled")
    def nat_translation_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.

        The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.

        The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        """
        return pulumi.get(self, "nat_translation_enabled")

    @nat_translation_enabled.setter
    def nat_translation_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_translation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="oracleCanInitiate")
    def oracle_can_initiate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        """
        return pulumi.get(self, "oracle_can_initiate")

    @oracle_can_initiate.setter
    def oracle_can_initiate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oracle_can_initiate", value)

    @_builtins.property
    @pulumi.getter(name="phaseOneDetails")
    def phase_one_details(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']]:
        """
        Configuration details for IKE phase one (ISAKMP) configuration parameters. 

        See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        """
        return pulumi.get(self, "phase_one_details")

    @phase_one_details.setter
    def phase_one_details(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseOneDetailsArgs']]):
        pulumi.set(self, "phase_one_details", value)

    @_builtins.property
    @pulumi.getter(name="phaseTwoDetails")
    def phase_two_details(self) -> Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']]:
        """
        Configuration details for IPSec phase two configuration parameters.

        See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        """
        return pulumi.get(self, "phase_two_details")

    @phase_two_details.setter
    def phase_two_details(self, value: Optional[pulumi.Input['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs']]):
        pulumi.set(self, "phase_two_details", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="sharedSecret")
    def shared_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        """
        return pulumi.get(self, "shared_secret")

    @shared_secret.setter
    def shared_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_secret", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPSec connection's tunnel's lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tunnel's current state.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_status_updated")

    @time_status_updated.setter
    def time_status_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_status_updated", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the IPSec connection's tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnIp")
    def vpn_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "vpn_ip")

    @vpn_ip.setter
    def vpn_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_ip", value)


@pulumi.type_token("oci:Core/ipsecConnectionTunnelManagement:IpsecConnectionTunnelManagement")
class IpsecConnectionTunnelManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_session_info: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementBgpSessionInfoArgs', 'IpsecConnectionTunnelManagementBgpSessionInfoArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecConnectionTunnelManagementDpdConfigArgs', 'IpsecConnectionTunnelManagementDpdConfigArgsDict']]]]] = None,
                 encryption_domain_config: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs', 'IpsecConnectionTunnelManagementEncryptionDomainConfigArgsDict']]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_translation_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_can_initiate: Optional[pulumi.Input[_builtins.str]] = None,
                 phase_one_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseOneDetailsArgs', 'IpsecConnectionTunnelManagementPhaseOneDetailsArgsDict']]] = None,
                 phase_two_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs', 'IpsecConnectionTunnelManagementPhaseTwoDetailsArgsDict']]] = None,
                 routing: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ip_sec_connection_tunnel = oci.core.IpsecConnectionTunnelManagement("test_ip_sec_connection_tunnel",
            ipsec_id=test_ipsec["id"],
            tunnel_id=test_ip_sec_connection_tunnels["ipSecConnectionTunnels"][0]["id"],
            routing=ip_sec_connection_tunnel_management_routing,
            bgp_session_info={
                "customer_bgp_asn": ip_sec_connection_tunnel_management_bgp_session_info_customer_bgp_asn,
                "customer_interface_ip": ip_sec_connection_tunnel_management_bgp_session_info_customer_interface_ip,
                "oracle_interface_ip": ip_sec_connection_tunnel_management_bgp_session_info_oracle_interface_ip,
            },
            display_name=ip_sec_connection_tunnel_management_display_name,
            encryption_domain_config={
                "cpe_traffic_selectors": ip_sec_connection_tunnel_management_encryption_domain_config_cpe_traffic_selector,
                "oracle_traffic_selectors": ip_sec_connection_tunnel_management_encryption_domain_config_oracle_traffic_selector,
            },
            shared_secret=ip_sec_connection_tunnel_management_shared_secret,
            ike_version="V1")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementBgpSessionInfoArgs', 'IpsecConnectionTunnelManagementBgpSessionInfoArgsDict']] bgp_session_info: Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.
               
               If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs', 'IpsecConnectionTunnelManagementEncryptionDomainConfigArgsDict']] encryption_domain_config: Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        :param pulumi.Input[_builtins.str] ike_version: Internet Key Exchange protocol version.
        :param pulumi.Input[_builtins.str] ipsec_id: The OCID of the IPSec connection.
        :param pulumi.Input[_builtins.str] nat_translation_enabled: By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.
               
               The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.
               
               The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        :param pulumi.Input[_builtins.str] oracle_can_initiate: Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseOneDetailsArgs', 'IpsecConnectionTunnelManagementPhaseOneDetailsArgsDict']] phase_one_details: Configuration details for IKE phase one (ISAKMP) configuration parameters. 
               
               See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs', 'IpsecConnectionTunnelManagementPhaseTwoDetailsArgsDict']] phase_two_details: Configuration details for IPSec phase two configuration parameters.
               
               See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        :param pulumi.Input[_builtins.str] routing: The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        :param pulumi.Input[_builtins.str] shared_secret: The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        :param pulumi.Input[_builtins.str] tunnel_id: The OCID of the IPSec connection's tunnel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsecConnectionTunnelManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ip_sec_connection_tunnel = oci.core.IpsecConnectionTunnelManagement("test_ip_sec_connection_tunnel",
            ipsec_id=test_ipsec["id"],
            tunnel_id=test_ip_sec_connection_tunnels["ipSecConnectionTunnels"][0]["id"],
            routing=ip_sec_connection_tunnel_management_routing,
            bgp_session_info={
                "customer_bgp_asn": ip_sec_connection_tunnel_management_bgp_session_info_customer_bgp_asn,
                "customer_interface_ip": ip_sec_connection_tunnel_management_bgp_session_info_customer_interface_ip,
                "oracle_interface_ip": ip_sec_connection_tunnel_management_bgp_session_info_oracle_interface_ip,
            },
            display_name=ip_sec_connection_tunnel_management_display_name,
            encryption_domain_config={
                "cpe_traffic_selectors": ip_sec_connection_tunnel_management_encryption_domain_config_cpe_traffic_selector,
                "oracle_traffic_selectors": ip_sec_connection_tunnel_management_encryption_domain_config_oracle_traffic_selector,
            },
            shared_secret=ip_sec_connection_tunnel_management_shared_secret,
            ike_version="V1")
        ```

        :param str resource_name: The name of the resource.
        :param IpsecConnectionTunnelManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsecConnectionTunnelManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_session_info: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementBgpSessionInfoArgs', 'IpsecConnectionTunnelManagementBgpSessionInfoArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecConnectionTunnelManagementDpdConfigArgs', 'IpsecConnectionTunnelManagementDpdConfigArgsDict']]]]] = None,
                 encryption_domain_config: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs', 'IpsecConnectionTunnelManagementEncryptionDomainConfigArgsDict']]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_translation_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_can_initiate: Optional[pulumi.Input[_builtins.str]] = None,
                 phase_one_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseOneDetailsArgs', 'IpsecConnectionTunnelManagementPhaseOneDetailsArgsDict']]] = None,
                 phase_two_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs', 'IpsecConnectionTunnelManagementPhaseTwoDetailsArgsDict']]] = None,
                 routing: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsecConnectionTunnelManagementArgs.__new__(IpsecConnectionTunnelManagementArgs)

            __props__.__dict__["bgp_session_info"] = bgp_session_info
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dpd_configs"] = dpd_configs
            __props__.__dict__["encryption_domain_config"] = encryption_domain_config
            __props__.__dict__["ike_version"] = ike_version
            if ipsec_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipsec_id'")
            __props__.__dict__["ipsec_id"] = ipsec_id
            __props__.__dict__["nat_translation_enabled"] = nat_translation_enabled
            __props__.__dict__["oracle_can_initiate"] = oracle_can_initiate
            __props__.__dict__["phase_one_details"] = phase_one_details
            __props__.__dict__["phase_two_details"] = phase_two_details
            __props__.__dict__["routing"] = routing
            __props__.__dict__["shared_secret"] = None if shared_secret is None else pulumi.Output.secret(shared_secret)
            if tunnel_id is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_id'")
            __props__.__dict__["tunnel_id"] = tunnel_id
            __props__.__dict__["associated_virtual_circuits"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["cpe_ip"] = None
            __props__.__dict__["dpd_mode"] = None
            __props__.__dict__["dpd_timeout_in_sec"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_status_updated"] = None
            __props__.__dict__["vpn_ip"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sharedSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IpsecConnectionTunnelManagement, __self__).__init__(
            'oci:Core/ipsecConnectionTunnelManagement:IpsecConnectionTunnelManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_virtual_circuits: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bgp_session_info: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementBgpSessionInfoArgs', 'IpsecConnectionTunnelManagementBgpSessionInfoArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            cpe_ip: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dpd_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecConnectionTunnelManagementDpdConfigArgs', 'IpsecConnectionTunnelManagementDpdConfigArgsDict']]]]] = None,
            dpd_mode: Optional[pulumi.Input[_builtins.str]] = None,
            dpd_timeout_in_sec: Optional[pulumi.Input[_builtins.int]] = None,
            encryption_domain_config: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs', 'IpsecConnectionTunnelManagementEncryptionDomainConfigArgsDict']]] = None,
            ike_version: Optional[pulumi.Input[_builtins.str]] = None,
            ipsec_id: Optional[pulumi.Input[_builtins.str]] = None,
            nat_translation_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            oracle_can_initiate: Optional[pulumi.Input[_builtins.str]] = None,
            phase_one_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseOneDetailsArgs', 'IpsecConnectionTunnelManagementPhaseOneDetailsArgsDict']]] = None,
            phase_two_details: Optional[pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs', 'IpsecConnectionTunnelManagementPhaseTwoDetailsArgsDict']]] = None,
            routing: Optional[pulumi.Input[_builtins.str]] = None,
            shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_status_updated: Optional[pulumi.Input[_builtins.str]] = None,
            tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_ip: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpsecConnectionTunnelManagement':
        """
        Get an existing IpsecConnectionTunnelManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_virtual_circuits: The list of virtual circuit [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s over which your network can reach this tunnel.
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementBgpSessionInfoArgs', 'IpsecConnectionTunnelManagementBgpSessionInfoArgsDict']] bgp_session_info: Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.
               
               If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the tunnel.
        :param pulumi.Input[_builtins.str] cpe_ip: The IP address of the CPE device's VPN headend.  Example: `203.0.113.22`
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dpd_mode: Dead peer detection (DPD) mode set on the Oracle side of the connection.
        :param pulumi.Input[_builtins.int] dpd_timeout_in_sec: DPD timeout in seconds.
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementEncryptionDomainConfigArgs', 'IpsecConnectionTunnelManagementEncryptionDomainConfigArgsDict']] encryption_domain_config: Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        :param pulumi.Input[_builtins.str] ike_version: Internet Key Exchange protocol version.
        :param pulumi.Input[_builtins.str] ipsec_id: The OCID of the IPSec connection.
        :param pulumi.Input[_builtins.str] nat_translation_enabled: By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.
               
               The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.
               
               The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        :param pulumi.Input[_builtins.str] oracle_can_initiate: Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseOneDetailsArgs', 'IpsecConnectionTunnelManagementPhaseOneDetailsArgsDict']] phase_one_details: Configuration details for IKE phase one (ISAKMP) configuration parameters. 
               
               See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        :param pulumi.Input[Union['IpsecConnectionTunnelManagementPhaseTwoDetailsArgs', 'IpsecConnectionTunnelManagementPhaseTwoDetailsArgsDict']] phase_two_details: Configuration details for IPSec phase two configuration parameters.
               
               See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        :param pulumi.Input[_builtins.str] routing: The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        :param pulumi.Input[_builtins.str] shared_secret: The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        :param pulumi.Input[_builtins.str] state: The IPSec connection's tunnel's lifecycle state.
        :param pulumi.Input[_builtins.str] status: The tunnel's current state.
        :param pulumi.Input[_builtins.str] time_created: The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_status_updated: When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] tunnel_id: The OCID of the IPSec connection's tunnel.
        :param pulumi.Input[_builtins.str] vpn_ip: The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsecConnectionTunnelManagementState.__new__(_IpsecConnectionTunnelManagementState)

        __props__.__dict__["associated_virtual_circuits"] = associated_virtual_circuits
        __props__.__dict__["bgp_session_info"] = bgp_session_info
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpe_ip"] = cpe_ip
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dpd_configs"] = dpd_configs
        __props__.__dict__["dpd_mode"] = dpd_mode
        __props__.__dict__["dpd_timeout_in_sec"] = dpd_timeout_in_sec
        __props__.__dict__["encryption_domain_config"] = encryption_domain_config
        __props__.__dict__["ike_version"] = ike_version
        __props__.__dict__["ipsec_id"] = ipsec_id
        __props__.__dict__["nat_translation_enabled"] = nat_translation_enabled
        __props__.__dict__["oracle_can_initiate"] = oracle_can_initiate
        __props__.__dict__["phase_one_details"] = phase_one_details
        __props__.__dict__["phase_two_details"] = phase_two_details
        __props__.__dict__["routing"] = routing
        __props__.__dict__["shared_secret"] = shared_secret
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_status_updated"] = time_status_updated
        __props__.__dict__["tunnel_id"] = tunnel_id
        __props__.__dict__["vpn_ip"] = vpn_ip
        return IpsecConnectionTunnelManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedVirtualCircuits")
    def associated_virtual_circuits(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of virtual circuit [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s over which your network can reach this tunnel.
        """
        return pulumi.get(self, "associated_virtual_circuits")

    @_builtins.property
    @pulumi.getter(name="bgpSessionInfo")
    def bgp_session_info(self) -> pulumi.Output['outputs.IpsecConnectionTunnelManagementBgpSessionInfo']:
        """
        Information for establishing a BGP session for the IPSec tunnel. Required if the tunnel uses BGP dynamic routing.

        If the tunnel instead uses static routing, you may optionally provide this object and set an IP address for one or both ends of the IPSec tunnel for the purposes of troubleshooting or monitoring the tunnel.
        """
        return pulumi.get(self, "bgp_session_info")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the tunnel.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="cpeIp")
    def cpe_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the CPE device's VPN headend.  Example: `203.0.113.22`
        """
        return pulumi.get(self, "cpe_ip")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dpdConfigs")
    def dpd_configs(self) -> pulumi.Output[Optional[Sequence['outputs.IpsecConnectionTunnelManagementDpdConfig']]]:
        return pulumi.get(self, "dpd_configs")

    @_builtins.property
    @pulumi.getter(name="dpdMode")
    def dpd_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Dead peer detection (DPD) mode set on the Oracle side of the connection.
        """
        return pulumi.get(self, "dpd_mode")

    @_builtins.property
    @pulumi.getter(name="dpdTimeoutInSec")
    def dpd_timeout_in_sec(self) -> pulumi.Output[_builtins.int]:
        """
        DPD timeout in seconds.
        """
        return pulumi.get(self, "dpd_timeout_in_sec")

    @_builtins.property
    @pulumi.getter(name="encryptionDomainConfig")
    def encryption_domain_config(self) -> pulumi.Output['outputs.IpsecConnectionTunnelManagementEncryptionDomainConfig']:
        """
        Configuration information used by the encryption domain policy. Required if the tunnel uses POLICY routing.
        """
        return pulumi.get(self, "encryption_domain_config")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> pulumi.Output[_builtins.str]:
        """
        Internet Key Exchange protocol version.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the IPSec connection.
        """
        return pulumi.get(self, "ipsec_id")

    @_builtins.property
    @pulumi.getter(name="natTranslationEnabled")
    def nat_translation_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.

        The `ENABLED` option sets the IKE protocol to use port 4500 instead of 500 and forces encapsulating traffic with the ESP protocol inside UDP packets.

        The `DISABLED` option directs IKE to completely refuse to negotiate NAT-T even if it senses there may be a NAT device in use.
        """
        return pulumi.get(self, "nat_translation_enabled")

    @_builtins.property
    @pulumi.getter(name="oracleCanInitiate")
    def oracle_can_initiate(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device (`RESPONDER_ONLY`), or both respond to and initiate requests (`INITIATOR_OR_RESPONDER`).
        """
        return pulumi.get(self, "oracle_can_initiate")

    @_builtins.property
    @pulumi.getter(name="phaseOneDetails")
    def phase_one_details(self) -> pulumi.Output['outputs.IpsecConnectionTunnelManagementPhaseOneDetails']:
        """
        Configuration details for IKE phase one (ISAKMP) configuration parameters. 

        See [PhaseOneConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseOneConfigDetails) for allowed values but note naming scheme follows [TunnelPhaseOneDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseOneDetails).
        """
        return pulumi.get(self, "phase_one_details")

    @_builtins.property
    @pulumi.getter(name="phaseTwoDetails")
    def phase_two_details(self) -> pulumi.Output['outputs.IpsecConnectionTunnelManagementPhaseTwoDetails']:
        """
        Configuration details for IPSec phase two configuration parameters.

        See [PhaseTwoConfigDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/PhaseTwoConfigDetails) for allowed values, but note naming scheme follows [TunnelPhaseTwoDetails](https://docs.oracle.com/en-us/iaas/api/#/en/iaas/20160918/datatypes/TunnelPhaseTwoDetails).
        """
        return pulumi.get(self, "phase_two_details")

    @_builtins.property
    @pulumi.getter
    def routing(self) -> pulumi.Output[_builtins.str]:
        """
        The type of routing to use for this tunnel (either BGP dynamic routing, STATIC routing or POLICY routing).
        """
        return pulumi.get(self, "routing")

    @_builtins.property
    @pulumi.getter(name="sharedSecret")
    def shared_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The shared secret (pre-shared key) to use for the IPSec tunnel. If you don't provide a value, Oracle generates a value for you. You can specify your own shared secret later if you like with [UpdateIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret).  Example: `EXAMPLEToUis6j1c.p8G.dVQxcmdfMO0yXMLi.lZTbYCMDGu4V8o`
        """
        return pulumi.get(self, "shared_secret")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The IPSec connection's tunnel's lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The tunnel's current state.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> pulumi.Output[_builtins.str]:
        """
        When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_status_updated")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the IPSec connection's tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="vpnIp")
    def vpn_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "vpn_ip")

