# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VolumeBackupPolicyAssignmentArgs', 'VolumeBackupPolicyAssignment']

@pulumi.input_type
class VolumeBackupPolicyAssignmentArgs:
    def __init__(__self__, *,
                 asset_id: pulumi.Input[_builtins.str],
                 policy_id: pulumi.Input[_builtins.str],
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeBackupPolicyAssignment resource.
        :param pulumi.Input[_builtins.str] asset_id: The OCID of the volume or volume group to assign the policy to.
        :param pulumi.Input[_builtins.str] policy_id: The OCID of the volume backup policy to assign to the volume.
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "policy_id", policy_id)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the volume or volume group to assign the policy to.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "asset_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the volume backup policy to assign to the volume.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.input_type
class _VolumeBackupPolicyAssignmentState:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeBackupPolicyAssignment resources.
        :param pulumi.Input[_builtins.str] asset_id: The OCID of the volume or volume group to assign the policy to.
        :param pulumi.Input[_builtins.str] policy_id: The OCID of the volume backup policy to assign to the volume.
        :param pulumi.Input[_builtins.str] time_created: The date and time the volume backup policy was assigned to the volume. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the volume or volume group to assign the policy to.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the volume backup policy to assign to the volume.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the volume backup policy was assigned to the volume. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.type_token("oci:Core/volumeBackupPolicyAssignment:VolumeBackupPolicyAssignment")
class VolumeBackupPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_backup_policy_assignment = oci.core.VolumeBackupPolicyAssignment("test_volume_backup_policy_assignment",
            asset_id=test_volume["id"],
            policy_id=test_volume_backup_policy["id"],
            xrc_kms_key_id=test_key["id"])
        ```

        ## Import

        VolumeBackupPolicyAssignments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeBackupPolicyAssignment:VolumeBackupPolicyAssignment test_volume_backup_policy_assignment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_id: The OCID of the volume or volume group to assign the policy to.
        :param pulumi.Input[_builtins.str] policy_id: The OCID of the volume backup policy to assign to the volume.
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeBackupPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_backup_policy_assignment = oci.core.VolumeBackupPolicyAssignment("test_volume_backup_policy_assignment",
            asset_id=test_volume["id"],
            policy_id=test_volume_backup_policy["id"],
            xrc_kms_key_id=test_key["id"])
        ```

        ## Import

        VolumeBackupPolicyAssignments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeBackupPolicyAssignment:VolumeBackupPolicyAssignment test_volume_backup_policy_assignment "id"
        ```

        :param str resource_name: The name of the resource.
        :param VolumeBackupPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeBackupPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeBackupPolicyAssignmentArgs.__new__(VolumeBackupPolicyAssignmentArgs)

            if asset_id is None and not opts.urn:
                raise TypeError("Missing required property 'asset_id'")
            __props__.__dict__["asset_id"] = asset_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
            __props__.__dict__["time_created"] = None
        super(VolumeBackupPolicyAssignment, __self__).__init__(
            'oci:Core/volumeBackupPolicyAssignment:VolumeBackupPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asset_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeBackupPolicyAssignment':
        """
        Get an existing VolumeBackupPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_id: The OCID of the volume or volume group to assign the policy to.
        :param pulumi.Input[_builtins.str] policy_id: The OCID of the volume backup policy to assign to the volume.
        :param pulumi.Input[_builtins.str] time_created: The date and time the volume backup policy was assigned to the volume. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeBackupPolicyAssignmentState.__new__(_VolumeBackupPolicyAssignmentState)

        __props__.__dict__["asset_id"] = asset_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
        return VolumeBackupPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the volume or volume group to assign the policy to.
        """
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the volume backup policy to assign to the volume.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the volume backup policy was assigned to the volume. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the Vault service key which is the master encryption key for the block / boot volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

