# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutonomousDatabaseWalletArgs', 'AutonomousDatabaseWallet']

@pulumi.input_type
class AutonomousDatabaseWalletArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 base64_encode_content: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regional: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseWallet resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[_builtins.bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        pulumi.set(__self__, "password", password)
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if generate_type is not None:
            pulumi.set(__self__, "generate_type", generate_type)
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @_builtins.property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @generate_type.setter
    def generate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generate_type", value)

    @_builtins.property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_regional", value)


@pulumi.input_type
class _AutonomousDatabaseWalletState:
    def __init__(__self__, *,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 base64_encode_content: Optional[pulumi.Input[_builtins.bool]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regional: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseWallet resources.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] content: content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[_builtins.str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[_builtins.bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[_builtins.str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if generate_type is not None:
            pulumi.set(__self__, "generate_type", generate_type)
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @generate_type.setter
    def generate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generate_type", value)

    @_builtins.property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_regional", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.type_token("oci:Database/autonomousDatabaseWallet:AutonomousDatabaseWallet")
class AutonomousDatabaseWallet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 base64_encode_content: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regional: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_wallet = oci.database.AutonomousDatabaseWallet("test_autonomous_database_wallet",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_wallet_password,
            base64_encode_content=False,
            generate_type=autonomous_database_wallet_generate_type,
            is_regional=autonomous_database_wallet_is_regional)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[_builtins.bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[_builtins.str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseWalletArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_wallet = oci.database.AutonomousDatabaseWallet("test_autonomous_database_wallet",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_wallet_password,
            base64_encode_content=False,
            generate_type=autonomous_database_wallet_generate_type,
            is_regional=autonomous_database_wallet_is_regional)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseWalletArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseWalletArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 base64_encode_content: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regional: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseWalletArgs.__new__(AutonomousDatabaseWalletArgs)

            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["base64_encode_content"] = base64_encode_content
            __props__.__dict__["generate_type"] = generate_type
            __props__.__dict__["is_regional"] = is_regional
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["content"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabaseWallet, __self__).__init__(
            'oci:Database/autonomousDatabaseWallet:AutonomousDatabaseWallet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            base64_encode_content: Optional[pulumi.Input[_builtins.bool]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            generate_type: Optional[pulumi.Input[_builtins.str]] = None,
            is_regional: Optional[pulumi.Input[_builtins.bool]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutonomousDatabaseWallet':
        """
        Get an existing AutonomousDatabaseWallet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] content: content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[_builtins.str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[_builtins.bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[_builtins.str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseWalletState.__new__(_AutonomousDatabaseWalletState)

        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["base64_encode_content"] = base64_encode_content
        __props__.__dict__["content"] = content
        __props__.__dict__["generate_type"] = generate_type
        __props__.__dict__["is_regional"] = is_regional
        __props__.__dict__["password"] = password
        return AutonomousDatabaseWallet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "base64_encode_content")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @_builtins.property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> pulumi.Output[_builtins.bool]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

