# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudExadataInfrastructureConfigureExascaleManagementArgs', 'CloudExadataInfrastructureConfigureExascaleManagement']

@pulumi.input_type
class CloudExadataInfrastructureConfigureExascaleManagementArgs:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: pulumi.Input[_builtins.str],
                 total_storage_in_gbs: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a CloudExadataInfrastructureConfigureExascaleManagement resource.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "total_storage_in_gbs", total_storage_in_gbs)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> pulumi.Input[_builtins.int]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "total_storage_in_gbs", value)


@pulumi.input_type
class _CloudExadataInfrastructureConfigureExascaleManagementState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 additional_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 available_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs']]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exascale_configs: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_scheduling_policy_associated: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]] = None,
                 max_cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 total_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CloudExadataInfrastructureConfigureExascaleManagement resources.
        :param pulumi.Input[_builtins.int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        :param pulumi.Input[_builtins.int] available_storage_size_in_gbs: The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[_builtins.int] cpu_count: The total number of CPU cores allocated.
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs']]] customer_contacts: The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[_builtins.str] db_server_version: The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]] exascale_configs: The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_scheduling_policy_associated: If true, the infrastructure is using granular maintenance scheduling preference.
        :param pulumi.Input[_builtins.str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[_builtins.int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[_builtins.float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[_builtins.int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[_builtins.int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[_builtins.str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] monthly_storage_server_version: The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[_builtins.str] shape: The model name of the cloud Exadata infrastructure resource.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the cloud Exadata infrastructure resource.
        :param pulumi.Input[_builtins.int] storage_count: The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[_builtins.str] storage_server_version: The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time the cloud Exadata infrastructure resource was created.
        :param pulumi.Input[_builtins.int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] total_storage_size_in_gbs: The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        if activated_storage_count is not None:
            pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_storage_count is not None:
            pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if available_storage_size_in_gbs is not None:
            pulumi.set(__self__, "available_storage_size_in_gbs", available_storage_size_in_gbs)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            pulumi.set(__self__, "db_server_version", db_server_version)
        if defined_file_system_configurations is not None:
            pulumi.set(__self__, "defined_file_system_configurations", defined_file_system_configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exascale_configs is not None:
            pulumi.set(__self__, "exascale_configs", exascale_configs)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_scheduling_policy_associated is not None:
            pulumi.set(__self__, "is_scheduling_policy_associated", is_scheduling_policy_associated)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_cpu_count is not None:
            pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if monthly_storage_server_version is not None:
            pulumi.set(__self__, "monthly_storage_server_version", monthly_storage_server_version)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_version is not None:
            pulumi.set(__self__, "storage_server_version", storage_server_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if total_storage_in_gbs is not None:
            pulumi.set(__self__, "total_storage_in_gbs", total_storage_in_gbs)
        if total_storage_size_in_gbs is not None:
            pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "activated_storage_count", value)

    @_builtins.property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "additional_storage_count", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @available_storage_size_in_gbs.setter
    def available_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of CPU cores allocated.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs']]]]:
        """
        The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs']]]]):
        pulumi.set(self, "customer_contacts", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_server_version", value)

    @_builtins.property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @defined_file_system_configurations.setter
    def defined_file_system_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]]):
        pulumi.set(self, "defined_file_system_configurations", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="exascaleConfigs")
    def exascale_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]]:
        """
        The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        """
        return pulumi.get(self, "exascale_configs")

    @exascale_configs.setter
    def exascale_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]]):
        pulumi.set(self, "exascale_configs", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isSchedulingPolicyAssociated")
    def is_scheduling_policy_associated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the infrastructure is using granular maintenance scheduling preference.
        """
        return pulumi.get(self, "is_scheduling_policy_associated")

    @is_scheduling_policy_associated.setter
    def is_scheduling_policy_associated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_scheduling_policy_associated", value)

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @_builtins.property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @monthly_storage_server_version.setter
    def monthly_storage_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_storage_server_version", value)

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model name of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_count", value)

    @_builtins.property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_server_version", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the cloud Exadata infrastructure resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_storage_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

    @total_storage_size_in_gbs.setter
    def total_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_storage_size_in_gbs", value)


@pulumi.type_token("oci:Database/cloudExadataInfrastructureConfigureExascaleManagement:CloudExadataInfrastructureConfigureExascaleManagement")
class CloudExadataInfrastructureConfigureExascaleManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_exadata_infrastructure_configure_exascale_management = oci.database.CloudExadataInfrastructureConfigureExascaleManagement("test_cloud_exadata_infrastructure_configure_exascale_management",
            cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
            total_storage_in_gbs=cloud_exadata_infrastructure_configure_exascale_management_total_storage_in_gbs)
        ```

        ## Import

        CloudExadataInfrastructureConfigureExascaleManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudExadataInfrastructureConfigureExascaleManagement:CloudExadataInfrastructureConfigureExascaleManagement test_cloud_exadata_infrastructure_configure_exascale_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudExadataInfrastructureConfigureExascaleManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_exadata_infrastructure_configure_exascale_management = oci.database.CloudExadataInfrastructureConfigureExascaleManagement("test_cloud_exadata_infrastructure_configure_exascale_management",
            cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
            total_storage_in_gbs=cloud_exadata_infrastructure_configure_exascale_management_total_storage_in_gbs)
        ```

        ## Import

        CloudExadataInfrastructureConfigureExascaleManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudExadataInfrastructureConfigureExascaleManagement:CloudExadataInfrastructureConfigureExascaleManagement test_cloud_exadata_infrastructure_configure_exascale_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudExadataInfrastructureConfigureExascaleManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudExadataInfrastructureConfigureExascaleManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudExadataInfrastructureConfigureExascaleManagementArgs.__new__(CloudExadataInfrastructureConfigureExascaleManagementArgs)

            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            if total_storage_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'total_storage_in_gbs'")
            __props__.__dict__["total_storage_in_gbs"] = total_storage_in_gbs
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["available_storage_size_in_gbs"] = None
            __props__.__dict__["cluster_placement_group_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_count"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["customer_contacts"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["defined_file_system_configurations"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["exascale_configs"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_scheduling_policy_associated"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["monthly_storage_server_version"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_count"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["subscription_id"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["total_storage_size_in_gbs"] = None
        super(CloudExadataInfrastructureConfigureExascaleManagement, __self__).__init__(
            'oci:Database/cloudExadataInfrastructureConfigureExascaleManagement:CloudExadataInfrastructureConfigureExascaleManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            additional_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            available_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_count: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs', 'CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgsDict']]]]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs', 'CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            exascale_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs', 'CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_scheduling_policy_associated: Optional[pulumi.Input[_builtins.bool]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs', 'CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgsDict']]]]] = None,
            max_cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            monthly_storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            total_storage_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            total_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None) -> 'CloudExadataInfrastructureConfigureExascaleManagement':
        """
        Get an existing CloudExadataInfrastructureConfigureExascaleManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        :param pulumi.Input[_builtins.int] available_storage_size_in_gbs: The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[_builtins.int] cpu_count: The total number of CPU cores allocated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgs', 'CloudExadataInfrastructureConfigureExascaleManagementCustomerContactArgsDict']]]] customer_contacts: The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[_builtins.str] db_server_version: The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs', 'CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgsDict']]]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs', 'CloudExadataInfrastructureConfigureExascaleManagementExascaleConfigArgsDict']]]] exascale_configs: The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_scheduling_policy_associated: If true, the infrastructure is using granular maintenance scheduling preference.
        :param pulumi.Input[_builtins.str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs', 'CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgsDict']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[_builtins.int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[_builtins.float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[_builtins.int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[_builtins.int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[_builtins.str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] monthly_storage_server_version: The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[_builtins.str] shape: The model name of the cloud Exadata infrastructure resource.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the cloud Exadata infrastructure resource.
        :param pulumi.Input[_builtins.int] storage_count: The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[_builtins.str] storage_server_version: The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[_builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time the cloud Exadata infrastructure resource was created.
        :param pulumi.Input[_builtins.int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] total_storage_size_in_gbs: The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudExadataInfrastructureConfigureExascaleManagementState.__new__(_CloudExadataInfrastructureConfigureExascaleManagementState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["available_storage_size_in_gbs"] = available_storage_size_in_gbs
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["customer_contacts"] = customer_contacts
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["defined_file_system_configurations"] = defined_file_system_configurations
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exascale_configs"] = exascale_configs
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_scheduling_policy_associated"] = is_scheduling_policy_associated
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["monthly_storage_server_version"] = monthly_storage_server_version
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["total_storage_in_gbs"] = total_storage_in_gbs
        __props__.__dict__["total_storage_size_in_gbs"] = total_storage_size_in_gbs
        return CloudExadataInfrastructureConfigureExascaleManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @_builtins.property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of CPU cores allocated.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureConfigureExascaleManagementCustomerContact']]:
        """
        The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance.
        """
        return pulumi.get(self, "customer_contacts")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "db_server_version")

    @_builtins.property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfiguration']]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exascaleConfigs")
    def exascale_configs(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureConfigureExascaleManagementExascaleConfig']]:
        """
        The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        """
        return pulumi.get(self, "exascale_configs")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isSchedulingPolicyAssociated")
    def is_scheduling_policy_associated(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the infrastructure is using granular maintenance scheduling preference.
        """
        return pulumi.get(self, "is_scheduling_policy_associated")

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureConfigureExascaleManagementMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @_builtins.property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_db_server_version")

    @_builtins.property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The model name of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @_builtins.property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "storage_server_version")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the cloud Exadata infrastructure resource was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

