# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseSnapshotStandbyArgs', 'DatabaseSnapshotStandby']

@pulumi.input_type
class DatabaseSnapshotStandbyArgs:
    def __init__(__self__, *,
                 database_admin_password: pulumi.Input[_builtins.str],
                 database_id: pulumi.Input[_builtins.str],
                 standby_conversion_type: pulumi.Input[_builtins.str],
                 snapshot_duration_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DatabaseSnapshotStandby resource.
        :param pulumi.Input[_builtins.str] database_admin_password: The administrator password of the primary database in this Data Guard association.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[_builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] standby_conversion_type: Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.
               
               Valid standbyConversionType:
               * SNAPSHOT
               * PHYSICAL
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] snapshot_duration_in_days: SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.
               
               This field is only applicable if the requested database role is snapshot standby.
        """
        pulumi.set(__self__, "database_admin_password", database_admin_password)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "standby_conversion_type", standby_conversion_type)
        if snapshot_duration_in_days is not None:
            pulumi.set(__self__, "snapshot_duration_in_days", snapshot_duration_in_days)

    @_builtins.property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @database_admin_password.setter
    def database_admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="standbyConversionType")
    def standby_conversion_type(self) -> pulumi.Input[_builtins.str]:
        """
        Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.

        Valid standbyConversionType:
        * SNAPSHOT
        * PHYSICAL


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_conversion_type")

    @standby_conversion_type.setter
    def standby_conversion_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "standby_conversion_type", value)

    @_builtins.property
    @pulumi.getter(name="snapshotDurationInDays")
    def snapshot_duration_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.

        This field is only applicable if the requested database role is snapshot standby.
        """
        return pulumi.get(self, "snapshot_duration_in_days")

    @snapshot_duration_in_days.setter
    def snapshot_duration_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_duration_in_days", value)


@pulumi.input_type
class _DatabaseSnapshotStandbyState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyConnectionStringArgs']]]] = None,
                 data_guard_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDataGuardGroupArgs']]]] = None,
                 database_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDatabaseManagementConfigArgs']]]] = None,
                 database_software_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDbBackupConfigArgs']]]] = None,
                 db_home_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_unique_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_cdb: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_backup_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 last_backup_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 last_failed_backup_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 ncharacter_set: Optional[pulumi.Input[_builtins.str]] = None,
                 pdb_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sid_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_duration_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 source_database_point_in_time_recovery_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_conversion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseSnapshotStandby resources.
        :param pulumi.Input[_builtins.str] character_set: The character set for the database.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyConnectionStringArgs']]] connection_strings: The Connection strings used to connect to the Oracle Database.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDataGuardGroupArgs']]] data_guard_groups: Details of Data Guard setup that the given database is part of.  Also includes information about databases part of this Data Guard group and properties for their Data Guard configuration.
        :param pulumi.Input[_builtins.str] database_admin_password: The administrator password of the primary database in this Data Guard association.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[_builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDatabaseManagementConfigArgs']]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[_builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDbBackupConfigArgs']]] db_backup_configs: Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        :param pulumi.Input[_builtins.str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[_builtins.str] db_name: The database name.
        :param pulumi.Input[_builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[_builtins.str] db_unique_name: A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        :param pulumi.Input[_builtins.str] db_workload: **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_cdb: True if the database is a container database.
        :param pulumi.Input[_builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[_builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[_builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[_builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[_builtins.int] last_backup_duration_in_seconds: The duration when the latest database backup created.
        :param pulumi.Input[_builtins.str] last_backup_timestamp: The date and time when the latest database backup was created.
        :param pulumi.Input[_builtins.str] last_failed_backup_timestamp: The date and time when the latest database backup failed.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.str] ncharacter_set: The national character set for the database.
        :param pulumi.Input[_builtins.str] pdb_name: The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        :param pulumi.Input[_builtins.str] sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[_builtins.int] snapshot_duration_in_days: SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.
               
               This field is only applicable if the requested database role is snapshot standby.
        :param pulumi.Input[_builtins.str] source_database_point_in_time_recovery_timestamp: Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[_builtins.str] standby_conversion_type: Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.
               
               Valid standbyConversionType:
               * SNAPSHOT
               * PHYSICAL
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the database.
        :param pulumi.Input[_builtins.str] time_created: The date and time the database was created.
        :param pulumi.Input[_builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[_builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if data_guard_groups is not None:
            pulumi.set(__self__, "data_guard_groups", data_guard_groups)
        if database_admin_password is not None:
            pulumi.set(__self__, "database_admin_password", database_admin_password)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_management_configs is not None:
            pulumi.set(__self__, "database_management_configs", database_management_configs)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_backup_configs is not None:
            pulumi.set(__self__, "db_backup_configs", db_backup_configs)
        if db_home_id is not None:
            pulumi.set(__self__, "db_home_id", db_home_id)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cdb is not None:
            pulumi.set(__self__, "is_cdb", is_cdb)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_backup_duration_in_seconds is not None:
            pulumi.set(__self__, "last_backup_duration_in_seconds", last_backup_duration_in_seconds)
        if last_backup_timestamp is not None:
            pulumi.set(__self__, "last_backup_timestamp", last_backup_timestamp)
        if last_failed_backup_timestamp is not None:
            pulumi.set(__self__, "last_failed_backup_timestamp", last_failed_backup_timestamp)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if pdb_name is not None:
            pulumi.set(__self__, "pdb_name", pdb_name)
        if sid_prefix is not None:
            pulumi.set(__self__, "sid_prefix", sid_prefix)
        if snapshot_duration_in_days is not None:
            pulumi.set(__self__, "snapshot_duration_in_days", snapshot_duration_in_days)
        if source_database_point_in_time_recovery_timestamp is not None:
            pulumi.set(__self__, "source_database_point_in_time_recovery_timestamp", source_database_point_in_time_recovery_timestamp)
        if standby_conversion_type is not None:
            pulumi.set(__self__, "standby_conversion_type", standby_conversion_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyConnectionStringArgs']]]]:
        """
        The Connection strings used to connect to the Oracle Database.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="dataGuardGroups")
    def data_guard_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDataGuardGroupArgs']]]]:
        """
        Details of Data Guard setup that the given database is part of.  Also includes information about databases part of this Data Guard group and properties for their Data Guard configuration.
        """
        return pulumi.get(self, "data_guard_groups")

    @data_guard_groups.setter
    def data_guard_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDataGuardGroupArgs']]]]):
        pulumi.set(self, "data_guard_groups", value)

    @_builtins.property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @database_admin_password.setter
    def database_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @database_management_configs.setter
    def database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "database_management_configs", value)

    @_builtins.property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_software_image_id", value)

    @_builtins.property
    @pulumi.getter(name="dbBackupConfigs")
    def db_backup_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDbBackupConfigArgs']]]]:
        """
        Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        """
        return pulumi.get(self, "db_backup_configs")

    @db_backup_configs.setter
    def db_backup_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseSnapshotStandbyDbBackupConfigArgs']]]]):
        pulumi.set(self, "db_backup_configs", value)

    @_builtins.property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @db_home_id.setter
    def db_home_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_home_id", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_unique_name", value)

    @_builtins.property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_workload", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isCdb")
    def is_cdb(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the database is a container database.
        """
        return pulumi.get(self, "is_cdb")

    @is_cdb.setter
    def is_cdb(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cdb", value)

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @_builtins.property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @_builtins.property
    @pulumi.getter(name="lastBackupDurationInSeconds")
    def last_backup_duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration when the latest database backup created.
        """
        return pulumi.get(self, "last_backup_duration_in_seconds")

    @last_backup_duration_in_seconds.setter
    def last_backup_duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_backup_duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="lastBackupTimestamp")
    def last_backup_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the latest database backup was created.
        """
        return pulumi.get(self, "last_backup_timestamp")

    @last_backup_timestamp.setter
    def last_backup_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_backup_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="lastFailedBackupTimestamp")
    def last_failed_backup_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the latest database backup failed.
        """
        return pulumi.get(self, "last_failed_backup_timestamp")

    @last_failed_backup_timestamp.setter
    def last_failed_backup_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_failed_backup_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ncharacter_set", value)

    @_builtins.property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        """
        return pulumi.get(self, "pdb_name")

    @pdb_name.setter
    def pdb_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pdb_name", value)

    @_builtins.property
    @pulumi.getter(name="sidPrefix")
    def sid_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "sid_prefix")

    @sid_prefix.setter
    def sid_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sid_prefix", value)

    @_builtins.property
    @pulumi.getter(name="snapshotDurationInDays")
    def snapshot_duration_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.

        This field is only applicable if the requested database role is snapshot standby.
        """
        return pulumi.get(self, "snapshot_duration_in_days")

    @snapshot_duration_in_days.setter
    def snapshot_duration_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_duration_in_days", value)

    @_builtins.property
    @pulumi.getter(name="sourceDatabasePointInTimeRecoveryTimestamp")
    def source_database_point_in_time_recovery_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "source_database_point_in_time_recovery_timestamp")

    @source_database_point_in_time_recovery_timestamp.setter
    def source_database_point_in_time_recovery_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_database_point_in_time_recovery_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="standbyConversionType")
    def standby_conversion_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.

        Valid standbyConversionType:
        * SNAPSHOT
        * PHYSICAL


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_conversion_type")

    @standby_conversion_type.setter
    def standby_conversion_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_conversion_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_id", value)


@pulumi.type_token("oci:Database/databaseSnapshotStandby:DatabaseSnapshotStandby")
class DatabaseSnapshotStandby(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_duration_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 standby_conversion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_snapshot_standby = oci.database.DatabaseSnapshotStandby("test_database_snapshot_standby",
            database_admin_password=database_snapshot_standby_database_admin_password,
            database_id=test_database["id"],
            standby_conversion_type=database_snapshot_standby_standby_conversion_type,
            snapshot_duration_in_days=database_snapshot_standby_snapshot_duration_in_days)
        ```

        ## Import

        DatabaseSnapshotStandby can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/databaseSnapshotStandby:DatabaseSnapshotStandby test_database_snapshot_standby "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_admin_password: The administrator password of the primary database in this Data Guard association.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[_builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.int] snapshot_duration_in_days: SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.
               
               This field is only applicable if the requested database role is snapshot standby.
        :param pulumi.Input[_builtins.str] standby_conversion_type: Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.
               
               Valid standbyConversionType:
               * SNAPSHOT
               * PHYSICAL
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseSnapshotStandbyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_snapshot_standby = oci.database.DatabaseSnapshotStandby("test_database_snapshot_standby",
            database_admin_password=database_snapshot_standby_database_admin_password,
            database_id=test_database["id"],
            standby_conversion_type=database_snapshot_standby_standby_conversion_type,
            snapshot_duration_in_days=database_snapshot_standby_snapshot_duration_in_days)
        ```

        ## Import

        DatabaseSnapshotStandby can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/databaseSnapshotStandby:DatabaseSnapshotStandby test_database_snapshot_standby "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseSnapshotStandbyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseSnapshotStandbyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_duration_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 standby_conversion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseSnapshotStandbyArgs.__new__(DatabaseSnapshotStandbyArgs)

            if database_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'database_admin_password'")
            __props__.__dict__["database_admin_password"] = None if database_admin_password is None else pulumi.Output.secret(database_admin_password)
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["snapshot_duration_in_days"] = snapshot_duration_in_days
            if standby_conversion_type is None and not opts.urn:
                raise TypeError("Missing required property 'standby_conversion_type'")
            __props__.__dict__["standby_conversion_type"] = standby_conversion_type
            __props__.__dict__["character_set"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["data_guard_groups"] = None
            __props__.__dict__["database_management_configs"] = None
            __props__.__dict__["database_software_image_id"] = None
            __props__.__dict__["db_backup_configs"] = None
            __props__.__dict__["db_home_id"] = None
            __props__.__dict__["db_name"] = None
            __props__.__dict__["db_system_id"] = None
            __props__.__dict__["db_unique_name"] = None
            __props__.__dict__["db_workload"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_cdb"] = None
            __props__.__dict__["key_store_id"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["kms_key_version_id"] = None
            __props__.__dict__["last_backup_duration_in_seconds"] = None
            __props__.__dict__["last_backup_timestamp"] = None
            __props__.__dict__["last_failed_backup_timestamp"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ncharacter_set"] = None
            __props__.__dict__["pdb_name"] = None
            __props__.__dict__["sid_prefix"] = None
            __props__.__dict__["source_database_point_in_time_recovery_timestamp"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vault_id"] = None
            __props__.__dict__["vm_cluster_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["databaseAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseSnapshotStandby, __self__).__init__(
            'oci:Database/databaseSnapshotStandby:DatabaseSnapshotStandby',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyConnectionStringArgs', 'DatabaseSnapshotStandbyConnectionStringArgsDict']]]]] = None,
            data_guard_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDataGuardGroupArgs', 'DatabaseSnapshotStandbyDataGuardGroupArgsDict']]]]] = None,
            database_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDatabaseManagementConfigArgs', 'DatabaseSnapshotStandbyDatabaseManagementConfigArgsDict']]]]] = None,
            database_software_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDbBackupConfigArgs', 'DatabaseSnapshotStandbyDbBackupConfigArgsDict']]]]] = None,
            db_home_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_unique_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_workload: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_cdb: Optional[pulumi.Input[_builtins.bool]] = None,
            key_store_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_backup_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            last_backup_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            last_failed_backup_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            ncharacter_set: Optional[pulumi.Input[_builtins.str]] = None,
            pdb_name: Optional[pulumi.Input[_builtins.str]] = None,
            sid_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_duration_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            source_database_point_in_time_recovery_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            standby_conversion_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseSnapshotStandby':
        """
        Get an existing DatabaseSnapshotStandby resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: The character set for the database.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyConnectionStringArgs', 'DatabaseSnapshotStandbyConnectionStringArgsDict']]]] connection_strings: The Connection strings used to connect to the Oracle Database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDataGuardGroupArgs', 'DatabaseSnapshotStandbyDataGuardGroupArgsDict']]]] data_guard_groups: Details of Data Guard setup that the given database is part of.  Also includes information about databases part of this Data Guard group and properties for their Data Guard configuration.
        :param pulumi.Input[_builtins.str] database_admin_password: The administrator password of the primary database in this Data Guard association.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[_builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDatabaseManagementConfigArgs', 'DatabaseSnapshotStandbyDatabaseManagementConfigArgsDict']]]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[_builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseSnapshotStandbyDbBackupConfigArgs', 'DatabaseSnapshotStandbyDbBackupConfigArgsDict']]]] db_backup_configs: Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        :param pulumi.Input[_builtins.str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[_builtins.str] db_name: The database name.
        :param pulumi.Input[_builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[_builtins.str] db_unique_name: A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        :param pulumi.Input[_builtins.str] db_workload: **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_cdb: True if the database is a container database.
        :param pulumi.Input[_builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[_builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[_builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[_builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[_builtins.int] last_backup_duration_in_seconds: The duration when the latest database backup created.
        :param pulumi.Input[_builtins.str] last_backup_timestamp: The date and time when the latest database backup was created.
        :param pulumi.Input[_builtins.str] last_failed_backup_timestamp: The date and time when the latest database backup failed.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.str] ncharacter_set: The national character set for the database.
        :param pulumi.Input[_builtins.str] pdb_name: The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        :param pulumi.Input[_builtins.str] sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[_builtins.int] snapshot_duration_in_days: SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.
               
               This field is only applicable if the requested database role is snapshot standby.
        :param pulumi.Input[_builtins.str] source_database_point_in_time_recovery_timestamp: Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[_builtins.str] standby_conversion_type: Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.
               
               Valid standbyConversionType:
               * SNAPSHOT
               * PHYSICAL
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the database.
        :param pulumi.Input[_builtins.str] time_created: The date and time the database was created.
        :param pulumi.Input[_builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[_builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseSnapshotStandbyState.__new__(_DatabaseSnapshotStandbyState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["data_guard_groups"] = data_guard_groups
        __props__.__dict__["database_admin_password"] = database_admin_password
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_management_configs"] = database_management_configs
        __props__.__dict__["database_software_image_id"] = database_software_image_id
        __props__.__dict__["db_backup_configs"] = db_backup_configs
        __props__.__dict__["db_home_id"] = db_home_id
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["db_workload"] = db_workload
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_cdb"] = is_cdb
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["last_backup_duration_in_seconds"] = last_backup_duration_in_seconds
        __props__.__dict__["last_backup_timestamp"] = last_backup_timestamp
        __props__.__dict__["last_failed_backup_timestamp"] = last_failed_backup_timestamp
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["pdb_name"] = pdb_name
        __props__.__dict__["sid_prefix"] = sid_prefix
        __props__.__dict__["snapshot_duration_in_days"] = snapshot_duration_in_days
        __props__.__dict__["source_database_point_in_time_recovery_timestamp"] = source_database_point_in_time_recovery_timestamp
        __props__.__dict__["standby_conversion_type"] = standby_conversion_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["vm_cluster_id"] = vm_cluster_id
        return DatabaseSnapshotStandby(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.DatabaseSnapshotStandbyConnectionString']]:
        """
        The Connection strings used to connect to the Oracle Database.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="dataGuardGroups")
    def data_guard_groups(self) -> pulumi.Output[Sequence['outputs.DatabaseSnapshotStandbyDataGuardGroup']]:
        """
        Details of Data Guard setup that the given database is part of.  Also includes information about databases part of this Data Guard group and properties for their Data Guard configuration.
        """
        return pulumi.get(self, "data_guard_groups")

    @_builtins.property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> pulumi.Output[Sequence['outputs.DatabaseSnapshotStandbyDatabaseManagementConfig']]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @_builtins.property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @_builtins.property
    @pulumi.getter(name="dbBackupConfigs")
    def db_backup_configs(self) -> pulumi.Output[Sequence['outputs.DatabaseSnapshotStandbyDbBackupConfig']]:
        """
        Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        """
        return pulumi.get(self, "db_backup_configs")

    @_builtins.property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[_builtins.str]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[_builtins.str]:
        """
        A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        """
        return pulumi.get(self, "db_unique_name")

    @_builtins.property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Output[_builtins.str]:
        """
        **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        """
        return pulumi.get(self, "db_workload")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isCdb")
    def is_cdb(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the database is a container database.
        """
        return pulumi.get(self, "is_cdb")

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @_builtins.property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @_builtins.property
    @pulumi.getter(name="lastBackupDurationInSeconds")
    def last_backup_duration_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The duration when the latest database backup created.
        """
        return pulumi.get(self, "last_backup_duration_in_seconds")

    @_builtins.property
    @pulumi.getter(name="lastBackupTimestamp")
    def last_backup_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the latest database backup was created.
        """
        return pulumi.get(self, "last_backup_timestamp")

    @_builtins.property
    @pulumi.getter(name="lastFailedBackupTimestamp")
    def last_failed_backup_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the latest database backup failed.
        """
        return pulumi.get(self, "last_failed_backup_timestamp")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[_builtins.str]:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @_builtins.property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        """
        return pulumi.get(self, "pdb_name")

    @_builtins.property
    @pulumi.getter(name="sidPrefix")
    def sid_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "sid_prefix")

    @_builtins.property
    @pulumi.getter(name="snapshotDurationInDays")
    def snapshot_duration_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby. The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.

        This field is only applicable if the requested database role is snapshot standby.
        """
        return pulumi.get(self, "snapshot_duration_in_days")

    @_builtins.property
    @pulumi.getter(name="sourceDatabasePointInTimeRecoveryTimestamp")
    def source_database_point_in_time_recovery_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "source_database_point_in_time_recovery_timestamp")

    @_builtins.property
    @pulumi.getter(name="standbyConversionType")
    def standby_conversion_type(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.

        Valid standbyConversionType:
        * SNAPSHOT
        * PHYSICAL


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_conversion_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

